/*
 * Decompiled with CFR 0.152.
 */
package org.openspaces.zookeeper.leader_selector.gsm;

import com.j_spaces.core.Constants;
import java.io.Closeable;
import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.curator.framework.CuratorFramework;
import org.apache.curator.framework.recipes.leader.Participant;
import org.apache.curator.utils.CloseableUtils;
import org.jini.rio.monitor.leader.LeadershipListener;
import org.jini.rio.monitor.leader.ZooKeeperLeaderHandlerLifecycle;
import org.openspaces.zookeeper.ZNodePathFactory;
import org.openspaces.zookeeper.curator.CuratorClient;
import org.openspaces.zookeeper.curator.XapLeaderSelector;
import org.openspaces.zookeeper.curator.XapLeaderSelectorListener;

public class ZooKeeperBasedGSMLeaderSelectorHandler
implements ZooKeeperLeaderHandlerLifecycle {
    private final String CONNECTION_TIMEOUT = "com.gs.manager.leader-election.zookeeper.connection-timeout";
    private final String SESSION_TIMEOUT = "com.gs.manager.leader-election.zookeeper.session-timeout";
    private final String RETRY_TIMEOUT = "com.gs.manager.leader-election.zookeeper.retry-timeout";
    private final String RETRY_INTERVAL = "com.gs.manager.leader-election.zookeeper.retry-interval";
    private final Logger logger;
    private final CuratorFramework client;
    private final XapLeaderSelector leaderSelector;

    public ZooKeeperBasedGSMLeaderSelectorHandler(LeadershipListener leadershipListener) {
        String loggerName = "com.gigaspaces.zookeeper.leader-selector.gsm." + leadershipListener.getId();
        this.logger = Logger.getLogger(loggerName);
        try {
            this.client = CuratorClient.create(Integer.valueOf(System.getProperty("com.gs.manager.leader-election.zookeeper.session-timeout", "15000")), Integer.valueOf(System.getProperty("com.gs.manager.leader-election.zookeeper.connection-timeout", "5000")), Integer.valueOf(System.getProperty("com.gs.manager.leader-election.zookeeper.retry-timeout", Constants.LeaderSelector.RETRY_TIMEOUT_DEFAULT)), Integer.valueOf(System.getProperty("com.gs.manager.leader-election.zookeeper.retry-interval", "100")));
        }
        catch (IOException e) {
            throw new IllegalStateException("Failed to initialize Curator Client", e);
        }
        String path = ZNodePathFactory.path("managers", "gsm", "leader-election", "participants");
        ListenerAdapter listenerAdapter = new ListenerAdapter(leadershipListener);
        this.leaderSelector = new XapLeaderSelector(this.client, path, leadershipListener.getId(), listenerAdapter);
    }

    public void start() {
        this.logger.info("Started");
        this.leaderSelector.start();
    }

    public void stop() {
        this.logger.info("Close leader selector");
        CloseableUtils.closeQuietly((Closeable)this.leaderSelector);
        this.logger.info("Close ZooKeeper client");
        CloseableUtils.closeQuietly((Closeable)this.client);
        this.logger.info("Stopped");
    }

    public boolean awaitLeader() {
        while (true) {
            try {
                while (true) {
                    Participant leader;
                    if ((leader = this.getLeaderIfExists()) != null) {
                        return leader.getId().equals(this.leaderSelector.getId());
                    }
                    Thread.sleep(1000L);
                }
            }
            catch (Exception e) {
                this.logger.log(Level.FINE, "Error while awaiting to find a leader", e);
                continue;
            }
            break;
        }
    }

    public boolean hasLeadership() {
        return this.leaderSelector.hasLeadership();
    }

    private Participant getLeaderIfExists() throws Exception {
        return this.leaderSelector.getLeaderIfExists();
    }

    private class ListenerAdapter
    extends XapLeaderSelectorListener {
        private final LeadershipListener listener;

        public ListenerAdapter(LeadershipListener listener) {
            this.listener = listener;
        }

        @Override
        public String getLoggerSuffix() {
            return "gsm." + this.listener.getId();
        }

        @Override
        public void onLeadershipOffered(XapLeaderSelector container) throws Exception {
            super.onLeadershipOffered(container);
            this.listener.tryTakeLeadership();
        }

        @Override
        public void onLeadershipLost(XapLeaderSelector container) {
            super.onLeadershipLost(container);
            this.listener.relinquishLeadership();
        }
    }
}

