/*
 * Decompiled with CFR 0.152.
 */
package com.google.api.gax.core;

import com.google.api.core.BetaApi;
import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;

@BetaApi
public class PropertiesProvider {
    private static final String DEFAULT_VERSION = "";
    private static final Logger logger = Logger.getLogger(PropertiesProvider.class.getName());

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String loadProperty(Class<?> loadedClass, String propertiesPath, String key) {
        InputStream inputStream = null;
        try {
            inputStream = loadedClass.getResourceAsStream(propertiesPath);
            if (inputStream != null) {
                Properties properties = new Properties();
                properties.load(inputStream);
                String string = properties.getProperty(key);
                return string;
            }
            PropertiesProvider.logMissingProperties(loadedClass, propertiesPath);
            String properties = null;
            return properties;
        }
        catch (Exception e) {
            logger.log(Level.WARNING, "Exception loading properties at \"" + propertiesPath + "\"", e);
            String string = null;
            return string;
        }
        finally {
            if (inputStream != null) {
                try {
                    inputStream.close();
                }
                catch (IOException e) {
                    logger.log(Level.WARNING, "Exception closing file at \"" + propertiesPath + "\"", e);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String loadProperty(Properties properties, String propertiesPath, String key) {
        InputStream inputStream = null;
        try {
            if (properties.isEmpty()) {
                inputStream = PropertiesProvider.class.getResourceAsStream(propertiesPath);
                if (inputStream != null) {
                    properties.load(inputStream);
                    inputStream.close();
                } else {
                    PropertiesProvider.logMissingProperties(PropertiesProvider.class, propertiesPath);
                    String string = null;
                    return string;
                }
            }
            String string = properties.getProperty(key);
            return string;
        }
        catch (Exception e) {
            logger.log(Level.WARNING, "Exception loading properties at \"" + propertiesPath + "\"", e);
            String string = null;
            return string;
        }
        finally {
            if (inputStream != null) {
                try {
                    inputStream.close();
                }
                catch (IOException e) {
                    logger.log(Level.WARNING, "Exception closing file at \"" + propertiesPath + "\"", e);
                }
            }
        }
    }

    private static void logMissingProperties(Class<?> loadedClass, String propertyFilePath) {
        logger.log(Level.WARNING, "Warning: Failed to open properties resource at '%s' of the given class '%s'\n", new Object[]{propertyFilePath, loadedClass.getName()});
    }
}

