/*
 * Decompiled with CFR 0.152.
 */
package com.gigaspaces.admin.cli;

import com.gigaspaces.admin.cli.ArgsTokenizer;
import com.gigaspaces.admin.cli.CLIUtilities;
import com.gigaspaces.admin.cli.Constants;
import com.gigaspaces.admin.cli.Formatter;
import com.gigaspaces.admin.cli.GS;
import com.gigaspaces.admin.cli.OptionHandler;
import com.gigaspaces.admin.cli.utils.CLISecurityRepository;
import com.gigaspaces.security.directory.CredentialsProvider;
import java.beans.Statement;
import java.io.BufferedReader;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;

public abstract class AbstractApplicationDeployHandler
implements GS.OptionHandler,
Constants {
    private static final Logger logger = Logger.getLogger("com.gigaspaces.admin.cli");
    private OptionHandler validOptions;
    private final String methodName;
    private final String className;
    private Class deployerClass;

    protected AbstractApplicationDeployHandler(String className, String methodName) {
        block4: {
            this.className = className;
            this.methodName = methodName;
            try {
                this.deployerClass = Class.forName(className);
                Field validOptionsField = this.deployerClass.getDeclaredField("validOptionsArray");
                String[] validOptionsArray = (String[])validOptionsField.get(null);
                this.validOptions = new OptionHandler(Formatter.fromArray(validOptionsArray));
            }
            catch (ClassNotFoundException e) {
                System.out.println("Please install OpenSpaces.");
                if (logger.isLoggable(Level.SEVERE)) {
                    logger.log(Level.SEVERE, e.toString());
                }
            }
            catch (Exception e) {
                if (!logger.isLoggable(Level.SEVERE)) break block4;
                logger.log(Level.SEVERE, e.toString(), e);
            }
        }
    }

    @Override
    public String getUsage() {
        try {
            Object deployer = this.createDeployerObject();
            Method getUsageMethod = deployer.getClass().getMethod("getUsage", new Class[0]);
            return (String)getUsageMethod.invoke(deployer, new Object[0]);
        }
        catch (ClassNotFoundException e) {
            System.out.println("Please install OpenSpaces.");
        }
        catch (Throwable e) {
            String msg = "Error showing pudeploy usage";
            logger.log(Level.WARNING, msg, e);
            System.out.println(msg + ":" + e.toString());
        }
        return "";
    }

    @Override
    public String process(String input, BufferedReader br) {
        ArgsTokenizer tokenizer = new ArgsTokenizer(input);
        int count = tokenizer.countTokens();
        if (count <= 1) {
            return this.getUsage();
        }
        tokenizer.nextToken();
        ArrayList<String> argsList = new ArrayList<String>(--count);
        for (int i = 0; i < count; ++i) {
            String token = tokenizer.nextToken();
            argsList.add(token);
        }
        String[] argv = new String[argsList.size()];
        argsList.toArray(argv);
        try {
            Map<String, String> args = this.validOptions.getOptions(input, true, true);
            if (args.containsKey("h") || args.containsKey("help")) {
                return this.getUsage();
            }
            Object deployer = this.createDeployerObject();
            Statement deploy = new Statement(deployer, this.methodName, new Object[]{argv});
            deploy.execute();
        }
        catch (IllegalArgumentException e) {
            if (e.getMessage() != null) {
                System.out.println(e.getMessage());
            } else {
                System.out.println(e.toString());
            }
            System.out.println(this.getUsage());
        }
        catch (Throwable e) {
            Object[] localCommandArgLine = CLIUtilities.getArgLineWithScreenPassword(argv);
            String msg = "Error deploying " + Arrays.toString(localCommandArgLine);
            logger.log(Level.SEVERE, msg, e);
            System.out.println(msg + ":" + e.toString());
        }
        return "";
    }

    private Object createDeployerObject() throws Exception {
        Object deployer = this.deployerClass.newInstance();
        Statement setManaged = new Statement(deployer, "setManaged", new Object[]{Boolean.TRUE});
        setManaged.execute();
        Statement setSout = new Statement(deployer, "setSout", new Object[]{Boolean.TRUE});
        setSout.execute();
        CredentialsProvider credentialsProvider = CLISecurityRepository.getInstance().getCurrentCredentialsProvider();
        if (credentialsProvider != null) {
            Statement setAdminUserDetails = new Statement(deployer, "setCredentialsProvider", new Object[]{credentialsProvider});
            setAdminUserDetails.execute();
        }
        return deployer;
    }
}

