/*
 * Decompiled with CFR 0.152.
 */
package com.gigaspaces.admin.cli;

import com.gigaspaces.admin.cli.CannotCastToBooleanException;
import com.gigaspaces.admin.cli.Constants;
import com.gigaspaces.admin.cli.GS;
import java.beans.Statement;
import java.util.HashMap;
import java.util.StringTokenizer;
import java.util.logging.Level;
import java.util.logging.Logger;

@Deprecated
public abstract class AbstractElasticDeploymentHandler
implements GS.OptionHandler,
Constants {
    private static final Logger LOGGER = Logger.getLogger("com.gigaspaces.admin.cli");

    protected void applyDedicatedMachineProvisioning(String propertiesAsString, Object elasticSpacePUDeployment) throws Exception {
        StringTokenizer tokenizer = new StringTokenizer(propertiesAsString);
        int count = tokenizer.countTokens();
        HashMap<DedicatedMachineProvisioningProperty, String> properties = new HashMap<DedicatedMachineProvisioningProperty, String>();
        for (int i = 0; i < count; ++i) {
            String token = tokenizer.nextToken();
            String[] propertyArray = token.split("=");
            String propertyName = propertyArray[0];
            DedicatedMachineProvisioningProperty property = DedicatedMachineProvisioningProperty.findByPropertyName(propertyName);
            if (property == null) {
                throw new IllegalArgumentException("Unknown dedicated-machine-provisioning property [" + propertyName + "]");
            }
            if (propertyArray.length > 1) {
                properties.put(property, propertyArray[1]);
                continue;
            }
            properties.put(property, null);
        }
        Object discoveredMachineProvisioningConfigurer = Class.forName("org.openspaces.admin.pu.elastic.config.DiscoveredMachineProvisioningConfigurer").newInstance();
        block6: for (DedicatedMachineProvisioningProperty property : properties.keySet()) {
            String propertyValue = (String)properties.get((Object)property);
            switch (property) {
                case GRID_SERVICE_AGENTS_ZONES: {
                    String[] zones;
                    this.logFinestIfLoggable("Handling GRID_SERVICE_AGENTS_ZONES on [" + propertyValue + "]");
                    for (String zone : zones = propertyValue.split(",")) {
                        AbstractElasticDeploymentHandler.logFineIfLoggable("Applying addGridServiceAgentZone on [" + zone + "]");
                        discoveredMachineProvisioningConfigurer.getClass().getMethod("addGridServiceAgentZone", String.class).invoke(discoveredMachineProvisioningConfigurer, zone);
                    }
                    continue block6;
                }
                case RESERVED_MEMORY_CAPACITY_PER_MACHINE: {
                    this.logFinestIfLoggable("Handling RESERVED_MEMORY_CAPACITY_PER_MACHINE");
                    String validationResult = this.validateMemoryParameter(propertyValue);
                    if (validationResult != null) {
                        throw new IllegalArgumentException("Invalid value for property [" + DedicatedMachineProvisioningProperty.RESERVED_MEMORY_CAPACITY_PER_MACHINE.getPropertyName() + "]: " + validationResult);
                    }
                    AbstractElasticDeploymentHandler.logFineIfLoggable("Applying reservedMemoryCapacityPerMachine on [" + propertyValue + "]");
                    discoveredMachineProvisioningConfigurer.getClass().getMethod("reservedMemoryCapacityPerMachine", String.class).invoke(discoveredMachineProvisioningConfigurer, propertyValue);
                    break;
                }
                case RESERVED_MEMORY_CAPACITY_PER_MANAGEMENT_MACHINE: {
                    this.logFinestIfLoggable("Handling RESERVED_MEMORY_CAPACITY_PER_MANAGEMENT_MACHINE");
                    String validationResult = this.validateMemoryParameter(propertyValue);
                    if (validationResult != null) {
                        throw new IllegalArgumentException("Invalid value for property [" + DedicatedMachineProvisioningProperty.RESERVED_MEMORY_CAPACITY_PER_MANAGEMENT_MACHINE.getPropertyName() + "]: " + validationResult);
                    }
                    AbstractElasticDeploymentHandler.logFineIfLoggable("Applying reservedMemoryCapacityPerManagementMachine on [" + propertyValue + "]");
                    discoveredMachineProvisioningConfigurer.getClass().getMethod("reservedMemoryCapacityPerManagementMachine", String.class).invoke(discoveredMachineProvisioningConfigurer, propertyValue);
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Unhandled dedicatedMachineProvisioning property [" + property.getPropertyName() + "]");
                }
            }
        }
        Object discoveredMachineProvisioningConfig = discoveredMachineProvisioningConfigurer.getClass().getMethod("create", new Class[0]).invoke(discoveredMachineProvisioningConfigurer, new Object[0]);
        Statement dedicatedMachineProvisioningStatement = new Statement(elasticSpacePUDeployment, "dedicatedMachineProvisioning", new Object[]{discoveredMachineProvisioningConfig});
        dedicatedMachineProvisioningStatement.execute();
    }

    protected void applySharedMachineProvisioning(String propertiesAsString, Object elasticSpacePUDeployment) throws Exception {
        StringTokenizer tokenizer = new StringTokenizer(propertiesAsString);
        int count = tokenizer.countTokens();
        String sharingId = null;
        HashMap<SharedMachineProvisioningProperty, String> properties = new HashMap<SharedMachineProvisioningProperty, String>();
        for (int i = 0; i < count; ++i) {
            String token = tokenizer.nextToken();
            String[] propertyArray = token.split("=");
            String propertyName = propertyArray[0];
            SharedMachineProvisioningProperty property = SharedMachineProvisioningProperty.findByPropertyName(propertyName);
            if (property == null) {
                throw new IllegalArgumentException("Unknown shared-machine-provisioning property [" + propertyName + "]");
            }
            if (property.equals((Object)SharedMachineProvisioningProperty.SHARING_ID)) {
                sharingId = propertyArray[1];
                continue;
            }
            if (propertyArray.length > 1) {
                properties.put(property, propertyArray[1]);
                continue;
            }
            properties.put(property, null);
        }
        if (sharingId == null) {
            throw new IllegalArgumentException("Property [" + SharedMachineProvisioningProperty.SHARING_ID.getPropertyName() + "] of shared-machine-provisioning must be specified.");
        }
        Object discoveredMachineProvisioningConfigurer = Class.forName("org.openspaces.admin.pu.elastic.config.DiscoveredMachineProvisioningConfigurer").newInstance();
        block6: for (SharedMachineProvisioningProperty property : properties.keySet()) {
            String propertyValue = (String)properties.get((Object)property);
            switch (property) {
                case GRID_SERVICE_AGENTS_ZONES: {
                    String[] zones;
                    this.logFinestIfLoggable("Handling GRID_SERVICE_AGENTS_ZONES on [" + propertyValue + "]");
                    for (String zone : zones = propertyValue.split(",")) {
                        AbstractElasticDeploymentHandler.logFineIfLoggable("Applying addGridServiceAgentZone on [" + zone + "]");
                        discoveredMachineProvisioningConfigurer.getClass().getMethod("addGridServiceAgentZone", String.class).invoke(discoveredMachineProvisioningConfigurer, zone);
                    }
                    continue block6;
                }
                case RESERVED_MEMORY_CAPACITY_PER_MACHINE: {
                    this.logFinestIfLoggable("Handling RESERVED_MEMORY_CAPACITY_PER_MACHINE");
                    String validationResult = this.validateMemoryParameter(propertyValue);
                    if (validationResult != null) {
                        throw new IllegalArgumentException("Invalid value for property [" + DedicatedMachineProvisioningProperty.RESERVED_MEMORY_CAPACITY_PER_MACHINE.getPropertyName() + "]: " + validationResult);
                    }
                    AbstractElasticDeploymentHandler.logFineIfLoggable("Applying reservedMemoryCapacityPerMachine on [" + propertyValue + "]");
                    discoveredMachineProvisioningConfigurer.getClass().getMethod("reservedMemoryCapacityPerMachine", String.class).invoke(discoveredMachineProvisioningConfigurer, propertyValue);
                    break;
                }
                case RESERVED_MEMORY_CAPACITY_PER_MANAGEMENT_MACHINE: {
                    this.logFinestIfLoggable("Handling RESERVED_MEMORY_CAPACITY_PER_MANAGEMENT_MACHINE");
                    String validationResult = this.validateMemoryParameter(propertyValue);
                    if (validationResult != null) {
                        throw new IllegalArgumentException("Invalid value for property [" + DedicatedMachineProvisioningProperty.RESERVED_MEMORY_CAPACITY_PER_MANAGEMENT_MACHINE.getPropertyName() + "]: " + validationResult);
                    }
                    AbstractElasticDeploymentHandler.logFineIfLoggable("Applying reservedMemoryCapacityPerManagementMachine on [" + propertyValue + "]");
                    discoveredMachineProvisioningConfigurer.getClass().getMethod("reservedMemoryCapacityPerManagementMachine", String.class).invoke(discoveredMachineProvisioningConfigurer, propertyValue);
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Unhandled dedicatedMachineProvisioning property [" + property.getPropertyName() + "]");
                }
            }
        }
        Object discoveredMachineProvisioningConfig = discoveredMachineProvisioningConfigurer.getClass().getMethod("create", new Class[0]).invoke(discoveredMachineProvisioningConfigurer, new Object[0]);
        Statement dedicatedMachineProvisioningStatement = new Statement(elasticSpacePUDeployment, "sharedMachineProvisioning", new Object[]{sharingId, discoveredMachineProvisioningConfig});
        dedicatedMachineProvisioningStatement.execute();
    }

    protected Object parseScaleProperties(String propertiesAsString) throws Exception {
        Object scaleStrategyConfigurer;
        ScaleStrategy scaleStrategy;
        String scaleStrategyName;
        StringTokenizer tokenizer = new StringTokenizer(propertiesAsString);
        int count = tokenizer.countTokens();
        if (count == 0) {
            throw new IllegalArgumentException("Scale strategy property must be provided");
        }
        HashMap<ScaleProperty, String> properties = new HashMap<ScaleProperty, String>();
        for (int i = 0; i < count; ++i) {
            String token = tokenizer.nextToken();
            String[] propertyArray = token.split("=");
            String propertyName = propertyArray[0];
            ScaleProperty property = ScaleProperty.findByPropertyName(propertyName);
            if (property == null) {
                throw new IllegalArgumentException("Unknown scale property [" + (String)propertyName + "]");
            }
            if (propertyArray.length > 1) {
                properties.put(property, propertyArray[1]);
                continue;
            }
            properties.put(property, null);
        }
        if (!properties.containsKey((Object)ScaleProperty.MAX_CONCURRENT_RELOCATIONS_PER_MACHINE)) {
            AbstractElasticDeploymentHandler.logFineIfLoggable("Scale property [" + ScaleProperty.MAX_CONCURRENT_RELOCATIONS_PER_MACHINE.getPropertyName() + "] is not provided, using default value: 1");
            properties.put(ScaleProperty.MAX_CONCURRENT_RELOCATIONS_PER_MACHINE, "1");
        }
        if (!properties.containsKey((Object)ScaleProperty.AT_MOST_ONE_CONCURRENT_RELOCATION)) {
            AbstractElasticDeploymentHandler.logFineIfLoggable("Scale property [" + ScaleProperty.AT_MOST_ONE_CONCURRENT_RELOCATION.getPropertyName() + "] is not provided, using default value: true");
            properties.put(ScaleProperty.AT_MOST_ONE_CONCURRENT_RELOCATION, "true");
        }
        if ((scaleStrategyName = (String)properties.get((Object)ScaleProperty.STRATEGY)) == null) {
            System.out.println("Scale strategy is not provided, using the default value : " + ScaleStrategy.getDefaultValue().getName());
            scaleStrategy = ScaleStrategy.getDefaultValue();
        } else {
            scaleStrategy = ScaleStrategy.findByStrategyName(scaleStrategyName);
            if (scaleStrategy == null) {
                throw new IllegalArgumentException("Invalid scale strategy [" + scaleStrategyName + "]");
            }
        }
        if (scaleStrategy.equals((Object)ScaleStrategy.EAGER)) {
            scaleStrategyConfigurer = Class.forName("org.openspaces.admin.pu.elastic.config.EagerScaleConfigurer").newInstance();
        } else if (scaleStrategy.equals((Object)ScaleStrategy.MANUAL)) {
            scaleStrategyConfigurer = Class.forName("org.openspaces.admin.pu.elastic.config.ManualCapacityScaleConfigurer").newInstance();
        } else {
            throw new IllegalArgumentException("Unhandled scale strategy [" + (Object)((Object)scaleStrategy) + "]");
        }
        block14: for (ScaleProperty property : properties.keySet()) {
            String propertyValue = (String)properties.get((Object)property);
            switch (property) {
                case STRATEGY: {
                    continue block14;
                }
                case MEMORY_CAPACITY: {
                    this.logFinestIfLoggable("Handling MAX_MEMORY_CAPACITY");
                    if (scaleStrategy.equals((Object)ScaleStrategy.MANUAL)) {
                        String validationResult = this.validateMemoryParameter(propertyValue);
                        if (validationResult != null) {
                            throw new IllegalArgumentException("Invalid value for property [" + ScaleProperty.MEMORY_CAPACITY.getPropertyName() + "]: " + validationResult);
                        }
                        AbstractElasticDeploymentHandler.logFineIfLoggable("Applying memoryCapacity on [" + propertyValue + "]");
                        scaleStrategyConfigurer.getClass().getMethod("memoryCapacity", String.class).invoke(scaleStrategyConfigurer, propertyValue);
                        continue block14;
                    }
                    throw new IllegalArgumentException("Scale property [" + ScaleProperty.MEMORY_CAPACITY.getPropertyName() + "] can only be used with manual scale");
                }
                case MAX_CONCURRENT_RELOCATIONS_PER_MACHINE: {
                    this.logFinestIfLoggable("Handling MAX_MEMORY_CAPACITY");
                    try {
                        AbstractElasticDeploymentHandler.logFineIfLoggable("Applying maxConcurrentRelocationsPerMachine on [" + propertyValue + "]");
                        scaleStrategyConfigurer.getClass().getMethod("maxConcurrentRelocationsPerMachine", Integer.TYPE).invoke(scaleStrategyConfigurer, Integer.valueOf(propertyValue));
                        continue block14;
                    }
                    catch (NumberFormatException e) {
                        throw new IllegalArgumentException("Invalid value for property [" + ScaleProperty.NUMBER_OF_CPU_CORES.getPropertyName() + "]: Must be a number");
                    }
                }
                case NUMBER_OF_CPU_CORES: {
                    this.logFinestIfLoggable("Handling MAX_MEMORY_CAPACITY");
                    if (scaleStrategy.equals((Object)ScaleStrategy.MANUAL)) {
                        try {
                            AbstractElasticDeploymentHandler.logFineIfLoggable("Applying numberOfCpuCores on [" + propertyValue + "]");
                            scaleStrategyConfigurer.getClass().getMethod("numberOfCpuCores", Double.TYPE).invoke(scaleStrategyConfigurer, Double.valueOf(propertyValue));
                            continue block14;
                        }
                        catch (NumberFormatException e) {
                            throw new IllegalArgumentException("Invalid value for property [" + ScaleProperty.NUMBER_OF_CPU_CORES.getPropertyName() + "]: Must be a number");
                        }
                    }
                    throw new IllegalArgumentException("Scale property [" + ScaleProperty.NUMBER_OF_CPU_CORES.getPropertyName() + "] can only be used with manual scale");
                }
                case AT_MOST_ONE_CONCURRENT_RELOCATION: {
                    this.logFinestIfLoggable("Handling AT_MOST_ONE_CONCURRENT_RELOCATION");
                    try {
                        AbstractElasticDeploymentHandler.logFineIfLoggable("Applying atMostOneConcurrentRelocation on [" + propertyValue + "]");
                        boolean booleanValue = AbstractElasticDeploymentHandler.getBooleanValue(propertyValue);
                        scaleStrategyConfigurer.getClass().getMethod("atMostOneConcurrentRelocation", Boolean.TYPE).invoke(scaleStrategyConfigurer, booleanValue);
                        continue block14;
                    }
                    catch (CannotCastToBooleanException e) {
                        throw new IllegalArgumentException("Invalid value for property [" + ScaleProperty.AT_MOST_ONE_CONCURRENT_RELOCATION.getPropertyName() + "]: Must be boolean");
                    }
                }
            }
            throw new IllegalArgumentException("Unhandled scale property [" + property.getPropertyName() + "]");
        }
        Object scaleConfig = scaleStrategyConfigurer.getClass().getMethod("create", new Class[0]).invoke(scaleStrategyConfigurer, new Object[0]);
        return scaleConfig;
    }

    protected static boolean getBooleanValue(String propertyValue) throws CannotCastToBooleanException {
        if (propertyValue == null || propertyValue.equals("") || propertyValue.equalsIgnoreCase("true")) {
            return true;
        }
        if (propertyValue.equalsIgnoreCase("false")) {
            return false;
        }
        throw new CannotCastToBooleanException();
    }

    protected String validateMemoryParameter(String memoryWithUnit) {
        if (memoryWithUnit.length() < 2) {
            return "Memory size and unit[m/g] must be specified, found: [" + memoryWithUnit + "]";
        }
        String memoryUnit = memoryWithUnit.substring(memoryWithUnit.length() - 1);
        if (!memoryUnit.equals("m") && !memoryUnit.equals("g")) {
            return "Invalid memory unit " + memoryUnit;
        }
        String memorySize = memoryWithUnit.substring(0, memoryWithUnit.length() - 1);
        try {
            Integer.valueOf(memorySize);
        }
        catch (NumberFormatException e) {
            return "Invalid memory size " + memorySize;
        }
        return null;
    }

    private static void logFineIfLoggable(String msg) {
        if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.fine(msg);
        }
    }

    private void logFinestIfLoggable(String msg) {
        if (LOGGER.isLoggable(Level.FINEST)) {
            LOGGER.finest(msg);
        }
    }

    protected static enum ScaleStrategy {
        EAGER("eager"),
        MANUAL("manual");

        private final String strategyName;

        private ScaleStrategy(String strategyName) {
            this.strategyName = strategyName;
        }

        public String getName() {
            return this.strategyName;
        }

        public static ScaleStrategy findByStrategyName(String strategyName) {
            for (ScaleStrategy scaleStrategy : ScaleStrategy.values()) {
                if (!scaleStrategy.strategyName.equals(strategyName)) continue;
                return scaleStrategy;
            }
            return null;
        }

        public String toString() {
            return this.strategyName;
        }

        public static ScaleStrategy getDefaultValue() {
            return EAGER;
        }
    }

    protected static enum SharedMachineProvisioningProperty {
        SHARING_ID("sharing-id", "sid", "sid, sharing-id=[common id to be used with other pu instances]"),
        GRID_SERVICE_AGENTS_ZONES("grid-service-agents-zones", "gsaz", "gsaz, grid-service-agents-zones=[comma separated list of zones]"),
        RESERVED_MEMORY_CAPACITY_PER_MACHINE("reserved-memory-capacity-per-machine", "rmcpm", "rmcpm, reserved-memory-capacity-per-machine=[number[m/g]]"),
        RESERVED_MEMORY_CAPACITY_PER_MANAGEMENT_MACHINE("reserved-memory-capacity-per-management-machine", "rmcpmm", "rmcpmm, reserved-memory-capacity-per-management-machine=[number[m/g]]");

        private String propertyName;
        private String propertyShortName;
        private String propertyUsage;

        private SharedMachineProvisioningProperty(String propertyName, String propertyShortName, String propertyUsage) {
            this.propertyName = propertyName;
            this.propertyShortName = propertyShortName;
            this.propertyUsage = propertyUsage;
        }

        public String getPropertyName() {
            return this.propertyName;
        }

        public String getPropertyShortName() {
            return this.propertyShortName;
        }

        public String getPropertyUsage() {
            return this.propertyUsage;
        }

        public static String getPropertiesUsage() {
            StringBuilder sb = new StringBuilder();
            SharedMachineProvisioningProperty[] values = SharedMachineProvisioningProperty.values();
            for (int i = 0; i < values.length; ++i) {
                sb.append("\t\t\t" + values[i].getPropertyUsage());
                if (i == values.length - 1) continue;
                sb.append("\n");
            }
            return sb.toString();
        }

        public static SharedMachineProvisioningProperty findByPropertyName(String propertyName) {
            for (SharedMachineProvisioningProperty property : SharedMachineProvisioningProperty.values()) {
                if (!property.getPropertyName().equals(propertyName) && !property.getPropertyShortName().equals(propertyName)) continue;
                return property;
            }
            return null;
        }
    }

    protected static enum DedicatedMachineProvisioningProperty {
        GRID_SERVICE_AGENTS_ZONES("grid-service-agents-zones", "gsaz", "gsaz, grid-service-agents-zones=[comma separated list of zones]"),
        RESERVED_MEMORY_CAPACITY_PER_MACHINE("reserved-memory-capacity-per-machine", "rmcpm", "rmcpm, reserved-memory-capacity-per-machine=[number[m/g]]"),
        RESERVED_MEMORY_CAPACITY_PER_MANAGEMENT_MACHINE("reserved-memory-capacity-per-management-machine", "rmcpmm", "rmcpmm, reserved-memory-capacity-per-management-machine=[number[m/g]]");

        private String propertyName;
        private String propertyShortName;
        private String propertyUsage;

        private DedicatedMachineProvisioningProperty(String propertyName, String propertyShortName, String propertyUsage) {
            this.propertyName = propertyName;
            this.propertyShortName = propertyShortName;
            this.propertyUsage = propertyUsage;
        }

        public String getPropertyName() {
            return this.propertyName;
        }

        public String getPropertyShortName() {
            return this.propertyShortName;
        }

        public String getPropertyUsage() {
            return this.propertyUsage;
        }

        public static String getPropertiesUsage() {
            StringBuilder sb = new StringBuilder();
            DedicatedMachineProvisioningProperty[] values = DedicatedMachineProvisioningProperty.values();
            for (int i = 0; i < values.length; ++i) {
                sb.append("\t\t\t" + values[i].getPropertyUsage());
                if (i == values.length - 1) continue;
                sb.append("\n");
            }
            return sb.toString();
        }

        public static DedicatedMachineProvisioningProperty findByPropertyName(String propertyName) {
            for (DedicatedMachineProvisioningProperty property : DedicatedMachineProvisioningProperty.values()) {
                if (!property.getPropertyName().equals(propertyName) && !property.getPropertyShortName().equals(propertyName)) continue;
                return property;
            }
            return null;
        }
    }

    protected static enum ScaleProperty {
        STRATEGY("strategy", "strategy=[" + (Object)((Object)ScaleStrategy.EAGER) + "/" + (Object)((Object)ScaleStrategy.MANUAL) + "]"),
        MAX_CONCURRENT_RELOCATIONS_PER_MACHINE("max-concurrent-relocations-per-machine", "mcrpm", "mcrpm, max-moncurrent-relocations-per-machine=[number]"),
        MEMORY_CAPACITY("memory-capacity", "mc", "mc, memory-capacity=[number[m/g]]\t : Manual strategy only"),
        NUMBER_OF_CPU_CORES("number-of-cpu-cores", "nocc", "nocc, number-of-cpu-cores=[number]\t : Manual strategy only"),
        AT_MOST_ONE_CONCURRENT_RELOCATION("at-most-one-concurrent-relocation", "amocr", "amocr, at-most-one-concurrent-relocation=[true/false]");

        private String propertyName;
        private String propertyShortName;
        private String propertyUsage;

        private ScaleProperty(String propertyName, String propertyUsage) {
            this.propertyName = propertyName;
            this.propertyShortName = null;
            this.propertyUsage = propertyUsage;
        }

        private ScaleProperty(String propertyName, String propertyShortName, String propertyUsage) {
            this.propertyName = propertyName;
            this.propertyShortName = propertyShortName;
            this.propertyUsage = propertyUsage;
        }

        public String getPropertyName() {
            return this.propertyName;
        }

        public String getPropertyShortName() {
            return this.propertyShortName;
        }

        public String getPropertyUsage() {
            return this.propertyUsage;
        }

        public static ScaleProperty findByPropertyName(String propertyName) {
            for (ScaleProperty property : ScaleProperty.values()) {
                if (!property.getPropertyName().equals(propertyName) && (property.getPropertyShortName() == null || !property.getPropertyShortName().equals(propertyName))) continue;
                return property;
            }
            return null;
        }

        public static String getPropertiesUsage() {
            StringBuilder sb = new StringBuilder();
            ScaleProperty[] values = ScaleProperty.values();
            for (int i = 0; i < values.length; ++i) {
                sb.append("\t\t\t" + values[i].getPropertyUsage());
                if (i == values.length - 1) continue;
                sb.append("\n");
            }
            return sb.toString();
        }
    }
}

