/*
 * Decompiled with CFR 0.152.
 */
package com.gigaspaces.admin.cli;

import com.gigaspaces.admin.cli.CLIFinder;
import com.gigaspaces.admin.cli.CLIUtilities;
import com.gigaspaces.admin.cli.Constants;
import com.gigaspaces.admin.cli.Formatter;
import com.gigaspaces.admin.cli.GS;
import com.gigaspaces.internal.client.spaceproxy.IDirectSpaceProxy;
import com.gigaspaces.internal.service.ServiceItemUtils;
import com.j_spaces.core.IJSpace;
import com.j_spaces.core.IJSpaceContainer;
import com.j_spaces.core.NoSuchNameException;
import com.j_spaces.core.admin.IJSpaceContainerAdmin;
import com.j_spaces.core.admin.IRemoteJSpaceAdmin;
import com.j_spaces.core.client.FinderException;
import com.j_spaces.core.client.SpaceURL;
import com.j_spaces.core.client.SpaceURLParser;
import com.j_spaces.core.cluster.ClusterPolicy;
import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.net.MalformedURLException;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.jini.core.lookup.ServiceItem;

public abstract class AbstractSpaceCommand
implements GS.OptionHandler,
Constants {
    protected String operationName;
    protected static final String CANCEL_OPTION = "c";
    protected static final String YES_OPTION = "y";
    protected static final String NO_OPTION = "n";
    protected static final Logger _logger = Logger.getLogger("com.gigaspaces.admin.cli");
    protected int searchedSpaceState;

    protected Map<String, IRemoteJSpaceAdmin> getClusterMembersAdminSpaces(ClusterPolicy clusterPolicy) throws RemoteException, FinderException, NoSuchNameException {
        Map<String, IJSpace> spaceProxiesMap = CLIFinder.getClusterMembersSpaceProxies(clusterPolicy, this.searchedSpaceState);
        HashMap<String, IRemoteJSpaceAdmin> spaceAdminsMap = new HashMap<String, IRemoteJSpaceAdmin>(spaceProxiesMap.size());
        Set<Map.Entry<String, IJSpace>> entriesSet = spaceProxiesMap.entrySet();
        for (Map.Entry<String, IJSpace> entry : entriesSet) {
            String memberName = entry.getKey();
            IJSpace spaceProxy = entry.getValue();
            IRemoteJSpaceAdmin remoteSpaceAdmin = (IRemoteJSpaceAdmin)spaceProxy.getAdmin();
            spaceAdminsMap.put(memberName, remoteSpaceAdmin);
        }
        return spaceAdminsMap;
    }

    protected StringBuffer getBasicUsage() {
        StringBuffer strBuffer = new StringBuffer();
        strBuffer.append("\n*****************************************************\n");
        strBuffer.append("Usage: space " + this.operationName + "[options]\n");
        strBuffer.append("options:\n");
        strBuffer.append("\t-h/-help    prints help\n");
        strBuffer.append("\t-url    space url\n");
        strBuffer.append("\t-c/-cluster    cluster operation\n");
        return strBuffer;
    }

    protected IJSpace[] getSelectedSpaceProxies(BufferedReader br) {
        ServiceItem[] items = CLIFinder.findSpaceServices(this.searchedSpaceState);
        return this.getSelectedFromListSpaceProxies(items, br, 8);
    }

    protected IJSpace[] getAllClusterMembers(ClusterPolicy clusterPolicy, BufferedReader br) {
        ServiceItem[] clusterMembers = CLIFinder.findClusterMembers(clusterPolicy, this.searchedSpaceState);
        return this.getSelectedFromListSpaceProxies(clusterMembers, br, 8);
    }

    protected IJSpace[] getSelectedFromListSpaceProxies(ServiceItem[] items, BufferedReader br, int options) {
        ServiceItem[] selectedItems;
        if (items.length == 0) {
            System.out.println("No GigaSpace instances discovered\n");
            return null;
        }
        if (br == null) {
            br = new BufferedReader(new InputStreamReader(System.in));
        }
        if ((selectedItems = Formatter.selectItems(items, this.getPrompt(this.operationName), br, options)) == null || selectedItems.length == 0) {
            return null;
        }
        int arraySize = selectedItems.length;
        LinkedList<IDirectSpaceProxy> spacesList = new LinkedList<IDirectSpaceProxy>();
        for (int i = 0; i < arraySize; ++i) {
            IDirectSpaceProxy service = ServiceItemUtils.getSpaceProxyIfRelevant((ServiceItem)selectedItems[i]);
            if (service == null) continue;
            spacesList.add(service);
        }
        return spacesList.toArray(new IJSpace[spacesList.size()]);
    }

    protected Object find(String finderURL) throws RemoteException, FinderException {
        Object foundService;
        block4: {
            foundService = null;
            SpaceURL spaceURL = null;
            try {
                spaceURL = SpaceURLParser.parseURL((String)finderURL);
                foundService = CLIFinder.find(spaceURL, this.searchedSpaceState);
            }
            catch (FinderException e) {
                CLIUtilities.printWrongServiceURLMessage(finderURL, spaceURL != null && finderURL != null && finderURL.indexOf("groups") >= 0, finderURL != null && finderURL.indexOf("locators") >= 0);
                if (_logger.isLoggable(Level.SEVERE)) {
                    _logger.log(Level.SEVERE, e.toString(), e);
                }
                throw e;
            }
            catch (Exception e1) {
                CLIUtilities.printWrongServiceURLMessage(finderURL, finderURL != null && finderURL.indexOf("groups") >= 0, finderURL != null && finderURL.indexOf("locators") >= 0);
                if (!_logger.isLoggable(Level.SEVERE)) break block4;
                _logger.log(Level.SEVERE, e1.toString(), e1);
            }
        }
        return foundService;
    }

    private String getPrompt(String command) {
        return "Enter a comma-separated list to " + command + " or \"" + CANCEL_OPTION + "\" to cancel : ";
    }

    protected ClusterPolicy getClusterPolicy(IJSpace space) {
        ClusterPolicy clusterPolicy;
        block2: {
            clusterPolicy = null;
            try {
                clusterPolicy = ((IRemoteJSpaceAdmin)space.getAdmin()).getClusterPolicy();
            }
            catch (Exception re) {
                if (!_logger.isLoggable(Level.SEVERE)) break block2;
                _logger.log(Level.SEVERE, re.toString(), re);
            }
        }
        return clusterPolicy;
    }

    public ServiceItem[] getContainerSpaces(IJSpaceContainer containerProxy, String url) throws RemoteException, NoSuchNameException, MalformedURLException {
        SpaceURL spaceURL = SpaceURLParser.parseURL((String)url);
        if (spaceURL.isRmiProtocol()) {
            String[] spaceNames = containerProxy.getSpaceNames();
            ArrayList<ServiceItem> servicesList = new ArrayList<ServiceItem>(spaceNames.length);
            for (int i = 0; i < spaceNames.length; ++i) {
                String spaceName = spaceNames[i];
                IJSpace spaceProxy = containerProxy.getSpace(spaceName);
                if (this.searchedSpaceState >= 0 && ((IRemoteJSpaceAdmin)((IDirectSpaceProxy)spaceProxy).getRemoteJSpace()).getState() != this.searchedSpaceState) continue;
                ServiceItem serviceItem = CLIFinder.createSpaceServiceItem(spaceProxy, spaceName);
                servicesList.add(serviceItem);
            }
            return servicesList.toArray(new ServiceItem[servicesList.size()]);
        }
        if (spaceURL.isJiniProtocol()) {
            String containerName = containerProxy.getName();
            IJSpaceContainerAdmin containerAdmin = (IJSpaceContainerAdmin)containerProxy;
            String hostName = containerAdmin.getConfig().containerHostName;
            return CLIFinder.findSpacesByJini(containerName, null, hostName, this.searchedSpaceState);
        }
        return null;
    }
}

