/*
 * Decompiled with CFR 0.152.
 */
package com.gigaspaces.admin.cli;

import com.gigaspaces.admin.cli.AbstractGSACommand;
import com.gigaspaces.admin.cli.CLIUtilities;
import com.gigaspaces.admin.cli.Formatter;
import com.gigaspaces.admin.cli.GS;
import com.gigaspaces.admin.cli.OptionHandler;
import com.gigaspaces.grid.gsa.GSA;
import com.gigaspaces.grid.gsa.GSProcessOptions;
import com.gigaspaces.security.AuthenticationException;
import com.j_spaces.kernel.JSpaceUtilities;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.Map;
import java.util.logging.Level;
import net.jini.core.lookup.ServiceItem;

public abstract class AbstractStartAgentCommand
extends AbstractGSACommand {
    private static String[] validOptionsArray = new String[]{"h", "help", "host"};
    private final String _agentType;
    private final String _agentTypeDescr;

    public AbstractStartAgentCommand(String operationName, String agentType, String agentTypeDescr) {
        super(new OptionHandler(Formatter.fromArray(validOptionsArray)), operationName);
        this._agentType = agentType;
        this._agentTypeDescr = agentTypeDescr;
    }

    @Override
    public String process(String input, BufferedReader br) {
        block10: {
            Map<String, String> args = null;
            try {
                args = this.validOptions.getOptions(input, true);
            }
            catch (IllegalArgumentException e) {
                if (e.getMessage() != null) {
                    System.out.println(e.getMessage());
                } else {
                    System.out.println(e.toString());
                }
                System.out.println(this.getUsage());
                return "";
            }
            if (args.containsKey("h") || args.containsKey("help")) {
                return this.getUsage();
            }
            String hostName = null;
            if (args.containsKey("host") && JSpaceUtilities.isEmpty((String)(hostName = args.get("host")), (boolean)true)) {
                CLIUtilities.printMissingValueMessage("host");
                return "";
            }
            GSA selectedGSA = this.getSelectedFromListGSAServices(br, hostName);
            if (selectedGSA == null) {
                return "";
            }
            try {
                GSProcessOptions gsProcessOptions = new GSProcessOptions(this._agentType);
                selectedGSA.startProcess(gsProcessOptions);
                System.out.println(this._agentTypeDescr + " agent created");
            }
            catch (AuthenticationException ae) {
                System.out.println("failed due:" + ae.toString());
            }
            catch (IOException re) {
                System.out.println(" failed. Please see CLI log file for details.");
                if (!_logger.isLoggable(Level.SEVERE)) break block10;
                _logger.log(Level.SEVERE, re.toString(), re);
            }
        }
        return "";
    }

    @Override
    public String getUsage() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("usage: gsa " + this.operationName + "\n");
        stringBuilder.append("Options:\n");
        stringBuilder.append("\t-h/-help\tprints help\n");
        stringBuilder.append("\t-host\t\thost name, optional parameter, allows to locate gsa that is running on specific machine\n");
        stringBuilder.append("Usage example:\n");
        stringBuilder.append("\tusage: gsa " + this.operationName + " -" + "host" + " host_name\n");
        stringBuilder.append("\n*****************************************************\n");
        return stringBuilder.toString();
    }

    protected GSA getSelectedFromListGSAServices(BufferedReader br, String hostName) {
        ServiceItem[] gsaServiceItems;
        if (br == null) {
            br = new BufferedReader(new InputStreamReader(System.in));
        }
        String[] machines = null;
        if (hostName != null) {
            machines = new String[]{hostName};
        }
        if ((gsaServiceItems = GS.getServiceFinder().findGSAs(machines, null)).length == 0) {
            System.out.println("No GSA instances discovered\n");
            return null;
        }
        ServiceItem[] selectedItems = Formatter.selectItems(gsaServiceItems, this.getPrompt(this.operationName), br, -1, false);
        if (selectedItems == null || selectedItems.length == 0) {
            return null;
        }
        return (GSA)selectedItems[0].getService();
    }

    private String getPrompt(String command) {
        return "Enter a number of service to gsa " + command + " or \"" + "c" + "\" to cancel : ";
    }
}

