/*
 * Decompiled with CFR 0.152.
 */
package com.gigaspaces.admin.cli;

import com.gigaspaces.admin.cli.Constants;
import com.gigaspaces.admin.cli.GS;
import com.gigaspaces.admin.cli.multicast.MulticastTest;
import com.gigaspaces.logger.GSLogConfigLoader;
import java.io.BufferedReader;
import java.util.HashMap;
import java.util.Map;
import java.util.StringTokenizer;

public class AdminHandler
implements GS.OptionHandler,
Constants {
    public static final String OPERATION_NAME = "admin";
    private static final Map<String, GS.OptionHandler> handlresMap = new HashMap<String, GS.OptionHandler>();

    @Override
    public String process(String input, BufferedReader br) {
        StringTokenizer tok = new StringTokenizer(input);
        tok.nextToken();
        if (!tok.hasMoreTokens()) {
            return this.getUsage();
        }
        String value = tok.nextToken();
        GS.OptionHandler handler = handlresMap.get(value);
        if (handler == null) {
            System.out.println("Unknown option : " + value);
            return this.getUsage();
        }
        StringBuilder args = new StringBuilder();
        while (tok.hasMoreTokens()) {
            args.append(tok.nextToken()).append(' ');
        }
        return handler.process(args.toString(), br);
    }

    @Override
    public String getUsage() {
        StringBuffer strBuffer = new StringBuffer();
        strBuffer.append("usage: ");
        strBuffer.append(OPERATION_NAME);
        strBuffer.append(" command [options]\n\n");
        strBuffer.append("Available commands (select a single command):\n\t");
        strBuffer.append("multicastTest");
        strBuffer.append("\noptions:\n\t-");
        strBuffer.append("h/-help");
        return strBuffer.toString();
    }

    static {
        handlresMap.put("multicastTest", new MulticastTest());
        GSLogConfigLoader.getLoader();
    }
}

