/*
 * Decompiled with CFR 0.152.
 */
package com.gigaspaces.admin.cli;

import java.util.ArrayList;
import java.util.List;

public class ArgsTokenizer {
    private String[] args;
    private int currentIndex = 0;

    public ArgsTokenizer(String commandLine) {
        ArrayList<String> resultBuffer = new ArrayList<String>();
        if (commandLine != null) {
            boolean inQuotes = false;
            StringBuilder buf = new StringBuilder();
            for (int i = 0; i < commandLine.length(); ++i) {
                char c = commandLine.charAt(i);
                if (c == '\"') {
                    ArgsTokenizer.addToResult(resultBuffer, buf);
                    inQuotes = !inQuotes;
                    continue;
                }
                if (inQuotes) {
                    buf.append(c);
                    continue;
                }
                if (Character.isWhitespace(c)) {
                    ArgsTokenizer.addToResult(resultBuffer, buf);
                    continue;
                }
                buf.append(c);
            }
            ArgsTokenizer.addToResult(resultBuffer, buf);
        }
        this.args = resultBuffer.toArray(new String[resultBuffer.size()]);
    }

    private static void addToResult(List<String> resultBuffer, StringBuilder buf) {
        if (buf.length() > 0) {
            resultBuffer.add(buf.toString());
            buf.setLength(0);
        }
    }

    public int countTokens() {
        return this.args.length;
    }

    public String nextToken() {
        return this.args[this.currentIndex++];
    }
}

