/*
 * Decompiled with CFR 0.152.
 */
package com.gigaspaces.admin.cli;

import com.gigaspaces.admin.cli.GS;
import com.gigaspaces.cluster.replication.MirrorServiceConfig;
import com.gigaspaces.internal.client.spaceproxy.IDirectSpaceProxy;
import com.gigaspaces.internal.client.spaceproxy.SpaceProxyImpl;
import com.gigaspaces.internal.service.ServiceItemUtils;
import com.j_spaces.core.IJSpace;
import com.j_spaces.core.NoSuchNameException;
import com.j_spaces.core.admin.IRemoteJSpaceAdmin;
import com.j_spaces.core.client.FinderException;
import com.j_spaces.core.client.SpaceFinder;
import com.j_spaces.core.client.SpaceURL;
import com.j_spaces.core.client.SpaceURLParser;
import com.j_spaces.core.cluster.ClusterMemberInfo;
import com.j_spaces.core.cluster.ClusterPolicy;
import com.j_spaces.kernel.JSpaceUtilities;
import com.j_spaces.lookup.entry.ClusterName;
import com.j_spaces.lookup.entry.ContainerName;
import com.j_spaces.lookup.entry.HostName;
import com.j_spaces.lookup.entry.State;
import java.net.InetAddress;
import java.net.MalformedURLException;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.jini.core.entry.Entry;
import net.jini.core.lookup.ServiceItem;
import net.jini.lookup.entry.Name;

public class CLIFinder {
    protected static final Logger _logger;
    public static final String LOCALHOST_NAME;

    public static Object find(SpaceURL finderSpaceURL, int spaceState) throws RemoteException, FinderException, NoSuchNameException {
        if (finderSpaceURL.isJiniProtocol()) {
            Object service;
            String spaceName = finderSpaceURL.getSpaceName();
            if (spaceName != null) {
                String hostName;
                String containerName = finderSpaceURL.getContainerName();
                ServiceItem[] foundServiceItems = CLIFinder.findSpacesByJini(containerName, spaceName, hostName = finderSpaceURL.getHost(), spaceState);
                if (foundServiceItems == null || foundServiceItems.length == 0) {
                    return null;
                }
                service = foundServiceItems[0].getService();
            } else {
                ServiceItem[] foundServiceItems = CLIFinder.findContainerServicesByJini(finderSpaceURL);
                if (foundServiceItems == null) {
                    return null;
                }
                service = foundServiceItems[0].getService();
            }
            if (service instanceof SpaceProxyImpl) {
                ((SpaceProxyImpl)service).setFinderURL(finderSpaceURL);
            }
            return service;
        }
        if (finderSpaceURL.isRmiProtocol()) {
            Object obj = SpaceFinder.find((SpaceURL)finderSpaceURL);
            if (obj instanceof IJSpace) {
                IJSpace spaceProxy = (IJSpace)obj;
                IRemoteJSpaceAdmin remoteSpaceAdmin = (IRemoteJSpaceAdmin)((IDirectSpaceProxy)obj).getRemoteJSpace();
                if (spaceState >= 0 && remoteSpaceAdmin.getState() != spaceState) {
                    obj = null;
                }
            }
            return obj;
        }
        return null;
    }

    public static ServiceItem[] findSpaceServices(int spaceState) {
        Entry[] entriesArray = null;
        if (spaceState >= 0) {
            entriesArray = new Entry[1];
            State state = new State(spaceState);
            entriesArray[0] = state;
        }
        ServiceItem[] serviceItems = GS.getServiceFinder().findSpaces(null, entriesArray);
        return serviceItems;
    }

    public static ServiceItem[] findSpaceServices(String finderURL, int spaceState) throws RemoteException, FinderException {
        IJSpace space;
        SpaceURL spaceURL = null;
        try {
            spaceURL = SpaceURLParser.parseURL((String)finderURL);
        }
        catch (MalformedURLException e) {
            throw new FinderException(e.toString());
        }
        if (spaceURL.isJiniProtocol()) {
            String hostName;
            String spaceName;
            String containerName = spaceURL.getContainerName();
            ServiceItem[] serviceItems = CLIFinder.findSpacesByJini(containerName, spaceName = spaceURL.getSpaceName(), hostName = spaceURL.getHost(), spaceState);
            if (serviceItems.length == 0) {
                if (hostName != null) {
                    System.out.println("Space '" + spaceName + "' under container '" + containerName + "' that running on host '" + hostName + "' was not found.");
                } else {
                    System.out.println("Space '" + spaceName + "' under container '" + containerName + "' was not found.");
                }
                return null;
            }
            return serviceItems;
        }
        if (spaceURL.isRmiProtocol() && (space = (IJSpace)SpaceFinder.find((String)finderURL)) != null && (spaceState < 0 || spaceState >= 0 && ((IRemoteJSpaceAdmin)((IDirectSpaceProxy)space).getRemoteJSpace()).getState() == spaceState)) {
            ServiceItem serviceItem = CLIFinder.createSpaceServiceItem(space, null);
            return new ServiceItem[]{serviceItem};
        }
        return null;
    }

    public static ServiceItem[] findSpacesByJini(String containerName, String spaceName, String hostName, int spaceState) {
        ArrayList<Object> entriesList = new ArrayList<Object>(3);
        if (!JSpaceUtilities.isEmpty((String)containerName) && !"*".equals(containerName)) {
            entriesList.add(new ContainerName(containerName));
        }
        if (!JSpaceUtilities.isEmpty((String)spaceName) && !"*".equals(spaceName)) {
            entriesList.add(new Name(spaceName));
        }
        if (!JSpaceUtilities.isEmpty((String)hostName) && !"*".equals(hostName)) {
            entriesList.add(CLIFinder.createHostNameAttribute(hostName));
        }
        if (spaceState >= 0) {
            entriesList.add(new State(spaceState));
        }
        Entry[] entriesArray = entriesList.toArray(new Entry[entriesList.size()]);
        ServiceItem[] serviceItems = GS.getServiceFinder().findSpaces(null, entriesArray);
        return serviceItems;
    }

    private static ServiceItem[] findContainerServicesByJini(SpaceURL spaceURL) throws FinderException {
        String containerName = spaceURL.getContainerName();
        String hostName = spaceURL.getHost();
        ArrayList<Object> entriesList = new ArrayList<Object>(2);
        if (!JSpaceUtilities.isEmpty((String)containerName) && !"*".equals(containerName)) {
            entriesList.add(new Name(containerName));
        }
        if (!JSpaceUtilities.isEmpty((String)hostName) && !"*".equals(hostName)) {
            entriesList.add(CLIFinder.createHostNameAttribute(hostName));
        }
        Entry[] entriesArray = entriesList.toArray(new Entry[entriesList.size()]);
        ServiceItem[] serviceItems = GS.getServiceFinder().find(null, entriesArray);
        if (serviceItems.length == 0) {
            System.out.println("Container '" + containerName + "' running on host '" + hostName + "' was not found.");
            return null;
        }
        return serviceItems;
    }

    public static ServiceItem[] findClusterMembers(String clusterName, int spaceState) throws RemoteException {
        ClusterName clusterNameAttr = new ClusterName(clusterName);
        Entry[] entriesArray = new Entry[]{clusterNameAttr};
        ServiceItem[] clusterMembers = GS.getServiceFinder().findSpaces(null, entriesArray);
        if (clusterMembers.length > 0) {
            IDirectSpaceProxy spaceProxy = ServiceItemUtils.getSpaceProxy((ServiceItem)clusterMembers[0]);
            IRemoteJSpaceAdmin spaceAdmin = (IRemoteJSpaceAdmin)spaceProxy.getAdmin();
            ClusterPolicy clusterPolicy = spaceAdmin.getClusterPolicy();
            clusterMembers = CLIFinder.getAllClusterMembers(clusterPolicy, clusterMembers);
        }
        return clusterMembers;
    }

    public static ServiceItem[] findClusterMembers(ClusterPolicy clusterPolicy, int spaceState) {
        Set<ClusterMemberInfo> clusterMembersSet = CLIFinder.getClusterMembersInfo(clusterPolicy);
        Iterator<ClusterMemberInfo> iterator = clusterMembersSet.iterator();
        String protocolName = "jini:";
        if (iterator.hasNext()) {
            SpaceURL memberURL = iterator.next().memberURL;
            protocolName = memberURL.getProtocol();
        }
        ServiceItem[] clusterMembers = null;
        if (protocolName.equals("jini:")) {
            String clusterName = clusterPolicy.m_ClusterName;
            ClusterName clusterNameEntry = new ClusterName(clusterName);
            Entry[] entriesArray = new Entry[spaceState < 0 ? 1 : 2];
            entriesArray[0] = clusterNameEntry;
            if (spaceState >= 0) {
                State state = new State(spaceState);
                entriesArray[1] = state;
            }
            clusterMembers = GS.getServiceFinder().findSpaces(null, entriesArray);
            clusterMembers = CLIFinder.getAllClusterMembers(clusterPolicy, clusterMembers);
        } else if (protocolName.equals("rmi:")) {
            iterator = clusterMembersSet.iterator();
            ArrayList<ServiceItem> resultList = new ArrayList<ServiceItem>(clusterMembersSet.size());
            while (iterator.hasNext()) {
                ClusterMemberInfo clusterMemberInfo = iterator.next();
                SpaceURL memberURL = clusterMemberInfo.memberURL;
                try {
                    IJSpace spaceProxy = (IJSpace)SpaceFinder.find((SpaceURL)memberURL);
                    if (spaceState >= 0 && ((IRemoteJSpaceAdmin)((IDirectSpaceProxy)spaceProxy).getRemoteJSpace()).getState() != spaceState) continue;
                    ServiceItem spaceItem = CLIFinder.createSpaceServiceItem(spaceProxy, null);
                    resultList.add(spaceItem);
                }
                catch (Exception e) {
                    System.out.println("Failed to find space cluster member:" + memberURL);
                    _logger.log(Level.SEVERE, e.toString(), e);
                }
            }
            clusterMembers = resultList.toArray(new ServiceItem[resultList.size()]);
        }
        return clusterMembers;
    }

    private static ServiceItem[] getAllClusterMembers(ClusterPolicy clusterPolicy, ServiceItem[] clusterMembers) {
        if (clusterPolicy.getReplicationPolicy() != null && clusterPolicy.getReplicationPolicy().getMirrorServiceConfig() != null) {
            MirrorServiceConfig mirrorServiceConfig = clusterPolicy.getReplicationPolicy().getMirrorServiceConfig();
            ServiceItem[] mirrorClusterMember = CLIFinder.findMirrorService(mirrorServiceConfig);
            ServiceItem[] resultsArray = new ServiceItem[clusterMembers.length + mirrorClusterMember.length];
            System.arraycopy(clusterMembers, 0, resultsArray, 0, clusterMembers.length);
            System.arraycopy(mirrorClusterMember, 0, resultsArray, clusterMembers.length, mirrorClusterMember.length);
            clusterMembers = resultsArray;
        }
        return clusterMembers;
    }

    private static ServiceItem[] findMirrorService(MirrorServiceConfig mirrorServiceConfig) {
        String mirrorSpaceName = mirrorServiceConfig.serviceURL.getSpaceName();
        String mirrorContainerName = mirrorServiceConfig.serviceURL.getContainerName();
        return CLIFinder.findMirrorService(mirrorSpaceName, mirrorContainerName);
    }

    private static ServiceItem[] findMirrorService(String mirrorSpaceName, String mirrorContainerName) {
        Name spaceNameAttr = new Name(mirrorSpaceName);
        ContainerName containerNameAttr = new ContainerName(mirrorContainerName);
        Entry[] entriesArray = new Entry[]{spaceNameAttr, containerNameAttr};
        return GS.getServiceFinder().findSpaces(null, entriesArray);
    }

    public static Map<String, IJSpace> getClusterMembersSpaceProxies(ClusterPolicy clusterPolicy, int spaceState) throws RemoteException, FinderException, NoSuchNameException {
        Set<ClusterMemberInfo> clusterMembersSet = CLIFinder.getClusterMembersInfo(clusterPolicy);
        int listSize = clusterMembersSet.size();
        HashMap<String, IJSpace> spaceProxiesMap = new HashMap<String, IJSpace>(listSize);
        for (ClusterMemberInfo clusterMemberInfo : clusterMembersSet) {
            IJSpace spaceProxy = (IJSpace)CLIFinder.find(clusterMemberInfo.memberURL, spaceState);
            if (spaceProxy == null) continue;
            spaceProxiesMap.put(clusterMemberInfo.memberName, spaceProxy);
        }
        return spaceProxiesMap;
    }

    public static Set<ClusterMemberInfo> getClusterMembersInfo(ClusterPolicy clusterPolicy) {
        return JSpaceUtilities.getClusterMembersInfoSet((ClusterPolicy)clusterPolicy);
    }

    public static ServiceItem createSpaceServiceItem(IJSpace spaceProxy, String spaceName) {
        if (spaceName == null) {
            spaceName = spaceProxy.getName();
        }
        Entry[] attrSet = new Entry[1];
        Name nameEntry = new Name(spaceName);
        attrSet[0] = nameEntry;
        ServiceItem serviceItem = new ServiceItem(null, (Object)spaceProxy, attrSet);
        return serviceItem;
    }

    private static HostName createHostNameAttribute(String hostName) {
        if (hostName == null) {
            return null;
        }
        if (hostName.equals("localhost")) {
            hostName = LOCALHOST_NAME;
        }
        return new HostName(hostName);
    }

    static {
        String localhost;
        block2: {
            _logger = Logger.getLogger("com.gigaspaces.admin.cli");
            localhost = null;
            try {
                localhost = InetAddress.getLocalHost().getHostName();
            }
            catch (Exception e) {
                if (!_logger.isLoggable(Level.SEVERE)) break block2;
                _logger.log(Level.SEVERE, e.toString(), e);
            }
        }
        LOCALHOST_NAME = localhost;
    }
}

