/*
 * Decompiled with CFR 0.152.
 */
package com.gigaspaces.admin.cli;

import java.util.logging.Logger;
import net.jini.core.entry.Entry;

public class CLIUtilities {
    protected static final Logger _logger = Logger.getLogger("com.gigaspaces.admin.cli");
    private static final String SERVICE_NOT_FOUND_WITH_PASSED_JINI_GROUP = "When using the CLI, lookup groups should be defined via the XAP_LOOKUP_GROUPS environment property and not a URL parameter.";
    private static final String SERVICE_NOT_FOUND_WITH_PASSED_LOOKUP_LOCATOR = "When using the CLI lookup locators should be defined via the XAP_LOOKUP_LOCATORS environment property and not a URL parameter.";

    public static void printMissingParameterMessage(String parameterName) {
        System.out.println("Parameter \"-" + parameterName + "\" must be provided.");
    }

    public static void printMissingParametersMessage(String parameter1Name, String parameter2Name) {
        System.out.println("Parameter \"-" + parameter1Name + "\" or \"-" + parameter2Name + "\" must be provided.");
    }

    public static void printMissingValueMessage(String value) {
        System.out.println(value + " value must be provided.");
    }

    public static void printMissingNameMessage(String name) {
        System.out.println(name + " name must be provided.");
    }

    public static void printWrongServiceURLMessage(String finderURL, boolean isGroupParameterPassed, boolean isLookupLocatorPassed) {
        System.out.println("Service is not found using the URL: " + finderURL);
        if (isGroupParameterPassed) {
            System.out.println(SERVICE_NOT_FOUND_WITH_PASSED_JINI_GROUP);
        }
        if (isLookupLocatorPassed) {
            System.out.println(SERVICE_NOT_FOUND_WITH_PASSED_LOOKUP_LOCATOR);
        }
    }

    public static void printWrongSpaceURLMessage(String finderURL, boolean isGroupParameterPassed, boolean isLookupLocatorPassed) {
        System.out.println("Space is not found using the URL: " + finderURL);
        if (isGroupParameterPassed) {
            System.out.println(SERVICE_NOT_FOUND_WITH_PASSED_JINI_GROUP);
        }
        if (isLookupLocatorPassed) {
            System.out.println(SERVICE_NOT_FOUND_WITH_PASSED_LOOKUP_LOCATOR);
        }
    }

    public static void printWrongClusterMemberMessage(String clusterMemberName) {
        System.out.println("Cluster member is not found using the member name: " + clusterMemberName);
    }

    public static Entry getEntryClass(Entry[] entriesArray, Class classInstance) {
        if (entriesArray != null) {
            for (Entry entry : entriesArray) {
                if (!entry.getClass().equals(classInstance)) continue;
                return entry;
            }
        }
        return null;
    }

    public static String[] getArgLineWithScreenPassword(String[] commandArgLine) {
        String[] localCommandArgLine = new String[commandArgLine.length];
        System.arraycopy(commandArgLine, 0, localCommandArgLine, 0, commandArgLine.length);
        for (int index = 0; index < localCommandArgLine.length; ++index) {
            String arg = localCommandArgLine[index];
            if (!arg.equalsIgnoreCase("-user") && !arg.equalsIgnoreCase("-password") || index + 1 >= localCommandArgLine.length) continue;
            localCommandArgLine[index + 1] = "****";
        }
        return localCommandArgLine;
    }

    public static boolean isGroupParameterPassed() {
        return true;
    }
}

