/*
 * Decompiled with CFR 0.152.
 */
package com.gigaspaces.admin.cli;

import com.gigaspaces.admin.cli.AbstractSpaceCommand;
import com.gigaspaces.admin.cli.CLIFinder;
import com.gigaspaces.admin.cli.CLIUtilities;
import com.gigaspaces.admin.cli.Formatter;
import com.gigaspaces.admin.cli.OptionHandler;
import com.gigaspaces.client.ClearException;
import com.gigaspaces.document.SpaceDocument;
import com.gigaspaces.security.SecurityException;
import com.j_spaces.core.IJSpace;
import com.j_spaces.core.IJSpaceContainer;
import com.j_spaces.core.NoSuchNameException;
import com.j_spaces.core.client.FinderException;
import com.j_spaces.core.cluster.ClusterPolicy;
import com.j_spaces.kernel.JSpaceUtilities;
import java.io.BufferedReader;
import java.rmi.RemoteException;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import net.jini.core.lookup.ServiceItem;

public class CleanSpace
extends AbstractSpaceCommand {
    private OptionHandler validOptions;
    public static final String OPERATION_NAME = "clean";

    public CleanSpace() {
        String[] validOptionsArray = new String[]{"h", "help", "url", "template", "c", "cluster"};
        this.validOptions = new OptionHandler(Formatter.fromArray(validOptionsArray));
        this.operationName = OPERATION_NAME;
        this.searchedSpaceState = 1;
    }

    @Override
    public String getUsage() {
        StringBuffer strBuffer = this.getBasicUsage();
        strBuffer.append("\t-template    class template\n");
        strBuffer.append("\n*****************************************************\n");
        return strBuffer.toString();
    }

    @Override
    public String process(String input, BufferedReader br) {
        try {
            ClusterPolicy clusterPolicy;
            Map<String, String> args = this.validOptions.getOptions(input, true);
            if (args.containsKey("h") || args.containsKey("help")) {
                return this.getUsage();
            }
            if (!args.containsKey("url")) {
                IJSpace[] spaces = this.getSelectedSpaceProxies(br);
                this.clearSpaces(spaces, args);
                return "";
            }
            String finderURL = args.get("url");
            if (JSpaceUtilities.isEmpty((String)finderURL, (boolean)true)) {
                CLIUtilities.printMissingValueMessage("url");
                return "";
            }
            Object foundObj = null;
            try {
                foundObj = this.find(finderURL);
            }
            catch (FinderException e) {
                return "";
            }
            if (foundObj == null) {
                CLIUtilities.printWrongServiceURLMessage(finderURL, finderURL != null && finderURL.indexOf("groups") >= 0, finderURL != null && finderURL.indexOf("locators") >= 0);
                return "";
            }
            IJSpace space = null;
            if (foundObj instanceof IJSpaceContainer) {
                ServiceItem[] serviceItemsArray = this.getContainerSpaces((IJSpaceContainer)foundObj, finderURL);
                IJSpace[] spacesArray = this.getSelectedFromListSpaceProxies(serviceItemsArray, br, -1);
                this.clearSpaces(spacesArray, args);
                return "";
            }
            if (foundObj instanceof IJSpace) {
                space = (IJSpace)foundObj;
            }
            if ((clusterPolicy = this.getClusterPolicy(space)) != null) {
                if (args.containsKey("c") || args.containsKey("cluster")) {
                    System.out.println("Attempting to receive cluster members...");
                    SpaceDocument template = null;
                    if (args.containsKey("template")) {
                        template = new SpaceDocument(args.get("template"));
                    }
                    this.clearClusterMembers(clusterPolicy, template);
                } else {
                    IJSpace[] selectedClusterMembers = this.getAllClusterMembers(clusterPolicy, br);
                    if (selectedClusterMembers == null) {
                        return "No cluster members found.";
                    }
                    this.clearSpaces(selectedClusterMembers, args);
                }
            } else {
                String spaceName = space.getName();
                System.out.println("Started to clean <" + spaceName + "> space...");
                SpaceDocument template = null;
                if (args.containsKey("template")) {
                    template = new SpaceDocument(args.get("template"));
                }
                this.clearSpace(space, template);
                System.out.println("The <" + spaceName + "> space cleaned successfully.");
            }
        }
        catch (ClearException se) {
            Throwable cause = this.getClearExceptionCause(se);
            if (cause instanceof SecurityException) {
                this.handleSecurityException((SecurityException)cause);
            } else {
                this.handleRegularException((Exception)((Object)se));
            }
        }
        catch (SecurityException se) {
            this.handleSecurityException(se);
        }
        catch (IllegalArgumentException e) {
            if (e.getMessage() != null) {
                System.out.println(e.getMessage());
            } else {
                System.out.println(e.toString());
            }
            System.out.println(this.getUsage());
        }
        catch (Exception ex) {
            this.handleRegularException(ex);
        }
        return "";
    }

    private Throwable getClearExceptionCause(ClearException se) {
        return se.getCauses() != null && se.getCauses().length > 0 ? se.getCauses()[0] : se.getCause();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void clearClusterMembers(ClusterPolicy clusterPolicy, Object template) throws RemoteException, FinderException, NoSuchNameException {
        Map<String, IJSpace> proxySpacesMap = CLIFinder.getClusterMembersSpaceProxies(clusterPolicy, this.searchedSpaceState);
        Set<Map.Entry<String, IJSpace>> entriesSet = proxySpacesMap.entrySet();
        int mapSize = proxySpacesMap.size();
        System.out.println("There are " + mapSize + " cluster spaces to be cleaned.");
        int counter = 0;
        String operationName = "Clear";
        for (Map.Entry<String, IJSpace> mapEntry : entriesSet) {
            IJSpace spaceProxy = mapEntry.getValue();
            String memberName = mapEntry.getKey();
            try {
                System.out.print(" " + operationName + " of <" + memberName + "> cluster member (" + (counter + 1) + " of " + mapSize + ")... ");
                this.clearSpace(spaceProxy, template);
                System.out.println(" successful");
            }
            catch (ClearException se) {
                Throwable cause = this.getClearExceptionCause(se);
                if (cause instanceof SecurityException) {
                    this.handleSecurityException((SecurityException)cause);
                    continue;
                }
                this.handleRegularException((Exception)((Object)se));
            }
            catch (SecurityException se) {
                this.handleSecurityException(se);
            }
            catch (Exception e) {
                this.handleRegularException(e);
            }
            finally {
                ++counter;
            }
        }
    }

    private void clearSpaces(IJSpace[] spaces, Map<String, String> args) throws RemoteException {
        if (spaces != null) {
            int selSpacesAmount = spaces.length;
            for (int i = 0; i < selSpacesAmount; ++i) {
                SpaceDocument template = null;
                if (args.containsKey("template")) {
                    template = new SpaceDocument(args.get("template"));
                }
                String spaceName = spaces[i].getName();
                System.out.print("Started to clean <" + spaceName + "> space (" + (i + 1) + " of " + selSpacesAmount + ")...");
                try {
                    this.clearSpace(spaces[i], template);
                    System.out.println(" successful");
                    continue;
                }
                catch (ClearException se) {
                    Throwable cause = this.getClearExceptionCause(se);
                    if (cause instanceof SecurityException) {
                        this.handleSecurityException((SecurityException)cause);
                        continue;
                    }
                    this.handleRegularException((Exception)((Object)se));
                    continue;
                }
                catch (SecurityException se) {
                    this.handleSecurityException(se);
                    continue;
                }
                catch (Exception e) {
                    this.handleRegularException(e);
                }
            }
        }
    }

    private void clearSpace(IJSpace space, Object template) throws Exception {
        space.clear(template, null);
    }

    private void handleSecurityException(SecurityException securityException) {
        System.out.println(" failed due to a security error: " + securityException.toString());
    }

    private void handleRegularException(Exception exception) {
        System.out.println(" failed. Please see CLI log file for details.");
        _logger.log(Level.SEVERE, exception.toString(), exception);
    }
}

