/*
 * Decompiled with CFR 0.152.
 */
package com.gigaspaces.admin.cli;

import com.gigaspaces.admin.cli.AbstractSpaceCommand;
import com.gigaspaces.admin.cli.CLIFinder;
import com.gigaspaces.admin.cli.CLIUtilities;
import com.gigaspaces.admin.cli.Formatter;
import com.gigaspaces.admin.cli.OptionHandler;
import com.gigaspaces.cluster.activeelection.ISpaceModeListener;
import com.gigaspaces.cluster.activeelection.SpaceMode;
import com.gigaspaces.internal.client.spaceproxy.IDirectSpaceProxy;
import com.gigaspaces.internal.service.ServiceItemUtils;
import com.j_spaces.core.IJSpace;
import com.j_spaces.core.IJSpaceContainer;
import com.j_spaces.core.admin.IInternalRemoteJSpaceAdmin;
import com.j_spaces.core.admin.IRemoteJSpaceAdmin;
import com.j_spaces.core.admin.SpaceConfig;
import com.j_spaces.core.client.FinderException;
import com.j_spaces.core.cluster.ClusterMemberInfo;
import com.j_spaces.core.cluster.ClusterPolicy;
import com.j_spaces.kernel.JSpaceUtilities;
import com.j_spaces.lookup.entry.ContainerName;
import java.io.BufferedReader;
import java.rmi.Remote;
import java.rmi.RemoteException;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import net.jini.core.entry.Entry;
import net.jini.core.lookup.ServiceItem;

public class ClusterMembers
extends AbstractSpaceCommand {
    private final OptionHandler validOptions;
    public static final String OPERATION_NAME = "cluster-members";
    private static final int[] _tabs = new int[]{37, 10, 105, 9};
    private static final String[] _labels = new String[]{"member name", "is alive", "member url", "primary"};
    private static final String YES_VAL = "Yes";
    private static final String NO_VAL = "No";

    public ClusterMembers() {
        String[] validOptionsArray = new String[]{"h", "help", "url", "clustername"};
        this.validOptions = new OptionHandler(Formatter.fromArray(validOptionsArray));
        this.searchedSpaceState = -1;
    }

    @Override
    public String getUsage() {
        StringBuffer strBuffer = new StringBuffer();
        strBuffer.append("\n*****************************************************\n");
        strBuffer.append("Prints cluster members information.\n");
        strBuffer.append("Usage: space cluster-members [options]\n");
        strBuffer.append("options:\n");
        strBuffer.append("\t-h/-help    prints help\n");
        strBuffer.append("\t-url    space url\n");
        strBuffer.append("\t-clustername    cluster name\n");
        return strBuffer.toString();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public String process(String input, BufferedReader br) {
        try {
            Map<String, String> args = this.validOptions.getOptions(input, true);
            if (args.containsKey("h")) return this.getUsage();
            if (args.containsKey("help")) return this.getUsage();
            if (args.containsKey("url") && args.containsKey("clustername")) {
                return this.getUsage();
            }
            ServiceItem[] items = null;
            String finderURL = args.get("url");
            if (args.containsKey("url")) {
                if (JSpaceUtilities.isEmpty((String)finderURL, (boolean)true)) {
                    CLIUtilities.printMissingValueMessage("url");
                    return "";
                }
                Object foundObj = null;
                try {
                    foundObj = this.find(finderURL);
                }
                catch (FinderException e) {
                    return "";
                }
                if (foundObj == null) {
                    CLIUtilities.printWrongServiceURLMessage(finderURL, finderURL != null && finderURL.indexOf("groups") >= 0, finderURL != null && finderURL.indexOf("locators") >= 0);
                    return "";
                }
                IJSpace spaceProxy = null;
                if (foundObj instanceof IJSpaceContainer) {
                    System.out.println("Please provide URL for a clustered space. URL of space container was provided.");
                    return "";
                }
                if (!(foundObj instanceof IJSpace)) {
                    System.out.println("Please provide URL for a clustered space.");
                    return "";
                }
                spaceProxy = (IJSpace)foundObj;
                ClusterPolicy clusterPolicy = this.getClusterPolicy(spaceProxy);
                if (clusterPolicy == null) {
                    System.out.println("Please provide URL for a clustered space. URL of not clustered space was provided.");
                    return "";
                }
                System.out.println("Attempting to receive cluster members...");
                items = CLIFinder.findClusterMembers(clusterPolicy, this.searchedSpaceState);
            } else {
                if (!args.containsKey("clustername")) return this.getUsage();
                String clusterName = args.get("clustername");
                if (JSpaceUtilities.isEmpty((String)clusterName, (boolean)true)) {
                    CLIUtilities.printMissingValueMessage("clustername");
                    return "";
                }
                items = CLIFinder.findClusterMembers(clusterName, this.searchedSpaceState);
            }
            if (items == null) return "";
            this.spaceLister(items);
            return "";
        }
        catch (IllegalArgumentException e) {
            if (e.getMessage() != null) {
                System.out.println(e.getMessage());
            } else {
                System.out.println(e.toString());
            }
            System.out.println(this.getUsage());
            return "";
        }
        catch (Exception ex) {
            _logger.log(Level.SEVERE, ex.toString(), ex);
        }
        return "";
    }

    private void spaceLister(ServiceItem[] items) {
        StringBuilder strBuff = null;
        System.out.println("\n" + ClusterMembers.createLabel(_labels));
        String sep = "---------------------------------------------------------------------------------------------------------------------------------------------------------------";
        System.out.println(sep);
        Set<ClusterMemberInfo> clusterMembersInfoSet = null;
        if (items != null && items.length > 0) {
            try {
                IDirectSpaceProxy space = ServiceItemUtils.getSpaceProxy((ServiceItem)items[0]);
                IRemoteJSpaceAdmin admin = (IRemoteJSpaceAdmin)space.getAdmin();
                ClusterPolicy clusterPolicy = admin.getClusterPolicy();
                clusterMembersInfoSet = CLIFinder.getClusterMembersInfo(clusterPolicy);
            }
            catch (Exception e) {
                if (_logger.isLoggable(Level.SEVERE)) {
                    _logger.log(Level.SEVERE, e.toString(), e);
                }
                return;
            }
            if (clusterMembersInfoSet == null) {
                return;
            }
            Map<String, String> aliveClusterMembersMap = this.getSpacePrimaryIndication(items);
            for (ClusterMemberInfo clusterMemberInfo : clusterMembersInfoSet) {
                String memberName = clusterMemberInfo.memberName;
                String isAlive = aliveClusterMembersMap.containsKey(memberName) ? YES_VAL : NO_VAL;
                String memberURL = clusterMemberInfo.memberURL.toString();
                String primaryIndication = aliveClusterMembersMap.containsKey(memberName) ? aliveClusterMembersMap.get(memberName) : "-";
                StringBuilder additionalInfoBuffer = new StringBuilder();
                System.out.println(ClusterMembers.createLabel(new String[]{memberName, isAlive, memberURL, primaryIndication}));
                System.out.println(additionalInfoBuffer.toString());
                if (strBuff != null && strBuff.length() > 0) {
                    System.out.println(strBuff.toString());
                }
                System.out.println(sep);
            }
            if (items.length > 0) {
                System.out.println("");
            }
            System.out.println(clusterMembersInfoSet.size() + " defined cluster member instance(s)");
            System.out.println(items.length + " alive cluster member instance(s)" + JSpaceUtilities.LINE_SEPARATOR);
        }
    }

    private Map<String, String> getSpacePrimaryIndication(ServiceItem[] items) {
        HashMap<String, String> map = new HashMap<String, String>(items.length);
        for (int i = 0; i < items.length; ++i) {
            try {
                IDirectSpaceProxy space = ServiceItemUtils.getSpaceProxy((ServiceItem)items[i]);
                Entry[] entriesArray = items[i].attributeSets;
                IRemoteJSpaceAdmin admin = null;
                admin = (IRemoteJSpaceAdmin)space.getAdmin();
                SpaceConfig spaceConfig = admin.getConfig();
                if (!spaceConfig.isClustered()) continue;
                ISpaceModeListener remoteListener = (ISpaceModeListener)space.getDirectProxy().getStubHandler().exportObject((Remote)((Object)new SpaceModeListenerImpl()));
                SpaceMode mode = ((IInternalRemoteJSpaceAdmin)admin).addSpaceModeListener(remoteListener);
                ((IInternalRemoteJSpaceAdmin)admin).removeSpaceModeListener(remoteListener);
                String primaryIndication = "-";
                if (mode != null) {
                    primaryIndication = mode.equals((Object)SpaceMode.PRIMARY) ? YES_VAL : NO_VAL;
                }
                String spaceName = space.getName();
                String containerName = this.getContainerName(entriesArray, (IJSpace)space);
                String clusterMemberName = containerName + ":" + spaceName;
                map.put(clusterMemberName, primaryIndication);
                continue;
            }
            catch (Exception e) {
                if (!_logger.isLoggable(Level.SEVERE)) continue;
                _logger.log(Level.SEVERE, e.toString(), e);
            }
        }
        return map;
    }

    private String getContainerName(Entry[] entriesArray, IJSpace spaceProxy) throws RemoteException {
        ContainerName containerNameEntry = (ContainerName)CLIUtilities.getEntryClass(entriesArray, ContainerName.class);
        String containerName = "";
        containerName = containerNameEntry != null ? containerNameEntry.name : spaceProxy.getContainerName();
        return containerName;
    }

    private static String createLabel(String[] labels) {
        StringBuilder str = new StringBuilder();
        for (int j = 0; j < labels.length; ++j) {
            if (labels[j].length() >= _tabs[j]) {
                str.append(labels[j], 0, _tabs[j] - 1).append('.');
            } else {
                str.append(labels[j]);
            }
            for (int s = 0; s < _tabs[j] - labels[j].length(); ++s) {
                str.append(' ');
            }
        }
        return str.toString();
    }

    static class SpaceModeListenerImpl
    implements ISpaceModeListener {
        SpaceModeListenerImpl() {
        }

        public void beforeSpaceModeChange(SpaceMode newMode) throws RemoteException {
        }

        public void afterSpaceModeChange(SpaceMode newMode) throws RemoteException {
        }
    }
}

