/*
 * Decompiled with CFR 0.152.
 */
package com.gigaspaces.admin.cli;

import com.gigaspaces.admin.cli.CLIFinder;
import com.gigaspaces.admin.cli.CLIUtilities;
import com.gigaspaces.admin.cli.Constants;
import com.gigaspaces.admin.cli.Formatter;
import com.gigaspaces.admin.cli.GS;
import com.gigaspaces.admin.cli.OptionHandler;
import com.gigaspaces.security.SecurityException;
import com.j_spaces.core.IJSpace;
import com.j_spaces.core.SpaceCopyStatus;
import com.j_spaces.core.admin.IRemoteJSpaceAdmin;
import com.j_spaces.core.client.SpaceURL;
import com.j_spaces.core.client.SpaceURLParser;
import java.io.BufferedReader;
import java.rmi.RemoteException;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;

public class CopySpace
implements GS.OptionHandler,
Constants {
    private SpaceURL _sourceSpaceURL;
    private SpaceURL _destSpaceURL;
    private Map<String, String> _args;
    private static final Logger _logger = Logger.getLogger("com.gigaspaces.admin.cli");
    private final OptionHandler validOptions;
    public static final String OPERATION_NAME = "copy";

    public CopySpace() {
        String[] validOptionsArray = new String[]{"h", "help", "move"};
        this.validOptions = new OptionHandler(Formatter.fromArray(validOptionsArray));
    }

    @Override
    public String process(String input, BufferedReader br) {
        IJSpace sourceSpace = null;
        IJSpace destSpace = null;
        try {
            Map<String, String> args = this.validOptions.getOptions(input, true);
            if (args.containsKey("h") || args.containsKey("help")) {
                return this.getUsage();
            }
            this._args = args;
            String[] parameters = OptionHandler.getCommandParameters(input);
            if (parameters.length < 2) {
                return this.getUsage();
            }
            this._sourceSpaceURL = SpaceURLParser.parseURL((String)parameters[0]);
            this._destSpaceURL = SpaceURLParser.parseURL((String)parameters[1]);
            System.out.println("Look up for " + this._sourceSpaceURL);
            try {
                sourceSpace = (IJSpace)CLIFinder.find(this._sourceSpaceURL, 1);
            }
            catch (Exception e) {
                CLIUtilities.printWrongSpaceURLMessage(this._sourceSpaceURL.getURL(), parameters[0] != null && parameters[0].indexOf("groups") >= 0, parameters[0] != null && parameters[0].indexOf("locators") >= 0);
                return "";
            }
            if (sourceSpace == null) {
                CLIUtilities.printWrongSpaceURLMessage(this._sourceSpaceURL.getURL(), parameters[0] != null && parameters[0].indexOf("groups") >= 0, parameters[0] != null && parameters[0].indexOf("locators") >= 0);
                return "";
            }
            System.out.println("Look up for " + this._destSpaceURL);
            try {
                destSpace = (IJSpace)CLIFinder.find(this._destSpaceURL, 1);
            }
            catch (Exception e) {
                CLIUtilities.printWrongSpaceURLMessage(this._destSpaceURL.getURL(), parameters[1] != null && parameters[1].indexOf("groups") >= 0, parameters[1] != null && parameters[1].indexOf("locators") >= 0);
                return "";
            }
            if (destSpace == null) {
                CLIUtilities.printWrongSpaceURLMessage(this._destSpaceURL.getURL(), parameters[1] != null && parameters[1].indexOf("groups") >= 0, parameters[1] != null && parameters[1].indexOf("locators") >= 0);
                return "";
            }
            this.copy(sourceSpace, destSpace);
            if (args.containsKey("move")) {
                sourceSpace.clear(null, null);
            }
        }
        catch (IllegalArgumentException e) {
            if (e.getMessage() != null) {
                System.out.println(e.getMessage());
            } else {
                System.out.println(e.toString());
            }
            System.out.println(this.getUsage());
        }
        catch (SecurityException se) {
            System.out.println("Space Copy failed due to a security error: " + se.toString());
        }
        catch (Exception ex) {
            System.out.println("Command failed. Please see CLI log file for details.");
            _logger.log(Level.SEVERE, ex.toString(), ex);
        }
        return "";
    }

    public void copy(IJSpace sourceSpace, IJSpace destSpace) throws SecurityException, RemoteException {
        IRemoteJSpaceAdmin admin = (IRemoteJSpaceAdmin)destSpace.getAdmin();
        SpaceCopyStatus spaceCopyStatus = admin.spaceCopy(sourceSpace, null, false, 1000);
        System.out.println("Loaded objects: " + spaceCopyStatus);
    }

    @Override
    public String getUsage() {
        StringBuffer strBuffer = new StringBuffer();
        strBuffer.append("\n*****************************************************\n\n");
        strBuffer.append("Usage: space copy [source-space-url]");
        strBuffer.append(" [destination-space-url] [options]\n");
        strBuffer.append("\noptions:\n");
        strBuffer.append("\t-h/-help  (help)     This help\n");
        strBuffer.append("\t-move  clean the source space after copy\n");
        strBuffer.append("Usage examples :\n");
        strBuffer.append("\tspace copy [source-space-url] [destination-space-url] -move\n");
        strBuffer.append("\tspace copy [source-space-url] [destination-space-url]");
        strBuffer.append("\n*****************************************************\n\n");
        return strBuffer.toString();
    }
}

