/*
 * Decompiled with CFR 0.152.
 */
package com.gigaspaces.admin.cli;

import com.gigaspaces.admin.cli.GS;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.Date;
import java.util.StringTokenizer;
import java.util.logging.Level;
import java.util.logging.Logger;

public class DirHandler
implements GS.OptionHandler {
    private static final Logger _logger = Logger.getLogger("com.gigaspaces.admin.cli");

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public String process(String input, BufferedReader br) {
        if (input.startsWith("ls") || input.startsWith("dir")) {
            File[] files;
            File d = GS.currentDir;
            boolean details = false;
            StringTokenizer tok = new StringTokenizer(input);
            if (tok.countTokens() > 1) {
                tok.nextToken();
                String option = tok.nextToken();
                if (option.equals("-l")) {
                    details = true;
                } else {
                    File temp = new File(d + File.separator + option);
                    if (temp.isDirectory()) {
                        d = temp;
                    } else {
                        System.out.println("Bad option " + option);
                        return "";
                    }
                }
            }
            if ((files = d.listFiles()) == null) {
                String path = GS.currentDir.getAbsolutePath();
                try {
                    path = GS.currentDir.getCanonicalPath();
                    return "No files for current working directory \"" + path + "\"";
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                return "No files for current working directory \"" + path + "\"";
            }
            int sum = 0;
            for (int i = 0; i < files.length; ++i) {
                sum = (int)((long)sum + files[i].length());
            }
            System.out.println("total " + sum);
            File parent = d.getParentFile();
            if (parent != null && details) {
                Date fileDate = new Date(parent.lastModified());
                System.out.println(this.getPerms(parent) + "   " + parent.length() + "\t" + fileDate.toString() + "\t..");
            }
            for (int i = 0; i < files.length; ++i) {
                if (details) {
                    String tabs = "\t";
                    if (files[i].length() < 10L) {
                        tabs = tabs + "\t";
                    }
                    String perms = this.getPerms(files[i]);
                    Date fileDate = new Date(files[i].lastModified());
                    System.out.println(perms + "   " + files[i].length() + tabs + fileDate.toString() + "\t" + files[i].getName());
                    continue;
                }
                System.out.println(files[i].getName());
            }
            return "";
        }
        if (input.equals("pwd")) {
            try {
                System.out.println("\"" + GS.currentDir.getCanonicalPath() + "\" is the current working directory");
                return "";
            }
            catch (IOException e) {
                System.out.println("\"" + GS.currentDir.getAbsolutePath() + "\" is the current working directory");
            }
            return "";
        } else {
            StringTokenizer tok = new StringTokenizer(input);
            if (tok.countTokens() > 1) {
                tok.nextToken();
                String value = tok.nextToken();
                if (value.endsWith("*")) return "";
                this.changeDir(value);
                return "";
            } else {
                if (br == null) {
                    br = new BufferedReader(new InputStreamReader(System.in));
                }
                System.out.print("(enter a directory to change to) ");
                try {
                    String response = br.readLine();
                    if (response.length() == 0) {
                        System.out.println("usage: cd directory");
                        return "";
                    }
                    this.changeDir(response);
                    return "";
                }
                catch (IOException e) {
                    if (!_logger.isLoggable(Level.SEVERE)) return "";
                    _logger.log(Level.SEVERE, e.toString(), e);
                }
            }
        }
        return "";
    }

    boolean changeDir(String dirName) {
        return DirHandler.changeDir(dirName, true);
    }

    static boolean changeDir(String dirName, boolean echoSuccess) {
        boolean changed = false;
        File dir = new File(dirName);
        if (!dir.exists() && !(dir = new File(GS.currentDir.getAbsolutePath() + File.separator + dirName)).exists()) {
            System.out.println(dirName + ": No such file or directory");
        }
        if (dir.isDirectory()) {
            GS.currentDir = dir;
            if (echoSuccess) {
                block6: {
                    try {
                        System.out.println(dir.getCanonicalPath());
                    }
                    catch (IOException e) {
                        if (!_logger.isLoggable(Level.SEVERE)) break block6;
                        _logger.log(Level.SEVERE, e.toString(), e);
                    }
                }
                System.out.println("Command successful");
            }
            changed = true;
        } else {
            System.out.println(dirName + ": Not a directory");
        }
        return changed;
    }

    String getPerms(File file) {
        String perms = "";
        perms = file.isDirectory() ? "d" : "-";
        perms = file.canRead() ? perms + "r" : perms + "-";
        perms = file.canWrite() ? perms + "w" : perms + "-";
        return perms;
    }

    @Override
    public String getUsage() {
        return "usage: [ls [-l] | pwd | cd directory-name\n";
    }
}

