/*
 * Decompiled with CFR 0.152.
 */
package com.gigaspaces.admin.cli;

import com.gigaspaces.admin.cli.AbstractElasticDeploymentHandler;
import com.gigaspaces.admin.cli.CLIUtilities;
import com.gigaspaces.admin.cli.CannotCastToBooleanException;
import com.gigaspaces.admin.cli.Constants;
import com.gigaspaces.admin.cli.GS;
import com.gigaspaces.admin.cli.InvalidCLIOptionException;
import com.gigaspaces.admin.cli.OptionHandler;
import com.gigaspaces.admin.cli.utils.CLISecurityRepository;
import com.gigaspaces.security.directory.CredentialsProvider;
import java.beans.Expression;
import java.beans.Statement;
import java.io.BufferedReader;
import java.io.File;
import java.lang.reflect.InvocationTargetException;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.jini.core.discovery.LookupLocator;

@Deprecated
public class ElasticPUDeploymentHandler
extends AbstractElasticDeploymentHandler
implements GS.OptionHandler,
Constants {
    private static final Logger LOGGER = Logger.getLogger("com.gigaspaces.admin.cli");
    public static final String OPERATION_NAME = "deploy-elastic-pu";
    private static final String ADMIN_FACTORY_CLASS = "org.openspaces.admin.AdminFactory";
    private Class adminFactoryClass;
    public static final String KEY_HELP1 = "h";
    public static final String KEY_HELP2 = "help";
    private static final String DEFAULT_SECURED = "false";
    private static final String DEFAULT_SCALE = "strategy=eager";
    private static final String DEFAULT_TIMEOUT = "120";
    private static final String DEFAULT_UNDEPLOY_ON_FAILURE = "false";
    private static Object INTACT_DEPLOYMENT_STATUS;

    ElasticPUDeploymentHandler() {
        block6: {
            try {
                ?[] deploymentStatuses = Class.forName("org.openspaces.admin.pu.DeploymentStatus").getEnumConstants();
                for (int i = 0; i < deploymentStatuses.length; ++i) {
                    if (!deploymentStatuses[i].getClass().getMethod("name", new Class[0]).invoke(deploymentStatuses[i], new Object[0]).equals("INTACT")) continue;
                    INTACT_DEPLOYMENT_STATUS = deploymentStatuses[i];
                    break;
                }
                if (INTACT_DEPLOYMENT_STATUS == null) {
                    throw new Exception("Internal error: unable to find INTACT value for DeploymentStatus");
                }
                this.adminFactoryClass = Class.forName(ADMIN_FACTORY_CLASS);
            }
            catch (ClassNotFoundException e) {
                System.out.println("Please install OpenSpaces.");
                if (LOGGER.isLoggable(Level.SEVERE)) {
                    LOGGER.log(Level.SEVERE, e.toString());
                }
            }
            catch (Exception e) {
                if (!LOGGER.isLoggable(Level.SEVERE)) break block6;
                LOGGER.log(Level.SEVERE, e.toString(), e);
            }
        }
    }

    @Override
    public String process(String input, BufferedReader br) {
        block119: {
            try {
                CredentialsProvider credentialsProvider;
                boolean undeployOnFailure;
                long timeoutInSec;
                Object elasticDeployment;
                Object processingUnitParameterValue;
                Class processingUnitParameterClass;
                DeploymentType deploymentType;
                LinkedHashMap<ElasticPUDeploymentOption, String> args = OptionHandler.OptionsParser.parseCommand(ElasticPUDeploymentOption.class, input);
                if (args.size() == 0 || args.containsKey(ElasticPUDeploymentOption.HELP)) {
                    return this.getUsage();
                }
                if (!args.containsKey(ElasticPUDeploymentOption.TYPE)) {
                    throw new IllegalArgumentException("Option [" + ElasticPUDeploymentOption.TYPE.getParamName() + "] must be provided");
                }
                String deploymentTypeString = args.get(ElasticPUDeploymentOption.TYPE);
                if (deploymentTypeString.equals(DeploymentType.STATELESS.getTypeName())) {
                    deploymentType = DeploymentType.STATELESS;
                } else if (deploymentTypeString.equals(DeploymentType.STATEFUL.getTypeName())) {
                    deploymentType = DeploymentType.STATEFUL;
                } else {
                    throw new IllegalArgumentException("Invalid deployment type [" + deploymentTypeString + "]");
                }
                if (args.containsKey(ElasticPUDeploymentOption.FILE) && args.containsKey(ElasticPUDeploymentOption.PU_NAME)) {
                    throw new IllegalArgumentException("Options [" + ElasticPUDeploymentOption.FILE.getParamName() + "] and [" + ElasticPUDeploymentOption.PU_NAME.getParamName() + "] cannot be used together");
                }
                if (!args.containsKey(ElasticPUDeploymentOption.FILE) && !args.containsKey(ElasticPUDeploymentOption.PU_NAME)) {
                    throw new IllegalArgumentException("Option [" + ElasticPUDeploymentOption.FILE.getParamName() + "] or [" + ElasticPUDeploymentOption.PU_NAME.getParamName() + "] must be specified");
                }
                if (args.containsKey(ElasticPUDeploymentOption.PU_NAME)) {
                    processingUnitParameterClass = String.class;
                    processingUnitParameterValue = args.get(ElasticPUDeploymentOption.PU_NAME);
                } else {
                    processingUnitParameterClass = File.class;
                    processingUnitParameterValue = new File(args.get(ElasticPUDeploymentOption.FILE));
                }
                if (deploymentType.equals((Object)DeploymentType.STATEFUL)) {
                    elasticDeployment = Class.forName("org.openspaces.admin.pu.elastic.ElasticStatefulProcessingUnitDeployment").getConstructor(processingUnitParameterClass).newInstance(processingUnitParameterValue);
                } else if (deploymentType.equals((Object)DeploymentType.STATELESS)) {
                    elasticDeployment = Class.forName("org.openspaces.admin.pu.elastic.ElasticStatelessProcessingUnitDeployment").getConstructor(processingUnitParameterClass).newInstance(processingUnitParameterValue);
                } else {
                    throw new IllegalArgumentException("Unhandled deployment type [" + (Object)((Object)deploymentType) + "]");
                }
                if (!args.containsKey(ElasticPUDeploymentOption.SECURED)) {
                    args.put(ElasticPUDeploymentOption.SECURED, "false");
                    if (LOGGER.isLoggable(Level.FINE)) {
                        LOGGER.fine("Using default value for option [" + ElasticPUDeploymentOption.SECURED.getParamName() + "] : " + "false");
                    }
                }
                if (!args.containsKey(ElasticPUDeploymentOption.SCALE)) {
                    args.put(ElasticPUDeploymentOption.SCALE, DEFAULT_SCALE);
                    if (LOGGER.isLoggable(Level.FINE)) {
                        LOGGER.fine("Using default value for option [" + ElasticPUDeploymentOption.SCALE.getParamName() + "] : " + DEFAULT_SCALE);
                    }
                }
                if (!args.containsKey(ElasticPUDeploymentOption.TIMEOUT)) {
                    args.put(ElasticPUDeploymentOption.TIMEOUT, DEFAULT_TIMEOUT);
                    if (LOGGER.isLoggable(Level.FINE)) {
                        LOGGER.fine("Using default value for option [" + ElasticPUDeploymentOption.TIMEOUT.getParamName() + "] : " + DEFAULT_TIMEOUT);
                    }
                }
                try {
                    timeoutInSec = Long.valueOf(args.get(ElasticPUDeploymentOption.TIMEOUT));
                }
                catch (NumberFormatException e) {
                    throw new IllegalArgumentException("Invalid value for option [" + ElasticPUDeploymentOption.TIMEOUT.getParamName() + "]: Must be a number");
                }
                if (!args.containsKey(ElasticPUDeploymentOption.UNDEPLOY_ON_FAILURE)) {
                    args.put(ElasticPUDeploymentOption.UNDEPLOY_ON_FAILURE, "false");
                    if (LOGGER.isLoggable(Level.FINE)) {
                        LOGGER.fine("Using default value for option [" + ElasticPUDeploymentOption.UNDEPLOY_ON_FAILURE.getParamName() + "] : " + "false");
                    }
                }
                String undeployOnFailureString = args.get(ElasticPUDeploymentOption.UNDEPLOY_ON_FAILURE);
                try {
                    undeployOnFailure = ElasticPUDeploymentHandler.getBooleanValue(undeployOnFailureString);
                }
                catch (CannotCastToBooleanException e) {
                    throw new IllegalArgumentException("Invalid value for option [" + ElasticPUDeploymentOption.UNDEPLOY_ON_FAILURE.getParamName() + "]: Must be true/false");
                }
                String username = args.get(ElasticPUDeploymentOption.USER);
                String password = args.get(ElasticPUDeploymentOption.PASSWORD);
                if (username != null && password == null) {
                    throw new IllegalArgumentException("Option [" + ElasticPUDeploymentOption.PASSWORD.getParamName() + "] is missing");
                }
                if (username == null && password != null) {
                    throw new IllegalArgumentException("Option [" + ElasticPUDeploymentOption.USER.getParamName() + "] is missing");
                }
                if (username != null && password != null) {
                    if (username.length() == 0) {
                        throw new IllegalArgumentException("Invalid value for option [" + ElasticPUDeploymentOption.USER.getParamName() + "]: Can not be empty");
                    }
                    if (password.length() == 0) {
                        throw new IllegalArgumentException("Invalid value for option [" + ElasticPUDeploymentOption.PASSWORD.getParamName() + "]: Can not be empty");
                    }
                    elasticDeployment.getClass().getMethod("userDetails", String.class, String.class).invoke(elasticDeployment, username, password);
                }
                block47: for (ElasticPUDeploymentOption option : args.keySet()) {
                    Object[] optionValue = args.get(option);
                    switch (option) {
                        case MEMORY_CAPACITY_PER_CONTAINER: {
                            this.logFinestIfLoggable("Handling MEMORY_CAPACITY_PER_CONTAINER");
                            String validationResult = this.validateMemoryParameter((String)optionValue);
                            if (validationResult != null) {
                                throw new IllegalArgumentException("Invalid value for option [" + option.getParamName() + "]: " + validationResult);
                            }
                            ElasticPUDeploymentHandler.logFineIfLoggable("Applying memoryCapacityPerContainer on [" + (String)optionValue + "]");
                            elasticDeployment.getClass().getMethod("memoryCapacityPerContainer", String.class).invoke(elasticDeployment, new Object[]{optionValue});
                            break;
                        }
                        case MAX_MEMORY_CAPACITY: {
                            String validationResult;
                            this.logFinestIfLoggable("Handling MAX_MEMORY_CAPACITY");
                            if (deploymentType.equals((Object)DeploymentType.STATEFUL)) {
                                validationResult = this.validateMemoryParameter((String)optionValue);
                                if (validationResult != null) {
                                    throw new IllegalArgumentException("Invalid value for option [" + option.getParamName() + "]: " + validationResult);
                                }
                                ElasticPUDeploymentHandler.logFineIfLoggable("Applying maxMemoryCapacity on [" + (String)optionValue + "]");
                                elasticDeployment.getClass().getMethod("maxMemoryCapacity", String.class).invoke(elasticDeployment, new Object[]{optionValue});
                                break;
                            }
                            throw new IllegalArgumentException("Option [" + option.getParamName() + "] can only be used with stateful deployment");
                        }
                        case NUMBER_OF_PARTITIONS: {
                            this.logFinestIfLoggable("Handling NUMBER_OF_PARTITIONS");
                            if (deploymentType.equals((Object)DeploymentType.STATEFUL)) {
                                try {
                                    ElasticPUDeploymentHandler.logFineIfLoggable("Applying numberOfPartitions on [" + (String)optionValue + "]");
                                    elasticDeployment.getClass().getMethod("numberOfPartitions", Integer.TYPE).invoke(elasticDeployment, Integer.valueOf((String)optionValue));
                                    break;
                                }
                                catch (NumberFormatException e) {
                                    throw new IllegalArgumentException("Invalid value for option [" + option.getParamName() + "]: Must be a number");
                                }
                            }
                            throw new IllegalArgumentException("Option [" + option.getParamName() + "] can only be used with stateful deployment");
                        }
                        case MAX_NUMBER_OF_CPU_CORES: {
                            this.logFinestIfLoggable("Handling MAX_NUMBER_OF_CPU_CORES");
                            if (deploymentType.equals((Object)DeploymentType.STATEFUL)) {
                                try {
                                    ElasticPUDeploymentHandler.logFineIfLoggable("Applying maxNumberOfCpuCores on [" + (String)optionValue + "]");
                                    elasticDeployment.getClass().getMethod("maxNumberOfCpuCores", Integer.TYPE).invoke(elasticDeployment, Integer.valueOf((String)optionValue));
                                    break;
                                }
                                catch (NumberFormatException e) {
                                    throw new IllegalArgumentException("Invalid value for option [" + option.getParamName() + "]: Must be a number");
                                }
                            }
                            throw new IllegalArgumentException("Option [" + option.getParamName() + "] can only be used with stateful deployment");
                        }
                        case SINGLE_MACHINE_DEPLOYMENT: {
                            this.logFinestIfLoggable("Handling SINGLE_MACHINE_DEPLOYMENT [" + (String)optionValue + "]");
                            if (deploymentType.equals((Object)DeploymentType.STATEFUL)) {
                                boolean singleMachineDeployment;
                                try {
                                    singleMachineDeployment = ElasticPUDeploymentHandler.getBooleanValue((String)optionValue);
                                }
                                catch (CannotCastToBooleanException e) {
                                    throw new IllegalArgumentException("Invalid value for option [" + option.getParamName() + "]: Must be true/false");
                                }
                                if (!singleMachineDeployment) continue block47;
                                ElasticPUDeploymentHandler.logFineIfLoggable("Applying singleMachineDeployment on [" + (String)optionValue + "]");
                                elasticDeployment.getClass().getMethod("singleMachineDeployment", new Class[0]).invoke(elasticDeployment, new Object[0]);
                                break;
                            }
                            throw new IllegalArgumentException("Option [" + option.getParamName() + "] can only be used with stateful deployment");
                        }
                        case DEDICATED_MACHINE_PROVISIONING: {
                            this.logFinestIfLoggable("Handling DEDICATED_MACHINE_PROVISIONING");
                            ElasticPUDeploymentHandler.logFineIfLoggable("Applying dedicatedMachineProvisioning on [" + (String)optionValue + "]");
                            this.applyDedicatedMachineProvisioning((String)optionValue, elasticDeployment);
                            break;
                        }
                        case SHARED_MACHINE_PROVISIONING: {
                            this.logFinestIfLoggable("Handling SHARED_MACHINE_PROVISIONING");
                            ElasticPUDeploymentHandler.logFineIfLoggable("Applying sharedMachineProvisioning on [" + (String)optionValue + "]");
                            this.applySharedMachineProvisioning((String)optionValue, elasticDeployment);
                            break;
                        }
                        case SCALE: {
                            this.logFinestIfLoggable("Handling SCALE");
                            Object scaleConfig = this.parseScaleProperties((String)optionValue);
                            ElasticPUDeploymentHandler.logFineIfLoggable("Applying scale on [" + (String)optionValue + "]");
                            Statement scaleStatement = new Statement(elasticDeployment, "scale", new Object[]{scaleConfig});
                            scaleStatement.execute();
                            break;
                        }
                        case HIGHLY_AVAILABLE: {
                            this.logFinestIfLoggable("Handling HIGHLY_AVAILABLE");
                            if (deploymentType.equals((Object)DeploymentType.STATEFUL)) {
                                boolean highlyAvailable;
                                try {
                                    highlyAvailable = ElasticPUDeploymentHandler.getBooleanValue((String)optionValue);
                                }
                                catch (CannotCastToBooleanException e) {
                                    throw new IllegalArgumentException("Invalid value for option [" + option.getParamName() + "]: Must be true/false");
                                }
                                ElasticPUDeploymentHandler.logFineIfLoggable("Applying highlyAvailable on [" + (String)optionValue + "]");
                                elasticDeployment.getClass().getMethod("highlyAvailable", Boolean.TYPE).invoke(elasticDeployment, highlyAvailable);
                                break;
                            }
                            throw new IllegalArgumentException("Option [" + option.getParamName() + "] can only be used with stateful deployment");
                        }
                        case SECURED: {
                            boolean secured;
                            this.logFinestIfLoggable("Handling SECURED");
                            try {
                                secured = ElasticPUDeploymentHandler.getBooleanValue((String)optionValue);
                            }
                            catch (CannotCastToBooleanException e) {
                                throw new IllegalArgumentException("Invalid value for option [" + option.getParamName() + "]: Must be true/false");
                            }
                            ElasticPUDeploymentHandler.logFineIfLoggable("Applying secured on [" + (String)optionValue + "]");
                            elasticDeployment.getClass().getMethod("secured", Boolean.TYPE).invoke(elasticDeployment, secured);
                            break;
                        }
                        case USER: 
                        case PASSWORD: {
                            break;
                        }
                        case PU_NAME: 
                        case FILE: 
                        case TYPE: {
                            break;
                        }
                        case TIMEOUT: {
                            break;
                        }
                        case UNDEPLOY_ON_FAILURE: {
                            break;
                        }
                        case NUMBER_OF_BACKUPS_PER_PARTITION: {
                            this.logFinestIfLoggable("Handling NUMBER_OF_BACKUPS_PER_PARTITION");
                            if (deploymentType.equals((Object)DeploymentType.STATEFUL)) {
                                try {
                                    ElasticPUDeploymentHandler.logFineIfLoggable("Applying numberOfBackupsPerPartition on [" + (String)optionValue + "]");
                                    elasticDeployment.getClass().getMethod("numberOfBackupsPerPartition", Integer.TYPE).invoke(elasticDeployment, Integer.valueOf((String)optionValue));
                                    break;
                                }
                                catch (NumberFormatException e) {
                                    throw new IllegalArgumentException("Invalid value for option [" + option.getParamName() + "]: Must be a number");
                                }
                            }
                            throw new IllegalArgumentException("Option [" + option.getParamName() + "] can only be used with stateful deployment");
                        }
                        case COMMAND_LINE_ARGUMENTS: {
                            String[] cmdargs;
                            this.logFinestIfLoggable("Handling COMMAND_LINE_ARGUMENTS [" + (String)optionValue + "]");
                            if (!optionValue.startsWith("\"") || !optionValue.endsWith("\"")) {
                                throw new IllegalArgumentException("Invalid value for option [" + option.getParamName() + "]: Must start and end with quotes.");
                            }
                            String value = optionValue.substring(1, optionValue.length() - 1);
                            for (String cmdarg : cmdargs = value.split(",")) {
                                ElasticPUDeploymentHandler.logFineIfLoggable("applying addCommandLineArgument on [" + cmdarg + "]");
                                elasticDeployment.getClass().getMethod("addCommandLineArgument", String.class).invoke(elasticDeployment, cmdarg);
                            }
                            continue block47;
                        }
                        case NAME: {
                            this.logFinestIfLoggable("Handling NAME [" + (String)optionValue + "]");
                            if (optionValue == null) {
                                throw new IllegalArgumentException("Invalid value for option [" + option.getParamName() + "]: Cannot be empty");
                            }
                            elasticDeployment.getClass().getMethod("name", String.class).invoke(elasticDeployment, new Object[]{optionValue});
                            break;
                        }
                        case CONTEXT_PROPERTIES: {
                            String[] keyValues;
                            this.logFinestIfLoggable("Handling CONTEXT_PROPERTIES [" + (String)optionValue + "]");
                            for (String keyValue : keyValues = optionValue.split(" ")) {
                                this.logFinestIfLoggable("Handling [" + keyValue + "] in CONTEXT_PROPERTIES");
                                String[] keyValueArr = keyValue.split("=");
                                if (keyValueArr.length != 2) {
                                    throw new IllegalArgumentException("Invalid value for option [" + option.getParamName() + "]: Invalid key value format");
                                }
                                ElasticPUDeploymentHandler.logFineIfLoggable("applying addContextProperty on [" + keyValueArr[0] + ", " + keyValueArr[1] + "]");
                                elasticDeployment.getClass().getMethod("addContextProperty", String.class, String.class).invoke(elasticDeployment, keyValueArr[0], keyValueArr[1]);
                            }
                            continue block47;
                        }
                        default: {
                            throw new IllegalArgumentException("Unhandled option [" + option.getParamName() + "]");
                        }
                    }
                }
                Object adminFactory = this.adminFactoryClass.newInstance();
                if (GS.settings != null) {
                    Object[] groups;
                    Object[] locators = (LookupLocator[])GS.settings.get("locators");
                    if (locators != null) {
                        if (LOGGER.isLoggable(Level.FINE)) {
                            LOGGER.fine("Locators: " + Arrays.toString(locators));
                        }
                        for (Object lookupLocator : locators) {
                            adminFactory.getClass().getMethod("addLocator", String.class).invoke(adminFactory, lookupLocator.getHost() + ":" + lookupLocator.getPort());
                        }
                    }
                    if ((groups = (String[])GS.settings.get("groups")) != null) {
                        if (LOGGER.isLoggable(Level.FINE)) {
                            LOGGER.fine("Groups: " + Arrays.toString(groups));
                        }
                        for (Object group : groups) {
                            adminFactory.getClass().getMethod("addGroup", String.class).invoke(adminFactory, group);
                        }
                    }
                }
                if ((credentialsProvider = CLISecurityRepository.getInstance().getCurrentCredentialsProvider()) != null) {
                    LOGGER.fine("Setting Credentials Provider for Admin Factory");
                    Statement scaleStatement = new Statement(adminFactory, "credentialsProvider", new Object[]{credentialsProvider});
                    scaleStatement.execute();
                }
                Object admin = adminFactory.getClass().getMethod("create", new Class[0]).invoke(adminFactory, new Object[0]);
                try {
                    boolean waitForResult;
                    Object gsms;
                    Object gsm;
                    Object esms;
                    Object esm;
                    Object gsAgents;
                    Object gsa;
                    if (LOGGER.isLoggable(Level.FINE)) {
                        LOGGER.fine("Waiting for at least one GSA");
                    }
                    if ((gsa = (gsAgents = admin.getClass().getMethod("getGridServiceAgents", new Class[0]).invoke(admin, new Object[0])).getClass().getMethod("waitForAtLeastOne", Long.TYPE, TimeUnit.class).invoke(gsAgents, new Object[]{10, TimeUnit.SECONDS})) == null) {
                        throw new IllegalArgumentException("Failed to find a running GSA within 10 seconds.");
                    }
                    if (LOGGER.isLoggable(Level.FINE)) {
                        LOGGER.fine("Waiting for at least one ESM");
                    }
                    if ((esm = (esms = admin.getClass().getMethod("getElasticServiceManagers", new Class[0]).invoke(admin, new Object[0])).getClass().getMethod("waitForAtLeastOne", Long.TYPE, TimeUnit.class).invoke(esms, new Object[]{10, TimeUnit.SECONDS})) == null) {
                        throw new IllegalArgumentException("Failed to find a running ESM within 10 seconds.");
                    }
                    if (LOGGER.isLoggable(Level.FINE)) {
                        LOGGER.fine("Waiting for at least one GSM");
                    }
                    if ((gsm = (gsms = admin.getClass().getMethod("getGridServiceManagers", new Class[0]).invoke(admin, new Object[0])).getClass().getMethod("waitForAtLeastOne", Long.TYPE, TimeUnit.class).invoke(gsms, new Object[]{10, TimeUnit.SECONDS})) == null) {
                        throw new IllegalArgumentException("Failed to find a running GSM within 10 seconds.");
                    }
                    if (processingUnitParameterValue instanceof File) {
                        LOGGER.info("Deploying elastic pu file [" + ((File)processingUnitParameterValue).getName() + "]");
                        System.out.println("Deploying elastic pu file [" + ((File)processingUnitParameterValue).getName() + "]");
                    } else {
                        LOGGER.info("Deploying elastic pu [" + processingUnitParameterValue + "]");
                        System.out.println("Deploying elastic pu [" + processingUnitParameterValue + "]");
                    }
                    long stTime = System.currentTimeMillis();
                    boolean deploymentSucceeded = false;
                    Expression expression = new Expression(gsm, "deploy", new Object[]{elasticDeployment, 10L, TimeUnit.SECONDS});
                    Object pu = expression.getValue();
                    String puName = pu.getClass().getMethod("getName", new Class[0]).invoke(pu, new Object[0]).toString();
                    int plannedNumberOfInstances = (Integer)pu.getClass().getMethod("getPlannedNumberOfInstances", new Class[0]).invoke(pu, new Object[0]);
                    if (LOGGER.isLoggable(Level.FINE)) {
                        LOGGER.fine("Waiting [" + timeoutInSec + "] seconds for all the pu instances to be instantiated.");
                        LOGGER.fine("Planned number of instances: " + plannedNumberOfInstances);
                    }
                    if (waitForResult = ((Boolean)pu.getClass().getMethod("waitFor", Integer.TYPE, Long.TYPE, TimeUnit.class).invoke(pu, new Object[]{plannedNumberOfInstances, timeoutInSec, TimeUnit.SECONDS})).booleanValue()) {
                        long timeout = timeoutInSec * 1000L;
                        while (true) {
                            Object deploymentStatus;
                            if ((deploymentStatus = pu.getClass().getMethod("getStatus", new Class[0]).invoke(pu, new Object[0])).equals(INTACT_DEPLOYMENT_STATUS)) {
                                deploymentSucceeded = true;
                                break;
                            }
                            if (System.currentTimeMillis() > stTime + timeout) break;
                            try {
                                LOGGER.info("Waiting for processing unit to be deployed...");
                                Thread.sleep(1000L);
                            }
                            catch (InterruptedException e) {
                                if (!LOGGER.isLoggable(Level.WARNING)) continue;
                                LOGGER.log(Level.WARNING, "Wait has interrupted", e);
                            }
                        }
                    }
                    if (deploymentSucceeded) {
                        LOGGER.info("Processing Unit [" + puName + "] deployed successfully.");
                        System.out.println("Processing Unit [" + puName + "] deployed successfully.");
                    } else {
                        LOGGER.info("Deployment of processing unit [" + puName + "] didn't finish within [" + timeoutInSec + "] seconds");
                        System.out.println("Deployment of processing unit [" + puName + "] didn't finish within [" + timeoutInSec + "] seconds");
                        if (undeployOnFailure) {
                            boolean undeployed;
                            LOGGER.info(ElasticPUDeploymentOption.UNDEPLOY_ON_FAILURE.getParamName() + " option is provided, undeploying processing unit [" + puName + "]");
                            System.out.println(ElasticPUDeploymentOption.UNDEPLOY_ON_FAILURE.getParamName() + " option is provided, undeploying processing unit [" + puName + "]");
                            String undeployStatusString = pu.getClass().getMethod("undeployAndWait", Long.TYPE, TimeUnit.class).invoke(pu, new Object[]{timeoutInSec, TimeUnit.SECONDS}).toString();
                            try {
                                undeployed = ElasticPUDeploymentHandler.getBooleanValue(undeployStatusString);
                            }
                            catch (CannotCastToBooleanException e) {
                                throw new Exception("Internal error: undeployAndWait didn't return a boolean!");
                            }
                            if (undeployed) {
                                LOGGER.info("Processing Unit [" + puName + "] is undeployed successfully");
                                System.out.println("Processing Unit [" + puName + "] is undeployed successfully");
                            } else {
                                LOGGER.info("Processing Unit [" + puName + "] is not undeployed within " + timeoutInSec + " seconds");
                                System.out.println("Processing Unit [" + puName + "] is not undeployed within " + timeoutInSec + " seconds");
                            }
                        }
                    }
                    admin.getClass().getMethod("close", new Class[0]).invoke(admin, new Object[0]);
                    return "";
                }
                catch (Throwable e) {
                    admin.getClass().getMethod("close", new Class[0]).invoke(admin, new Object[0]);
                    throw e;
                }
            }
            catch (IllegalArgumentException e) {
                Object[] localCommandArgLine = CLIUtilities.getArgLineWithScreenPassword(input.split(" "));
                String msg = "Error deploying " + Arrays.toString(localCommandArgLine);
                LOGGER.log(Level.SEVERE, msg, e);
                if (e.getMessage() != null) {
                    System.out.println(msg);
                    System.out.println(e.getMessage());
                } else {
                    System.out.println(msg);
                    System.out.println(e.toString());
                }
            }
            catch (InvalidCLIOptionException e) {
                Object[] localCommandArgLine = CLIUtilities.getArgLineWithScreenPassword(input.split(" "));
                String msg = "Error deploying " + Arrays.toString(localCommandArgLine);
                LOGGER.log(Level.SEVERE, msg, e);
                if (e.getMessage() != null) {
                    System.out.println(msg);
                    System.out.println(e.getMessage());
                } else {
                    System.out.println(msg);
                    System.out.println(e.toString());
                }
                System.out.println(this.getUsage());
            }
            catch (InvocationTargetException e) {
                Object[] localCommandArgLine = CLIUtilities.getArgLineWithScreenPassword(input.split(" "));
                String msg = "Error deploying " + Arrays.toString(localCommandArgLine);
                LOGGER.log(Level.SEVERE, msg, e);
                if (e.getTargetException() != null && e.getTargetException().getMessage() != null) {
                    System.out.println(msg + ":" + e.getTargetException().getMessage());
                } else {
                    System.out.println(msg + ":" + e.toString());
                }
            }
            catch (Throwable e) {
                Object[] localCommandArgLine = CLIUtilities.getArgLineWithScreenPassword(input.split(" "));
                String msg = "Error deploying " + Arrays.toString(localCommandArgLine);
                LOGGER.log(Level.SEVERE, msg, e);
                System.out.println(msg + ":" + e.toString());
                if (e.getCause() == null) break block119;
                LOGGER.severe(e.getCause().toString());
            }
        }
        return "";
    }

    @Override
    public String getUsage() {
        StringBuilder sb = new StringBuilder();
        sb.append("Usage: \n\t deploy-elastic-pu [options] -" + ElasticPUDeploymentOption.TYPE.getParamName() + " [" + (Object)((Object)DeploymentType.STATEFUL) + "/" + (Object)((Object)DeploymentType.STATELESS) + "] -" + ElasticPUDeploymentOption.FILE.getParamName() + " [path to file]\n\t " + OPERATION_NAME + " [options] -" + ElasticPUDeploymentOption.TYPE.getParamName() + " [" + (Object)((Object)DeploymentType.STATEFUL) + "/" + (Object)((Object)DeploymentType.STATELESS) + "] -" + ElasticPUDeploymentOption.PU_NAME.getParamName() + "[pu name]\n");
        sb.append("\n");
        sb.append("Available options: \n");
        sb.append("(*) Required options but cannot be used together\n");
        for (ElasticPUDeploymentOption option : ElasticPUDeploymentOption.values()) {
            if (option.equals(ElasticPUDeploymentOption.HELP)) continue;
            sb.append("\t" + option.getParamUsage() + "\n");
        }
        sb.append("\n");
        sb.append("Default values:\n");
        sb.append("\t" + ElasticPUDeploymentOption.SECURED.getParamName() + "\t\t\t\t: " + "false" + "\n");
        sb.append("\t" + ElasticPUDeploymentOption.SCALE.getParamName() + "\t\t\t\t: " + DEFAULT_SCALE + "\n");
        sb.append("\t" + ElasticPUDeploymentOption.TIMEOUT.getParamName() + "\t\t\t\t: " + DEFAULT_TIMEOUT + "\n");
        sb.append("\t" + ElasticPUDeploymentOption.UNDEPLOY_ON_FAILURE.getParamName() + "\t\t: " + "false" + "\n");
        sb.append("\n");
        sb.append("Examples:\n");
        sb.append("1. deploy-elastic-pu -type stateless -file /home/user/feeder.jar\n\t-Deploys an elastic stateless pu from file.\n");
        sb.append("2. deploy-elastic-pu -type stateless -scale strategy=manual memory-capacity=128m -file /home/user/processor.jar\n\t-Deploys an elastic stateful pu from file with manual scale strategy and memory-capacity=128m.\n");
        return sb.toString();
    }

    private static void logFineIfLoggable(String msg) {
        if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.fine(msg);
        }
    }

    private void logFinestIfLoggable(String msg) {
        if (LOGGER.isLoggable(Level.FINEST)) {
            LOGGER.finest(msg);
        }
    }

    public static enum ElasticPUDeploymentOption implements OptionHandler.AbstractCLIOption
    {
        TYPE("type", "-type [" + (Object)((Object)DeploymentType.STATEFUL) + "/" + (Object)((Object)DeploymentType.STATELESS) + "] \t\t\t\t : Required"),
        FILE("file", "-file [file path] \t\t\t\t\t : Processing unit file path (processing unit jar/zip file or a directory)"),
        PU_NAME("puname", "-puname [PU name] \t\t\t\t\t : Processing unit name (should exists under the [GS ROOT]/deploy directory)"),
        NAME("name", "-name [name] \t\t\t\t\t : Overrides the Processing Unit name"),
        MEMORY_CAPACITY_PER_CONTAINER("memory-capacity-per-container", "mcpc", "-mcpc, -memory-capacity-per-container [number[m/g]] \t : Required - Specifies the the heap size per container (operating system process)"),
        MAX_MEMORY_CAPACITY("max-memory-capacity", "mmc", "-mmc, -max-memory-capacity [number[m/g]] \t\t : Required(*) - stateful only - Specifies an estimate of the maximum memory capacity for this processing unit"),
        NUMBER_OF_PARTITIONS("number-of-partitions", "nop", "-nop,-number-of-partitions [number] \t\t\t : Required(*) - stateful only -  Defines the number of processing unit partitions"),
        MAX_NUMBER_OF_CPU_CORES("max-number-of-cpu-cores", "mnocc", "-mnocc, -max-number-of-cpu-cores [number] \t\t : Stateful only - Specifies an estimate for the maximum total number of cpu cores used by this processing unit"),
        SINGLE_MACHINE_DEPLOYMENT("single-machine-deployment", "smd", "-smd, -single-machine-deployment \t\t\t : Stateful only - Allows deployment of the processing unit on a single machine"),
        HIGHLY_AVAILABLE("highly-available", "ha", "-ha, -highly-available [true/false] \t\t\t : Stateful only - Specifies if the space should duplicate each information on two different machines"),
        SECURED("secured", "-secured [true/false] \t\t\t\t\t : Deploys a secured processing unit (implicit when using -user/-password)"),
        USER("user", "-user [username] \t\t\t\t\t : Deploys a secured processing unit propagated with the supplied user and password"),
        PASSWORD("password", "-password [password] \t\t\t\t\t : Deploys a secured processing unit propagated with the supplied user and password"),
        SHARED_MACHINE_PROVISIONING("shared-machine-provisioning", "smp", "-smp, -shared-machine-provisioning \t\t\t : Configure the server side bean that starts and stops machines automatically\n" + AbstractElasticDeploymentHandler.SharedMachineProvisioningProperty.getPropertiesUsage()),
        DEDICATED_MACHINE_PROVISIONING("dedicated-machine-provisioning", "dmp", "-dmp, -dedicated-machine-provisioning \t\t\t : Configure the server side bean that starts and stops machines automatically\n" + AbstractElasticDeploymentHandler.DedicatedMachineProvisioningProperty.getPropertiesUsage()),
        SCALE("scale", "-scale [scale properties] \t\t\t\t : Enables the specified scale strategy, and disables all other scale strategies\n" + AbstractElasticDeploymentHandler.ScaleProperty.getPropertiesUsage()),
        TIMEOUT("timeout", "-timeout [timeout in seconds] \t\t\t\t : Timeout for deploy operation"),
        UNDEPLOY_ON_FAILURE("undeploy-on-failure", "uof", "-uof, -undeploy-on-failure [true/false] \t\t : Specifies if the processing unit should be undeployed if the specified timeout has expired."),
        NUMBER_OF_BACKUPS_PER_PARTITION("number-of-backups-per-partition", "nobpp", "-nobpp, -number-of-backups-per-partition [number] \t : Specifies the number of backup processing unit instances per partition. This is an advanced property."),
        COMMAND_LINE_ARGUMENTS("command-line-arguments", "cmdargs", "-cmdargs, -command-line-args [\"comma separated list\"] \t : Adds the arguments as JVM level arguments when the process is executed using pure JVM."),
        CONTEXT_PROPERTIES("context-properties", "ctxp", "-ctxp, -context-properties key1=value1 key2=value2 \t : Defines a context deploy time property overriding any ${...}"),
        HELP("help", "-help");

        private String paramName;
        private String shortParamName;
        private String usageDesc;

        private ElasticPUDeploymentOption(String paramName, String usageDesc) {
            this.paramName = paramName;
            this.shortParamName = null;
            this.usageDesc = usageDesc;
        }

        private ElasticPUDeploymentOption(String paramName, String shortParamName, String usageDesc) {
            this.paramName = paramName;
            this.shortParamName = shortParamName;
            this.usageDesc = usageDesc;
        }

        @Override
        public String getParamName() {
            return this.paramName;
        }

        @Override
        public String getShortParamName() {
            return this.shortParamName;
        }

        public String getParamUsage() {
            return this.usageDesc;
        }
    }

    private static enum DeploymentType {
        STATEFUL("stateful"),
        STATELESS("stateless");

        private String typeName;

        private DeploymentType(String typeName) {
            this.typeName = typeName;
        }

        public String getTypeName() {
            return this.typeName;
        }

        public String toString() {
            return this.typeName;
        }
    }
}

