/*
 * Decompiled with CFR 0.152.
 */
package com.gigaspaces.admin.cli;

import com.gigaspaces.admin.cli.AbstractElasticDeploymentHandler;
import com.gigaspaces.admin.cli.CLIUtilities;
import com.gigaspaces.admin.cli.CannotCastToBooleanException;
import com.gigaspaces.admin.cli.Constants;
import com.gigaspaces.admin.cli.GS;
import com.gigaspaces.admin.cli.InvalidCLIOptionException;
import com.gigaspaces.admin.cli.OptionHandler;
import com.gigaspaces.admin.cli.utils.CLISecurityRepository;
import com.gigaspaces.security.directory.CredentialsProvider;
import java.beans.Expression;
import java.beans.Statement;
import java.io.BufferedReader;
import java.lang.reflect.InvocationTargetException;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.jini.core.discovery.LookupLocator;

@Deprecated
public class ElasticSpaceDeploymentHandler
extends AbstractElasticDeploymentHandler
implements GS.OptionHandler,
Constants {
    private static final Logger LOGGER = Logger.getLogger("com.gigaspaces.admin.cli");
    public static final String OPERATION_NAME = "deploy-elastic-space";
    private static final String ADMIN_FACTORY_CLASS = "org.openspaces.admin.AdminFactory";
    private static final String ELASTIC_SPACE_DEPLOYMENT_CLASS = "org.openspaces.admin.space.ElasticSpaceDeployment";
    private Class adminFactoryClass;
    private Class elasticSpaceDeploymentClass;
    public static final String KEY_HELP1 = "h";
    public static final String KEY_HELP2 = "help";
    private static final String DEFAULT_SECURED = "false";
    private static final String DEFAULT_SCALE = "strategy=eager";
    private static final String DEFAULT_TIMEOUT = "120";
    private static final String DEFAULT_UNDEPLOY_ON_FAILURE = "false";
    private static Object INTACT_DEPLOYMENT_STATUS;

    ElasticSpaceDeploymentHandler() {
        block6: {
            try {
                ?[] deploymentStatuses = Class.forName("org.openspaces.admin.pu.DeploymentStatus").getEnumConstants();
                for (int i = 0; i < deploymentStatuses.length; ++i) {
                    if (!deploymentStatuses[i].getClass().getMethod("name", new Class[0]).invoke(deploymentStatuses[i], new Object[0]).equals("INTACT")) continue;
                    INTACT_DEPLOYMENT_STATUS = deploymentStatuses[i];
                    break;
                }
                if (INTACT_DEPLOYMENT_STATUS == null) {
                    throw new Exception("Internal error: unable to find INTACT value for DeploymentStatus");
                }
                this.adminFactoryClass = Class.forName(ADMIN_FACTORY_CLASS);
                this.elasticSpaceDeploymentClass = Class.forName(ELASTIC_SPACE_DEPLOYMENT_CLASS);
            }
            catch (ClassNotFoundException e) {
                System.out.println("Please install OpenSpaces.");
                if (LOGGER.isLoggable(Level.SEVERE)) {
                    LOGGER.log(Level.SEVERE, e.toString());
                }
            }
            catch (Exception e) {
                if (!LOGGER.isLoggable(Level.SEVERE)) break block6;
                LOGGER.log(Level.SEVERE, e.toString(), e);
            }
        }
    }

    @Override
    public String process(String input, BufferedReader br) {
        try {
            CredentialsProvider credentialsProvider;
            boolean undeployOnFailure;
            long timeoutInSec;
            input = input.trim();
            int index = input.lastIndexOf(32);
            if (index <= 0) {
                throw new InvalidCLIOptionException("SpaceName must be provided");
            }
            String command = input.substring(0, index);
            String spaceName = input.substring(index + 1);
            LinkedHashMap<ElasticSpaceDeploymentOption, String> args = OptionHandler.OptionsParser.parseCommand(ElasticSpaceDeploymentOption.class, command);
            if (args.size() == 0 || args.containsKey(ElasticSpaceDeploymentOption.HELP)) {
                return this.getUsage();
            }
            if (!args.containsKey(ElasticSpaceDeploymentOption.SECURED)) {
                args.put(ElasticSpaceDeploymentOption.SECURED, "false");
                if (LOGGER.isLoggable(Level.FINE)) {
                    LOGGER.fine("Using default value for option [" + ElasticSpaceDeploymentOption.SECURED.getParamName() + "] : " + "false");
                }
            }
            if (!args.containsKey(ElasticSpaceDeploymentOption.SCALE)) {
                args.put(ElasticSpaceDeploymentOption.SCALE, DEFAULT_SCALE);
                if (LOGGER.isLoggable(Level.FINE)) {
                    LOGGER.fine("Using default value for option [" + ElasticSpaceDeploymentOption.SCALE.getParamName() + "] : " + DEFAULT_SCALE);
                }
            }
            if (!args.containsKey(ElasticSpaceDeploymentOption.TIMEOUT)) {
                args.put(ElasticSpaceDeploymentOption.TIMEOUT, DEFAULT_TIMEOUT);
                if (LOGGER.isLoggable(Level.FINE)) {
                    LOGGER.fine("Using default value for option [" + ElasticSpaceDeploymentOption.TIMEOUT.getParamName() + "] : " + DEFAULT_TIMEOUT);
                }
            }
            try {
                timeoutInSec = Long.valueOf(args.get(ElasticSpaceDeploymentOption.TIMEOUT));
            }
            catch (NumberFormatException e) {
                throw new IllegalArgumentException("Invalid value for option [" + ElasticSpaceDeploymentOption.TIMEOUT + "]: Must be a number");
            }
            if (!args.containsKey(ElasticSpaceDeploymentOption.UNDEPLOY_ON_FAILURE)) {
                args.put(ElasticSpaceDeploymentOption.UNDEPLOY_ON_FAILURE, "false");
                if (LOGGER.isLoggable(Level.FINE)) {
                    LOGGER.fine("Using default value for option [" + ElasticSpaceDeploymentOption.UNDEPLOY_ON_FAILURE.getParamName() + "] : " + "false");
                }
            }
            String undeployOnFailureString = args.get(ElasticSpaceDeploymentOption.UNDEPLOY_ON_FAILURE);
            try {
                undeployOnFailure = ElasticSpaceDeploymentHandler.getBooleanValue(undeployOnFailureString);
            }
            catch (CannotCastToBooleanException e) {
                throw new IllegalArgumentException("Invalid value for option [" + ElasticSpaceDeploymentOption.UNDEPLOY_ON_FAILURE.getParamName() + "]: Must be true/false");
            }
            Object elasticSpaceDeployment = this.elasticSpaceDeploymentClass.getConstructor(String.class).newInstance(spaceName);
            String username = args.get(ElasticSpaceDeploymentOption.USER);
            String password = args.get(ElasticSpaceDeploymentOption.PASSWORD);
            if (username != null && password == null) {
                throw new IllegalArgumentException("Option [" + ElasticSpaceDeploymentOption.PASSWORD.getParamName() + "] is missing");
            }
            if (username == null && password != null) {
                throw new IllegalArgumentException("Option [" + ElasticSpaceDeploymentOption.USER.getParamName() + "] is missing");
            }
            if (username != null && password != null) {
                if (username.length() == 0) {
                    throw new IllegalArgumentException("Invalid value for option [" + ElasticSpaceDeploymentOption.USER.getParamName() + "]: Can not be empty");
                }
                if (password.length() == 0) {
                    throw new IllegalArgumentException("Invalid value for option [" + ElasticSpaceDeploymentOption.PASSWORD.getParamName() + "]: Can not be empty");
                }
                elasticSpaceDeployment.getClass().getMethod("userDetails", String.class, String.class).invoke(elasticSpaceDeployment, username, password);
            }
            block46: for (ElasticSpaceDeploymentOption option : args.keySet()) {
                Object[] optionValue = args.get(option);
                switch (option) {
                    case MAX_MEMORY_CAPACITY: {
                        this.logFinestIfLoggable("Handling MAX_MEMORY_CAPACITY");
                        String validationResult = this.validateMemoryParameter((String)optionValue);
                        if (validationResult != null) {
                            throw new IllegalArgumentException("Invalid value for option [" + option.getParamName() + "]: " + validationResult);
                        }
                        ElasticSpaceDeploymentHandler.logFineIfLoggable("Applying maxMemoryCapacity on [" + (String)optionValue + "]");
                        elasticSpaceDeployment.getClass().getMethod("maxMemoryCapacity", String.class).invoke(elasticSpaceDeployment, new Object[]{optionValue});
                        break;
                    }
                    case NUMBER_OF_PARTITIONS: {
                        this.logFinestIfLoggable("Handling NUMBER_OF_PARTITIONS");
                        try {
                            ElasticSpaceDeploymentHandler.logFineIfLoggable("Applying numberOfPartitions on [" + (String)optionValue + "]");
                            elasticSpaceDeployment.getClass().getMethod("numberOfPartitions", Integer.TYPE).invoke(elasticSpaceDeployment, Integer.valueOf((String)optionValue));
                            break;
                        }
                        catch (NumberFormatException e) {
                            throw new IllegalArgumentException("Invalid value for option [" + option.getParamName() + "]: Must be a number");
                        }
                    }
                    case MEMORY_CAPACITY_PER_CONTAINER: {
                        this.logFinestIfLoggable("Handling MEMORY_CAPACITY_PER_CONTAINER");
                        String validationResult = this.validateMemoryParameter((String)optionValue);
                        if (validationResult != null) {
                            throw new IllegalArgumentException("Invalid value for option [" + option.getParamName() + "]: " + validationResult);
                        }
                        ElasticSpaceDeploymentHandler.logFineIfLoggable("Applying memoryCapacityPerContainer on [" + (String)optionValue + "]");
                        elasticSpaceDeployment.getClass().getMethod("memoryCapacityPerContainer", String.class).invoke(elasticSpaceDeployment, new Object[]{optionValue});
                        break;
                    }
                    case MAX_NUMBER_OF_CPU_CORES: {
                        this.logFinestIfLoggable("Handling MAX_NUMBER_OF_CPU_CORES");
                        try {
                            ElasticSpaceDeploymentHandler.logFineIfLoggable("Applying maxNumberOfCpuCores on [" + (String)optionValue + "]");
                            elasticSpaceDeployment.getClass().getMethod("maxNumberOfCpuCores", Integer.TYPE).invoke(elasticSpaceDeployment, Integer.valueOf((String)optionValue));
                            break;
                        }
                        catch (NumberFormatException e) {
                            throw new IllegalArgumentException("Invalid value for option [" + option.getParamName() + "]: Must be a number");
                        }
                    }
                    case DEDICATED_MACHINE_PROVISIONING: {
                        this.logFinestIfLoggable("Handling DEDICATED_MACHINE_PROVISIONING");
                        ElasticSpaceDeploymentHandler.logFineIfLoggable("Applying dedicatedMachineProvisioning on [" + (String)optionValue + "]");
                        this.applyDedicatedMachineProvisioning((String)optionValue, elasticSpaceDeployment);
                        break;
                    }
                    case SHARED_MACHINE_PROVISIONING: {
                        this.logFinestIfLoggable("Handling SHARED_MACHINE_PROVISIONING");
                        ElasticSpaceDeploymentHandler.logFineIfLoggable("Applying sharedMachineProvisioning on [" + (String)optionValue + "]");
                        this.applySharedMachineProvisioning((String)optionValue, elasticSpaceDeployment);
                        break;
                    }
                    case SCALE: {
                        this.logFinestIfLoggable("Handling SCALE");
                        Object scaleConfig = this.parseScaleProperties((String)optionValue);
                        ElasticSpaceDeploymentHandler.logFineIfLoggable("Applying scale on [" + (String)optionValue + "]");
                        Statement scaleStatement = new Statement(elasticSpaceDeployment, "scale", new Object[]{scaleConfig});
                        scaleStatement.execute();
                        break;
                    }
                    case SINGLE_MACHINE_DEPLOYMENT: {
                        boolean singleMachineDeployment;
                        this.logFinestIfLoggable("Handling SINGLE_MACHINE_DEPLOYMENT [" + (String)optionValue + "]");
                        try {
                            singleMachineDeployment = ElasticSpaceDeploymentHandler.getBooleanValue((String)optionValue);
                        }
                        catch (CannotCastToBooleanException e) {
                            throw new IllegalArgumentException("Invalid value for option [" + option.getParamName() + "]: Must be true/false");
                        }
                        if (!singleMachineDeployment) continue block46;
                        ElasticSpaceDeploymentHandler.logFineIfLoggable("Applying singleMachineDeployment on [" + (String)optionValue + "]");
                        elasticSpaceDeployment.getClass().getMethod("singleMachineDeployment", new Class[0]).invoke(elasticSpaceDeployment, new Object[0]);
                        break;
                    }
                    case HIGHLY_AVAILABLE: {
                        boolean highlyAvailable;
                        this.logFinestIfLoggable("Handling HIGHLY_AVAILABLE");
                        try {
                            highlyAvailable = ElasticSpaceDeploymentHandler.getBooleanValue((String)optionValue);
                        }
                        catch (CannotCastToBooleanException e) {
                            throw new IllegalArgumentException("Invalid value for option [" + option.getParamName() + "]: Must be true/false");
                        }
                        ElasticSpaceDeploymentHandler.logFineIfLoggable("Applying highlyAvailable on [" + (String)optionValue + "]");
                        elasticSpaceDeployment.getClass().getMethod("highlyAvailable", Boolean.TYPE).invoke(elasticSpaceDeployment, highlyAvailable);
                        break;
                    }
                    case SECURED: {
                        boolean secured;
                        this.logFinestIfLoggable("Handling SECURED");
                        try {
                            secured = ElasticSpaceDeploymentHandler.getBooleanValue((String)optionValue);
                        }
                        catch (CannotCastToBooleanException e) {
                            throw new IllegalArgumentException("Invalid value for option [" + option.getParamName() + "]: Must be true/false");
                        }
                        ElasticSpaceDeploymentHandler.logFineIfLoggable("Applying secured on [" + (String)optionValue + "]");
                        elasticSpaceDeployment.getClass().getMethod("secured", Boolean.TYPE).invoke(elasticSpaceDeployment, secured);
                        break;
                    }
                    case USER: {
                        break;
                    }
                    case PASSWORD: {
                        break;
                    }
                    case TIMEOUT: {
                        break;
                    }
                    case UNDEPLOY_ON_FAILURE: {
                        break;
                    }
                    case NUMBER_OF_BACKUPS_PER_PARTITION: {
                        this.logFinestIfLoggable("Handling NUMBER_OF_BACKUPS_PER_PARTITION");
                        try {
                            ElasticSpaceDeploymentHandler.logFineIfLoggable("Applying numberOfBackupsPerPartition on [" + (String)optionValue + "]");
                            elasticSpaceDeployment.getClass().getMethod("numberOfBackupsPerPartition", Integer.TYPE).invoke(elasticSpaceDeployment, Integer.valueOf((String)optionValue));
                            break;
                        }
                        catch (NumberFormatException e) {
                            throw new IllegalArgumentException("Invalid value for option [" + option.getParamName() + "]: Must be a number");
                        }
                    }
                    case COMMAND_LINE_ARGUMENTS: {
                        String[] cmdargs;
                        this.logFinestIfLoggable("Handling COMMAND_LINE_ARGUMENTS [" + (String)optionValue + "]");
                        if (!optionValue.startsWith("\"") || !optionValue.endsWith("\"")) {
                            throw new IllegalArgumentException("Invalid value for option [" + option.getParamName() + "]: Must start and end with quotes.");
                        }
                        String value = optionValue.substring(1, optionValue.length() - 1);
                        for (String cmdarg : cmdargs = value.split(",")) {
                            ElasticSpaceDeploymentHandler.logFineIfLoggable("applying addCommandLineArgument on [" + cmdarg + "]");
                            elasticSpaceDeployment.getClass().getMethod("addCommandLineArgument", String.class).invoke(elasticSpaceDeployment, cmdarg);
                        }
                        continue block46;
                    }
                    case CONTEXT_PROPERTIES: {
                        String[] keyValues;
                        this.logFinestIfLoggable("Handling CONTEXT_PROPERTIES [" + (String)optionValue + "]");
                        for (String keyValue : keyValues = optionValue.split(" ")) {
                            this.logFinestIfLoggable("Handling [" + keyValue + "] in CONTEXT_PROPERTIES");
                            String[] keyValueArr = keyValue.split("=");
                            if (keyValueArr.length != 2) {
                                throw new IllegalArgumentException("Invalid value for option [" + option.getParamName() + "]: Invalid key value format");
                            }
                            ElasticSpaceDeploymentHandler.logFineIfLoggable("applying addContextProperty on [" + keyValueArr[0] + ", " + keyValueArr[1] + "]");
                            elasticSpaceDeployment.getClass().getMethod("addContextProperty", String.class, String.class).invoke(elasticSpaceDeployment, keyValueArr[0], keyValueArr[1]);
                        }
                        continue block46;
                    }
                    default: {
                        throw new IllegalArgumentException("Unhandled option [" + option.getParamName() + "]");
                    }
                }
            }
            Object adminFactory = this.adminFactoryClass.newInstance();
            if (GS.settings != null) {
                Object[] groups;
                Object[] locators = (LookupLocator[])GS.settings.get("locators");
                if (locators != null) {
                    if (LOGGER.isLoggable(Level.FINE)) {
                        LOGGER.fine("Locators: " + Arrays.toString(locators));
                    }
                    for (Object lookupLocator : locators) {
                        adminFactory.getClass().getMethod("addLocator", String.class).invoke(adminFactory, lookupLocator.getHost() + ":" + lookupLocator.getPort());
                    }
                }
                if ((groups = (String[])GS.settings.get("groups")) != null) {
                    if (LOGGER.isLoggable(Level.FINE)) {
                        LOGGER.fine("Groups: " + Arrays.toString(groups));
                    }
                    for (Object group : groups) {
                        adminFactory.getClass().getMethod("addGroup", String.class).invoke(adminFactory, group);
                    }
                }
            }
            if ((credentialsProvider = CLISecurityRepository.getInstance().getCurrentCredentialsProvider()) != null) {
                LOGGER.fine("Setting Credentials Provider for Admin Factory");
                Statement scaleStatement = new Statement(adminFactory, "credentialsProvider", new Object[]{credentialsProvider});
                scaleStatement.execute();
            }
            Object admin = adminFactory.getClass().getMethod("create", new Class[0]).invoke(adminFactory, new Object[0]);
            try {
                boolean waitForResult;
                Object gsms;
                Object gsm;
                Object esms;
                Object esm;
                Object gsAgents;
                Object gsa;
                if (LOGGER.isLoggable(Level.FINE)) {
                    LOGGER.fine("Waiting for at least one GSA");
                }
                if ((gsa = (gsAgents = admin.getClass().getMethod("getGridServiceAgents", new Class[0]).invoke(admin, new Object[0])).getClass().getMethod("waitForAtLeastOne", Long.TYPE, TimeUnit.class).invoke(gsAgents, new Object[]{10, TimeUnit.SECONDS})) == null) {
                    throw new IllegalArgumentException("Failed to find a running GSA within 10 seconds.");
                }
                if (LOGGER.isLoggable(Level.FINE)) {
                    LOGGER.fine("Waiting for at least one ESM");
                }
                if ((esm = (esms = admin.getClass().getMethod("getElasticServiceManagers", new Class[0]).invoke(admin, new Object[0])).getClass().getMethod("waitForAtLeastOne", Long.TYPE, TimeUnit.class).invoke(esms, new Object[]{10, TimeUnit.SECONDS})) == null) {
                    throw new IllegalArgumentException("Failed to find a running ESM within 10 seconds.");
                }
                if (LOGGER.isLoggable(Level.FINE)) {
                    LOGGER.fine("Waiting for at least one GSM");
                }
                if ((gsm = (gsms = admin.getClass().getMethod("getGridServiceManagers", new Class[0]).invoke(admin, new Object[0])).getClass().getMethod("waitForAtLeastOne", Long.TYPE, TimeUnit.class).invoke(gsms, new Object[]{10, TimeUnit.SECONDS})) == null) {
                    throw new IllegalArgumentException("Failed to find a running GSM within 10 seconds.");
                }
                LOGGER.info("Deploying elastic space [" + spaceName + "]");
                System.out.println("Deploying elastic space [" + spaceName + "]");
                long stTime = System.currentTimeMillis();
                boolean deploymentSucceeded = false;
                Expression expression = new Expression(gsm, "deploy", new Object[]{elasticSpaceDeployment, 10L, TimeUnit.SECONDS});
                Object pu = expression.getValue();
                int plannedNumberOfInstances = (Integer)pu.getClass().getMethod("getPlannedNumberOfInstances", new Class[0]).invoke(pu, new Object[0]);
                if (LOGGER.isLoggable(Level.FINE)) {
                    LOGGER.fine("Waiting [" + timeoutInSec + "] seconds for all the space instances to be instantiated.");
                    LOGGER.fine("Planned number of instances: " + plannedNumberOfInstances);
                }
                if (waitForResult = ((Boolean)pu.getClass().getMethod("waitFor", Integer.TYPE, Long.TYPE, TimeUnit.class).invoke(pu, new Object[]{plannedNumberOfInstances, timeoutInSec, TimeUnit.SECONDS})).booleanValue()) {
                    long timeout = timeoutInSec * 1000L;
                    while (true) {
                        Object deploymentStatus;
                        if ((deploymentStatus = pu.getClass().getMethod("getStatus", new Class[0]).invoke(pu, new Object[0])).equals(INTACT_DEPLOYMENT_STATUS)) {
                            deploymentSucceeded = true;
                            break;
                        }
                        if (System.currentTimeMillis() > stTime + timeout) break;
                        try {
                            LOGGER.info("Waiting for space to be deployed...");
                            Thread.sleep(1000L);
                        }
                        catch (InterruptedException e) {
                            if (!LOGGER.isLoggable(Level.WARNING)) continue;
                            LOGGER.log(Level.WARNING, "Wait has interrupted", e);
                        }
                    }
                }
                if (deploymentSucceeded) {
                    LOGGER.info("Space [" + spaceName + "] deployed successfully.");
                    System.out.println("Space [" + spaceName + "] deployed successfully.");
                } else {
                    LOGGER.info("Deployment of space [" + spaceName + "] didn't finish within [" + timeoutInSec + "] seconds");
                    System.out.println("Deployment of space [" + spaceName + "] didn't finish within [" + timeoutInSec + "] seconds");
                    if (undeployOnFailure) {
                        LOGGER.info(ElasticSpaceDeploymentOption.UNDEPLOY_ON_FAILURE.getParamName() + " option is provided, undeploying space [" + spaceName + "]");
                        System.out.println(ElasticSpaceDeploymentOption.UNDEPLOY_ON_FAILURE.getParamName() + " option is provided, undeploying space [" + spaceName + "]");
                        String undeployStatusString = pu.getClass().getMethod("undeployAndWait", Long.TYPE, TimeUnit.class).invoke(pu, new Object[]{timeoutInSec, TimeUnit.SECONDS}).toString();
                        try {
                            boolean undeployed = ElasticSpaceDeploymentHandler.getBooleanValue(undeployStatusString);
                            if (undeployed) {
                                LOGGER.info("Space [" + spaceName + "] is undeployed successfully");
                                System.out.println("Space [" + spaceName + "] is undeployed successfully");
                            } else {
                                LOGGER.info("Space [" + spaceName + "] is not undeployed within " + timeoutInSec + " seconds");
                                System.out.println("Space [" + spaceName + "] is not undeployed within " + timeoutInSec + " seconds");
                            }
                        }
                        catch (CannotCastToBooleanException e) {
                            throw new IllegalArgumentException("Invalid value for property [" + AbstractElasticDeploymentHandler.ScaleProperty.AT_MOST_ONE_CONCURRENT_RELOCATION.getPropertyName() + "]: Must be boolean");
                        }
                    }
                }
                admin.getClass().getMethod("close", new Class[0]).invoke(admin, new Object[0]);
                return "";
            }
            catch (Throwable e) {
                admin.getClass().getMethod("close", new Class[0]).invoke(admin, new Object[0]);
                throw e;
            }
        }
        catch (IllegalArgumentException e) {
            Object[] localCommandArgLine = CLIUtilities.getArgLineWithScreenPassword(input.split(" "));
            String msg = "Error deploying " + Arrays.toString(localCommandArgLine);
            LOGGER.log(Level.SEVERE, msg, e);
            if (e.getMessage() != null) {
                System.out.println(msg);
                System.out.println(e.getMessage());
            } else {
                System.out.println(msg);
                System.out.println(e.toString());
            }
        }
        catch (InvalidCLIOptionException e) {
            Object[] localCommandArgLine = CLIUtilities.getArgLineWithScreenPassword(input.split(" "));
            String msg = "Error deploying " + Arrays.toString(localCommandArgLine);
            LOGGER.log(Level.SEVERE, msg, e);
            if (e.getMessage() != null) {
                System.out.println(msg);
                System.out.println(e.getMessage());
            } else {
                System.out.println(msg);
                System.out.println(e.toString());
            }
            System.out.println(this.getUsage());
        }
        catch (InvocationTargetException e) {
            Object[] localCommandArgLine = CLIUtilities.getArgLineWithScreenPassword(input.split(" "));
            String msg = "Error deploying " + Arrays.toString(localCommandArgLine);
            LOGGER.log(Level.SEVERE, msg, e);
            if (e.getTargetException() != null && e.getTargetException().getMessage() != null) {
                System.out.println(msg + ":" + e.getTargetException().getMessage());
            } else {
                System.out.println(msg + ":" + e.toString());
            }
        }
        catch (Throwable e) {
            Object[] localCommandArgLine = CLIUtilities.getArgLineWithScreenPassword(input.split(" "));
            String msg = "Error deploying " + Arrays.toString(localCommandArgLine);
            LOGGER.log(Level.SEVERE, msg, e);
            System.out.println(msg + ":" + e.toString());
        }
        return "";
    }

    @Override
    public String getUsage() {
        StringBuilder sb = new StringBuilder();
        sb.append("Usage: \n\t deploy-elastic-space [options] -" + ElasticSpaceDeploymentOption.MEMORY_CAPACITY_PER_CONTAINER.getParamName() + " [number[m/g]] -" + ElasticSpaceDeploymentOption.MAX_MEMORY_CAPACITY.getParamName() + " [number[m/g]] Space_Name\n\t " + OPERATION_NAME + " [options] -" + ElasticSpaceDeploymentOption.MEMORY_CAPACITY_PER_CONTAINER.getParamName() + " [number[m/g]] -" + ElasticSpaceDeploymentOption.NUMBER_OF_PARTITIONS.getParamName() + " [number] Space_Name\n");
        sb.append("\n");
        sb.append("Available options: \n");
        sb.append("(*) Required options but cannot be used together\n");
        for (ElasticSpaceDeploymentOption option : ElasticSpaceDeploymentOption.values()) {
            if (option.equals(ElasticSpaceDeploymentOption.HELP)) continue;
            sb.append("\t" + option.getParamUsage() + "\n");
        }
        sb.append("\n");
        sb.append("Default values:\n");
        sb.append("\t" + ElasticSpaceDeploymentOption.SECURED.getParamName() + "\t\t\t\t: " + "false" + "\n");
        sb.append("\t" + ElasticSpaceDeploymentOption.SCALE.getParamName() + "\t\t\t\t: " + DEFAULT_SCALE + "\n");
        sb.append("\t" + ElasticSpaceDeploymentOption.TIMEOUT.getParamName() + "\t\t\t\t: " + DEFAULT_TIMEOUT + "\n");
        sb.append("\t" + ElasticSpaceDeploymentOption.UNDEPLOY_ON_FAILURE.getParamName() + "\t\t: " + "false" + "\n");
        sb.append("\n");
        sb.append("Examples:\n");
        sb.append("1. deploy-elastic-space -mcpc 32m -mmc 256m mySpace\n\t-Deploys an elastic space named mySpace with memory-capacity-per-container=32m and max-memory-capacity=256m.\n");
        sb.append("2. deploy-elastic-space -mcpc 32m -mmc 256m -scale strategy=manual memory-capacity=128m mySpace\n\t-Deploys an elastic stateful pu from file with manual scale strategy and memory-capacity=128m.\n");
        return sb.toString();
    }

    private static void logFineIfLoggable(String msg) {
        if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.fine(msg);
        }
    }

    private void logFinestIfLoggable(String msg) {
        if (LOGGER.isLoggable(Level.FINEST)) {
            LOGGER.finest(msg);
        }
    }

    private static enum ElasticSpaceDeploymentOption implements OptionHandler.AbstractCLIOption
    {
        MEMORY_CAPACITY_PER_CONTAINER("memory-capacity-per-container", "mcpc", "-mcpc, -memory-capacity-per-container [number[m/g]] \t : Required - specifies the the heap size per container (operating system process)"),
        MAX_MEMORY_CAPACITY("max-memory-capacity", "mmc", "-mmc, -max-memory-capacity [number[m/g]] \t\t : Required(*) - Specifies an estimate of the maximum memory capacity for this processing unit"),
        NUMBER_OF_PARTITIONS("number-of-partitions", "nop", "-nop, -number-of-partitions [number] \t\t\t : Required(*) - Defines the number of processing unit partitions"),
        MAX_NUMBER_OF_CPU_CORES("max-number-of-cpu-cores", "mnocc", "-mnocc, -max-number-of-cpu-cores [number] \t\t : Specifies an estimate for the maximum total number of cpu cores used by this processing unit"),
        SINGLE_MACHINE_DEPLOYMENT("single-machine-deployment", "smd", "-smd, -single-machine-deployment [true/false] \t\t : Allows deployment of the processing unit on a single machine"),
        HIGHLY_AVAILABLE("highly-available", "ha", "-ha, -highly-available [true/false] \t\t\t : Specifies if the space should duplicate each information on two different machines"),
        SECURED("secured", "-secured [true/false] \t\t\t\t\t : Deploys a secured processing unit (implicit when using -user/-password)"),
        USER("user", "-user [username] \t\t\t\t\t : Deploys a secured processing unit propagated with the supplied user and password"),
        PASSWORD("password", "-password [password] \t\t\t\t\t : Deploys a secured processing unit propagated with the supplied user and password"),
        DEDICATED_MACHINE_PROVISIONING("dedicated-machine-provisioning", "dmp", "-dmp, -dedicated-machine-provisioning \t\t\t : Configure the server side bean that starts and stops machines automatically\n" + AbstractElasticDeploymentHandler.DedicatedMachineProvisioningProperty.getPropertiesUsage()),
        SHARED_MACHINE_PROVISIONING("shared-machine-provisioning", "smp", "-smp, -shared-machine-provisioning \t\t\t : Configure the server side bean that starts and stops machines automatically\n" + AbstractElasticDeploymentHandler.SharedMachineProvisioningProperty.getPropertiesUsage()),
        SCALE("scale", "-scale [scale properties] \t\t\t\t : Enables the specified scale strategy, and disables all other scale strategies\n" + AbstractElasticDeploymentHandler.ScaleProperty.getPropertiesUsage()),
        TIMEOUT("timeout", "-timeout [timeout in seconds] \t\t\t\t : Timeout for deploy operation"),
        UNDEPLOY_ON_FAILURE("undeploy-on-failure", "uof", "-uof, -undeploy-on-failure [true/false] \t\t : Specifies if the space should be undeployed if the specified timeout has expired."),
        NUMBER_OF_BACKUPS_PER_PARTITION("number-of-backups-per-partition", "nobpp", "-nobpp, -number-of-backups-per-partition [number] \t : Specifies the number of backup processing unit instances per partition. This is an advanced property."),
        COMMAND_LINE_ARGUMENTS("command-line-arguments", "cmdargs", "-cmdargs, -command-line-args [\"comma separated list\"] \t : Adds the arguments as JVM level arguments when the process is executed using pure JVM."),
        CONTEXT_PROPERTIES("context-properties", "ctxp", "-ctxp, -context-properties key1=value1 key2=value2 \t : Defines a context deploy time property overriding any ${...}"),
        HELP("help", "-help");

        private String paramName;
        private String shortParamName;
        private String usageDesc;

        private ElasticSpaceDeploymentOption(String paramName, String usageDesc) {
            this.paramName = paramName;
            this.shortParamName = null;
            this.usageDesc = usageDesc;
        }

        private ElasticSpaceDeploymentOption(String paramName, String shortParamName, String usageDesc) {
            this.paramName = paramName;
            this.shortParamName = shortParamName;
            this.usageDesc = usageDesc;
        }

        @Override
        public String getParamName() {
            return this.paramName;
        }

        @Override
        public String getShortParamName() {
            return this.shortParamName;
        }

        public String getParamUsage() {
            return this.usageDesc;
        }
    }
}

