/*
 * Decompiled with CFR 0.152.
 */
package com.gigaspaces.admin.cli;

import com.gigaspaces.admin.cli.GS;
import com.gigaspaces.admin.cli.ListSpaces;
import com.gigaspaces.admin.cli.ServiceFinder;
import com.gigaspaces.admin.cli.utils.CLISecurityUtils;
import com.gigaspaces.cluster.activeelection.ISpaceModeListener;
import com.gigaspaces.cluster.activeelection.SpaceMode;
import com.gigaspaces.grid.gsa.AgentProcessDetails;
import com.gigaspaces.grid.gsa.AgentProcessesDetails;
import com.gigaspaces.grid.gsa.GSA;
import com.gigaspaces.grid.gsc.GSC;
import com.gigaspaces.security.authorities.MonitorAuthority;
import com.gigaspaces.security.authorities.Privilege;
import com.gigaspaces.security.service.SecuredService;
import com.j_spaces.core.IJSpace;
import com.j_spaces.core.admin.IInternalRemoteJSpaceAdmin;
import com.j_spaces.core.admin.IRemoteJSpaceAdmin;
import com.j_spaces.core.admin.SpaceConfig;
import com.j_spaces.kernel.JSpaceUtilities;
import java.io.BufferedReader;
import java.io.IOException;
import java.rmi.Remote;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.StringTokenizer;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.jini.core.lookup.ServiceItem;
import org.jini.rio.core.OperationalStringManager;
import org.jini.rio.core.ServiceBeanInstance;
import org.jini.rio.core.ServiceElement;
import org.jini.rio.core.provision.ServiceRecord;
import org.jini.rio.cybernode.Cybernode;
import org.jini.rio.monitor.DeployAdmin;
import org.jini.rio.monitor.ProvisionMonitor;
import org.jini.rio.resources.util.TimeUtil;

public class Formatter {
    static final int JMX_CONNECTION = 1;
    static final int UTILIZATION = 2;
    static final int EXPORT_CODEBASE = 4;
    static final int PRIMARY_BACKUP_INDICATION = 8;
    static final int MAX_ITEM_LENGTH = 30;
    private static final Logger _logger = Logger.getLogger("com.gigaspaces.admin.cli");

    public static String asList(ServiceItem[] items) {
        return Formatter.asList(items, 0);
    }

    public static String asList(ServiceItem[] items, int options) {
        String[] array = Formatter.formattedArray(items, options);
        StringBuilder buffer = new StringBuilder();
        for (int i = 0; i < array.length; ++i) {
            if (i > 0) {
                buffer.append("\n");
            }
            buffer.append(array[i]);
        }
        return buffer.toString();
    }

    public static String asChoices(ServiceItem[] items) {
        return Formatter.asChoices(items, true);
    }

    public static String asChoices(ServiceItem[] items, boolean isAppendAllOption) {
        return Formatter.asChoices(items, 0, isAppendAllOption);
    }

    public static String asChoices(ServiceItem[] items, int options) {
        return Formatter.asChoices(items, options, true);
    }

    public static String asChoices(ServiceItem[] items, int options, boolean isAppendAllOption) {
        StringBuilder buffer = new StringBuilder(Formatter.asList(items, options));
        if (isAppendAllOption) {
            buffer.append("\n[").append(items.length + 1).append("]  all");
        }
        return buffer.toString();
    }

    public static String[] formattedArray(ServiceItem[] items, int options) {
        int i;
        ArrayList<OutputInfo> list = new ArrayList<OutputInfo>();
        ServiceFinder.ServiceInfo[] serviceInfo = GS.finder.getServiceInfo();
        for (int i2 = 0; i2 < items.length; ++i2) {
            IJSpace space;
            SpaceMode mode;
            String[] optionValues;
            String host;
            String[] groups;
            long pid;
            String name;
            Object service;
            boolean isSecuredService;
            ServiceItem serviceItem;
            block42: {
                String cpu;
                block41: {
                    serviceItem = items[i2];
                    isSecuredService = false;
                    service = serviceItem.getService();
                    if (service instanceof SecuredService) {
                        try {
                            isSecuredService = ((SecuredService)service).isServiceSecured();
                        }
                        catch (Exception e) {
                            if (!_logger.isLoggable(Level.SEVERE)) break block41;
                            _logger.log(Level.SEVERE, e.toString(), e);
                        }
                    }
                }
                ServiceFinder.ServiceInfo sInfo = null;
                for (int j = 0; j < serviceInfo.length; ++j) {
                    ServiceItem item = serviceInfo[j].getServiceItem();
                    if (!item.serviceID.equals((Object)serviceItem.serviceID)) continue;
                    sInfo = serviceInfo[j];
                    break;
                }
                if (sInfo == null) {
                    sInfo = new ServiceFinder.ServiceInfo(serviceItem);
                    GS.finder.resolveServiceInfo(sInfo);
                }
                name = sInfo.getServiceName();
                pid = sInfo.getPid();
                groups = sInfo.getGroups();
                host = sInfo.getHost();
                if (groups == null) {
                    groups = new String[]{"<?>"};
                }
                optionValues = new String[]{"", "", ""};
                String[] optionFormats = new String[]{"%s", "%s", "%s"};
                if ((options & 2) != 0 && (cpu = ServiceFinder.getCPU(serviceItem.attributeSets)) != null) {
                    optionValues[0] = cpu;
                    optionFormats[0] = "%-8s";
                }
                mode = null;
                if (service instanceof IJSpace) {
                    space = (IJSpace)service;
                    try {
                        IRemoteJSpaceAdmin admin = (IRemoteJSpaceAdmin)space.getAdmin();
                        SpaceConfig spaceConfig = admin.getConfig();
                        boolean isClustered = spaceConfig.isClustered();
                        if (isClustered) {
                            ISpaceModeListener remoteListener = (ISpaceModeListener)space.getDirectProxy().getStubHandler().exportObject((Remote)((Object)new ListSpaces.SpaceModeListenerImpl()));
                            mode = ((IInternalRemoteJSpaceAdmin)admin).addSpaceModeListener(remoteListener);
                            ((IInternalRemoteJSpaceAdmin)admin).removeSpaceModeListener(remoteListener);
                        }
                    }
                    catch (RemoteException re) {
                        if (!_logger.isLoggable(Level.SEVERE)) break block42;
                        _logger.log(Level.SEVERE, re.toString(), re);
                    }
                }
            }
            if ((options & 8) != 0 && mode != null) {
                space = (IJSpace)service;
                optionFormats[0] = "%-20s";
                optionFormats[1] = "%-8s";
                optionValues[1] = mode != null ? (mode.equals((Object)SpaceMode.PRIMARY) ? "Primary" : "Backup") : "-";
                optionValues[0] = space.getContainerName();
            }
            if ((options & 4) != 0) {
                String exportCodebase = JSpaceUtilities.getExportCodebase((Object)service);
                optionValues[1] = "   " + exportCodebase;
                optionFormats[1] = "%-32s";
            }
            if ((options & 1) != 0) {
                String jmxConn;
                boolean isJMXCanBeShown;
                block43: {
                    isJMXCanBeShown = true;
                    if (isSecuredService) {
                        SecuredService securedService = (SecuredService)service;
                        try {
                            boolean isMonitorJVMPermitted;
                            isJMXCanBeShown = isMonitorJVMPermitted = CLISecurityUtils.hasPermittedPermission(securedService, serviceItem.serviceID, (Privilege)MonitorAuthority.MonitorPrivilege.MONITOR_JVM, isSecuredService);
                        }
                        catch (Exception e) {
                            if (!_logger.isLoggable(Level.SEVERE)) break block43;
                            _logger.log(Level.SEVERE, e.toString(), e);
                        }
                    }
                }
                String string = jmxConn = !isJMXCanBeShown ? "*****" : JSpaceUtilities.getJMXConnectionUrl((ServiceItem)serviceItem);
                if (jmxConn != null) {
                    optionValues[2] = "   " + jmxConn;
                    optionFormats[2] = "%-32s";
                }
            }
            OutputInfo oi = new OutputInfo();
            oi.itemNum = "[" + (i2 + 1) + "]";
            oi.pid = pid > 0L ? String.valueOf(pid) : "";
            oi.name = Formatter.truncate(name);
            oi.spaceMode = mode != null ? (mode.equals((Object)SpaceMode.PRIMARY) ? "Primary" : "Backup") : "";
            oi.groups = Formatter.truncate(Formatter.fromArray(groups));
            oi.host = Formatter.truncate(host);
            oi.option0 = optionValues[0].trim();
            oi.option1 = optionValues[1].trim();
            oi.option2 = optionValues[2].trim();
            oi.secured = isSecuredService ? "secured" : "";
            list.add(oi);
        }
        OutputInfo[] oi = list.toArray(new OutputInfo[list.size()]);
        ArrayList<String> itemsList = new ArrayList<String>(oi.length);
        int maxItemNumLength = 0;
        int maxPidLength = 0;
        int maxNameLength = 0;
        int maxSpaceNameLength = 0;
        int maxGroupLength = 0;
        int maxHostLength = 0;
        int maxOption0Length = 0;
        int maxOption1Length = 0;
        int maxOption2Length = 0;
        for (i = 0; i < oi.length; ++i) {
            if (oi[i].itemNum.length() > maxItemNumLength) {
                maxItemNumLength = oi[i].itemNum.length();
            }
            if (oi[i].pid.length() > maxPidLength) {
                maxPidLength = oi[i].pid.length();
            }
            if (oi[i].name.length() > maxNameLength) {
                maxNameLength = oi[i].name.length();
            }
            if (oi[i].spaceMode.length() > maxSpaceNameLength) {
                maxSpaceNameLength = oi[i].spaceMode.length();
            }
            if (oi[i].groups.length() > maxGroupLength) {
                maxGroupLength = oi[i].groups.length();
            }
            if (oi[i].host.length() > maxHostLength) {
                maxHostLength = oi[i].host.length();
            }
            if (oi[i].option0.length() > maxOption0Length) {
                maxOption0Length = oi[i].option0.length();
            }
            if (oi[i].option1.length() > maxOption1Length) {
                maxOption1Length = oi[i].option1.length();
            }
            if (oi[i].option2.length() <= maxOption2Length) continue;
            maxOption2Length = oi[i].option2.length();
        }
        for (i = 0; i < oi.length; ++i) {
            int j;
            String spaceItemNum = "";
            String spacePid = "";
            String spaceName = "";
            String spaceMode = "";
            String spaceGroup = "";
            String spaceHost = "";
            String spaceOption0 = "";
            String spaceOption1 = "";
            String spaceOption2 = "";
            int endOfLineSpaceLength = 2;
            int itemNumLengthDif = maxItemNumLength - oi[i].itemNum.length() + endOfLineSpaceLength;
            StringBuilder sb = new StringBuilder();
            for (int j2 = 0; j2 < itemNumLengthDif; ++j2) {
                sb.append(" ");
            }
            spaceItemNum = sb.toString();
            int pidLengthDif = maxPidLength - oi[i].pid.length() + endOfLineSpaceLength;
            sb = new StringBuilder();
            for (int j3 = 0; j3 < pidLengthDif; ++j3) {
                sb.append(" ");
            }
            spacePid = sb.toString();
            int nameLengthDif = maxNameLength - oi[i].name.length() + endOfLineSpaceLength;
            sb = new StringBuilder();
            for (int j4 = 0; j4 < nameLengthDif; ++j4) {
                sb.append(" ");
            }
            spaceName = sb.toString();
            int spaceNameLengthDiff = maxSpaceNameLength - oi[i].spaceMode.length() + endOfLineSpaceLength;
            sb = new StringBuilder();
            for (int j5 = 0; j5 < spaceNameLengthDiff; ++j5) {
                sb.append(" ");
            }
            spaceMode = sb.toString();
            int groupLengthDif = maxGroupLength - oi[i].groups.length() + endOfLineSpaceLength;
            sb = new StringBuilder();
            for (int j6 = 0; j6 < groupLengthDif; ++j6) {
                sb.append(" ");
            }
            spaceGroup = sb.toString();
            int hostLengthDif = maxHostLength - oi[i].host.length() + endOfLineSpaceLength;
            sb = new StringBuilder();
            for (int j7 = 0; j7 < hostLengthDif; ++j7) {
                sb.append(" ");
            }
            spaceHost = sb.toString();
            if (maxOption0Length > 0) {
                int option0LengthDif = maxOption0Length - oi[i].option0.length() + endOfLineSpaceLength;
                sb = new StringBuilder();
                for (j = 0; j < option0LengthDif; ++j) {
                    sb.append(" ");
                }
                spaceOption0 = sb.toString();
            }
            if (maxOption1Length > 0) {
                int option1LengthDif = maxOption1Length - oi[i].option1.length() + endOfLineSpaceLength;
                sb = new StringBuilder();
                for (j = 0; j < option1LengthDif; ++j) {
                    sb.append(" ");
                }
                spaceOption1 = sb.toString();
            }
            if (maxOption2Length > 0) {
                int option2LengthDif = maxOption2Length - oi[i].option2.length() + endOfLineSpaceLength;
                sb = new StringBuilder();
                for (j = 0; j < option2LengthDif; ++j) {
                    sb.append(" ");
                }
                spaceOption2 = sb.toString();
            }
            itemsList.add(oi[i].itemNum + spaceItemNum + oi[i].pid + spacePid + oi[i].name + spaceName + oi[i].spaceMode + spaceMode + oi[i].groups + spaceGroup + oi[i].host + spaceHost + oi[i].option0 + spaceOption0 + oi[i].option1 + spaceOption1 + oi[i].option2 + spaceOption2 + oi[i].secured);
        }
        return itemsList.toArray(new String[list.size()]);
    }

    private static String truncate(String s) {
        if (s.length() > 30) {
            s = s.substring(0, 27) + "...";
        }
        return s;
    }

    public static void gscLister(ServiceItem[] items, int options) {
        String[] gscs = Formatter.formattedArray(items, options);
        for (int i = 0; i < gscs.length; ++i) {
            System.out.println(gscs[i]);
            try {
                Object service = items[i].getService();
                if (service instanceof Cybernode) {
                    ServiceRecord[] records = ((GSC)service).getServiceRecords(1);
                    if (records.length == 0) {
                        System.out.println("\tNo contained services");
                        continue;
                    }
                    for (int j = 0; j < records.length; ++j) {
                        String groups = Formatter.fromArray(records[j].getServiceElement().getServiceBeanConfig().getGroups());
                        String elapsed = TimeUtil.format((long)records[j].computeElapsedTime());
                        boolean isSecured = ((SecuredService)service).isServiceSecured();
                        System.out.println("\t" + records[j].getName() + "\t\t" + groups + "\t\t" + elapsed + "\t" + (isSecured ? "secured" : ""));
                    }
                    continue;
                }
                System.out.println("\tNot a Grid Service Container");
                continue;
            }
            catch (Exception e) {
                if (!_logger.isLoggable(Level.SEVERE)) continue;
                _logger.log(Level.SEVERE, e.toString(), e);
            }
        }
    }

    public static void gsaLister(ServiceItem[] items, int options) {
        String[] gsas = Formatter.formattedArray(items, options);
        for (int i = 0; i < gsas.length; ++i) {
            System.out.println(gsas[i]);
            try {
                Object service = items[i].getService();
                if (service instanceof GSA) {
                    AgentProcessDetails[] agentProcessDetailsArray;
                    GSA gsa = (GSA)service;
                    AgentProcessesDetails agentProcessesDetails = gsa.getDetails();
                    for (AgentProcessDetails agentProcessDetails : agentProcessDetailsArray = agentProcessesDetails.getProcessDetails()) {
                        int agentID = agentProcessDetails.getAgentId();
                        String serviceType = agentProcessDetails.getServiceType();
                        long processId = agentProcessDetails.getProcessId();
                        StringBuilder strBuilder = new StringBuilder();
                        strBuilder.append(serviceType);
                        strBuilder.append("-");
                        strBuilder.append(agentID);
                        strBuilder.append("[");
                        strBuilder.append(processId);
                        strBuilder.append("]");
                        System.out.println("\t" + strBuilder.toString());
                    }
                    continue;
                }
                System.out.println("\tNot a Grid Service Agent");
                continue;
            }
            catch (Exception e) {
                if (!_logger.isLoggable(Level.SEVERE)) continue;
                _logger.log(Level.SEVERE, e.toString(), e);
            }
        }
    }

    public static void gsmLister(ServiceItem[] items, int options) {
        String[] gsms = Formatter.formattedArray(items, options);
        for (int i = 0; i < gsms.length; ++i) {
            System.out.println(gsms[i]);
            try {
                Object service = items[i].getService();
                if (service instanceof ProvisionMonitor) {
                    DeployAdmin deployAdmin = (DeployAdmin)((ProvisionMonitor)service).getAdmin();
                    OperationalStringManager[] opMgrs = deployAdmin.getOperationalStringManagers();
                    if (opMgrs.length == 0) {
                        System.out.println("\tNo Managed Deployments");
                    }
                    for (int j = 0; j < opMgrs.length; ++j) {
                        Formatter.listMgr(opMgrs[j]);
                    }
                    continue;
                }
                System.out.println("\tNot a Grid Service Manager");
                continue;
            }
            catch (Exception e) {
                if (!_logger.isLoggable(Level.SEVERE)) continue;
                _logger.log(Level.SEVERE, e.toString(), e);
            }
        }
    }

    public static void listMgr(OperationalStringManager opMgr) {
        block6: {
            String pad = "    ";
            String role = "primary";
            try {
                if (!opMgr.isManaging()) {
                    role = "backup";
                }
                System.out.println("\t" + opMgr.getOperationalString().getName() + "\trole=" + role);
                ServiceElement[] sElems = opMgr.getOperationalString().getServices();
                for (int i = 0; i < sElems.length; ++i) {
                    String tabs = "\t";
                    if (sElems[i].getName().length() < 10) {
                        tabs = tabs + "\t";
                    }
                    String pending = "pending=";
                    pending = role.equals("backup") ? pending + "<n/a>" : pending + opMgr.getPendingCount(sElems[i]);
                    System.out.println("\t" + pad + sElems[i].getName() + tabs + "planned=" + sElems[i].getPlanned() + "\tactual=" + sElems[i].getActual() + "\t" + pending);
                    ServiceBeanInstance[] instances = opMgr.getServiceBeanInstances(sElems[i]);
                    for (int j = 0; j < instances.length; ++j) {
                        Long id = instances[j].getServiceBeanConfig().getInstanceID();
                        System.out.println("\t" + pad + pad + "id=" + id + "\t\t" + instances[j].getHostAddress());
                    }
                }
            }
            catch (Exception e) {
                if (!_logger.isLoggable(Level.SEVERE)) break block6;
                _logger.log(Level.SEVERE, e.toString(), e);
            }
        }
    }

    public static ServiceItem[] selectItems(ServiceItem[] items, String prompt, BufferedReader br, int options) {
        return Formatter.selectItems(items, prompt, br, options, true);
    }

    public static ServiceItem[] selectItems(ServiceItem[] items, String prompt, BufferedReader br, int options, boolean isSupportMultipleOptionsSelection) {
        boolean validInput;
        ServiceItem[] selectedItems = null;
        int[] selections = new int[]{};
        if (options >= 0) {
            System.out.println(Formatter.asChoices(items, options, isSupportMultipleOptionsSelection) + "\n");
        } else {
            System.out.println(Formatter.asChoices(items, isSupportMultipleOptionsSelection) + "\n");
        }
        System.out.print(prompt);
        block6: while (true) {
            try {
                while (true) {
                    String response;
                    block18: {
                        response = br.readLine();
                        validInput = true;
                        if (response == null) continue;
                        if (response.equals("c")) {
                            return null;
                        }
                        if (isSupportMultipleOptionsSelection) {
                            StringTokenizer tok = new StringTokenizer(response, " ,");
                            selections = new int[tok.countTokens()];
                            for (int i = 0; i < selections.length; ++i) {
                                try {
                                    String selection = tok.nextToken();
                                    selections[i] = Integer.parseInt(selection);
                                    if (selections[i] < 1 || selections[i] > items.length + 1) {
                                        validInput = false;
                                        break;
                                    }
                                    if (selections[i] != items.length + 1) continue;
                                    return items;
                                }
                                catch (NumberFormatException e) {
                                    validInput = false;
                                    break;
                                }
                            }
                        } else {
                            if (response.trim().length() > 0) {
                                selections = new int[1];
                                try {
                                    selections[0] = Integer.parseInt(response.trim());
                                    break block18;
                                }
                                catch (NumberFormatException e) {
                                    validInput = false;
                                    break block6;
                                }
                            }
                            validInput = false;
                        }
                    }
                    if (validInput) break block6;
                    System.out.println("Invalid choice " + response);
                    System.out.print(prompt);
                }
            }
            catch (IOException e) {
                if (!_logger.isLoggable(Level.SEVERE)) continue;
                _logger.log(Level.SEVERE, e.toString(), e);
                continue;
            }
            break;
        }
        if (validInput && selections.length > 0) {
            selectedItems = new ServiceItem[selections.length];
            for (int i = 0; i < selectedItems.length; ++i) {
                selectedItems[i] = items[selections[i] - 1];
            }
        }
        return selectedItems;
    }

    public static String fromArray(String[] array) {
        return Formatter.fromArray(array, ", ");
    }

    public static String fromArray(String[] array, String delim) {
        if (array == null) {
            throw new NullPointerException("array is null");
        }
        if (delim == null) {
            throw new NullPointerException("delim is null");
        }
        StringBuffer buffer = new StringBuffer();
        for (int i = 0; i < array.length; ++i) {
            if (i > 0) {
                buffer.append(delim);
            }
            buffer.append(array[i]);
        }
        return buffer.toString();
    }

    public static String[] toArray(String arg) {
        StringTokenizer tok = new StringTokenizer(arg, " ,");
        String[] array = new String[tok.countTokens()];
        int i = 0;
        while (tok.hasMoreTokens()) {
            array[i] = tok.nextToken();
            ++i;
        }
        return array;
    }

    private static class OutputInfo {
        String itemNum;
        String pid;
        String name;
        String spaceMode;
        String groups;
        String host;
        String option0;
        String option1;
        String option2;
        String secured = "";

        private OutputInfo() {
        }
    }
}

