/*
 * Decompiled with CFR 0.152.
 */
package com.gigaspaces.admin.cli;

import com.gigaspaces.admin.cli.AdminHandler;
import com.gigaspaces.admin.cli.ApplicationDeployHandler;
import com.gigaspaces.admin.cli.ApplicationUndeployHandler;
import com.gigaspaces.admin.cli.CLIUtilities;
import com.gigaspaces.admin.cli.Constants;
import com.gigaspaces.admin.cli.DirHandler;
import com.gigaspaces.admin.cli.ElasticPUDeploymentHandler;
import com.gigaspaces.admin.cli.ElasticSpaceDeploymentHandler;
import com.gigaspaces.admin.cli.Formatter;
import com.gigaspaces.admin.cli.GSAHandler;
import com.gigaspaces.admin.cli.GSMControl;
import com.gigaspaces.admin.cli.ListHandler;
import com.gigaspaces.admin.cli.Login;
import com.gigaspaces.admin.cli.MemcachedDeployHandler;
import com.gigaspaces.admin.cli.PUDeployHandler;
import com.gigaspaces.admin.cli.QuiesceCLIHandler;
import com.gigaspaces.admin.cli.RestHandler;
import com.gigaspaces.admin.cli.RuntimeInfo;
import com.gigaspaces.admin.cli.ScaleHandler;
import com.gigaspaces.admin.cli.ServiceFinder;
import com.gigaspaces.admin.cli.ServiceProvisionNotification;
import com.gigaspaces.admin.cli.SpaceDeployHandler;
import com.gigaspaces.admin.cli.SpaceHandler;
import com.gigaspaces.admin.cli.UnquiesceCLIHandler;
import com.gigaspaces.admin.cli.utils.CLISecurityRepository;
import com.gigaspaces.admin.cli.utils.CLISecurityUtils;
import com.gigaspaces.admin.discovery.ReggieStat;
import com.gigaspaces.internal.utils.StringUtils;
import com.gigaspaces.internal.version.PlatformVersion;
import com.gigaspaces.logger.GSLogConfigLoader;
import com.gigaspaces.management.entry.JMXConnection;
import com.gigaspaces.security.authorities.MonitorAuthority;
import com.gigaspaces.security.authorities.Privilege;
import com.gigaspaces.security.directory.CredentialsProviderHelper;
import com.gigaspaces.security.service.SecuredService;
import com.gigaspaces.start.Locator;
import com.gigaspaces.start.SystemConfig;
import com.gigaspaces.start.SystemInfo;
import com.j_spaces.jmx.util.JConsoleUtilities;
import com.j_spaces.kernel.JSpaceUtilities;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.InetAddress;
import java.net.MalformedURLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.jini.config.Configuration;
import net.jini.config.ConfigurationException;
import net.jini.core.discovery.LookupLocator;
import net.jini.core.entry.Entry;
import net.jini.core.lookup.ServiceItem;
import net.jini.discovery.DiscoveryGroupManagement;
import net.jini.discovery.DiscoveryLocatorManagement;
import net.jini.discovery.DiscoveryManagement;
import net.jini.discovery.LookupGroups;
import org.jini.rio.boot.BootUtil;
import org.jini.rio.resources.util.TimeUtil;

public class GS
implements Constants {
    private static final long startTime = System.currentTimeMillis();
    static final String COMPONENT = "com.gigaspaces.admin.cli";
    static ServiceFinder finder;
    private static ServiceProvisionNotification provisionNotifier;
    static String hostName;
    static String hostAddress;
    static boolean commandLine;
    static final String DISCOVERY_TIMEOUT = "disco-timeout";
    private static final String GROUPS = "groups";
    private static final String LOCATORS = "locators";
    private static final String SYS_PROPS = "system-props";
    static final String DEPLOY_BLOCK = "wait-on-deploy";
    static final String DEPLOY_WAIT = "deploy-timeout";
    public static final Map<String, Object> settings;
    private static final Map<String, OptionHandlerDesc> optionMap;
    private static String homeDir;
    private static String[] commandArgLine;
    static File currentDir;
    private static SystemConfig sysConfig;
    private static String overrideFile;
    private static String previous;
    public static final int DEFAULT_TIMEOUT = 10000;
    private static int timeout;
    private static Logger logger;

    private static void printUsage() {
        String msg = "Usage :\n\tGS [ -user username -password password | -user-details-provider com.custom.UserDetailsProviderImpl -user-details-properties prop1=value1;prop2=value2 | ] [ list | pudeploy | deploy | undeploy | task | space ]";
        System.out.println(msg);
    }

    private static String getInteractiveUsage() {
        String[] optionNames = GS.getOptionNames();
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < optionNames.length; ++i) {
            sb.append(optionNames[i]);
            if (i > 0 && i % 4 == 3) {
                sb.append(StringUtils.NEW_LINE);
                continue;
            }
            for (int j = optionNames[i].length(); j < 20; ++j) {
                sb.append(' ');
            }
            sb.append(' ');
        }
        return sb.toString();
    }

    private static String[] getOptionNames() {
        Set<String> keys = optionMap.keySet();
        Object[] names = new String[keys.size()];
        int i = 0;
        for (String key : keys) {
            names[i++] = key;
        }
        Arrays.sort(names);
        return names;
    }

    private static void onExit(boolean print) {
        if (finder != null) {
            finder.terminate();
        }
        if (print) {
            System.out.println("\nThank you for using the GS Interactive Shell Program\n");
        }
        System.exit(0);
    }

    private static boolean validCommand(String command) {
        return command.equalsIgnoreCase("owen") || optionMap.containsKey(command);
    }

    private static OptionHandler getOptionHandler(String option) {
        OptionHandler handler = null;
        OptionHandlerDesc desc = optionMap.get(option);
        if (desc == null) {
            System.out.println("unknown option [" + option + "]");
        } else {
            handler = desc.getOptionHandler();
        }
        return handler;
    }

    private static void loadOptionHandlers(Configuration config) throws ConfigurationException {
        OptionHandlerDesc[] optionHandlers;
        OptionHandlerDesc[] defaultHandlers = new OptionHandlerDesc[]{new OptionHandlerDesc("list", ListHandler.class), new OptionHandlerDesc("undeploy", GSMControl.UndeployHandler.class), new OptionHandlerDesc("set", SettingsHandler.class), new OptionHandlerDesc("ls", DirHandler.class), new OptionHandlerDesc("dir", DirHandler.class), new OptionHandlerDesc("pwd", DirHandler.class), new OptionHandlerDesc("cd", DirHandler.class), new OptionHandlerDesc("jconsole", JConsoleHandler.class), new OptionHandlerDesc("stats", StatsHandler.class), new OptionHandlerDesc("help", HelpHandler.class), new OptionHandlerDesc("version", VersionHandler.class), new OptionHandlerDesc("pudeploy", PUDeployHandler.class), new OptionHandlerDesc("deploy", PUDeployHandler.class), new OptionHandlerDesc("deploy-space", SpaceDeployHandler.class), new OptionHandlerDesc("deploy-memcached", MemcachedDeployHandler.class), new OptionHandlerDesc("deploy-application", ApplicationDeployHandler.class), new OptionHandlerDesc("undeploy-application", ApplicationUndeployHandler.class), new OptionHandlerDesc("login", Login.class), new OptionHandlerDesc("deploy-elastic-space", ElasticSpaceDeploymentHandler.class), new OptionHandlerDesc("deploy-elastic-pu", ElasticPUDeploymentHandler.class), new OptionHandlerDesc("scale", ScaleHandler.class), new OptionHandlerDesc(RestHandler.OPERATION_NAME, RestHandler.class), new OptionHandlerDesc("space", SpaceHandler.class), new OptionHandlerDesc("gsa", GSAHandler.class), new OptionHandlerDesc("admin", AdminHandler.class), new OptionHandlerDesc("quiesce", QuiesceCLIHandler.class), new OptionHandlerDesc("unquiesce", UnquiesceCLIHandler.class)};
        for (OptionHandlerDesc optionHandler : optionHandlers = (OptionHandlerDesc[])config.getEntry(COMPONENT, "optionHandlers", OptionHandlerDesc[].class, (Object)defaultHandlers)) {
            optionMap.put(optionHandler.getName(), optionHandler);
        }
        OptionHandlerDesc[] addOptionHandlers = (OptionHandlerDesc[])config.getEntry(COMPONENT, "addOptionHandlers", OptionHandlerDesc[].class, (Object)new OptionHandlerDesc[0]);
        if (addOptionHandlers.length > 0) {
            StringBuilder sb = logger.isLoggable(Level.CONFIG) ? new StringBuilder("addOptionHandlers") : null;
            for (OptionHandlerDesc optionHandler : addOptionHandlers) {
                optionMap.put(optionHandler.getName(), optionHandler);
                if (sb == null) continue;
                sb.append(StringUtils.NEW_LINE).append("    ").append(optionHandler.toString());
            }
            if (sb != null) {
                logger.config(sb.toString());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void manageInteraction() {
        String prompt = "gs> ";
        BufferedReader br = new BufferedReader(new InputStreamReader(System.in));
        System.out.println("Welcome to the GigaSpaces Interactive Shell Program. You can interact\nwith the GigaSpaces Service Grid using the following commands : \n" + GS.getInteractiveUsage() + "\n\nFor help on any of these commands type help [command].\nTo leave this program type quit or exit\n");
        System.out.print(prompt);
        while (true) {
            try {
                String response;
                String input = br.readLine();
                if (input == null || input.length() <= 0) continue;
                if (input.equals("q") || input.equals("quit") || input.equals("exit")) {
                    try {
                        br.close();
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                    GS.onExit(true);
                    continue;
                }
                if (!input.equals("!!")) {
                    previous = input;
                } else {
                    input = previous;
                }
                String command = input;
                StringTokenizer tok = new StringTokenizer(command);
                if (tok.countTokens() > 0) {
                    command = tok.nextToken();
                }
                FirstParametersWrapper firstParametersParameter = GS.retrieveFirstParameters(input, false);
                if (command.startsWith("-")) {
                    command = firstParametersParameter.getCommand();
                }
                if (!command.equals("login") && firstParametersParameter.isFirstParametersPassed() && firstParametersParameter.isParametersValid()) {
                    String credentialsProvider = firstParametersParameter.getUserDetailsProviderClass();
                    Properties userDetailsProperties = firstParametersParameter.getUserDetailsProperties();
                    if (userDetailsProperties == null) {
                        userDetailsProperties = CredentialsProviderHelper.createLoginProperties((String)firstParametersParameter.getUser(), (String)firstParametersParameter.getPassword());
                    }
                    if (!CLISecurityRepository.getInstance().login(userDetailsProperties, credentialsProvider)) continue;
                }
                if (!GS.validCommand(command)) {
                    if (command.equalsIgnoreCase("-user") || command.equalsIgnoreCase("-password")) continue;
                    System.out.println("? Invalid command");
                    System.out.println(GS.getInteractiveUsage());
                    continue;
                }
                OptionHandler handler = GS.getOptionHandler(command);
                if (firstParametersParameter.isFirstParametersPassed()) {
                    input = input.substring(input.indexOf(command));
                }
                if (handler == null || (response = handler.process(input, br)).length() <= 0) continue;
                System.out.println(response);
                continue;
            }
            catch (IllegalArgumentException e) {
                if (e.getMessage() != null) {
                    System.out.println(e.getMessage());
                    continue;
                }
                System.out.println(e.toString());
                continue;
            }
            catch (Exception e) {
                System.out.println("Command failed. Please see CLI log file for details.");
                if (!logger.isLoggable(Level.SEVERE)) continue;
                logger.log(Level.SEVERE, e.toString(), e);
                continue;
            }
            finally {
                System.out.print(prompt);
                continue;
            }
            break;
        }
    }

    private static FirstParametersWrapper retrieveFirstParametersParameter(String[] commandArgs, boolean isPrintMessages) {
        StringBuilder commandLineBuilder = new StringBuilder();
        for (String arg : commandArgs) {
            commandLineBuilder.append(arg);
            commandLineBuilder.append(" ");
        }
        return GS.retrieveFirstParameters(commandLineBuilder.toString(), isPrintMessages);
    }

    private static FirstParametersWrapper retrieveFirstParameters(String input, boolean isPrintMessages) {
        String[] validOptionsArray = new String[]{"user", "password", "user-details-provider", "user-details-properties"};
        com.gigaspaces.admin.cli.OptionHandler validOptions = new com.gigaspaces.admin.cli.OptionHandler(Formatter.fromArray(validOptionsArray));
        Map<String, String> args = validOptions.getOptions(input, input.startsWith("-"), false);
        String command = args.get("command");
        if (command == null) {
            System.out.println("Command not found");
            System.exit(1);
        }
        command = command.indexOf(" ") < 0 ? command : command.substring(0, command.indexOf(" "));
        return GS.parseLoginParameters(args, command, isPrintMessages);
    }

    public static FirstParametersWrapper parseLoginParameters(Map<String, String> args, String command, boolean isPrintMessages) {
        boolean isUserParamExists = args.containsKey("user");
        boolean isPasswordParamExists = args.containsKey("password");
        boolean isProviderParamExists = args.containsKey("user-details-provider");
        boolean isUserPropertiesParamExists = args.containsKey("user-details-properties");
        String userParam = args.get("user");
        String passwordParam = args.get("password");
        String userDetailsProviderClassParam = args.get("user-details-provider");
        String userDetailsPropertiesStrParam = args.get("user-details-properties");
        Properties userDetailsPropertiesParam = JSpaceUtilities.parsePropertiesParam((String)userDetailsPropertiesStrParam);
        boolean isParametersValid = true;
        if (!(userParam == null && passwordParam == null || userDetailsProviderClassParam == null && userDetailsPropertiesParam == null)) {
            if (isPrintMessages) {
                System.out.println("\nuser and password parameters cannot be used together with user-details-provider and user-details-properties parameters.");
            }
            isParametersValid = false;
        } else if (isUserParamExists && userParam == null || userParam != null && userParam.trim().length() == 0) {
            if (isPrintMessages) {
                System.out.println("\nPlease provide user name.");
            }
            isParametersValid = false;
        } else if (isPasswordParamExists && passwordParam == null) {
            if (isPrintMessages) {
                System.out.println("\nPlease provide password.");
            }
            isParametersValid = false;
        } else if (passwordParam != null && userParam == null) {
            if (isPrintMessages) {
                System.out.println("\nPlease provide user name parameter with appropriate value: -user john_user");
            }
            isParametersValid = false;
        } else if (userParam != null && passwordParam == null) {
            if (isPrintMessages) {
                System.out.println("\nPlease provide password parameter with appropriate value: -password john_password");
            }
            isParametersValid = false;
        } else if (isProviderParamExists && userDetailsProviderClassParam == null) {
            if (isPrintMessages) {
                System.out.println("\nPlease provide user details provider class.");
            }
            isParametersValid = false;
        } else if (isUserPropertiesParamExists && userDetailsPropertiesParam == null) {
            if (isPrintMessages) {
                System.out.println("\nPlease provide user details properties.");
            }
            isParametersValid = false;
        } else if (userDetailsPropertiesParam != null && userDetailsProviderClassParam == null) {
            if (isPrintMessages) {
                System.out.println("\nPlease provide user details provider class parameter with appropriate value: -user-details-provider com.custom.UserDetailsProviderImpl");
            }
            isParametersValid = false;
        }
        boolean isFirstParameterPassed = isUserParamExists || isPasswordParamExists || isProviderParamExists || isUserPropertiesParamExists;
        return new FirstParametersWrapper(command, isParametersValid, isFirstParameterPassed, userParam, passwordParam, userDetailsProviderClassParam, userDetailsPropertiesStrParam, userDetailsPropertiesParam);
    }

    private static Properties getConfiguredSystemProperties() throws ConfigurationException {
        Configuration config = SystemConfig.getInstance().getConfiguration();
        Properties sysProps = new Properties();
        String[] systemProperties = (String[])config.getEntry("com.gigaspaces.start", "systemProperties", String[].class, (Object)new String[0]);
        if (systemProperties.length > 0) {
            if (systemProperties.length % 2 != 0) {
                if (logger.isLoggable(Level.FINE)) {
                    logger.fine("systemProperties elements has odd length : " + systemProperties.length);
                }
            } else {
                for (int i = 0; i < systemProperties.length; i += 2) {
                    String name = systemProperties[i];
                    String value = systemProperties[i + 1];
                    sysProps.setProperty(name, value);
                }
            }
        }
        return sysProps;
    }

    public static void initSettings(String[] groups, LookupLocator[] locators) throws ConfigurationException {
        settings.put(GROUPS, groups);
        settings.put(LOCATORS, locators);
        Properties props = Locator.deriveDirectories();
        props.put("java.protocol.handler.pkgs", "net.jini.url");
        Properties addedProps = GS.getConfiguredSystemProperties();
        props.putAll((Map<?, ?>)addedProps);
        Properties sysProps = System.getProperties();
        sysProps.putAll((Map<?, ?>)props);
        System.setProperties(sysProps);
        settings.put(SYS_PROPS, props);
        settings.put(DISCOVERY_TIMEOUT, 5000L);
        settings.put(DEPLOY_BLOCK, Boolean.TRUE);
        settings.put(DEPLOY_WAIT, 5000L);
        if (homeDir == null) {
            homeDir = System.getProperty("user.dir");
        }
        currentDir = new File(homeDir);
        if (!commandLine) {
            String[] localCommandArgLine = CLIUtilities.getArgLineWithScreenPassword(commandArgLine);
            logger.info("\n" + GS.getStartupMessage(localCommandArgLine));
            System.out.println(GS.getStartupMessage(null) + "\n");
            if (addedProps.size() > 0) {
                StringBuilder buff = new StringBuilder();
                for (Map.Entry<Object, Object> mapEntry : addedProps.entrySet()) {
                    String key = (String)mapEntry.getKey();
                    String value = (String)mapEntry.getValue();
                    buff.append('\n');
                    buff.append("    ").append(key).append('=').append(value);
                }
                if (logger.isLoggable(Level.CONFIG)) {
                    logger.config("Added System Properties {" + buff.toString() + "\n}");
                }
            }
        }
    }

    private static String getStartupMessage(String[] commandLine) {
        String newline = System.lineSeparator();
        String separator = "**********************************************************************";
        String docsBaseUrl = PlatformVersion.getProductHelpUrl();
        StringBuilder sb = new StringBuilder();
        sb.append(separator).append(newline);
        if (commandLine != null) {
            sb.append("GigaSpaces Interactive Shell Program using command <" + Arrays.toString(commandLine) + ">").append(newline);
            sb.append("Log created by <" + System.getProperty("user.name") + "> on " + new Date().toString()).append(newline);
        }
        sb.append("This legacy CLI is deprecated and will be removed in the future.").append(newline);
        sb.append("Use the new command line interface (called 'xap') instead.").append(newline);
        sb.append("For more information:").append(newline);
        sb.append("   * Run 'xap --help'").append(newline);
        sb.append("   * " + docsBaseUrl + "/admin/tools-cli.html").append(newline);
        sb.append("   * " + docsBaseUrl + "/admin/upgrading-cli.html").append(newline);
        sb.append(separator);
        return sb.toString();
    }

    public static synchronized ServiceFinder getServiceFinder() {
        block3: {
            if (finder == null) {
                String[] groups = LookupGroups.all();
                try {
                    finder = new ServiceFinder(groups, null);
                }
                catch (Exception e) {
                    if (!logger.isLoggable(Level.SEVERE)) break block3;
                    logger.log(Level.SEVERE, e.toString(), e);
                }
            }
        }
        return finder;
    }

    public static void main(String[] args) {
        if (logger == null) {
            Handler[] handlers;
            GSLogConfigLoader.getLoader((String)"cli");
            logger = Logger.getLogger(COMPONENT);
            Logger rootLogger = Logger.getLogger("");
            for (Handler handler : handlers = rootLogger.getHandlers()) {
                if (!handler.getClass().getName().endsWith("ConsoleHandler")) continue;
                rootLogger.removeHandler(handler);
                break;
            }
        }
        boolean isTimeoutPassed = false;
        LinkedList<String> commandArgs = new LinkedList<String>();
        try {
            for (int i = 0; i < args.length; ++i) {
                commandArgs.add(args[i]);
            }
            String timeoutParamater = "-initialization-timeout";
            int timeoutIndex = commandArgs.indexOf(timeoutParamater);
            if (timeoutIndex > 0) {
                if (timeoutIndex == commandArgs.size() - 1) {
                    System.out.println("Value for initialization timeout ( in milliseconds ) must be provided.");
                    return;
                }
                String strTimeoutVal = (String)commandArgs.get(timeoutIndex + 1);
                try {
                    timeout = Integer.parseInt(strTimeoutVal);
                    isTimeoutPassed = true;
                }
                catch (NumberFormatException nfe) {
                    System.out.println("Value provided for timeout is not a valid number. Initialization timeout ( in milliseconds ) must be provided as a valid number.");
                    return;
                }
                commandArgs.remove(timeoutIndex + 1);
                commandArgs.remove(timeoutIndex);
            }
            if (args.length >= 1) {
                boolean createConfig = false;
                if (args[0].endsWith(".config") || args[0].endsWith(".xml")) {
                    createConfig = true;
                    commandArgs.removeFirst();
                    if (args.length > 1 && args[1].endsWith(".xml")) {
                        overrideFile = args[1];
                        commandArgs.removeFirst();
                    }
                }
                if (createConfig) {
                    sysConfig = overrideFile != null ? SystemConfig.getInstance((String[])new String[]{args[0], overrideFile}) : SystemConfig.getInstance((String[])new String[]{args[0]});
                }
            }
            String homeDir = null;
            for (int i = 0; i < args.length; ++i) {
                if (!args[i].startsWith("homeDir")) continue;
                String[] values = args[i].split("=");
                homeDir = values[1].trim();
                commandArgs.remove(args[i]);
            }
            args = commandArgs.toArray(new String[commandArgs.size()]);
            commandArgLine = args;
            if (sysConfig == null) {
                sysConfig = SystemConfig.getInstance((String[])new String[0]);
            }
            Configuration config = sysConfig.getConfiguration();
            String[] groups = LookupGroups.all();
            String systemGroups = SystemInfo.singleton().lookup().groups();
            try {
                groups = (String[])config.getEntry("com.gigaspaces.admin", GROUPS, String[].class, (Object)BootUtil.toArray((String)systemGroups));
            }
            catch (ConfigurationException e) {
                logger.log(Level.INFO, "Groups Not Set.  Defaulting to ALL_GROUPS.");
            }
            if (systemGroups == null) {
                StringBuilder groupBuffer = new StringBuilder();
                if (groups != null) {
                    for (int i = 0; i < groups.length; ++i) {
                        String group = groups[i];
                        if (i > 0) {
                            groupBuffer.append(',');
                        }
                        groupBuffer.append(group);
                    }
                }
                SystemInfo.singleton().lookup().setGroups(groupBuffer.toString());
            }
            LookupLocator[] locators = new LookupLocator[]{};
            try {
                locators = (LookupLocator[])config.getEntry("com.gigaspaces.admin", LOCATORS, LookupLocator[].class, (Object)BootUtil.toLookupLocators((String)System.getProperty("com.gs.jini_lus.locators", "")));
            }
            catch (ConfigurationException e) {
                logger.log(Level.INFO, "Locators Not Set");
            }
            commandLine = false;
            GS.initSettings(groups, locators);
            if (homeDir != null && DirHandler.changeDir(homeDir, false)) {
                GS.homeDir = currentDir.getCanonicalPath();
            }
            boolean initLookup = true;
            if (args.length > 0 && args[0].equals("version")) {
                initLookup = false;
                timeout = 0;
            }
            if (initLookup) {
                finder = new ServiceFinder(groups, locators);
                provisionNotifier = new ServiceProvisionNotification(sysConfig.getConfiguration());
            }
            InetAddress inetAddress = SystemInfo.singleton().network().getHost();
            hostName = inetAddress.getHostName();
            hostAddress = inetAddress.getHostAddress();
            GS.loadOptionHandlers(sysConfig.getConfiguration());
        }
        catch (Exception e) {
            if (logger.isLoggable(Level.SEVERE)) {
                logger.log(Level.SEVERE, e.toString(), e);
            }
            System.exit(1);
        }
        if (args.length > 0 || isTimeoutPassed) {
            try {
                Thread.sleep(timeout);
            }
            catch (InterruptedException e) {
                // empty catch block
            }
        }
        OptionHandler handler = null;
        if (args.length == 0) {
            GS.manageInteraction();
        } else {
            FirstParametersWrapper firstParametersParameter = GS.retrieveFirstParametersParameter(args, true);
            if (GS.validCommand(args[0]) || firstParametersParameter != null && firstParametersParameter.isParametersValid()) {
                if (!firstParametersParameter.isFirstParametersPassed()) {
                    handler = GS.getOptionHandler(args[0]);
                } else {
                    String command = firstParametersParameter.getCommand();
                    if (command.trim().length() == 0) {
                        command = "login";
                    }
                    handler = GS.getOptionHandler(command);
                }
                if (handler != null) {
                    BufferedReader br = new BufferedReader(new InputStreamReader(System.in));
                    boolean isPerformLoginOnly = false;
                    if (firstParametersParameter.isFirstParametersPassed() && firstParametersParameter.isParametersValid()) {
                        String command = firstParametersParameter.getCommand();
                        if (command.trim().length() == 0) {
                            isPerformLoginOnly = true;
                        } else {
                            String[] argsArray;
                            OptionHandler loginHandler = GS.getOptionHandler("login");
                            for (String arg : argsArray = GS.createLoginParameters(firstParametersParameter)) {
                                commandArgs.remove(arg);
                            }
                            String response = loginHandler.process(Formatter.fromArray(argsArray, " "), br);
                            if (response.length() > 0) {
                                System.out.println(response);
                            }
                        }
                    }
                    String[] argsArray = new String[commandArgs.size()];
                    commandArgs.toArray(argsArray);
                    String response = handler.process(Formatter.fromArray(argsArray, " "), br);
                    if (response.length() > 0) {
                        System.out.println(response);
                    }
                    if (isPerformLoginOnly) {
                        GS.manageInteraction();
                    }
                }
            } else {
                GS.printUsage();
            }
            if (handler instanceof Login) {
                GS.manageInteraction();
            }
            GS.onExit(false);
        }
    }

    private static String[] createLoginParameters(FirstParametersWrapper firstParametersParameter) {
        ArrayList<String> loginParams = new ArrayList<String>(4);
        if (firstParametersParameter.getUser() != null) {
            loginParams.add("-user");
            loginParams.add(firstParametersParameter.getUser());
        }
        if (firstParametersParameter.getPassword() != null) {
            loginParams.add("-password");
            loginParams.add(firstParametersParameter.getPassword());
        }
        if (firstParametersParameter.getUserDetailsProviderClass() != null) {
            loginParams.add("-user-details-provider");
            loginParams.add(firstParametersParameter.getUserDetailsProviderClass());
        }
        if (firstParametersParameter.getUserDetailsProperties() != null) {
            loginParams.add("-user-details-properties");
            loginParams.add(firstParametersParameter.getUserDetailsPropertiesStr());
        }
        String[] argsArray = loginParams.toArray(new String[loginParams.size()]);
        return argsArray;
    }

    static {
        commandLine = true;
        settings = new HashMap<String, Object>();
        optionMap = new HashMap<String, OptionHandlerDesc>();
        previous = "";
        timeout = 10000;
    }

    private static class VersionHandler
    implements OptionHandler {
        @Override
        public String process(String input, BufferedReader br) {
            StringTokenizer tok = new StringTokenizer(input);
            switch (tok.countTokens()) {
                case 0: {
                    return this.getUsage();
                }
                case 1: {
                    return PlatformVersion.getOfficialVersion();
                }
                case 2: {
                    tok.nextToken();
                    String option = tok.nextToken();
                    if (option.equals("-verbose")) {
                        return RuntimeInfo.getEnvironmentInfo((boolean)true);
                    }
                    return this.getUsage();
                }
            }
            return this.getUsage();
        }

        @Override
        public String getUsage() {
            return "usage: version [-verbose]";
        }
    }

    private static class JConsoleHandler
    implements OptionHandler,
    Constants {
        private final com.gigaspaces.admin.cli.OptionHandler validOptions;
        private static final String OPERATION_NAME = "jconsole";

        public JConsoleHandler() {
            String[] validOptionsArray = new String[]{"h", "help"};
            this.validOptions = new com.gigaspaces.admin.cli.OptionHandler(Formatter.fromArray(validOptionsArray));
        }

        @Override
        public String process(String input, BufferedReader br) {
            try {
                StringTokenizer tok = new StringTokenizer(input);
                String jmxServiceURL = null;
                ServiceItem serviceItem = null;
                boolean isJmxRemotePortDefined = false;
                Map<String, String> args = this.validOptions.getOptions(input, true);
                if (args.containsKey("h") || args.containsKey("help")) {
                    return this.getUsage();
                }
                int count = tok.countTokens();
                ArrayList<String> argsList = new ArrayList<String>(count);
                for (int i = 0; i < count; ++i) {
                    String token = tok.nextToken();
                    argsList.add(token);
                }
                if (argsList.size() == 1) {
                    ServiceItem[] items = finder.find(null, new Entry[]{new JMXConnection()});
                    if (items.length == 0) {
                        return "No service instances with a JMXConnection entry discovered.\nTry " + this.getUsage();
                    }
                    if (items.length == 1) {
                        jmxServiceURL = JSpaceUtilities.getJMXConnectionUrl((ServiceItem)items[0]);
                        isJmxRemotePortDefined = JSpaceUtilities.isJMXRemotePortDefined((ServiceItem)items[0]);
                        serviceItem = items[0];
                    } else {
                        if (br == null) {
                            br = new BufferedReader(new InputStreamReader(System.in));
                        }
                        System.out.println(Formatter.asList(items) + "\n");
                        this.printRequest();
                        block7: while (true) {
                            try {
                                while (true) {
                                    String response;
                                    if ((response = br.readLine()) == null) {
                                        continue;
                                    }
                                    if (response.equals("c")) break block7;
                                    try {
                                        int num = Integer.parseInt(response);
                                        if (num < 1 || num > items.length + 1) {
                                            this.printRequest();
                                            continue block7;
                                        }
                                        serviceItem = items[num - 1];
                                        jmxServiceURL = JSpaceUtilities.getJMXConnectionUrl((ServiceItem)serviceItem);
                                        isJmxRemotePortDefined = JSpaceUtilities.isJMXRemotePortDefined((ServiceItem)serviceItem);
                                        break block7;
                                    }
                                    catch (NumberFormatException e) {
                                        System.out.println("Invalid choice [" + response + "]");
                                        this.printRequest();
                                        continue;
                                    }
                                    break;
                                }
                            }
                            catch (IOException e) {
                                if (!logger.isLoggable(Level.SEVERE)) continue;
                                logger.log(Level.SEVERE, e.toString(), e);
                                continue;
                            }
                            break;
                        }
                    }
                    if (jmxServiceURL != null) {
                        Object service;
                        Object object = service = serviceItem == null ? null : serviceItem.getService();
                        if (service instanceof SecuredService && !CLISecurityUtils.hasPermittedPermission((SecuredService)service, serviceItem.serviceID, (Privilege)MonitorAuthority.MonitorPrivilege.MONITOR_JVM, ((SecuredService)service).isServiceSecured())) {
                            return "You do not have the <" + MonitorAuthority.MonitorPrivilege.MONITOR_JVM + "> permission which is required to run jconsole.\n";
                        }
                        this.execJConsole(jmxServiceURL, !isJmxRemotePortDefined);
                        return this.onSuccess();
                    }
                    return "Command failed, no JMXConnection entry\n";
                }
                if (argsList.size() > 1) {
                    jmxServiceURL = (String)argsList.get(1);
                    this.execJConsole(jmxServiceURL, !isJmxRemotePortDefined);
                    return this.onSuccess();
                }
                return this.getUsage();
            }
            catch (IOException e) {
                System.out.println("Command failed, " + e.getClass().getName() + ": " + e.getLocalizedMessage());
                return "";
            }
        }

        private String onSuccess() {
            return "Launching jconsole, command successful\n";
        }

        private void execJConsole(String jmxServiceURL, boolean useParameters) throws IOException {
            String[] commandArray = JConsoleUtilities.createJConsoleCommand((String)jmxServiceURL, null, (boolean)true, (boolean)useParameters);
            Runtime.getRuntime().exec(commandArray);
        }

        private void printRequest() {
            System.out.print("Choose a service for jconsole support or \"c\" to cancel : ");
        }

        @Override
        public String getUsage() {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("usage: ");
            stringBuilder.append(OPERATION_NAME);
            stringBuilder.append(" [jmx-connection-string]");
            stringBuilder.append(", options:\n");
            stringBuilder.append("\t-h/-help    prints help\n");
            stringBuilder.append("\nFor example:\n");
            stringBuilder.append("\tjconsole");
            stringBuilder.append(" service:jmx:rmi:///jndi/rmi://192.10.10.10:10098/jmxrmi");
            return stringBuilder.toString();
        }
    }

    private static class StatsHandler
    implements OptionHandler {
        @Override
        public String process(String input, BufferedReader br) {
            int i;
            long currentTime = System.currentTimeMillis();
            System.out.println();
            System.out.println("GigaSpaces version : " + PlatformVersion.getOfficialVersion());
            System.out.println("User : " + System.getProperty("user.name"));
            System.out.println("Home directory : " + homeDir);
            System.out.println("Login time : " + new Date(startTime).toString());
            System.out.println("Time logged in : " + TimeUtil.format((long)(currentTime - startTime)));
            ReggieStat[] rStats = finder.getReggieStats(0);
            System.out.println("Lookup Service Discovery Statistics");
            if (rStats.length == 0) {
                System.out.println("\tNo lookup services discovered");
            }
            for (i = 0; i < rStats.length; ++i) {
                long baseTime = rStats[i].getBaseTime() == 0L ? startTime : rStats[i].getBaseTime();
                long t = (rStats[i].getEventTime() - baseTime) / 1000L;
                System.out.println("\t" + rStats[i].getMachine() + "\t" + Formatter.fromArray(rStats[i].getGroups()) + "\t" + t + " secs");
            }
            rStats = finder.getReggieStats(1);
            System.out.println("Lookup Service Discarded Statistics");
            if (rStats.length == 0) {
                System.out.println("\tNo lookup services discarded");
            }
            for (i = 0; i < rStats.length; ++i) {
                System.out.println("\t" + rStats[i].getMachine() + "\t" + Formatter.fromArray(rStats[i].getGroups()) + "\t" + new Date(rStats[i].getEventTime()).toString());
            }
            System.out.println("Service Information Statistics");
            Map<Thread, ServiceFinder.InfoFetchStat> poolables = finder.getPoolables();
            if (poolables.isEmpty()) {
                System.out.println("\tNo pending information requests");
            } else {
                System.out.println("\tNum pending : " + poolables.size());
                int i2 = 1;
                for (ServiceFinder.InfoFetchStat ifs : poolables.values()) {
                    long pending = currentTime - ifs.starTime;
                    System.out.println("\t  [" + i2 + "] " + ifs.name + " blocked : " + TimeUtil.format((long)pending));
                    ++i2;
                }
            }
            return "";
        }

        @Override
        public String getUsage() {
            return "usage: stats";
        }
    }

    private static class SettingsHandler
    implements OptionHandler {
        @Override
        public String process(String input, BufferedReader br) {
            StringBuilder buffer = new StringBuilder();
            StringTokenizer tok = new StringTokenizer(input);
            if (tok.countTokens() > 1) {
                while (tok.hasMoreTokens()) {
                    long l;
                    String timeout;
                    String token = tok.nextToken();
                    if (token.equals("set")) continue;
                    if (!tok.hasMoreTokens()) {
                        System.out.println("You must specify a value for " + token);
                        break;
                    }
                    if (token.equals(GS.DEPLOY_BLOCK)) {
                        String block = tok.nextToken();
                        if (block.equalsIgnoreCase("true") || block.equalsIgnoreCase("yes")) {
                            settings.put(GS.DEPLOY_BLOCK, Boolean.TRUE);
                            continue;
                        }
                        settings.put(GS.DEPLOY_BLOCK, Boolean.FALSE);
                        continue;
                    }
                    if (token.equals(GS.DEPLOY_WAIT)) {
                        timeout = tok.nextToken();
                        try {
                            l = Long.parseLong(timeout);
                            settings.put(GS.DEPLOY_WAIT, l);
                            settings.put(GS.DEPLOY_BLOCK, Boolean.FALSE);
                            continue;
                        }
                        catch (NumberFormatException e) {
                            return "Invalid deploy-wait " + timeout;
                        }
                    }
                    if (token.equals(GS.GROUPS)) {
                        DiscoveryManagement dMgr;
                        String value = tok.nextToken();
                        if (value.equalsIgnoreCase("all_groups")) {
                            settings.put(GS.GROUPS, LookupGroups.all());
                        } else {
                            settings.put(GS.GROUPS, Formatter.toArray(value));
                        }
                        if (!((dMgr = finder.getDiscoveryManagement()) instanceof DiscoveryGroupManagement)) continue;
                        try {
                            ((DiscoveryGroupManagement)dMgr).setGroups(Formatter.toArray(value));
                        }
                        catch (Throwable t) {
                            System.out.println("Exception setting groups : " + t.getMessage());
                        }
                        continue;
                    }
                    if (token.equals(GS.LOCATORS)) {
                        String locator = tok.nextToken();
                        DiscoveryManagement dMgr = finder.getDiscoveryManagement();
                        if (!(dMgr instanceof DiscoveryLocatorManagement)) continue;
                        if (locator.equalsIgnoreCase("null")) {
                            ((DiscoveryLocatorManagement)dMgr).setLocators(new LookupLocator[0]);
                            continue;
                        }
                        try {
                            ((DiscoveryLocatorManagement)dMgr).addLocators(new LookupLocator[]{new LookupLocator(locator)});
                        }
                        catch (MalformedURLException e) {
                            System.out.println("Bad locator format");
                        }
                        continue;
                    }
                    if (token.equals(GS.SYS_PROPS)) {
                        String property = tok.nextToken();
                        StringTokenizer tok1 = new StringTokenizer(property, "= ");
                        if (tok1.countTokens() < 2) {
                            return "Invalid system property definition " + property;
                        }
                        String name = tok1.nextToken();
                        String value = tok1.nextToken();
                        Properties props = (Properties)settings.get(GS.SYS_PROPS);
                        props.put(name, value);
                        System.setProperty(name, value);
                        settings.put(GS.SYS_PROPS, props);
                        continue;
                    }
                    if (token.equals(GS.DISCOVERY_TIMEOUT)) {
                        timeout = tok.nextToken();
                        try {
                            l = Long.parseLong(timeout);
                            settings.put(GS.DISCOVERY_TIMEOUT, l);
                            continue;
                        }
                        catch (NumberFormatException e) {
                            return "Invalid discovery-timeout " + timeout;
                        }
                    }
                    System.out.println("Invalid property " + token);
                }
            } else {
                int i;
                String[] groups = (String[])settings.get(GS.GROUPS);
                if (groups == LookupGroups.all()) {
                    groups = new String[]{"ALL_GROUPS"};
                }
                buffer.append(GS.GROUPS).append("\t\t").append(Formatter.fromArray(groups));
                buffer.append('\n');
                DiscoveryManagement dMgr = finder.getDiscoveryManagement();
                LookupLocator[] locators = null;
                if (dMgr instanceof DiscoveryLocatorManagement) {
                    locators = ((DiscoveryLocatorManagement)dMgr).getLocators();
                }
                String sLocators = null;
                if (locators != null) {
                    String[] sLocs = new String[locators.length];
                    for (i = 0; i < sLocs.length; ++i) {
                        sLocs[i] = locators[i].toString();
                    }
                    sLocators = Formatter.fromArray(sLocs);
                }
                buffer.append(GS.LOCATORS).append('\t').append(sLocators);
                Properties props = (Properties)settings.get(GS.SYS_PROPS);
                buffer.append('\n');
                i = 0;
                Enumeration<Object> en = props.keys();
                while (en.hasMoreElements()) {
                    String key = (String)en.nextElement();
                    String value = props.getProperty(key);
                    if (i == 0) {
                        buffer.append(GS.SYS_PROPS).append('\t').append(key).append('=').append(value);
                    } else {
                        buffer.append("\t\t").append(key).append('=').append(value);
                    }
                    buffer.append('\n');
                    ++i;
                }
                buffer.append("disco-timeout\t" + settings.get(GS.DISCOVERY_TIMEOUT));
                buffer.append("\n");
                buffer.append("wait-on-deploy\t" + settings.get(GS.DEPLOY_BLOCK));
                buffer.append("\n");
                buffer.append("deploy-timeout\t" + settings.get(GS.DEPLOY_WAIT));
            }
            return buffer.toString();
        }

        @Override
        public String getUsage() {
            return "usage: set [groups | locators | system-props | disco-timeout| wait-on-deploy | deploy-timeout]\n";
        }
    }

    private static class HelpHandler
    implements OptionHandler {
        @Override
        public String process(String input, BufferedReader br) {
            StringTokenizer tok = new StringTokenizer(input);
            if (tok.countTokens() > 1) {
                tok.nextToken();
                String option = tok.nextToken();
                if (option.equals("quit")) {
                    return "usage: quit\n";
                }
                if (option.equals("exit")) {
                    return "usage: exit\n";
                }
                if (option.equals("?")) {
                    return "usage: ?\n";
                }
                if (option.equals("ls")) {
                    return "usage: ls [-l]\n";
                }
                if (option.equals("cd")) {
                    return "usage: cd [directory-name]\n";
                }
                if (option.equals("pwd")) {
                    return "usage: pwd\n";
                }
                OptionHandler handler = GS.getOptionHandler(option);
                if (handler != null) {
                    return handler.getUsage();
                }
                return "unknown handler for " + option + "\n";
            }
            return GS.getInteractiveUsage();
        }

        @Override
        public String getUsage() {
            return "usage: help [command]\n";
        }
    }

    public static interface OptionHandler {
        public String process(String var1, BufferedReader var2);

        public String getUsage();
    }

    static class FirstParametersWrapper {
        private final boolean _isParametersValid;
        private final boolean _isFirstParametersPassed;
        private final String _user;
        private final String _password;
        private final String _userDetailsProviderClass;
        private final String _userDetailsPropertiesStr;
        private final Properties _userDetailsProperties;
        private final String _command;

        private FirstParametersWrapper(String command, boolean isParametersValid, boolean isFirstParametersPassed, String user, String password, String userDetailsProviderClass, String userDetailsPropertiesStr, Properties userDetailsProperties) {
            this._command = command;
            this._isParametersValid = isParametersValid;
            this._isFirstParametersPassed = isFirstParametersPassed;
            this._user = user;
            this._password = password;
            this._userDetailsProviderClass = userDetailsProviderClass;
            this._userDetailsPropertiesStr = userDetailsPropertiesStr;
            this._userDetailsProperties = userDetailsProperties;
        }

        public String getCommand() {
            return this._command;
        }

        public boolean isParametersValid() {
            return this._isParametersValid;
        }

        public boolean isFirstParametersPassed() {
            return this._isFirstParametersPassed;
        }

        public String getUser() {
            return this._user;
        }

        public String getPassword() {
            return this._password;
        }

        public String getUserDetailsProviderClass() {
            return this._userDetailsProviderClass;
        }

        public Properties getUserDetailsProperties() {
            return this._userDetailsProperties;
        }

        public String getUserDetailsPropertiesStr() {
            return this._userDetailsPropertiesStr;
        }
    }

    public static class OptionHandlerDesc {
        private final String name;
        private final Class<OptionHandler> optionHandlerClass;

        public OptionHandlerDesc(String name, Class<?> optionHandlerClass) {
            if (name == null) {
                throw new IllegalArgumentException("name is null");
            }
            this.name = name;
            if (optionHandlerClass == null) {
                throw new IllegalArgumentException("optionHandlerClass is null");
            }
            this.optionHandlerClass = optionHandlerClass;
        }

        public String getName() {
            return this.name;
        }

        public OptionHandler getOptionHandler() {
            OptionHandler oh = null;
            try {
                oh = this.optionHandlerClass.newInstance();
            }
            catch (Exception e) {
                if (logger.isLoggable(Level.SEVERE)) {
                    logger.log(Level.SEVERE, e.toString(), e);
                }
                System.out.println("Exception [" + e.getClass().getName() + "] creating " + this.optionHandlerClass);
            }
            return oh;
        }

        public String toString() {
            return "name=" + this.name + ", OptionHandler=" + this.optionHandlerClass;
        }
    }
}

