/*
 * Decompiled with CFR 0.152.
 */
package com.gigaspaces.admin.cli;

import com.gigaspaces.admin.cli.Constants;
import com.gigaspaces.admin.cli.GS;
import com.gigaspaces.admin.cli.GSAShutdown;
import com.gigaspaces.admin.cli.StartGSCAgent;
import com.gigaspaces.admin.cli.StartGSMAgent;
import com.gigaspaces.admin.cli.StartLookupAgent;
import com.gigaspaces.logger.GSLogConfigLoader;
import java.io.BufferedReader;
import java.util.HashMap;
import java.util.Map;
import java.util.StringTokenizer;

public class GSAHandler
implements GS.OptionHandler,
Constants {
    public static final String OPERATION_NAME = "gsa";
    private static final Map<String, GS.OptionHandler> handlresMap = new HashMap<String, GS.OptionHandler>();

    @Override
    public String process(String input, BufferedReader br) {
        StringTokenizer tok = new StringTokenizer(input);
        tok.nextToken();
        if (!tok.hasMoreTokens()) {
            return this.getUsage();
        }
        String value = tok.nextToken();
        GS.OptionHandler handler = handlresMap.get(value);
        if (handler == null) {
            System.out.println("Unknown option : " + value);
            return this.getUsage();
        }
        String args = "";
        while (tok.hasMoreTokens()) {
            args = args + tok.nextToken() + " ";
        }
        return handler.process(args, br);
    }

    @Override
    public String getUsage() {
        StringBuffer strBuffer = new StringBuffer();
        strBuffer.append("usage: gsa command [options]\n");
        strBuffer.append("\nAvailable commands (select a single command):");
        strBuffer.append("\n\t");
        strBuffer.append("gsa shutdown | ");
        strBuffer.append("gsa start-gsm | ");
        strBuffer.append("gsa start-gsc | ");
        strBuffer.append("gsa start-lookup");
        strBuffer.append("\n");
        strBuffer.append("options:");
        strBuffer.append("\n\t-h/-help");
        return strBuffer.toString();
    }

    static {
        handlresMap.put("shutdown", new GSAShutdown());
        handlresMap.put("start-gsm", new StartGSMAgent());
        handlresMap.put("start-gsc", new StartGSCAgent());
        handlresMap.put("start-lookup", new StartLookupAgent());
        GSLogConfigLoader.getLoader();
    }
}

