/*
 * Decompiled with CFR 0.152.
 */
package com.gigaspaces.admin.cli;

import com.gigaspaces.admin.cli.AbstractGSACommand;
import com.gigaspaces.admin.cli.CLIUtilities;
import com.gigaspaces.admin.cli.Formatter;
import com.gigaspaces.admin.cli.GS;
import com.gigaspaces.admin.cli.OptionHandler;
import com.gigaspaces.grid.gsa.GSA;
import com.gigaspaces.security.AuthenticationException;
import com.j_spaces.kernel.JSpaceUtilities;
import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.nio.channels.ClosedChannelException;
import java.rmi.RemoteException;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.logging.Level;
import net.jini.core.lookup.ServiceItem;

public class GSAShutdown
extends AbstractGSACommand {
    protected static final String OPERATION_NAME = "shutdown";
    private static String[] validOptionsArray = new String[]{"h", "help", "host"};

    public GSAShutdown() {
        super(new OptionHandler(Formatter.fromArray(validOptionsArray)), OPERATION_NAME);
    }

    @Override
    public String process(String input, BufferedReader br) {
        ServiceItem[] selectedFromListGSAServiceItems;
        StringTokenizer tok = new StringTokenizer(input);
        Map<String, String> args = null;
        try {
            args = this.validOptions.getOptions(input, true);
        }
        catch (IllegalArgumentException e) {
            if (e.getMessage() != null) {
                System.out.println(e.getMessage());
            } else {
                System.out.println(e.toString());
            }
            System.out.println(this.getUsage());
            return "";
        }
        if (args.containsKey("h") || args.containsKey("help")) {
            return this.getUsage();
        }
        String hostName = null;
        if (args.containsKey("host") && JSpaceUtilities.isEmpty((String)(hostName = args.get("host")), (boolean)true)) {
            CLIUtilities.printMissingValueMessage("host");
            return "";
        }
        for (ServiceItem gsaServiceItem : selectedFromListGSAServiceItems = this.getSelectedFromListGSAServices(br, hostName)) {
            try {
                GSA gsa = (GSA)gsaServiceItem.getService();
                long pid = gsa.getJVMDetails().getPid();
                System.out.print("Shutting down of gsa[" + pid + "]...");
                gsa.shutdown();
                System.out.println(" completed");
            }
            catch (AuthenticationException ae) {
                System.out.println("failed due:" + ae.toString());
            }
            catch (RemoteException re) {
                if (JSpaceUtilities.getCauseExceptionFromHierarchy((Exception)re, ClosedChannelException.class) == null && GS.getServiceFinder().lookupServiceItem(gsaServiceItem.serviceID) != null) {
                    System.out.println(" failed. Please see CLI log file for details.");
                    if (!_logger.isLoggable(Level.SEVERE)) continue;
                    _logger.log(Level.SEVERE, re.toString(), re);
                    continue;
                }
                System.out.println(" completed");
            }
        }
        return "";
    }

    private ServiceItem[] getSelectedFromListGSAServices(BufferedReader br, String hostName) {
        ServiceItem[] gsaServiceItems;
        if (br == null) {
            br = new BufferedReader(new InputStreamReader(System.in));
        }
        String[] machines = null;
        if (hostName != null) {
            machines = new String[]{hostName};
        }
        if ((gsaServiceItems = GS.getServiceFinder().findGSAs(machines, null)).length == 0) {
            System.out.println("No GSA instances discovered\n");
            return new ServiceItem[0];
        }
        ServiceItem[] selectedItems = Formatter.selectItems(gsaServiceItems, this.getPrompt(this.operationName), br, -1);
        if (selectedItems == null || selectedItems.length == 0) {
            return new ServiceItem[0];
        }
        return selectedItems;
    }

    @Override
    public String getUsage() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("usage: gsa shutdown\n");
        stringBuilder.append("Options:\n");
        stringBuilder.append("\t-h/-help\tprints help\n");
        stringBuilder.append("\t-host\t\thost name, optional parameter, allows to locate gsa that is running on specific machine\n");
        stringBuilder.append("Usage example:\n");
        stringBuilder.append("\tusage: gsa shutdown -host host_name\n");
        stringBuilder.append("\n*****************************************************\n");
        return stringBuilder.toString();
    }

    private String getPrompt(String command) {
        return "Enter a comma-separated list to gsa " + command + " or \"" + "c" + "\" to cancel : ";
    }
}

