/*
 * Decompiled with CFR 0.152.
 */
package com.gigaspaces.admin.cli;

import com.gigaspaces.admin.cli.Constants;
import com.gigaspaces.admin.cli.Formatter;
import com.gigaspaces.admin.cli.GS;
import com.gigaspaces.admin.cli.OptionHandler;
import com.gigaspaces.security.SecurityException;
import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.util.LinkedList;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.jini.core.lookup.ServiceItem;
import org.jini.rio.core.OperationalString;
import org.jini.rio.core.OperationalStringManager;
import org.jini.rio.monitor.DeployAdmin;
import org.jini.rio.monitor.ProvisionMonitor;

public class GSMControl {
    private static final Logger _logger = Logger.getLogger("com.gigaspaces.admin.cli");

    static DeployAdmin findDeployAdmin(ServiceItem[] items, String opstringName) {
        DeployAdmin primary;
        block7: {
            DeployAdmin deployAdmin;
            ProvisionMonitor provisionMonitor;
            primary = null;
            LinkedList<ServiceItem> filteredServiceItemsList = new LinkedList<ServiceItem>();
            for (int i = 0; i < items.length; ++i) {
                try {
                    provisionMonitor = (ProvisionMonitor)items[i].getService();
                    deployAdmin = (DeployAdmin)provisionMonitor.getAdmin();
                    OperationalStringManager[] opMgrs = deployAdmin.getOperationalStringManagers();
                    for (int j = 0; j < opMgrs.length; ++j) {
                        OperationalString opString = opMgrs[j].getOperationalString();
                        if (!opString.getName().equals(opstringName) || !opMgrs[j].isManaging()) continue;
                        filteredServiceItemsList.add(items[i]);
                    }
                    continue;
                }
                catch (Exception e) {
                    if (!_logger.isLoggable(Level.SEVERE)) continue;
                    _logger.log(Level.SEVERE, e.toString(), e);
                }
            }
            ServiceItem[] filteredServiceItemsArray = new ServiceItem[filteredServiceItemsList.size()];
            filteredServiceItemsList.toArray(filteredServiceItemsArray);
            if (filteredServiceItemsArray.length > 0) {
                try {
                    provisionMonitor = (ProvisionMonitor)filteredServiceItemsArray[0].getService();
                    primary = deployAdmin = (DeployAdmin)provisionMonitor.getAdmin();
                }
                catch (Exception e) {
                    if (!_logger.isLoggable(Level.SEVERE)) break block7;
                    _logger.log(Level.SEVERE, e.toString(), e);
                }
            }
        }
        return primary;
    }

    static OperationalStringManager findOperationalStringManager(ServiceItem[] items, OperationalString deploy) {
        OperationalStringManager primary = null;
        block2: for (int i = 0; i < items.length; ++i) {
            try {
                DeployAdmin deployAdmin = (DeployAdmin)((ProvisionMonitor)items[i].getService()).getAdmin();
                OperationalStringManager[] opMgrs = deployAdmin.getOperationalStringManagers();
                for (int j = 0; j < opMgrs.length; ++j) {
                    OperationalString opString = opMgrs[j].getOperationalString();
                    if (!opString.getName().equals(deploy.getName()) || !opMgrs[j].isManaging()) continue;
                    primary = opMgrs[j];
                    continue block2;
                }
                continue;
            }
            catch (Exception e) {
                if (!_logger.isLoggable(Level.SEVERE)) continue;
                _logger.log(Level.SEVERE, e.toString(), e);
            }
        }
        return primary;
    }

    public static boolean httpdWarning(String codebase) {
        if (codebase == null) {
            throw new NullPointerException("codebase is null");
        }
        boolean httpdWarning = false;
        StringTokenizer st = new StringTokenizer(codebase, " ");
        String url = null;
        URL u = null;
        int i = 0;
        while (st.hasMoreTokens()) {
            url = st.nextToken();
            try {
                u = new URL(url);
                String fileName = u.getFile();
                if (fileName != null && !fileName.endsWith("/")) {
                    try {
                        GSMControl.drainStream(u.openStream());
                    }
                    catch (Exception ioe) {
                        httpdWarning = true;
                        System.out.println("HTTP server not found for [" + url + "], unable to verify codebase");
                    }
                }
            }
            catch (MalformedURLException e) {
                httpdWarning = true;
                System.out.println("HTTP server unknown protocol [" + url + "], unable to verify codebase");
            }
            ++i;
        }
        return httpdWarning;
    }

    public static boolean checkHttpURL(URL url) {
        boolean ok = true;
        try {
            URLConnection conn = url.openConnection();
            conn.getContentLength();
        }
        catch (Exception e) {
            if (_logger.isLoggable(Level.SEVERE)) {
                _logger.log(Level.SEVERE, e.toString(), e);
            }
            System.out.println("HTTP server not found for [" + url.toExternalForm() + "], unable to verify connection");
            ok = false;
        }
        return ok;
    }

    private static void drainStream(InputStream is) throws IOException {
        BufferedInputStream reader = new BufferedInputStream(is);
        while (reader.read() != -1) {
        }
    }

    public static class UndeployHandler
    implements GS.OptionHandler,
    Constants {
        private OptionHandler validOptions;
        private static final String OPERATION_NAME = "undeploy";

        UndeployHandler() {
            String[] validOptionsArray = new String[]{"h", "help"};
            this.validOptions = new OptionHandler(Formatter.fromArray(validOptionsArray));
        }

        @Override
        public String process(String input, BufferedReader br) {
            StringTokenizer tok = new StringTokenizer(input);
            String opstringName = null;
            Map<String, String> args = null;
            try {
                args = this.validOptions.getOptions(input, true);
            }
            catch (IllegalArgumentException e) {
                if (e.getMessage() != null) {
                    System.out.println(e.getMessage());
                } else {
                    System.out.println(e.toString());
                }
                System.out.println(this.getUsage());
                return "";
            }
            if (args.containsKey("h") || args.containsKey("help")) {
                return this.getUsage();
            }
            if (tok.countTokens() > 1) {
                tok.nextToken();
                opstringName = tok.nextToken();
            }
            if (opstringName == null) {
                return this.getUsage();
            }
            ServiceItem[] items = GS.finder.findGSMs(null, null);
            if (items.length == 0) {
                return "No Grid Service Manager instances discovered\n";
            }
            DeployAdmin primary = GSMControl.findDeployAdmin(items, opstringName);
            if (primary != null) {
                try {
                    primary.undeploy(opstringName);
                    return "Command successful";
                }
                catch (SecurityException se) {
                    System.out.println("Unable to undeploy due:" + se.toString());
                    return "";
                }
                catch (Exception e) {
                    if (_logger.isLoggable(Level.SEVERE)) {
                        _logger.log(Level.SEVERE, e.toString(), e);
                    }
                    return "Problem undeploying " + opstringName + ", Exception :" + e.toString();
                }
            }
            return "Command failed, no active deployment for " + opstringName;
        }

        @Override
        public String getUsage() {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("usage: undeploy deploy-descriptor\n");
            stringBuilder.append("Options:\n");
            stringBuilder.append("\t-h/-help    prints help\n");
            stringBuilder.append("Usage example:\n");
            stringBuilder.append("\tusage: undeploy data-processor\n");
            stringBuilder.append("\n*****************************************************\n");
            return stringBuilder.toString();
        }
    }
}

