/*
 * Decompiled with CFR 0.152.
 */
package com.gigaspaces.admin.cli;

import com.gigaspaces.admin.cli.Formatter;
import com.gigaspaces.admin.cli.GS;
import com.gigaspaces.management.entry.JMXConnection;
import java.io.BufferedReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.StringTokenizer;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.jini.core.discovery.LookupLocator;
import net.jini.core.entry.Entry;
import net.jini.core.lookup.ServiceID;
import net.jini.core.lookup.ServiceItem;
import net.jini.core.lookup.ServiceMatches;
import net.jini.core.lookup.ServiceRegistrar;
import net.jini.core.lookup.ServiceTemplate;
import net.jini.discovery.DiscoveryEvent;
import net.jini.discovery.DiscoveryListener;
import net.jini.discovery.LookupDiscoveryManager;
import net.jini.discovery.LookupGroups;
import org.jini.rio.boot.BootUtil;
import org.jini.rio.entry.ComputeResourceUtilization;

public class ListHandler
implements GS.OptionHandler {
    private static final Logger _logger = Logger.getLogger("com.gigaspaces.admin.cli");
    private static final String OPERATION_NAME = "list";
    private static final String PARAM_NAME_GSM = "gsm";
    private static final String PARAM_NAME_GSC = "gsc";
    private static final String PARAM_NAME_GSA = "gsa";
    private static final String PARAM_NAME_LUS = "lus";
    private static final String PARAM_NAME_ALL = "all";
    private static final String OPTION_NAME_JMX = "jmx";
    private static final String OPTION_NAME_CPU = "cpu";
    private static final String OPTION_NAME_CODESERVER = "codeserver";
    private static final String OPTION_NAME_TIMEOUT = "timeout";
    private final long DEFAULT_TIMEOUT = 30000L;

    @Override
    public String process(String input, BufferedReader br) {
        StringTokenizer tok = new StringTokenizer(input);
        String cmd = tok.nextToken();
        int options = 0;
        String lookfor = this.getWhatToLookFor(input = input.substring(input.length() == cmd.length() ? cmd.length() : cmd.length() + 1));
        if (lookfor == null) {
            return this.getUsage();
        }
        if (!lookfor.equals(PARAM_NAME_ALL)) {
            input = input.substring(input.length() == lookfor.length() ? lookfor.length() : lookfor.length() + 1);
        }
        tok = new StringTokenizer(input);
        long timeout = -1L;
        while (tok.hasMoreTokens()) {
            String option = tok.nextToken();
            if (option.equals(OPTION_NAME_JMX)) {
                options |= 1;
                continue;
            }
            if (option.equals(OPTION_NAME_CPU)) {
                options |= 2;
                continue;
            }
            if (option.equals(OPTION_NAME_CODESERVER)) {
                options |= 4;
                continue;
            }
            if (option.startsWith(OPTION_NAME_TIMEOUT)) {
                StringTokenizer tok1 = new StringTokenizer(option, "= ");
                if (tok1.countTokens() < 2) {
                    return "Bad discovery timeout option : " + option;
                }
                tok1.nextToken();
                String value = tok1.nextToken();
                try {
                    timeout = Long.parseLong(value);
                    GS.settings.put("disco-timeout", timeout);
                    continue;
                }
                catch (NumberFormatException e) {
                    return "Bad discovery timeout value : " + value;
                }
            }
            System.out.println("Unknown option : " + option);
            return this.getUsage();
        }
        ArrayList<Object> attrList = new ArrayList<Object>();
        if (options & true) {
            attrList.add(new JMXConnection());
        }
        if ((options & 2) != 0) {
            attrList.add(new ComputeResourceUtilization());
        }
        Entry[] attrs = attrList.toArray(new Entry[attrList.size()]);
        ServiceItem[] items = null;
        boolean genericLister = true;
        if (lookfor.equals(PARAM_NAME_ALL)) {
            items = GS.finder.find(null, attrs);
        } else if (lookfor.equals(PARAM_NAME_GSC)) {
            items = GS.finder.findGSCs(null, attrs);
            genericLister = false;
            Formatter.gscLister(items, options);
        } else if (lookfor.equals(PARAM_NAME_GSA)) {
            items = GS.finder.findGSAs(null, attrs);
            genericLister = false;
            Formatter.gsaLister(items, options);
        } else if (lookfor.equals(PARAM_NAME_GSM)) {
            items = GS.finder.findGSMs(null, attrs);
            genericLister = false;
            Formatter.gsmLister(items, options);
        } else if (lookfor.equals(PARAM_NAME_LUS)) {
            genericLister = false;
            this.listLookupServices(timeout);
        }
        if (items != null && items.length > 0 && genericLister) {
            System.out.println(Formatter.asList(items, options) + "\n");
        }
        return "";
    }

    private String getWhatToLookFor(String input) {
        String lookFor = PARAM_NAME_ALL;
        StringTokenizer tok = new StringTokenizer(input);
        if (tok.countTokens() > 0) {
            String value = tok.nextToken();
            if (value.equals(PARAM_NAME_GSM)) {
                lookFor = value;
            } else if (value.equals(PARAM_NAME_GSC)) {
                lookFor = value;
            } else if (value.equals(PARAM_NAME_GSA)) {
                lookFor = value;
            } else if (value.equals(PARAM_NAME_LUS)) {
                lookFor = value;
            } else if (!this.isValidOption(value)) {
                return null;
            }
        }
        return lookFor;
    }

    private boolean isValidOption(String input) {
        boolean valid = true;
        StringTokenizer tok = new StringTokenizer(input);
        while (tok.hasMoreTokens()) {
            String option = tok.nextToken();
            if (option.equals(OPTION_NAME_JMX) || option.equals(OPTION_NAME_CPU) || option.equals(OPTION_NAME_CODESERVER) || option.startsWith(OPTION_NAME_TIMEOUT)) continue;
            valid = false;
            break;
        }
        return valid;
    }

    @Override
    public String getUsage() {
        return "usage: list [type] [options]\n\ntype:\n  gsm | gsc | gsa | lus\t\tOnly one allowed, default is to list \"all\" except lus \n\noptions:\n   cpu | jmx | codeserver\tUse when the type is either \"gsc\" or \"gsm\", can be combined\n   timeout\t\t\tDiscovery timeout(msec), usage example: timeout=20000. Default value is 30000 msec \n\nExample: \tgs> list gsc cpu\n\t\tgs> list lus timeout=20000";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void listLookupServices(long timeout) {
        System.out.println("Searching for available Jini Lookup Services...");
        ListLUSs listLuss = new ListLUSs();
        try {
            if (timeout > 0L) {
                Thread.sleep(timeout);
            } else {
                Thread.sleep(30000L);
            }
        }
        catch (InterruptedException interruptedException) {
        }
        finally {
            if (listLuss != null && listLuss.ldm != null) {
                listLuss.ldm.terminate();
            }
        }
    }

    private static class ListLUSs
    implements DiscoveryListener {
        private final ServiceTemplate template = new ServiceTemplate(null, new Class[0], new Entry[0]);
        private final LookupDiscoveryManager ldm;

        public ListLUSs() {
            LookupDiscoveryManager ldm = null;
            try {
                String locators = System.getProperty("com.gs.jini_lus.locators", "");
                LookupLocator[] lookupLocators = BootUtil.toLookupLocators((String)locators);
                ldm = new LookupDiscoveryManager(LookupGroups.all(), lookupLocators, (DiscoveryListener)this);
            }
            catch (IOException e) {
                _logger.log(Level.SEVERE, e.toString(), e);
            }
            this.ldm = ldm;
        }

        public void discovered(DiscoveryEvent evt) {
            ServiceRegistrar[] registrars = evt.getRegistrars();
            for (int n = 0; n < registrars.length; ++n) {
                ServiceRegistrar registrar = registrars[n];
                try {
                    int i;
                    LookupLocator lookupLocator = registrar.getLocator();
                    System.out.println("\n-----------------------------------------------------------------------\n-- Discovered Lookup Service at host [ " + lookupLocator.getHost() + ":" + lookupLocator.getPort() + " ].");
                    long t0 = System.currentTimeMillis();
                    ServiceMatches matches = registrar.lookup(this.template, Integer.MAX_VALUE);
                    long t1 = System.currentTimeMillis();
                    String[] groups = registrar.getGroups();
                    if (groups != null) {
                        System.out.println("-- Lookup Service registered to the following jini groups: ");
                        for (i = 0; i < groups.length; ++i) {
                            System.out.println("\t\t Group [ " + groups[i] + " ]");
                        }
                    }
                    if (matches == null) continue;
                    System.out.println("-- Lookup Service has [" + matches.items.length + "] services, lookup took [" + (t1 - t0) + "] millis, [" + (t1 - t0) / 1000L + "] seconds: ");
                    for (i = 0; i < matches.items.length; ++i) {
                        ServiceItem serviceItem = matches.items[i];
                        if (serviceItem == null) continue;
                        Object serviceObj = serviceItem.getService();
                        ServiceID serviceId = serviceItem.serviceID;
                        if (serviceObj == null) continue;
                        System.out.println("\t\t Service Class: " + serviceObj.getClass().getName() + " | " + serviceId);
                        Object[] attributesSet = serviceItem.attributeSets;
                        if (attributesSet == null) continue;
                        System.out.println("\t\t Service Attributes Set: " + Arrays.toString(attributesSet) + "\n");
                    }
                    continue;
                }
                catch (Exception e) {
                    _logger.log(Level.SEVERE, e.toString(), e);
                }
            }
        }

        public void discarded(DiscoveryEvent evt) {
        }
    }
}

