/*
 * Decompiled with CFR 0.152.
 */
package com.gigaspaces.admin.cli;

import com.gigaspaces.admin.cli.AbstractSpaceCommand;
import com.gigaspaces.admin.cli.CLIFinder;
import com.gigaspaces.admin.cli.CLIUtilities;
import com.gigaspaces.admin.cli.Formatter;
import com.gigaspaces.admin.cli.GS;
import com.gigaspaces.admin.cli.OptionHandler;
import com.gigaspaces.admin.cli.utils.CLISecurityUtils;
import com.gigaspaces.cluster.activeelection.ISpaceModeListener;
import com.gigaspaces.cluster.activeelection.SpaceMode;
import com.gigaspaces.internal.jvm.JVMInfoProvider;
import com.gigaspaces.internal.os.OSInfoProvider;
import com.gigaspaces.security.authorities.MonitorAuthority;
import com.gigaspaces.security.authorities.Privilege;
import com.gigaspaces.security.service.SecuredService;
import com.j_spaces.core.IJSpace;
import com.j_spaces.core.IJSpaceContainer;
import com.j_spaces.core.admin.IInternalRemoteJSpaceAdmin;
import com.j_spaces.core.admin.IRemoteJSpaceAdmin;
import com.j_spaces.core.admin.SpaceConfig;
import com.j_spaces.core.admin.SpaceRuntimeInfo;
import com.j_spaces.core.admin.StatisticsAdmin;
import com.j_spaces.core.client.FinderException;
import com.j_spaces.core.client.SpaceURL;
import com.j_spaces.core.cluster.ClusterPolicy;
import com.j_spaces.core.filters.StatisticsContext;
import com.j_spaces.kernel.JSpaceUtilities;
import com.j_spaces.lookup.entry.ContainerName;
import java.io.BufferedReader;
import java.io.IOException;
import java.rmi.ConnectException;
import java.rmi.Remote;
import java.rmi.RemoteException;
import java.util.Map;
import java.util.logging.Level;
import net.jini.core.entry.Entry;
import net.jini.core.lookup.ServiceID;
import net.jini.core.lookup.ServiceItem;

public class ListSpaces
extends AbstractSpaceCommand {
    static final int SPACE_STATS = 1;
    static final int NO_RUNTIME_INFO = 2;
    static final int SPACE_ENTRIES = 4;
    private final OptionHandler validOptions;
    public static final String OPERATION_NAME = "list";
    private static final int[] _tabs = new int[]{15, 15, 17, 8, 10, 9, 11, 6, 12, 21, 21, 15};
    private static final String[] _labels = new String[]{"Space name", "objects count", "templates count", "secured", "clustered", "primary", "persistent", "pid", "schema", "jini group", "container name", "host name"};
    private static final String YES_VAL = "Yes";
    private static final String NO_VAL = "No";
    private static final String SECURITY_HIDDEN = "****";

    public ListSpaces() {
        String[] validOptionsArray = new String[]{"h", "help", "url", "c", "cluster", "stats", "noRTI", "noCount", "entry"};
        this.validOptions = new OptionHandler(Formatter.fromArray(validOptionsArray));
        this.searchedSpaceState = -1;
    }

    @Override
    public String getUsage() {
        StringBuffer strBuffer = new StringBuffer();
        strBuffer.append("\n*****************************************************\n");
        strBuffer.append("Usage: space list [options]\n");
        strBuffer.append("options:\n");
        strBuffer.append("\t-h/-help    prints help\n");
        strBuffer.append("\t-url    space url\n");
        strBuffer.append("\t-c/-cluster    cluster operation\n");
        strBuffer.append("\t-stats\n");
        strBuffer.append("\t-noRTI/-noCount\n");
        return strBuffer.toString();
    }

    @Override
    public String process(String input, BufferedReader br) {
        try {
            Map<String, String> args = this.validOptions.getOptions(input, true);
            if (args.containsKey("h") || args.containsKey("help")) {
                return this.getUsage();
            }
            int options = 0;
            options |= 4;
            if (args.containsKey("stats")) {
                options |= 1;
            } else if (args.containsKey("noRTI") || args.containsKey("noCount")) {
                options |= 2;
            }
            ServiceItem[] items = null;
            String finderURL = args.get("url");
            if (args.containsKey("url")) {
                ClusterPolicy clusterPolicy;
                if (JSpaceUtilities.isEmpty((String)finderURL, (boolean)true)) {
                    CLIUtilities.printMissingValueMessage("url");
                    return "";
                }
                Object foundObj = null;
                try {
                    foundObj = this.find(finderURL);
                }
                catch (FinderException e) {
                    return "";
                }
                if (foundObj == null) {
                    CLIUtilities.printWrongServiceURLMessage(finderURL, finderURL != null && finderURL.indexOf("groups") >= 0, finderURL != null && finderURL.indexOf("locators") >= 0);
                    return "";
                }
                IJSpace spaceProxy = null;
                if (foundObj instanceof IJSpaceContainer) {
                    ServiceItem[] serviceItemsArray = this.getContainerSpaces((IJSpaceContainer)foundObj, finderURL);
                    this.spaceLister(serviceItemsArray, options);
                    return "";
                }
                if (foundObj instanceof IJSpace) {
                    spaceProxy = (IJSpace)foundObj;
                }
                if ((clusterPolicy = this.getClusterPolicy(spaceProxy)) != null) {
                    if (args.containsKey("c") || args.containsKey("cluster")) {
                        System.out.println("Attempting to receive cluster members...");
                        items = CLIFinder.findClusterMembers(clusterPolicy, this.searchedSpaceState);
                    } else {
                        String response = this.showClusterWarningMessageAndReadUserInput(br);
                        if (response == null || response.equals("c")) {
                            return "";
                        }
                        items = response.equals("n") ? CLIFinder.findSpaceServices(finderURL, this.searchedSpaceState) : CLIFinder.findClusterMembers(clusterPolicy, this.searchedSpaceState);
                    }
                } else {
                    items = CLIFinder.findSpaceServices(finderURL, this.searchedSpaceState);
                }
            } else {
                items = GS.getServiceFinder().findSpaces(null, null);
            }
            if (items != null) {
                this.spaceLister(items, options);
            }
        }
        catch (IllegalArgumentException e) {
            if (e.getMessage() != null) {
                System.out.println(e.getMessage());
            } else {
                System.out.println(e.toString());
            }
            System.out.println(this.getUsage());
        }
        catch (Exception ex) {
            _logger.log(Level.SEVERE, ex.toString(), ex);
        }
        return "";
    }

    protected String showClusterWarningMessageAndReadUserInput(BufferedReader br) throws IOException {
        String message = "The space is clustered.Do you want to display list of all the spaces members in this cluster?\nEnter \"y\" for Yes, \"n\" for displaying list with only one space.";
        System.out.println(message);
        return br.readLine();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void spaceLister(ServiceItem[] items, int options) {
        boolean stats = false;
        boolean noRTI = false;
        boolean entry = false;
        if ((options & 1) != 0) {
            stats = true;
        }
        if ((options & 2) != 0) {
            noRTI = true;
        }
        if ((options & 4) != 0) {
            entry = true;
        }
        StringBuilder strBuff = null;
        String sep = "--------------------------------------------------------------------------------------------------------------------------------------------------------------" + JSpaceUtilities.LINE_SEPARATOR;
        String sep2 = "~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~" + JSpaceUtilities.LINE_SEPARATOR;
        System.out.print(sep);
        System.out.println(ListSpaces.createLabel(_labels));
        System.out.println(sep);
        if (items != null) {
            for (int i = 0; i < items.length; ++i) {
                StringBuilder additionalInfoBuffer;
                SpaceRuntimeInfo info;
                String primary;
                String hostName;
                String containerName;
                String jiniGroup;
                String schema;
                String persistent;
                String pid;
                String templatesCount;
                String objectsCount;
                String secured;
                String clustered;
                boolean isMonitorPUPermitted;
                String spaceName;
                IJSpace space;
                block42: {
                    SpaceURL spaceURL;
                    block41: {
                        space = (IJSpace)items[i].getService();
                        ServiceID spaceID = items[i].serviceID;
                        spaceName = space.getName();
                        spaceURL = space.getURL();
                        isMonitorPUPermitted = CLISecurityUtils.hasPermittedPermission((SecuredService)space, spaceID, (Privilege)MonitorAuthority.MonitorPrivilege.MONITOR_PU, space.isSecured());
                        try {
                            if (stats) {
                                strBuff = new StringBuilder();
                                Object adminObj = space.getAdmin();
                                if (isMonitorPUPermitted && adminObj instanceof StatisticsAdmin) {
                                    StatisticsAdmin statAdmin = (StatisticsAdmin)adminObj;
                                    if (!statAdmin.isStatisticsAvailable()) {
                                        String message = "Statistics for Space \"" + spaceName + "\" not Available. Please Start the Statistics Filter.";
                                        System.out.println(message);
                                    } else {
                                        Map statMap = statAdmin.getStatistics();
                                        ListSpaces.mergeOperationStatistics(statMap, 2, 12);
                                        ListSpaces.mergeOperationStatistics(statMap, 3, 14);
                                        if (statMap.size() > 0) {
                                            this.writeStatisticsHeader(strBuff);
                                        }
                                        for (Map.Entry statEntry : statMap.entrySet()) {
                                            Integer statOper = (Integer)statEntry.getKey();
                                            String operStr = this.getOperationName(statOper);
                                            if (operStr == null) continue;
                                            StatisticsContext statContext = (StatisticsContext)statEntry.getValue();
                                            strBuff.append('\t').append(operStr).append(" : ");
                                            strBuff.append(statContext);
                                            strBuff.append('\n');
                                        }
                                    }
                                }
                            }
                        }
                        catch (Exception e) {
                            this.writeStatisticsHeader(strBuff);
                            strBuff.append("\tException thrown while fetching statistics for space <" + spaceName + ">\n");
                            if (!_logger.isLoggable(Level.SEVERE)) break block41;
                            _logger.log(Level.SEVERE, e.toString(), e);
                        }
                    }
                    clustered = "-";
                    secured = "false";
                    objectsCount = "-";
                    templatesCount = "-";
                    pid = "-";
                    persistent = "-";
                    schema = "-";
                    jiniGroup = "-";
                    containerName = "-";
                    hostName = "-";
                    primary = "-";
                    IRemoteJSpaceAdmin admin = null;
                    info = null;
                    additionalInfoBuffer = new StringBuilder();
                    try {
                        ContainerName containerNameEntry;
                        SpaceURL spaceFinderURL;
                        Entry[] entriesArray = items[i].attributeSets;
                        admin = (IRemoteJSpaceAdmin)space.getAdmin();
                        if (admin != null) {
                            SpaceConfig spaceConfig;
                            pid = String.valueOf(((JVMInfoProvider)admin).getJVMDetails().getPid());
                            if (!noRTI) {
                                if (isMonitorPUPermitted) {
                                    try {
                                        if (_logger.isLoggable(Level.FINEST)) {
                                            _logger.finest("Before retrieve space runtime Info:" + space.getContainerName() + ":" + space.getName());
                                        }
                                        info = admin.getRuntimeInfo();
                                        if (_logger.isLoggable(Level.FINEST)) {
                                            _logger.finest("After retrieve space runtime Info");
                                        }
                                        objectsCount = ListSpaces.countObjects(info);
                                        templatesCount = ListSpaces.countTemplates(info);
                                    }
                                    catch (Exception e) {
                                        if (_logger.isLoggable(Level.SEVERE)) {
                                            _logger.log(Level.SEVERE, e.toString(), e);
                                        }
                                    }
                                } else {
                                    objectsCount = SECURITY_HIDDEN;
                                    templatesCount = SECURITY_HIDDEN;
                                }
                            }
                            clustered = (spaceConfig = admin.getConfig()).isClustered() ? YES_VAL : NO_VAL;
                            String string = persistent = spaceConfig.isPersistent() ? YES_VAL : NO_VAL;
                            if (spaceConfig.isClustered()) {
                                ISpaceModeListener remoteListener = (ISpaceModeListener)space.getDirectProxy().getStubHandler().exportObject((Remote)((Object)new SpaceModeListenerImpl()));
                                SpaceMode mode = ((IInternalRemoteJSpaceAdmin)admin).addSpaceModeListener(remoteListener);
                                ((IInternalRemoteJSpaceAdmin)admin).removeSpaceModeListener(remoteListener);
                                if (mode != null) {
                                    String string2 = primary = mode.equals((Object)SpaceMode.PRIMARY) ? YES_VAL : NO_VAL;
                                }
                                if (spaceURL.getClusterSchema() != null) {
                                    additionalInfoBuffer.append("Cluster schema: ").append(spaceURL.getClusterSchema()).append('\n');
                                }
                            }
                            schema = spaceConfig.getSchemaName();
                        }
                        if ((spaceFinderURL = space.getURL()) != null) {
                            String spaceURLStr = spaceFinderURL.getURL();
                            additionalInfoBuffer.append("\nSpaceURL: ").append(spaceURLStr);
                        }
                        containerName = (containerNameEntry = (ContainerName)CLIUtilities.getEntryClass(entriesArray, ContainerName.class)) != null ? containerNameEntry.name : space.getContainerName();
                        try {
                            hostName = admin instanceof OSInfoProvider ? ((OSInfoProvider)admin).getOSDetails().getHostName() : space.getDirectProxy().getContainerConfig().containerHostName;
                            jiniGroup = JSpaceUtilities.getJiniGroupRepresentation((IRemoteJSpaceAdmin)admin);
                        }
                        catch (ConnectException ce) {
                            if (_logger.isLoggable(Level.WARNING)) {
                                _logger.log(Level.WARNING, ce.toString(), ce);
                            }
                        }
                        catch (RemoteException re) {
                            if (!_logger.isLoggable(Level.SEVERE)) break block42;
                            _logger.log(Level.SEVERE, re.toString(), re);
                        }
                    }
                    catch (Exception e) {
                        block43: {
                            try {
                                if (!_logger.isLoggable(Level.SEVERE)) break block43;
                                _logger.log(Level.SEVERE, e.toString(), e);
                            }
                            catch (Throwable throwable) {
                                secured = space.isSecured() ? YES_VAL : NO_VAL;
                                System.out.println(ListSpaces.createLabel(new String[]{spaceName, objectsCount, templatesCount, secured, clustered, primary, persistent, pid, schema, jiniGroup, containerName, hostName}));
                                System.out.println(additionalInfoBuffer.toString());
                                if (isMonitorPUPermitted && entry && info != null && info.m_ClassNames.size() > 0) {
                                    System.out.println(sep2);
                                    ListSpaces.printClassNames(info);
                                }
                                if (strBuff != null && strBuff.length() > 0) {
                                    System.out.println(strBuff.toString());
                                }
                                System.out.println(sep);
                                throw throwable;
                            }
                        }
                        secured = space.isSecured() ? YES_VAL : NO_VAL;
                        System.out.println(ListSpaces.createLabel(new String[]{spaceName, objectsCount, templatesCount, secured, clustered, primary, persistent, pid, schema, jiniGroup, containerName, hostName}));
                        System.out.println(additionalInfoBuffer.toString());
                        if (isMonitorPUPermitted && entry && info != null && info.m_ClassNames.size() > 0) {
                            System.out.println(sep2);
                            ListSpaces.printClassNames(info);
                        }
                        if (strBuff != null && strBuff.length() > 0) {
                            System.out.println(strBuff.toString());
                        }
                        System.out.println(sep);
                        continue;
                    }
                }
                secured = space.isSecured() ? YES_VAL : NO_VAL;
                System.out.println(ListSpaces.createLabel(new String[]{spaceName, objectsCount, templatesCount, secured, clustered, primary, persistent, pid, schema, jiniGroup, containerName, hostName}));
                System.out.println(additionalInfoBuffer.toString());
                if (isMonitorPUPermitted && entry && info != null && info.m_ClassNames.size() > 0) {
                    System.out.println(sep2);
                    ListSpaces.printClassNames(info);
                }
                if (strBuff != null && strBuff.length() > 0) {
                    System.out.println(strBuff.toString());
                }
                System.out.println(sep);
                continue;
            }
            if (items.length > 0) {
                System.out.println(JSpaceUtilities.LINE_SEPARATOR + items.length + " space instance(s)" + JSpaceUtilities.LINE_SEPARATOR);
            }
        }
    }

    private void writeStatisticsHeader(StringBuilder strBuilder) {
        strBuilder.append("\n\tStatistics\n");
        strBuilder.append("\t--------------------------------------------------\n");
    }

    private static void mergeOperationStatistics(Map<Integer, StatisticsContext> statMap, int primaryOpCode, int secondaryOpCode) {
        StatisticsContext secondaryOp = statMap.remove(secondaryOpCode);
        if (secondaryOp != null) {
            StatisticsContext primaryOp = statMap.get(primaryOpCode);
            if (primaryOp != null) {
                primaryOp.add(secondaryOp.getCurrentCount());
            } else {
                statMap.put(primaryOpCode, secondaryOp);
            }
        }
    }

    private String getOperationName(int operationType) {
        switch (operationType) {
            case 2: {
                return "READ";
            }
            case 12: {
                return "READ MULTIPLE";
            }
            case 0: {
                return "WRITE";
            }
            case 9: {
                return "UPDATE";
            }
            case 4: {
                return "NOTIFY REG.";
            }
            case 15: {
                return "NOTIFY SENT";
            }
            case 16: {
                return "NOTIFY ACK.";
            }
            case 3: {
                return "TAKE";
            }
            case 14: {
                return "TAKE MULTIPLE";
            }
            case 20: {
                return "EXECUTE";
            }
        }
        return null;
    }

    private static void printClassNames(SpaceRuntimeInfo info) {
        try {
            int classesAmount = info.m_ClassNames.size();
            if (classesAmount <= 0) {
                return;
            }
            for (int i = 0; i < classesAmount; ++i) {
                System.out.println("Class Name: " + (String)info.m_ClassNames.get(i) + "\tObjects count: " + info.m_NumOFEntries.get(i) + "\tTemplates count: " + info.m_NumOFTemplates.get(i));
            }
            System.out.println(JSpaceUtilities.LINE_SEPARATOR + classesAmount + " class instance(s)" + JSpaceUtilities.LINE_SEPARATOR);
        }
        catch (Exception e) {
            _logger.log(Level.SEVERE, e.toString(), e);
        }
    }

    private static String countObjects(SpaceRuntimeInfo info) {
        int count = 0;
        for (Integer intObj : info.m_NumOFEntries) {
            count += intObj.intValue();
        }
        return String.valueOf(count);
    }

    private static String countTemplates(SpaceRuntimeInfo info) {
        int count = 0;
        for (Integer intObj : info.m_NumOFTemplates) {
            count += intObj.intValue();
        }
        return String.valueOf(count);
    }

    private static String createLabel(String[] labels) {
        String str = "";
        for (int j = 0; j < labels.length; ++j) {
            str = labels[j].length() >= _tabs[j] ? str + labels[j].substring(0, _tabs[j] - 1).concat(".") : str + labels[j];
            for (int s = 0; s < _tabs[j] - labels[j].length(); ++s) {
                str = str + ' ';
            }
        }
        return str;
    }

    static class SpaceModeListenerImpl
    implements ISpaceModeListener {
        SpaceModeListenerImpl() {
        }

        public void beforeSpaceModeChange(SpaceMode newMode) throws RemoteException {
        }

        public void afterSpaceModeChange(SpaceMode newMode) throws RemoteException {
        }
    }
}

