/*
 * Decompiled with CFR 0.152.
 */
package com.gigaspaces.admin.cli;

import com.gigaspaces.admin.cli.AbstractSpaceCommand;
import com.gigaspaces.admin.cli.CLIUtilities;
import com.gigaspaces.admin.cli.Formatter;
import com.gigaspaces.admin.cli.GS;
import com.gigaspaces.admin.cli.OptionHandler;
import com.gigaspaces.admin.cli.utils.CLISecurityRepository;
import com.gigaspaces.internal.utils.concurrent.GSThread;
import com.gigaspaces.security.directory.CredentialsProviderHelper;
import com.j_spaces.kernel.JSpaceUtilities;
import java.io.BufferedReader;
import java.util.Map;
import java.util.Properties;
import java.util.logging.Level;

public class Login
extends AbstractSpaceCommand {
    private final OptionHandler validOptions;
    protected static final String OPERATION_NAME = "login";
    private static final String USER_NAME = "user";
    private static final String PASSWORD = "password";
    private final ConsoleEraser _consoleEraser;

    public Login() {
        String[] validOptionsArray = new String[]{"h", "help", USER_NAME, "user-details-provider", "user-details-properties", PASSWORD};
        this._consoleEraser = new ConsoleEraser();
        this.validOptions = new OptionHandler(Formatter.fromArray(validOptionsArray));
        this.operationName = OPERATION_NAME;
    }

    @Override
    public String getUsage() {
        StringBuffer strBuffer = new StringBuffer();
        strBuffer.append("\n*****************************************************\n");
        strBuffer.append("Usage: " + this.operationName + " [options]\n");
        strBuffer.append("After typing " + this.operationName + " press Enter key and you will be requested to enter user name\n");
        strBuffer.append("and after pressing Enter key you will be requested to enter password.\n");
        strBuffer.append("Options:\n");
        strBuffer.append("\t-h/-help    prints help\n");
        strBuffer.append("\t-user    user name for login, optional parameter\n");
        strBuffer.append("\t-password    password for login, optional parameter\n");
        strBuffer.append("\t-user-details-provider    UserDetailsProvider implementation class name\n");
        strBuffer.append("\t-user-details-properties  properties that will be passed to create method of UserDetailsProvider implementation\n");
        strBuffer.append("Usage example :\n");
        strBuffer.append("\t" + this.operationName + "\n");
        strBuffer.append("\t" + this.operationName + " -" + USER_NAME + " USER_NAME -" + PASSWORD + " PASSW\n");
        strBuffer.append("\t" + this.operationName + " -" + "user-details-provider" + " com.custom.UserDetailsProviderImpl -" + "user-details-properties" + " prop1=value1;prop2=value2\n");
        return strBuffer.toString();
    }

    @Override
    public String process(String input, BufferedReader br) {
        try {
            Map<String, String> args = this.validOptions.getOptions(input, true);
            if (args.containsKey("h") || args.containsKey("help")) {
                return this.getUsage();
            }
            if (CLISecurityRepository.getInstance().getCurrentCredentialsProvider() != null) {
                Login.promptAboutReLogin();
            }
            String userName = null;
            String password = null;
            if (args.containsKey(USER_NAME) && args.containsKey(PASSWORD) || args.containsKey("user-details-provider")) {
                return Login.login(args);
            }
            System.out.println("Please enter user name:");
            userName = br.readLine();
            if (JSpaceUtilities.isEmpty((String)userName, (boolean)true)) {
                CLIUtilities.printMissingValueMessage(USER_NAME);
                return "";
            }
            System.out.println("Please enter user password:");
            this._consoleEraser.start();
            password = br.readLine();
            this._consoleEraser.halt();
            System.out.print("\b");
            if (JSpaceUtilities.isEmpty((String)password, (boolean)true)) {
                CLIUtilities.printMissingValueMessage(PASSWORD);
                return "";
            }
            Login.login(userName, password);
        }
        catch (IllegalArgumentException e) {
            if (e.getMessage() != null) {
                System.out.println(e.getMessage());
            } else {
                System.out.println(e.toString());
            }
            System.out.println(this.getUsage());
            return "";
        }
        catch (Exception ex) {
            System.out.println("Command failed. Please see CLI log file for details.");
            _logger.log(Level.SEVERE, ex.toString(), ex);
        }
        return "";
    }

    private static String login(Map<String, String> args) {
        GS.FirstParametersWrapper loginParameters = GS.parseLoginParameters(args, OPERATION_NAME, true);
        if (!loginParameters.isParametersValid()) {
            return "";
        }
        String user = loginParameters.getUser();
        String password = loginParameters.getPassword();
        if (user != null && password != null) {
            Login.login(user, password);
            return "";
        }
        Properties loginProperties = loginParameters.getUserDetailsProperties();
        String userDetailsProviderClass = loginParameters.getUserDetailsProviderClass();
        if (userDetailsProviderClass != null) {
            Login.login(loginProperties, userDetailsProviderClass);
            return "";
        }
        return "login was not performed since invalid parameters were passed";
    }

    private static void login(String userName, String password) {
        Login.login(CredentialsProviderHelper.createLoginProperties((String)userName, (String)password), null);
    }

    private static boolean login(Properties loginProperties, String userDetailsProviderClass) {
        return CLISecurityRepository.getInstance().login(loginProperties, userDetailsProviderClass);
    }

    private static void promptAboutReLogin() {
        System.out.println("Relogin will be performed since login was already done before.");
    }

    static class ConsoleEraser
    extends GSThread {
        private boolean running = true;

        public ConsoleEraser() {
            super("Login-ConsoleEraser");
        }

        public void run() {
            while (this.running) {
                System.out.print("\b ");
            }
        }

        public synchronized void halt() {
            this.running = false;
        }
    }
}

