/*
 * Decompiled with CFR 0.152.
 */
package com.gigaspaces.admin.cli;

import com.gigaspaces.admin.cli.ArgsTokenizer;
import com.gigaspaces.admin.cli.CLIUtilities;
import com.gigaspaces.admin.cli.Constants;
import com.gigaspaces.admin.cli.Formatter;
import com.gigaspaces.admin.cli.GS;
import com.gigaspaces.admin.cli.OptionHandler;
import java.beans.Statement;
import java.io.BufferedReader;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.jini.core.lookup.ServiceItem;
import net.jini.discovery.DiscoveryGroupManagement;

public class MemcachedDeployHandler
implements GS.OptionHandler,
Constants {
    private static final Logger LOGGER = Logger.getLogger("com.gigaspaces.admin.cli");
    private boolean isSecuredService;
    private static final String MSG_SECURITY = "Unable to deploy Processing Unit using secured GSM without Admin permissions. Please perform login.";
    private OptionHandler validOptions;
    public static final String OPERATION_NAME = "deploy-memcached";
    private static final String MEMCACHED_DEPLOY_CLASS = "org.openspaces.pu.container.servicegrid.deploy.MemcachedDeploy";
    private Class deployerClass;

    MemcachedDeployHandler() {
        block4: {
            try {
                this.deployerClass = Class.forName(MEMCACHED_DEPLOY_CLASS);
                Field validOptionsField = this.deployerClass.getDeclaredField("validOptionsArray");
                String[] validOptionsArray = (String[])validOptionsField.get(null);
                this.validOptions = new OptionHandler(Formatter.fromArray(validOptionsArray));
            }
            catch (ClassNotFoundException e) {
                System.out.println("Please install OpenSpaces.");
                if (LOGGER.isLoggable(Level.SEVERE)) {
                    LOGGER.log(Level.SEVERE, e.toString());
                }
            }
            catch (Exception e) {
                if (!LOGGER.isLoggable(Level.SEVERE)) break block4;
                LOGGER.log(Level.SEVERE, e.toString(), e);
            }
        }
    }

    @Override
    public String process(String input, BufferedReader br) {
        ArgsTokenizer tokenizer = new ArgsTokenizer(input);
        int count = tokenizer.countTokens();
        if (count <= 1) {
            return this.getUsage();
        }
        tokenizer.nextToken();
        ArrayList<String> argsList = new ArrayList<String>(--count);
        for (int i = 0; i < count; ++i) {
            String token = tokenizer.nextToken();
            argsList.add(token);
        }
        String[] argv = new String[argsList.size()];
        argsList.toArray(argv);
        try {
            Map<String, String> args = this.validOptions.getOptions(input, true, true);
            if (args.containsKey("h") || args.containsKey("help")) {
                return this.getUsage();
            }
            Object deployer = this.deployerClass.newInstance();
            Statement setSout = new Statement(deployer, "setSout", new Object[]{Boolean.TRUE});
            setSout.execute();
            if (Boolean.FALSE.equals(GS.settings.get("wait-on-deploy"))) {
                Long deployTimeout = (Long)GS.settings.get("deploy-timeout");
                Statement setDeployTimeout = new Statement(deployer, "setDeployTimeout", new Object[]{deployTimeout});
                setDeployTimeout.execute();
            }
            String[] groups = null;
            groups = GS.finder.getDiscoveryManagement() instanceof DiscoveryGroupManagement ? ((DiscoveryGroupManagement)GS.finder.getDiscoveryManagement()).getGroups() : GS.finder.getGroups();
            Statement setGroups = new Statement(deployer, "setGroups", new Object[]{groups});
            setGroups.execute();
            ServiceItem[] serviceItems = GS.finder.findGSMs(null, null);
            if (serviceItems == null || serviceItems.length <= 0) {
                return "No Grid Service Manager instances discovered,\ntry to increase timeout by parameter -initialization-timeout, default timeout is 10000 msec.\n";
            }
            Statement setDeployAdmin = new Statement(deployer, "initializeDiscovery", new Object[]{serviceItems[0].getService()});
            setDeployAdmin.execute();
            Statement deploy = new Statement(deployer, "deployAndWait", new Object[]{argv});
            deploy.execute();
        }
        catch (IllegalArgumentException e) {
            if (e.getMessage() != null) {
                System.out.println(e.getMessage());
            } else {
                System.out.println(e.toString());
            }
            System.out.println(this.getUsage());
        }
        catch (Throwable e) {
            Object[] localCommandArgLine = CLIUtilities.getArgLineWithScreenPassword(argv);
            String msg = "Error deploying " + Arrays.toString(localCommandArgLine);
            LOGGER.log(Level.SEVERE, msg, e);
            System.out.println(msg + ":" + e.toString());
        }
        return "";
    }

    @Override
    public String getUsage() {
        try {
            Object deployer = this.deployerClass.newInstance();
            Method getUsageMethod = this.deployerClass.getMethod("getUsage", Boolean.TYPE);
            return (String)getUsageMethod.invoke(deployer, true);
        }
        catch (Throwable e) {
            String msg = "Error showing pudeploy usage";
            LOGGER.log(Level.WARNING, msg, e);
            System.out.println(msg + ":" + e.toString());
            return "";
        }
    }
}

