/*
 * Decompiled with CFR 0.152.
 */
package com.gigaspaces.admin.cli;

import com.gigaspaces.admin.cli.InvalidCLIOptionException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;

public class OptionHandler {
    private final Set<String> _optionsSet;
    public static final String COMMAND_KEY = "command";

    public OptionHandler(String options) {
        StringTokenizer strTokenizer = new StringTokenizer(options, ",", false);
        this._optionsSet = new HashSet<String>(strTokenizer.countTokens());
        while (strTokenizer.hasMoreTokens()) {
            String nextToken = strTokenizer.nextToken().trim();
            this._optionsSet.add(nextToken);
        }
    }

    public Map<String, String> getOptions(String[] args) throws IllegalArgumentException {
        HashMap<String, String> argsMap = new HashMap<String, String>();
        for (int i = 0; i < args.length; ++i) {
            String arg = args[i];
            if (!arg.startsWith("-")) continue;
            String option = arg.substring(1);
            if (!this.isValidOption(option)) {
                throw new IllegalArgumentException("Invalid option : -" + option);
            }
            argsMap.put(option, this.getArgs(args, i));
        }
        return argsMap;
    }

    public Map<String, String> getOptions(String args, boolean isInvokedFromOperationHadler) throws IllegalArgumentException {
        return this.getOptions(args, true, isInvokedFromOperationHadler);
    }

    public Map<String, String> getOptions(String args, boolean chekInvalidOptions, boolean isInvokedFromOperationHandler) throws IllegalArgumentException {
        HashMap<String, String> argsMap = new HashMap<String, String>();
        StringTokenizer strTokenizer = new StringTokenizer(args);
        int i = 0;
        String lastArg = "";
        String lastAddedArg = "";
        while (strTokenizer.hasMoreTokens()) {
            String arg = strTokenizer.nextToken();
            if (arg.startsWith("-")) {
                String option = arg.substring(1);
                if (chekInvalidOptions && !this.isValidOption(option)) {
                    throw new IllegalArgumentException("Invalid option: -" + option);
                }
                if (!isInvokedFromOperationHandler) {
                    String val = this.getArgs(args, i + 1);
                    if (val.startsWith("-")) {
                        val = "";
                    }
                    lastAddedArg = val;
                    argsMap.put(option, lastAddedArg);
                    lastArg = "";
                } else {
                    argsMap.put(option, this.getOperationArgs(args, i + 1));
                }
            } else if (!isInvokedFromOperationHandler && !arg.equals(lastAddedArg)) {
                lastArg = lastArg + arg + " ";
                argsMap.put(COMMAND_KEY, lastArg);
                break;
            }
            ++i;
        }
        if (!isInvokedFromOperationHandler && !argsMap.containsKey(COMMAND_KEY) && lastArg.trim().length() > 0) {
            argsMap.put(COMMAND_KEY, lastArg);
        }
        return argsMap;
    }

    public static String getOptionsString(String[] args) {
        StringBuilder stringBuffer = new StringBuilder();
        for (int i = 0; i < args.length; ++i) {
            stringBuffer.append(args[i]);
            stringBuffer.append(' ');
        }
        return stringBuffer.toString();
    }

    private String getArgs(String[] args, int i) {
        String entire = "";
        ++i;
        while (i < args.length && !args[i].startsWith("-")) {
            entire = entire + args[i] + " ";
            ++i;
        }
        return entire.trim();
    }

    private String getOperationArgs(String argsStr, int curStrIndex) {
        String entire = "";
        int i = 0;
        StringTokenizer strTokenizer = new StringTokenizer(argsStr);
        while (strTokenizer.hasMoreTokens()) {
            String str = strTokenizer.nextToken();
            if (i >= curStrIndex) {
                if (str.startsWith("-")) break;
                entire = entire + str + " ";
            }
            ++i;
        }
        return entire.trim();
    }

    private String getArgs(String argsStr, int curStrIndex) {
        String entire = "";
        int i = 0;
        StringTokenizer strTokenizer = new StringTokenizer(argsStr);
        while (strTokenizer.hasMoreTokens()) {
            String str = strTokenizer.nextToken();
            if (i == curStrIndex) {
                entire = entire + str + " ";
            } else if (i > curStrIndex) break;
            ++i;
        }
        return entire.trim();
    }

    public static String[] getCommandParameters(String input) {
        String token;
        StringTokenizer strTokenizer = new StringTokenizer(input);
        ArrayList<String> paramsList = new ArrayList<String>(2);
        while (strTokenizer.hasMoreTokens() && !(token = strTokenizer.nextToken()).startsWith("-")) {
            paramsList.add(token);
        }
        return paramsList.toArray(new String[paramsList.size()]);
    }

    public boolean isValidOption(String option) {
        return this._optionsSet.contains(option);
    }

    public static class OptionsParser {
        private static <T extends AbstractCLIOption> T findByParamName(Class<T> type, String paramName) {
            for (AbstractCLIOption t : (AbstractCLIOption[])type.getEnumConstants()) {
                if (!t.getParamName().equals(paramName) && (t.getShortParamName() == null || !t.getShortParamName().equals(paramName))) continue;
                return (T)t;
            }
            return null;
        }

        public static <T extends AbstractCLIOption> LinkedHashMap<T, String> parseCommand(Class<T> type, String command) {
            return OptionsParser.parseCommand(type, command, true);
        }

        public static <T extends AbstractCLIOption> LinkedHashMap<T, String> parseCommand(Class<T> type, String command, boolean skipFirst) {
            return OptionsParser.parseCommand(type, command.split(" "), skipFirst);
        }

        public static <T extends AbstractCLIOption> LinkedHashMap<T, String> parseCommand(Class<T> type, String[] args) {
            return OptionsParser.parseCommand(type, args, true);
        }

        public static <T extends AbstractCLIOption> LinkedHashMap<T, String> parseCommand(Class<T> type, String[] args, boolean skipFirst) {
            int i;
            LinkedHashMap<T, String> commands = new LinkedHashMap<T, String>();
            int n = i = skipFirst ? 1 : 0;
            while (i < args.length) {
                if (args[i].startsWith("-")) {
                    T option = OptionsParser.findByParamName(type, args[i].substring(1));
                    if (option != null) {
                        ++i;
                        String value = "";
                        while (i < args.length && !args[i].startsWith("-")) {
                            value = value + " " + args[i];
                            ++i;
                        }
                        commands.put(option, value.trim());
                        continue;
                    }
                    throw new InvalidCLIOptionException("Invalid option [" + args[i] + "]");
                }
                throw new InvalidCLIOptionException("Unknown option [" + args[i] + "]");
            }
            return commands;
        }
    }

    public static interface AbstractCLIOption {
        public String getParamName();

        public String getShortParamName();
    }
}

