/*
 * Decompiled with CFR 0.152.
 */
package com.gigaspaces.admin.cli;

import com.gigaspaces.admin.cli.AbstractSpaceCommand;
import com.gigaspaces.admin.cli.CLIFinder;
import com.gigaspaces.admin.cli.CLIUtilities;
import com.gigaspaces.admin.cli.Formatter;
import com.gigaspaces.admin.cli.OptionHandler;
import com.gigaspaces.annotation.pojo.SpaceClass;
import com.gigaspaces.annotation.pojo.SpaceId;
import com.gigaspaces.annotation.pojo.SpaceProperty;
import com.gigaspaces.annotation.pojo.SpaceRouting;
import com.gigaspaces.client.transaction.DistributedTransactionManagerProvider;
import com.gigaspaces.internal.lookup.SpaceUrlUtils;
import com.gigaspaces.security.SecurityException;
import com.j_spaces.core.IJSpace;
import com.j_spaces.core.IJSpaceContainer;
import com.j_spaces.core.NoSuchNameException;
import com.j_spaces.core.client.FinderException;
import com.j_spaces.core.cluster.ClusterPolicy;
import com.j_spaces.kernel.JSpaceUtilities;
import java.io.BufferedReader;
import java.io.Serializable;
import java.rmi.RemoteException;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import net.jini.core.lease.LeaseDeniedException;
import net.jini.core.lookup.ServiceItem;
import net.jini.core.transaction.Transaction;
import net.jini.core.transaction.TransactionException;
import net.jini.core.transaction.TransactionFactory;
import net.jini.core.transaction.server.TransactionManager;

public class Ping
extends AbstractSpaceCommand {
    private String finderURL;
    private final OptionHandler validOptions;
    protected static final String OPERATION_NAME = "ping";
    private static final long DEFAULT_LEASE_VALUE = 10000L;
    private DistributedTransactionManagerProvider distributedTransactionManagerProvider;
    private final Object distributedTransactionManagerProviderLock = new Object();

    public Ping() {
        String[] validOptionsArray = new String[]{"i", "url", "c", "cluster", "s", "t", "h", "help", "read", "take", "x", "ft"};
        this.validOptions = new OptionHandler(Formatter.fromArray(validOptionsArray));
        this.operationName = OPERATION_NAME;
        this.searchedSpaceState = 1;
    }

    @Override
    public String process(String input, BufferedReader br) {
        try {
            String leaseTimeoutStr;
            Map<String, String> args = this.validOptions.getOptions(input, true);
            Transaction xtn = null;
            int numberOfIteration = 5;
            long messageLength = 100L;
            long leaseTimeout = 10000L;
            long finderTimeout = 5000L;
            String msgAddition = "";
            if (args.containsKey("h") || args.containsKey("help")) {
                return this.getUsage();
            }
            if (args.containsKey("s")) {
                messageLength = Long.parseLong(args.get("s"));
            }
            if (args.containsKey("i")) {
                numberOfIteration = Integer.parseInt(args.get("i"));
            }
            if (args.containsKey("t")) {
                leaseTimeout = Long.parseLong(args.get("t"));
            }
            if (args.containsKey("ft")) {
                finderTimeout = Long.parseLong(args.get("ft"));
            }
            byte[] messageBuf = new byte[(int)messageLength];
            boolean isCreateTransaction = args.containsKey("x");
            String string = leaseTimeoutStr = leaseTimeout == Long.MAX_VALUE ? "FOREVER" : leaseTimeout / 1000L + " seconds";
            if (!args.containsKey("url")) {
                IJSpace[] spaces = this.getSelectedSpaceProxies(br);
                this.printPingInfo(null, this.finderURL, msgAddition, leaseTimeoutStr, finderTimeout, messageLength, numberOfIteration);
                this.pingSpaces(spaces, leaseTimeout, numberOfIteration, args, messageBuf, isCreateTransaction);
                return "";
            }
            this.finderURL = args.get("url");
            if (JSpaceUtilities.isEmpty((String)this.finderURL, (boolean)true)) {
                CLIUtilities.printMissingValueMessage("url");
                return "";
            }
            Object foundObj = null;
            try {
                this.finderURL = SpaceUrlUtils.setPropertyInUrl((String)this.finderURL, (String)"timeout", (String)Long.toString(finderTimeout), (boolean)false);
                foundObj = this.find(this.finderURL);
            }
            catch (FinderException e) {
                return "";
            }
            if (foundObj == null) {
                CLIUtilities.printWrongServiceURLMessage(this.finderURL, this.finderURL != null && this.finderURL.indexOf("groups") >= 0, this.finderURL != null && this.finderURL.indexOf("locators") >= 0);
                return "";
            }
            IJSpace space = null;
            if (foundObj instanceof IJSpaceContainer) {
                ServiceItem[] serviceItemsArray = this.getContainerSpaces((IJSpaceContainer)foundObj, this.finderURL);
                IJSpace[] spacesArray = this.getSelectedFromListSpaceProxies(serviceItemsArray, br, -1);
                if (spacesArray != null && spacesArray.length > 0) {
                    this.printPingInfo(null, this.finderURL, msgAddition, leaseTimeoutStr, finderTimeout, messageLength, numberOfIteration);
                    this.pingSpaces(spacesArray, leaseTimeout, numberOfIteration, args, messageBuf, isCreateTransaction);
                }
                return "";
            }
            if (foundObj instanceof IJSpace) {
                space = (IJSpace)foundObj;
            }
            if (space == null) {
                String warningMessage = "Space was not found using the SpaceURL: " + this.finderURL;
                System.out.println(warningMessage);
                return "";
            }
            String spaceName = space.getName();
            if (isCreateTransaction) {
                msgAddition = " [ using transaction ] ";
            }
            this.printPingInfo(spaceName, this.finderURL, msgAddition, leaseTimeoutStr, finderTimeout, messageLength, numberOfIteration);
            ClusterPolicy clusterPolicy = this.getClusterPolicy(space);
            if (clusterPolicy != null) {
                if (args.containsKey("c") || args.containsKey("cluster")) {
                    System.out.println("Attempting to receive cluster members...");
                    this.pingClusterMembers(clusterPolicy, leaseTimeout, numberOfIteration, args.containsKey("take"), messageBuf, isCreateTransaction);
                } else {
                    IJSpace[] selectedClusterMembers = this.getAllClusterMembers(clusterPolicy, br);
                    if (selectedClusterMembers == null) {
                        return "No cluster members found.";
                    }
                    this.pingSpaces(selectedClusterMembers, leaseTimeout, numberOfIteration, args, messageBuf, isCreateTransaction);
                }
            } else {
                if (isCreateTransaction) {
                    xtn = this.createTransaction(space);
                }
                this.performPing(space, leaseTimeout, numberOfIteration, args.containsKey("take"), messageBuf, xtn);
            }
        }
        catch (SecurityException se) {
            System.out.println("Space Ping failed due to a security error: " + se.toString());
        }
        catch (IllegalArgumentException e) {
            if (e.getMessage() != null) {
                System.out.println(e.getMessage());
            } else {
                System.out.println(e.toString());
            }
            System.out.println(this.getUsage());
        }
        catch (Exception ex) {
            _logger.log(Level.SEVERE, ex.toString(), ex);
        }
        return "";
    }

    private void printPingInfo(String spaceName, String finderURL, String msgAddition, String leaseTimeoutStr, long finderTimeout, long messageLength, int numberOfIteration) {
        StringBuffer strBuffer = new StringBuffer();
        strBuffer.append(this.operationName);
        if (spaceName != null) {
            strBuffer.append(" from <" + spaceName + "> space\n");
        }
        strBuffer.append(" with:\n");
        strBuffer.append("Finder URL: " + (finderURL == null ? "-" : finderURL));
        strBuffer.append("\nLease Timeout: " + msgAddition);
        strBuffer.append(" " + leaseTimeoutStr);
        strBuffer.append("\nLookupFinder timeout: " + finderTimeout + " milliseconds\n");
        strBuffer.append("Buffer Size: " + messageLength);
        strBuffer.append("\nIterations: " + numberOfIteration);
        strBuffer.append("\n");
        System.out.println(strBuffer.toString());
    }

    private void pingSpaces(IJSpace[] spaces, long leaseTimeout, int numberOfIteration, Map<String, String> args, byte[] messageBuf, boolean isCreateTransaction) throws RemoteException, LeaseDeniedException, TransactionException {
        if (spaces != null) {
            Transaction xtn = null;
            int selSpacesAmount = spaces.length;
            for (int i = 0; i < selSpacesAmount; ++i) {
                String spaceName = spaces[i].getName();
                System.out.print("Started to ping <" + spaceName + "> space (" + (i + 1) + " of " + selSpacesAmount + ")...");
                if (isCreateTransaction) {
                    xtn = this.createTransaction(spaces[i]);
                }
                try {
                    this.performPing(spaces[i], leaseTimeout, numberOfIteration, args.containsKey("take"), messageBuf, xtn);
                    System.out.println(" successful\n");
                    continue;
                }
                catch (SecurityException se) {
                    System.out.println(" failed due to a security error: " + se.toString());
                    continue;
                }
                catch (Exception e) {
                    System.out.println(" failed. See log file for details.");
                    _logger.log(Level.SEVERE, e.toString(), e);
                }
            }
        }
    }

    private void performPing(IJSpace space, long leaseTimeout, int numberOfIteration, boolean isPerformTake, byte[] messageBuf, Transaction xtn) throws Exception {
        long initialTime = System.currentTimeMillis();
        for (int counter = 1; counter <= numberOfIteration; ++counter) {
            space.write((Object)new Message(counter, messageBuf), xtn, leaseTimeout);
            Message template = new Message(counter, null);
            if (isPerformTake) {
                space.take((Object)template, xtn, leaseTimeout);
                continue;
            }
            space.read((Object)template, xtn, leaseTimeout);
        }
        if (xtn != null) {
            xtn.commit();
        }
        long avrTime = (System.currentTimeMillis() - initialTime) / (long)numberOfIteration;
        System.out.println("Average Time = " + avrTime + " milliseconds");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Transaction createTransaction(IJSpace space) throws LeaseDeniedException, TransactionException, RemoteException {
        if (this.distributedTransactionManagerProvider == null) {
            Object object = this.distributedTransactionManagerProviderLock;
            synchronized (object) {
                if (this.distributedTransactionManagerProvider == null) {
                    this.distributedTransactionManagerProvider = new DistributedTransactionManagerProvider();
                }
            }
        }
        TransactionManager xtnManager = this.distributedTransactionManagerProvider.getTransactionManager();
        Transaction.Created xtnCreated = TransactionFactory.create((TransactionManager)xtnManager, (long)Long.MAX_VALUE);
        return xtnCreated.transaction;
    }

    @Override
    public String getUsage() {
        StringBuffer stringBuffer = this.getBasicUsage();
        stringBuffer.append("\t-t     set lease timeout in milliseconds, default value is 10 seconds\n");
        stringBuffer.append("\t-ft    set Jini LookupFinder timeout in milliseconds\n");
        stringBuffer.append("\t-s     set byte size of the object.\n");
        stringBuffer.append("\t-i     set number of iteration.\n");
        stringBuffer.append("\t-read|take   read or take written object from space, read is invoked by default\n");
        stringBuffer.append("\t-x     under transaction\n");
        stringBuffer.append("\n*****************************************************\n\n");
        return stringBuffer.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void pingClusterMembers(ClusterPolicy clusterPolicy, long leaseTimeout, int numberOfIteration, boolean isPerformTake, byte[] messageBuf, boolean isCreateTransaction) throws RemoteException, FinderException, NoSuchNameException {
        Map<String, IJSpace> spaceProxiesMap = CLIFinder.getClusterMembersSpaceProxies(clusterPolicy, this.searchedSpaceState);
        Set<Map.Entry<String, IJSpace>> entriesSet = spaceProxiesMap.entrySet();
        System.out.println("There are " + spaceProxiesMap.size() + " cluster spaces to be pinged.");
        int counter = 0;
        Transaction xtn = null;
        for (Map.Entry<String, IJSpace> spaceProxyEntry : entriesSet) {
            String memberName = spaceProxyEntry.getKey();
            IJSpace spaceProxy = spaceProxyEntry.getValue();
            try {
                String msg = counter + " Ping <" + memberName + "> cluster member...";
                System.out.print(msg);
                if (isCreateTransaction) {
                    xtn = this.createTransaction(spaceProxy);
                }
                this.performPing(spaceProxy, leaseTimeout, numberOfIteration, isPerformTake, messageBuf, xtn);
                System.out.println(" successful.");
            }
            catch (SecurityException se) {
                System.out.println("Space Ping failed due to a security error: " + se.toString());
            }
            catch (Exception e) {
                System.out.println(" failed.");
                _logger.log(Level.SEVERE, e.toString(), e);
            }
            finally {
                ++counter;
            }
        }
    }

    @SpaceClass(persist=false)
    public static class Message
    implements Serializable {
        private static final long serialVersionUID = 8153865863567499479L;
        private byte[] _content;
        private int _counter = -1;

        public Message() {
        }

        public Message(int initVal, byte[] content) {
            this._content = content;
            this._counter = initVal;
        }

        public void setContent(byte[] content) {
            this._content = content;
        }

        public void setCounter(int counter) {
            this._counter = counter;
        }

        public byte[] getContent() {
            return this._content;
        }

        @SpaceRouting
        @SpaceProperty(nullValue="-1")
        @SpaceId
        public int getCounter() {
            return this._counter;
        }

        public String toString() {
            return this.getClass() + "_" + this._counter + "_" + this._content;
        }
    }
}

