/*
 * Decompiled with CFR 0.152.
 */
package com.gigaspaces.admin.cli;

import com.gigaspaces.admin.cli.CLIUtilities;
import com.gigaspaces.admin.cli.GS;
import com.gigaspaces.admin.cli.InvalidCLIOptionException;
import com.gigaspaces.admin.cli.OptionHandler;
import com.gigaspaces.admin.cli.utils.CLISecurityRepository;
import com.gigaspaces.admin.quiesce.QuiesceState;
import com.gigaspaces.security.directory.CredentialsProvider;
import java.beans.Statement;
import java.io.BufferedReader;
import java.lang.reflect.InvocationTargetException;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.jini.core.discovery.LookupLocator;

public class QuiesceCLIHandler
implements GS.OptionHandler {
    private static final Logger LOGGER = Logger.getLogger("com.gigaspaces.admin.cli");
    public static final String OPERATION_NAME = "quiesce";
    private static final String DEFAULT_TIMEOUT_IN_SEC = "300";
    private static final String ADMIN_FACTORY_CLASS = "org.openspaces.admin.AdminFactory";
    private Class adminFactoryClass;

    public QuiesceCLIHandler() {
        block2: {
            try {
                this.adminFactoryClass = Class.forName(ADMIN_FACTORY_CLASS);
            }
            catch (ClassNotFoundException e) {
                System.out.println("Please install OpenSpaces.");
                if (!LOGGER.isLoggable(Level.SEVERE)) break block2;
                LOGGER.log(Level.SEVERE, e.toString());
            }
        }
    }

    @Override
    public String process(String input, BufferedReader br) {
        int index = (input = input.trim()).lastIndexOf(32);
        boolean interactiveMode = index <= 0;
        long timeoutInSeconds = Long.valueOf(DEFAULT_TIMEOUT_IN_SEC);
        String description = "";
        try {
            CredentialsProvider credentialsProvider;
            Object adminFactory = this.adminFactoryClass.newInstance();
            if (GS.settings != null) {
                Object[] groups;
                Object[] locators = (LookupLocator[])GS.settings.get("locators");
                if (locators != null) {
                    if (LOGGER.isLoggable(Level.FINE)) {
                        LOGGER.fine("Locators: " + Arrays.toString(locators));
                    }
                    for (Object lookupLocator : locators) {
                        adminFactory.getClass().getMethod("addLocator", String.class).invoke(adminFactory, lookupLocator.getHost() + ":" + lookupLocator.getPort());
                    }
                }
                if ((groups = (String[])GS.settings.get("groups")) != null) {
                    if (LOGGER.isLoggable(Level.FINE)) {
                        LOGGER.fine("Groups: " + Arrays.toString(groups));
                    }
                    for (Object group : groups) {
                        adminFactory.getClass().getMethod("addGroup", String.class).invoke(adminFactory, group);
                    }
                }
            }
            if ((credentialsProvider = CLISecurityRepository.getInstance().getCurrentCredentialsProvider()) != null) {
                LOGGER.fine("Setting Credentials Provider for Admin Factory");
                Statement scaleStatement = new Statement(adminFactory, "credentialsProvider", new Object[]{credentialsProvider});
                scaleStatement.execute();
            }
            Object admin = adminFactory.getClass().getMethod("create", new Class[0]).invoke(adminFactory, new Object[0]);
            try {
                String puName;
                block55: {
                    if (interactiveMode) {
                        String response;
                        int i;
                        LOGGER.info("Locating processing units ...");
                        System.out.println("Locating processing units ...");
                        boolean gotResult = false;
                        Object[] pusArray = null;
                        for (i = 0; i < 3 && !gotResult; ++i) {
                            try {
                                LOGGER.info("Locating processing units, Attempt " + (i + 1) + " of 3");
                                Thread.sleep(5000L);
                            }
                            catch (InterruptedException e) {
                                LOGGER.log(Level.WARNING, "Sleep interrupted", e);
                            }
                            Object pus = admin.getClass().getMethod("getProcessingUnits", new Class[0]).invoke(admin, new Object[0]);
                            pusArray = (Object[])pus.getClass().getMethod("getProcessingUnits", new Class[0]).invoke(pus, new Object[0]);
                            if (pusArray.length == 0) {
                                LOGGER.info("Unable to locate processing units. Attempt " + (i + 1) + " of 3");
                                continue;
                            }
                            LOGGER.info("Found [" + pusArray.length + "] processing units");
                            gotResult = true;
                        }
                        if (!gotResult || pusArray == null) {
                            LOGGER.info("Unable to locate processing units within 15 seconds. Please try invoking the command in non-interactive mode.");
                            System.out.println("Unable to locate processing units within 15 seconds.");
                            System.out.println("Please try invoking the command in non-interactive mode.");
                            admin.getClass().getMethod("close", new Class[0]).invoke(admin, new Object[0]);
                            return "";
                        }
                        System.out.println("Total processing units: " + pusArray.length);
                        for (i = 0; i < pusArray.length; ++i) {
                            System.out.println("[" + (i + 1) + "]\t" + pusArray[i].getClass().getMethod("getName", new Class[0]).invoke(pusArray[i], new Object[0]));
                        }
                        while (true) {
                            System.out.print("Choose a processing unit or \"c\" to cancel: ");
                            response = br.readLine();
                            if (response == null || response.equals("")) {
                                System.out.println("Invalid choice [" + response + "]");
                                continue;
                            }
                            if (response.equals("c")) {
                                admin.getClass().getMethod("close", new Class[0]).invoke(admin, new Object[0]);
                                return "Command canceled";
                            }
                            try {
                                int puId = Integer.parseInt(response) - 1;
                                if (puId >= 0 && puId < pusArray.length) {
                                    puName = (String)pusArray[puId].getClass().getMethod("getName", new Class[0]).invoke(pusArray[puId], new Object[0]);
                                    break;
                                }
                                System.out.println("Invalid choice [" + response + "]");
                            }
                            catch (NumberFormatException e) {
                                System.out.println("Invalid choice [" + response + "]: Must be number");
                            }
                        }
                        System.out.println("Enter new value, or press ENTER for the default");
                        System.out.print("\tQuiesce description []: ");
                        response = br.readLine();
                        if (response != null && !response.equals("")) {
                            description = response;
                        }
                        while (true) {
                            System.out.print("\tTimeout in seconds [300]: ");
                            response = br.readLine();
                            if (response == null || response.equals("")) break block55;
                            try {
                                timeoutInSeconds = Long.valueOf(response);
                                break block55;
                            }
                            catch (NumberFormatException e) {
                                System.out.println("Invalid value [" + response + "]: Must be number");
                                continue;
                            }
                            break;
                        }
                    }
                    String command = input.substring(0, index);
                    puName = input.substring(index + 1);
                    LinkedHashMap<QuiesceOption, String> args = OptionHandler.OptionsParser.parseCommand(QuiesceOption.class, command);
                    if (args.containsKey(QuiesceOption.HELP) || args.size() == 0 && puName.equals("-" + QuiesceOption.HELP.getParamName())) {
                        return this.getUsage();
                    }
                    if (!args.containsKey(QuiesceOption.DESCRIPTION) && LOGGER.isLoggable(Level.FINE)) {
                        LOGGER.fine("Using default value for option [" + QuiesceOption.DESCRIPTION.getParamName() + "] : Empty string");
                    }
                    if (!args.containsKey(QuiesceOption.TIMEOUT) && LOGGER.isLoggable(Level.FINE)) {
                        LOGGER.fine("Using default value for option [" + QuiesceOption.TIMEOUT.getParamName() + "] : " + DEFAULT_TIMEOUT_IN_SEC);
                    }
                    block25: for (QuiesceOption option : args.keySet()) {
                        switch (option) {
                            case TIMEOUT: {
                                try {
                                    timeoutInSeconds = Long.valueOf(args.get(option));
                                    continue block25;
                                }
                                catch (NumberFormatException e) {
                                    throw new IllegalArgumentException("Invalid value for option [" + option.getParamName() + "]: Must be a number");
                                }
                            }
                            case DESCRIPTION: {
                                description = args.get(option);
                                if (description != null) continue block25;
                                throw new IllegalArgumentException("Invalid value for option [" + option.getParamName() + "]: Must have a value");
                            }
                        }
                        throw new IllegalArgumentException("Unhandled option [" + option.getParamName() + "]");
                    }
                }
                LOGGER.info("Locating processing unit with name [" + puName + "]");
                System.out.println("Locating processing unit with name [" + puName + "]");
                Object pus = admin.getClass().getMethod("getProcessingUnits", new Class[0]).invoke(admin, new Object[0]);
                Object pu = pus.getClass().getMethod("waitFor", String.class, Long.TYPE, TimeUnit.class).invoke(pus, new Object[]{puName, 15, TimeUnit.SECONDS});
                if (pu == null) {
                    admin.getClass().getMethod("close", new Class[0]).invoke(admin, new Object[0]);
                    return "Unable to find processing unit with name [" + puName + "] within 15 seconds.";
                }
                LOGGER.info("Sending quiesce request...");
                System.out.println("Sending quiesce request...");
                Object quiesceRequest = Class.forName("org.openspaces.admin.quiesce.QuiesceRequest").getConstructor(String.class).newInstance(description);
                Object quiesceResult = pu.getClass().getMethod(OPERATION_NAME, quiesceRequest.getClass()).invoke(pu, quiesceRequest);
                Object token = quiesceResult.getClass().getMethod("getToken", new Class[0]).invoke(quiesceResult, new Object[0]);
                LOGGER.info("Waiting up to " + timeoutInSeconds + " seconds until the processing unit [" + puName + "] is quiesced");
                System.out.println("Waiting up to " + timeoutInSeconds + " seconds until the processing unit [" + puName + "] is quiesced");
                boolean finishedWithinTimeout = (Boolean)pu.getClass().getMethod("waitFor", QuiesceState.class, Long.TYPE, TimeUnit.class).invoke(pu, new Object[]{QuiesceState.QUIESCED, timeoutInSeconds, TimeUnit.SECONDS});
                if (finishedWithinTimeout) {
                    LOGGER.info("Quiesce command completed successfully [token=" + token.toString() + "]");
                    System.out.println("Quiesce command completed successfully [token=" + token.toString() + "]");
                } else {
                    LOGGER.info("Quiesce command timed out [token=" + token.toString() + "]");
                    System.out.println("Quiesce command timed out [token=" + token.toString() + "]");
                    LOGGER.info("Quiesce details:");
                    System.out.println("Quiesce details:");
                    Object quiesceDetails = pu.getClass().getMethod("getQuiesceDetails", new Class[0]).invoke(pu, new Object[0]);
                    String details = quiesceDetails.getClass().getMethod("getInstancesQuiesceState", new Class[0]).invoke(quiesceDetails, new Object[0]).toString();
                    LOGGER.info(details);
                    System.out.println(details);
                }
                admin.getClass().getMethod("close", new Class[0]).invoke(admin, new Object[0]);
            }
            catch (Throwable e) {
                admin.getClass().getMethod("close", new Class[0]).invoke(admin, new Object[0]);
                throw e;
            }
        }
        catch (IllegalArgumentException e) {
            Object[] localCommandArgLine = CLIUtilities.getArgLineWithScreenPassword(input.split(" "));
            LOGGER.log(Level.SEVERE, "Quiesce command failed " + Arrays.toString(localCommandArgLine), e);
            if (e.getMessage() != null) {
                System.out.println("Quiesce command failed");
                System.out.println(e.getMessage());
            } else {
                System.out.println("Quiesce command failed");
                System.out.println(e.toString());
            }
        }
        catch (InvalidCLIOptionException e) {
            Object[] localCommandArgLine = CLIUtilities.getArgLineWithScreenPassword(input.split(" "));
            LOGGER.log(Level.SEVERE, "Quiesce command failed " + Arrays.toString(localCommandArgLine), e);
            if (e.getMessage() != null) {
                System.out.println("Quiesce command failed");
                System.out.println(e.getMessage());
            } else {
                System.out.println("Quiesce command failed");
                System.out.println(e.toString());
            }
            System.out.println(this.getUsage());
        }
        catch (InvocationTargetException e) {
            Object[] localCommandArgLine = CLIUtilities.getArgLineWithScreenPassword(input.split(" "));
            LOGGER.log(Level.SEVERE, "Quiesce command failed " + Arrays.toString(localCommandArgLine), e);
            if (e.getTargetException() != null && e.getTargetException().getMessage() != null) {
                if (e.getTargetException().getClass().getName().equals("org.openspaces.admin.AdminException") && e.getTargetException().getCause() != null) {
                    System.out.println("Quiesce command failed: " + e.getTargetException().getMessage());
                    System.out.println(e.getTargetException().getCause().getMessage());
                } else {
                    System.out.println("Quiesce command failed: " + e.getTargetException().getMessage());
                }
            } else if (e.getCause() != null) {
                System.out.println("Quiesce command failed: " + e.getCause().getMessage());
            } else {
                System.out.println("Quiesce command failed: " + e.toString());
            }
        }
        catch (Throwable e) {
            Object[] localCommandArgLine = CLIUtilities.getArgLineWithScreenPassword(input.split(" "));
            LOGGER.log(Level.SEVERE, "Quiesce command failed " + Arrays.toString(localCommandArgLine), e);
            System.out.println("Quiesce command failed: " + e.toString());
        }
        return "";
    }

    @Override
    public String getUsage() {
        StringBuilder sb = new StringBuilder();
        sb.append("Usage: \n\t quiesce [options] PU_NAME\n");
        sb.append("\n");
        sb.append("Available options: \n");
        for (QuiesceOption option : QuiesceOption.values()) {
            if (option.equals(QuiesceOption.HELP)) continue;
            sb.append("\t" + option.getParamUsage() + "\n");
        }
        sb.append("\n");
        return sb.toString();
    }

    private static enum QuiesceOption implements OptionHandler.AbstractCLIOption
    {
        TIMEOUT("timeout", "-timeout [timeout in seconds] \t : Timeout for quiesce operation. Default is 300 seconds."),
        DESCRIPTION("description", "-description [description] \t : The quiesce request description"),
        HELP("help", "-help");

        private String _paramName;
        private String _usageDesc;

        private QuiesceOption(String _paramName, String _usageDesc) {
            this._paramName = _paramName;
            this._usageDesc = _usageDesc;
        }

        @Override
        public String getParamName() {
            return this._paramName;
        }

        @Override
        public String getShortParamName() {
            return null;
        }

        public String getParamUsage() {
            return this._usageDesc;
        }
    }
}

