/*
 * Decompiled with CFR 0.152.
 */
package com.gigaspaces.admin.cli;

import com.gigaspaces.admin.cli.Constants;
import com.gigaspaces.admin.cli.GS;
import com.gigaspaces.admin.cli.InvalidCLIOptionException;
import com.gigaspaces.admin.cli.OptionHandler;
import com.gigaspaces.admin.cli.utils.CLISecurityRepository;
import com.gigaspaces.security.directory.CredentialsProvider;
import java.beans.Expression;
import java.beans.Statement;
import java.io.BufferedReader;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.jini.core.discovery.LookupLocator;

public class RestHandler
implements GS.OptionHandler,
Constants {
    private static final Logger LOGGER = Logger.getLogger("com.gigaspaces.admin.cli");
    public static String OPERATION_NAME = "deploy-rest";
    private static int DEFAULT_DEPLOY_TIMEOUT = 30;
    private static String DEFAULT_INSTANCES = "1";

    @Override
    public String process(String input, BufferedReader br) {
        block53: {
            try {
                CredentialsProvider credentialsProvider;
                int timeoutInSec;
                LinkedHashMap<Options, String> parsed = OptionHandler.OptionsParser.parseCommand(Options.class, input);
                if (parsed.keySet().size() == 0 || parsed.containsKey(Options.HELP)) {
                    return this.getUsage();
                }
                Object processingUnitDeployment = Class.forName("org.openspaces.admin.pu.ProcessingUnitDeployment").getConstructor(String.class).newInstance("/templates/rest");
                if (!parsed.containsKey(Options.SPACE_NAME)) {
                    throw new IllegalArgumentException("-" + Options.SPACE_NAME.getParamName() + " option must be specified.");
                }
                if (!parsed.containsKey(Options.PORT)) {
                    throw new IllegalArgumentException("-" + Options.PORT.getParamName() + " option must be specified.");
                }
                if (!parsed.containsKey(Options.INSTANCES)) {
                    parsed.put(Options.INSTANCES, DEFAULT_INSTANCES);
                    RestHandler.logFineIfLoggable("Using default value for [" + Options.INSTANCES + "]: " + DEFAULT_INSTANCES);
                }
                if (!parsed.containsKey(Options.PUNAME)) {
                    parsed.put(Options.PUNAME, (String)parsed.get(Options.SPACE_NAME) + "-rest");
                    RestHandler.logFineIfLoggable("Using processing unit name [" + (String)parsed.get(Options.SPACE_NAME) + "-rest]");
                }
                if (!parsed.containsKey(Options.TIMEOUT)) {
                    RestHandler.logFineIfLoggable("Using default value for [" + Options.TIMEOUT + "]: " + DEFAULT_DEPLOY_TIMEOUT);
                    timeoutInSec = DEFAULT_DEPLOY_TIMEOUT;
                } else {
                    try {
                        timeoutInSec = Integer.valueOf((String)parsed.get(Options.TIMEOUT));
                    }
                    catch (NumberFormatException e) {
                        throw new IllegalArgumentException("Invalid value for option [" + Options.TIMEOUT.getParamName() + "]: Must be number");
                    }
                }
                block27: for (Options option : parsed.keySet()) {
                    Object[] value = (Object[])parsed.get(option);
                    switch (option) {
                        case PORT: {
                            RestHandler.logFineIfLoggable("Applying port on [" + (String)value + "]");
                            processingUnitDeployment.getClass().getMethod("setContextProperty", String.class, String.class).invoke(processingUnitDeployment, "rest.port", value);
                            break;
                        }
                        case SPACE_NAME: {
                            RestHandler.logFineIfLoggable("Applying spaceName on [" + (String)value + "]");
                            processingUnitDeployment.getClass().getMethod("setContextProperty", String.class, String.class).invoke(processingUnitDeployment, "rest.spaceName", value);
                            break;
                        }
                        case GROUPS: {
                            RestHandler.logFineIfLoggable("Applying groups on [" + (String)value + "]");
                            processingUnitDeployment.getClass().getMethod("setContextProperty", String.class, String.class).invoke(processingUnitDeployment, "rest.lookup-groups", value);
                            break;
                        }
                        case LOCATORS: {
                            RestHandler.logFineIfLoggable("Applying locators on [" + (String)value + "]");
                            processingUnitDeployment.getClass().getMethod("setContextProperty", String.class, String.class).invoke(processingUnitDeployment, "rest.lookup-locators", value);
                            break;
                        }
                        case INSTANCES: {
                            RestHandler.logFineIfLoggable("Applying numberOfInstances on [" + (String)value + "]");
                            try {
                                processingUnitDeployment.getClass().getMethod("numberOfInstances", Integer.TYPE).invoke(processingUnitDeployment, Integer.valueOf((String)value));
                                break;
                            }
                            catch (NumberFormatException e) {
                                throw new IllegalArgumentException("Invalid value for option [" + option.getParamName() + "]: Must be number");
                            }
                        }
                        case MAX_INSTANCES_PER_MACHINE: {
                            RestHandler.logFineIfLoggable("Applying maxInstancesPerMachine on [" + (String)value + "]");
                            try {
                                processingUnitDeployment.getClass().getMethod("maxInstancesPerMachine", Integer.TYPE).invoke(processingUnitDeployment, Integer.valueOf((String)value));
                                break;
                            }
                            catch (NumberFormatException e) {
                                throw new IllegalArgumentException("Invalid value for option [" + option.getParamName() + "]: Must be number");
                            }
                        }
                        case MAX_INSTANCES_PER_VM: {
                            RestHandler.logFineIfLoggable("Applying maxInstancesPerVM on [" + (String)value + "]");
                            try {
                                processingUnitDeployment.getClass().getMethod("maxInstancesPerVM", Integer.TYPE).invoke(processingUnitDeployment, Integer.valueOf((String)value));
                                break;
                            }
                            catch (NumberFormatException e) {
                                throw new IllegalArgumentException("Invalid value for option [" + option.getParamName() + "]: Must be number");
                            }
                        }
                        case ZONES: {
                            String[] zones;
                            RestHandler.logFineIfLoggable("HANDLING ZONES - [" + (String)value + "]");
                            for (String zone : zones = value.split(",")) {
                                RestHandler.logFineIfLoggable("Applying addZone on [" + zone + "]");
                                processingUnitDeployment.getClass().getMethod("addZone", String.class).invoke(processingUnitDeployment, zone);
                            }
                            continue block27;
                        }
                        case PRIMARY_ZONE: {
                            RestHandler.logFineIfLoggable("Applying primaryZone on [" + (String)value + "]");
                            processingUnitDeployment.getClass().getMethod("primaryZone", String.class).invoke(processingUnitDeployment, new Object[]{value});
                            break;
                        }
                        case PUNAME: {
                            RestHandler.logFineIfLoggable("Applying name on [" + (String)value + "]");
                            processingUnitDeployment.getClass().getMethod("name", String.class).invoke(processingUnitDeployment, new Object[]{value});
                            break;
                        }
                        case TIMEOUT: 
                        case HELP: {
                            break;
                        }
                        default: {
                            return "Unhandled option [" + option.getParamName() + "]";
                        }
                    }
                }
                LOGGER.info("Deploying rest processing unit with name [" + (String)parsed.get(Options.PUNAME) + "]");
                System.out.println("Deploying rest processing unit with name [" + (String)parsed.get(Options.PUNAME) + "]");
                Object adminFactory = Class.forName("org.openspaces.admin.AdminFactory").newInstance();
                if (GS.settings != null) {
                    Object[] groups;
                    Object[] locators = (LookupLocator[])GS.settings.get("locators");
                    if (locators != null) {
                        if (LOGGER.isLoggable(Level.FINE)) {
                            LOGGER.fine("Locators: " + Arrays.toString(locators));
                        }
                        for (Object lookupLocator : locators) {
                            adminFactory.getClass().getMethod("addLocator", String.class).invoke(adminFactory, lookupLocator.getHost() + ":" + lookupLocator.getPort());
                        }
                    }
                    if ((groups = (String[])GS.settings.get("groups")) != null) {
                        if (LOGGER.isLoggable(Level.FINE)) {
                            LOGGER.fine("Groups: " + Arrays.toString(groups));
                        }
                        for (Object group : groups) {
                            adminFactory.getClass().getMethod("addGroup", String.class).invoke(adminFactory, group);
                        }
                    }
                }
                if ((credentialsProvider = CLISecurityRepository.getInstance().getCurrentCredentialsProvider()) != null) {
                    LOGGER.fine("Setting Credentials Provider for Admin Factory");
                    Statement scaleStatement = new Statement(adminFactory, "credentialsProvider", new Object[]{credentialsProvider});
                    scaleStatement.execute();
                }
                Object admin = adminFactory.getClass().getMethod("create", new Class[0]).invoke(adminFactory, new Object[0]);
                try {
                    Object gsms;
                    Object gsm;
                    Object gsAgents;
                    Object gsa;
                    if (LOGGER.isLoggable(Level.FINE)) {
                        LOGGER.fine("Waiting for at least one GSA");
                    }
                    if ((gsa = (gsAgents = admin.getClass().getMethod("getGridServiceAgents", new Class[0]).invoke(admin, new Object[0])).getClass().getMethod("waitForAtLeastOne", Long.TYPE, TimeUnit.class).invoke(gsAgents, new Object[]{10, TimeUnit.SECONDS})) == null) {
                        throw new IllegalArgumentException("Failed to find a running GSA within 10 seconds.");
                    }
                    if (LOGGER.isLoggable(Level.FINE)) {
                        LOGGER.fine("Waiting for at least one GSM");
                    }
                    if ((gsm = (gsms = admin.getClass().getMethod("getGridServiceManagers", new Class[0]).invoke(admin, new Object[0])).getClass().getMethod("waitForAtLeastOne", Long.TYPE, TimeUnit.class).invoke(gsms, new Object[]{10, TimeUnit.SECONDS})) == null) {
                        throw new IllegalArgumentException("Failed to find a running GSM within 10 seconds.");
                    }
                    Expression expression = new Expression(gsm, "deploy", new Object[]{processingUnitDeployment, 10L, TimeUnit.SECONDS});
                    Object pu = expression.getValue();
                    String puName = pu.getClass().getMethod("getName", new Class[0]).invoke(pu, new Object[0]).toString();
                    int plannedNumberOfInstances = (Integer)pu.getClass().getMethod("getPlannedNumberOfInstances", new Class[0]).invoke(pu, new Object[0]);
                    boolean waitForResult = (Boolean)pu.getClass().getMethod("waitFor", Integer.TYPE, Long.TYPE, TimeUnit.class).invoke(pu, new Object[]{plannedNumberOfInstances, timeoutInSec, TimeUnit.SECONDS});
                    if (waitForResult) {
                        LOGGER.info("Rest Processing Unit [" + puName + "] deployed successfully.");
                        System.out.println("Rest Processing Unit [" + puName + "] deployed successfully.");
                    } else {
                        LOGGER.info("Deployment of rest processing unit [" + puName + "] didn't finish within [" + timeoutInSec + "] seconds");
                        System.out.println("Deployment of rest processing unit [" + puName + "] didn't finish within [" + timeoutInSec + "] seconds");
                    }
                    RestHandler.logFineIfLoggable("Closing admin");
                    admin.getClass().getMethod("close", new Class[0]).invoke(admin, new Object[0]);
                }
                catch (Exception e) {
                    RestHandler.logFineIfLoggable("Closing admin");
                    admin.getClass().getMethod("close", new Class[0]).invoke(admin, new Object[0]);
                    throw e;
                }
            }
            catch (IllegalArgumentException e) {
                String msg = "Unable to deploy rest processing unit";
                LOGGER.log(Level.SEVERE, msg, e);
                System.out.println(msg + ": " + e.getMessage());
                if (e.getCause() != null) {
                    LOGGER.severe(e.getCause().toString());
                }
            }
            catch (InvalidCLIOptionException e) {
                String msg = "Error deploying rest processing unit";
                LOGGER.log(Level.SEVERE, msg, e);
                if (e.getMessage() != null) {
                    System.out.println(msg);
                    System.out.println(e.getMessage());
                } else {
                    System.out.println(msg);
                    System.out.println(e.toString());
                }
                System.out.println(this.getUsage());
            }
            catch (Throwable e) {
                String msg = "Unable to deploy rest processing unit";
                LOGGER.log(Level.SEVERE, msg, e);
                System.out.println(msg + ": " + e.toString());
                if (e.getCause() == null) break block53;
                LOGGER.severe(e.getCause().toString());
            }
        }
        return "";
    }

    private static void logFineIfLoggable(String msg) {
        if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.fine(msg);
        }
    }

    @Override
    public String getUsage() {
        StringBuilder sb = new StringBuilder();
        sb.append("Usage: \n\t " + OPERATION_NAME + " [options] \n");
        sb.append("\n");
        sb.append("Available options: \n");
        for (Options option : Options.values()) {
            if (option.equals(Options.HELP)) continue;
            sb.append("\t" + option.getParamUsage() + "\n");
        }
        return sb.toString();
    }

    static /* synthetic */ String access$000() {
        return DEFAULT_INSTANCES;
    }

    static /* synthetic */ int access$100() {
        return DEFAULT_DEPLOY_TIMEOUT;
    }

    private static enum Options implements OptionHandler.AbstractCLIOption
    {
        PORT("port", "-port [number] \t\t\t\t\t\t : Required - The port which the rest will be available on."),
        SPACE_NAME("spacename", "-spacename [spacename] \t\t\t\t\t : Required - Name of the Space that the rest should connect to."),
        GROUPS("lookup-groups", "-lookup-groups [comma separated list] \t\t\t : The lookup groups to be used when locating the specified space."),
        LOCATORS("lookup-locators", "-lookup-locators [comma separated list of host:port] \t : The lookup locators to be used when locating the specified space."),
        INSTANCES("instances", "-instances [number] \t\t\t\t\t : Specify the amount of instances to be deployed. Default to " + RestHandler.access$000()),
        PUNAME("puname", "-puname [processing unit name] \t\t\t\t : Specify the processing unit's name. Defaults to [spacename]-rest"),
        ZONES("zones", "-zones [comma separated list] \t\t\t\t : Specify the zones that the rest pu can be deployed on"),
        PRIMARY_ZONE("primary-zone", "-primary-zone [zone name] \t\t\t\t : Set the primary zone where the processing unit is allowed to be deployed on."),
        MAX_INSTANCES_PER_VM("max-instances-per-vm", "-max-instances-per-vm [number] \t\t\t\t : Specify the number of instances per VM."),
        MAX_INSTANCES_PER_MACHINE("max-instance-per-machine", "-max-instance-per-machine [number] \t\t\t : Specify the number of instances per machine."),
        TIMEOUT("timeout", "-timeout [time in seconds] \t\t\t\t : Set the timeout for deploying the rest processing unit. Default to " + RestHandler.access$100()),
        HELP("help", "-help");

        String optionName;
        String usage;

        private Options(String command, String usage) {
            this.optionName = command;
            this.usage = usage;
        }

        @Override
        public String getParamName() {
            return this.optionName;
        }

        public String getParamUsage() {
            return this.usage;
        }

        @Override
        public String getShortParamName() {
            return null;
        }

        public static Options findByOptionName(String optionName) {
            for (Options option : Options.values()) {
                if (!option.getParamName().equals(optionName)) continue;
                return option;
            }
            return null;
        }
    }
}

