/*
 * Decompiled with CFR 0.152.
 */
package com.gigaspaces.admin.cli;

import com.gigaspaces.admin.cli.AbstractElasticDeploymentHandler;
import com.gigaspaces.admin.cli.ArgsTokenizer;
import com.gigaspaces.admin.cli.CLIUtilities;
import com.gigaspaces.admin.cli.Constants;
import com.gigaspaces.admin.cli.Formatter;
import com.gigaspaces.admin.cli.GS;
import com.gigaspaces.admin.cli.OptionHandler;
import com.gigaspaces.admin.cli.utils.CLISecurityRepository;
import com.gigaspaces.security.directory.CredentialsProvider;
import java.beans.Statement;
import java.io.BufferedReader;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.jini.core.discovery.LookupLocator;

public class ScaleHandler
extends AbstractElasticDeploymentHandler
implements GS.OptionHandler,
Constants {
    private static final Logger LOGGER = Logger.getLogger("com.gigaspaces.admin.cli");
    public static final String OPERATION_NAME = "scale";
    private OptionHandler validScaleOptions;
    private static final String ADMIN_FACTORY_CLASS = "org.openspaces.admin.AdminFactory";
    private Class adminFactoryClass;

    ScaleHandler() {
        block5: {
            try {
                this.adminFactoryClass = Class.forName(ADMIN_FACTORY_CLASS);
                ArrayList<String> paramNames = new ArrayList<String>();
                for (ScaleOption option : ScaleOption.values()) {
                    paramNames.add(option.getParamName());
                    if (option.getShortParamName() == null) continue;
                    paramNames.add(option.getShortParamName());
                }
                paramNames.add("h");
                paramNames.add("help");
                String[] validOptionsArray = new String[paramNames.size()];
                paramNames.toArray(validOptionsArray);
                this.validScaleOptions = new OptionHandler(Formatter.fromArray(validOptionsArray));
            }
            catch (ClassNotFoundException e) {
                System.out.println("Please install OpenSpaces.");
                if (LOGGER.isLoggable(Level.SEVERE)) {
                    LOGGER.log(Level.SEVERE, e.toString());
                }
            }
            catch (Exception e) {
                if (!LOGGER.isLoggable(Level.SEVERE)) break block5;
                LOGGER.log(Level.SEVERE, e.toString(), e);
            }
        }
    }

    @Override
    public String process(String input, BufferedReader br) {
        ArgsTokenizer tokenizer = new ArgsTokenizer(input);
        int count = tokenizer.countTokens();
        if (count == 1) {
            return this.getUsage();
        }
        tokenizer.nextToken();
        ArrayList<String> argsList = new ArrayList<String>(--count);
        for (int i = 0; i < count; ++i) {
            String token = tokenizer.nextToken();
            argsList.add(token);
        }
        String[] arr = new String[argsList.size()];
        argsList.toArray(arr);
        try {
            CredentialsProvider credentialsProvider;
            Map<String, String> argsmap = this.validScaleOptions.getOptions(arr);
            if (argsmap.containsKey("h") || argsmap.containsKey("help")) {
                return this.getUsage();
            }
            HashMap<ScaleOption, String> args = new HashMap<ScaleOption, String>();
            for (String arg : argsmap.keySet()) {
                Object option = ScaleOption.findByParamName(arg);
                if (option == null) {
                    throw new IllegalArgumentException("Unknown scale option [" + arg + "]");
                }
                args.put((ScaleOption)((Object)option), argsmap.get(arg));
            }
            if (!args.containsKey((Object)ScaleOption.NAME)) {
                throw new IllegalArgumentException("Option [" + ScaleOption.NAME.getParamName() + "] must be provided");
            }
            String puName = (String)args.get((Object)ScaleOption.NAME);
            if (puName.length() == 0) {
                throw new IllegalArgumentException("Invalid value for option [" + ScaleOption.NAME.getParamName() + "]: Can not be empty");
            }
            Object scaleStrategyConfigurer = Class.forName("org.openspaces.admin.pu.elastic.config.ManualCapacityScaleConfigurer").newInstance();
            block18: for (ScaleOption option : args.keySet()) {
                String optionValue = (String)args.get((Object)option);
                switch (option) {
                    case NAME: {
                        continue block18;
                    }
                    case MEMORY_CAPACITY: {
                        this.logFinestIfLoggable("Handling MEMORY_CAPACITY");
                        Object[] validationResult = this.validateMemoryParameter(optionValue);
                        if (validationResult != null) {
                            throw new IllegalArgumentException("Invalid value for option [" + option.getParamName() + "]: " + (String)validationResult);
                        }
                        ScaleHandler.logFineIfLoggable("Applying memoryCapacity on [" + optionValue + "]");
                        scaleStrategyConfigurer.getClass().getMethod("memoryCapacity", String.class).invoke(scaleStrategyConfigurer, optionValue);
                        continue block18;
                    }
                    case MAX_CONCURRENT_RELOCATIONS_PER_MACHINE: {
                        this.logFinestIfLoggable("Handling MAX_CONCURRENT_RELOCATIONS_PER_MACHINE");
                        try {
                            ScaleHandler.logFineIfLoggable("Applying maxConcurrentRelocationsPerMachine on [" + optionValue + "]");
                            scaleStrategyConfigurer.getClass().getMethod("maxConcurrentRelocationsPerMachine", Integer.TYPE).invoke(scaleStrategyConfigurer, Integer.valueOf(optionValue));
                            continue block18;
                        }
                        catch (NumberFormatException e) {
                            throw new IllegalArgumentException("Invalid value for option [" + option.getParamName() + "]: Must be a number");
                        }
                    }
                    case NUMBER_OF_CPU_CORES: {
                        this.logFinestIfLoggable("Handling NUMBER_OF_CPU_CORES");
                        try {
                            ScaleHandler.logFineIfLoggable("Applying numberOfCpuCores on [" + optionValue + "]");
                            scaleStrategyConfigurer.getClass().getMethod("numberOfCpuCores", Double.TYPE).invoke(scaleStrategyConfigurer, Double.valueOf(optionValue));
                            continue block18;
                        }
                        catch (NumberFormatException e) {
                            throw new IllegalArgumentException("Invalid value for option [" + option.getParamName() + "]: Must be a number");
                        }
                    }
                }
                throw new IllegalArgumentException("Unhandled scale option [" + option.getParamName() + "]");
            }
            Object scaleConfig = scaleStrategyConfigurer.getClass().getMethod("create", new Class[0]).invoke(scaleStrategyConfigurer, new Object[0]);
            Object adminFactory = this.adminFactoryClass.newInstance();
            if (GS.settings != null) {
                Object[] groups;
                Object[] locators = (LookupLocator[])GS.settings.get("locators");
                if (locators != null) {
                    if (LOGGER.isLoggable(Level.FINE)) {
                        LOGGER.fine("Locators: " + Arrays.toString(locators));
                    }
                    for (Object lookupLocator : locators) {
                        adminFactory.getClass().getMethod("addLocator", String.class).invoke(adminFactory, lookupLocator.getHost() + ":" + lookupLocator.getPort());
                    }
                }
                if ((groups = (String[])GS.settings.get("groups")) != null) {
                    if (LOGGER.isLoggable(Level.FINE)) {
                        LOGGER.fine("Groups: " + Arrays.toString(groups));
                    }
                    for (Object group : groups) {
                        adminFactory.getClass().getMethod("addGroup", String.class).invoke(adminFactory, group);
                    }
                }
            }
            if ((credentialsProvider = CLISecurityRepository.getInstance().getCurrentCredentialsProvider()) != null) {
                LOGGER.fine("Setting Credentials Provider for Admin Factory");
                Statement scaleStatement = new Statement(adminFactory, "credentialsProvider", new Object[]{credentialsProvider});
                scaleStatement.execute();
            }
            Object admin = adminFactory.getClass().getMethod("create", new Class[0]).invoke(adminFactory, new Object[0]);
            try {
                Object pus = admin.getClass().getMethod("getProcessingUnits", new Class[0]).invoke(admin, new Object[0]);
                Object pu = pus.getClass().getMethod("waitFor", String.class, Long.TYPE, TimeUnit.class).invoke(pus, new Object[]{puName, 10, TimeUnit.SECONDS});
                if (pu == null) {
                    admin.getClass().getMethod("close", new Class[0]).invoke(admin, new Object[0]);
                    return "Failed to find processing unit with name [" + puName + "] within 10 seconds.";
                }
                Statement statement = new Statement(pu, OPERATION_NAME, new Object[]{scaleConfig});
                statement.execute();
                admin.getClass().getMethod("close", new Class[0]).invoke(admin, new Object[0]);
                return "Command executed successfully";
            }
            catch (Exception e) {
                admin.getClass().getMethod("close", new Class[0]).invoke(admin, new Object[0]);
                throw e;
            }
        }
        catch (IllegalArgumentException e) {
            Object[] localCommandArgLine = CLIUtilities.getArgLineWithScreenPassword(arr);
            String msg = "Error scaling " + Arrays.toString(localCommandArgLine);
            LOGGER.log(Level.SEVERE, msg, e);
            if (e.getMessage() != null) {
                System.out.println(msg);
                System.out.println(e.getMessage());
            } else {
                System.out.println(msg);
                System.out.println(e.toString());
            }
            System.out.println(this.getUsage());
        }
        catch (InvocationTargetException e) {
            Object[] localCommandArgLine = CLIUtilities.getArgLineWithScreenPassword(arr);
            String msg = "Error scaling " + Arrays.toString(localCommandArgLine);
            LOGGER.log(Level.SEVERE, msg, e);
            if (e.getTargetException() != null && e.getTargetException().getMessage() != null) {
                System.out.println(msg + ":" + e.getTargetException().getMessage());
            } else {
                System.out.println(msg + ":" + e.toString());
            }
        }
        catch (Throwable e) {
            Object[] localCommandArgLine = CLIUtilities.getArgLineWithScreenPassword(arr);
            String msg = "Error scaling " + Arrays.toString(localCommandArgLine);
            LOGGER.log(Level.SEVERE, msg, e);
            System.out.println(msg + ":" + e.toString());
        }
        return "";
    }

    @Override
    public String getUsage() {
        StringBuilder sb = new StringBuilder();
        sb.append("Usage: \n\t scale [options] \n");
        sb.append("\n");
        sb.append("Available options: \n");
        for (ScaleOption option : ScaleOption.values()) {
            sb.append("\t" + option.getParamUsage() + "\n");
        }
        return sb.toString();
    }

    private static void logFineIfLoggable(String msg) {
        if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.fine(msg);
        }
    }

    private void logFinestIfLoggable(String msg) {
        if (LOGGER.isLoggable(Level.FINEST)) {
            LOGGER.finest(msg);
        }
    }

    private static enum ScaleOption {
        NAME("name", "-name [processing unit name] \t\t\t\t\t : *Required"),
        NUMBER_OF_CPU_CORES("number-of-cpu-cores", "nocc", "-nocc, -number-of-cpu-cores [number] \t\t\t\t : Specifies the number of CPU cores (as reported by the operating system)"),
        MEMORY_CAPACITY("memory-capacity", "mc", "-mc, -memory-capacity [number[m/g]] \t\t\t\t : Specifies the memory capacity (RAM)"),
        MAX_CONCURRENT_RELOCATIONS_PER_MACHINE("max-concurrent-relocations-per-machine", "mcrpm", "-mcrpm, -max-concurrent-relocations-per-machine [number] \t : Specifies the number of processing unit instance relocations each machine can handle concurrently");

        private final String paramName;
        private final String shortParamName;
        private final String paramUsage;

        private ScaleOption(String paramName, String paramUsage) {
            this.paramName = paramName;
            this.shortParamName = null;
            this.paramUsage = paramUsage;
        }

        private ScaleOption(String paramName, String shortParamName, String paramUsage) {
            this.paramName = paramName;
            this.shortParamName = shortParamName;
            this.paramUsage = paramUsage;
        }

        public String getParamName() {
            return this.paramName;
        }

        public String getShortParamName() {
            return this.shortParamName;
        }

        public String getParamUsage() {
            return this.paramUsage;
        }

        public static ScaleOption findByParamName(String paramName) {
            for (ScaleOption option : ScaleOption.values()) {
                if (!option.getParamName().equals(paramName) && (option.getShortParamName() == null || !option.getShortParamName().equals(paramName))) continue;
                return option;
            }
            return null;
        }
    }
}

