/*
 * Decompiled with CFR 0.152.
 */
package com.gigaspaces.admin.cli;

import com.gigaspaces.admin.cli.GS;
import com.gigaspaces.admin.cli.utils.CLISecurityRepository;
import com.gigaspaces.admin.discovery.RecordingDiscoveryListener;
import com.gigaspaces.admin.discovery.ReggieStat;
import com.gigaspaces.grid.gsa.GSA;
import com.gigaspaces.grid.gsm.GSM;
import com.gigaspaces.internal.jvm.JVMInfoProvider;
import com.gigaspaces.start.SystemConfig;
import com.j_spaces.core.IJSpace;
import com.sun.jini.lookup.entry.LookupAttributes;
import java.io.IOException;
import java.lang.reflect.Field;
import java.rmi.RemoteException;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.jini.admin.Administrable;
import net.jini.admin.JoinAdmin;
import net.jini.config.Configuration;
import net.jini.config.ConfigurationException;
import net.jini.core.discovery.LookupLocator;
import net.jini.core.entry.Entry;
import net.jini.core.lookup.ServiceID;
import net.jini.core.lookup.ServiceItem;
import net.jini.core.lookup.ServiceRegistrar;
import net.jini.core.lookup.ServiceTemplate;
import net.jini.discovery.DiscoveryListener;
import net.jini.discovery.DiscoveryManagement;
import net.jini.discovery.LookupDiscoveryManager;
import net.jini.discovery.LookupGroups;
import net.jini.lease.LeaseRenewalManager;
import net.jini.lookup.BackwardsServiceDiscoveryManager;
import net.jini.lookup.DiscoveryAdmin;
import net.jini.lookup.LookupCache;
import net.jini.lookup.ServiceDiscoveryEvent;
import net.jini.lookup.ServiceDiscoveryListener;
import net.jini.lookup.ServiceDiscoveryManager;
import net.jini.lookup.ServiceItemFilter;
import net.jini.lookup.entry.Name;
import org.jini.rio.cybernode.Cybernode;
import org.jini.rio.entry.ApplianceInfo;
import org.jini.rio.entry.ComputeResourceUtilization;
import org.jini.rio.monitor.ProvisionMonitor;
import org.jini.rio.resources.resource.PoolableThread;
import org.jini.rio.resources.resource.ResourceUnavailableException;
import org.jini.rio.resources.resource.ThreadPool;

public class ServiceFinder {
    private final ServiceDiscoveryManager sdm;
    private LookupCache allServicesCache;
    private LookupCache gscCache;
    private LookupCache gsmCache;
    private LookupCache gsaCache;
    private LookupCache spaceCache;
    private final ServiceTemplate allServices;
    private final ServiceTemplate gscServices;
    private final ServiceTemplate gsmServices;
    private final ServiceTemplate gsaServices;
    private final ServiceTemplate spaceServices;
    private final ArrayList<ServiceInfo> serviceInfo = new ArrayList();
    private final ThreadPool serviceInfoFetchPool;
    private final Map<Thread, InfoFetchStat> poolMap = Collections.synchronizedMap(new HashMap());
    private final RecordingDiscoveryListener recordingDiscoveryListener;
    private final String[] groups;
    private static final Logger logger = Logger.getLogger("com.gigaspaces.admin.cli");

    public String[] getGroups() {
        return this.groups;
    }

    public ServiceFinder(String[] groups, LookupLocator[] locators) throws IOException, ConfigurationException {
        this.groups = groups;
        Configuration config = SystemConfig.getInstance().getConfiguration();
        int serviceInfoPoolSize = (Integer)config.getEntry("com.gigaspaces.admin.cli", "serviceInfoPoolSize", Integer.TYPE, (Object)50);
        this.serviceInfoFetchPool = new ThreadPool("(GS)Service Info Fetch Pool", 1, serviceInfoPoolSize);
        LookupDiscoveryManager discoMgr = new LookupDiscoveryManager(groups, locators, null, config);
        this.recordingDiscoveryListener = new RecordingDiscoveryListener();
        discoMgr.addDiscoveryListener((DiscoveryListener)this.recordingDiscoveryListener);
        this.sdm = new BackwardsServiceDiscoveryManager((DiscoveryManagement)discoMgr, new LeaseRenewalManager(), config);
        this.allServices = new ServiceTemplate(null, null, null);
        this.gscServices = new ServiceTemplate(null, new Class[]{Cybernode.class}, null);
        this.gsmServices = new ServiceTemplate(null, new Class[]{ProvisionMonitor.class}, null);
        this.gsaServices = new ServiceTemplate(null, new Class[]{GSA.class}, null);
        this.spaceServices = new ServiceTemplate(null, new Class[]{IJSpace.class}, null);
        if (!GS.commandLine) {
            this.allServicesCache = this.sdm.createLookupCache(this.allServices, null, (ServiceDiscoveryListener)new ServiceListener());
            SecurityUpdateServiceListener securityUpdateServiceListener = new SecurityUpdateServiceListener();
            this.gscCache = this.sdm.createLookupCache(this.gscServices, null, (ServiceDiscoveryListener)securityUpdateServiceListener);
            this.gsmCache = this.sdm.createLookupCache(this.gsmServices, null, (ServiceDiscoveryListener)securityUpdateServiceListener);
            this.gsaCache = this.sdm.createLookupCache(this.gsaServices, null, (ServiceDiscoveryListener)securityUpdateServiceListener);
            this.spaceCache = this.sdm.createLookupCache(this.spaceServices, null, (ServiceDiscoveryListener)securityUpdateServiceListener);
        }
    }

    ReggieStat[] getReggieStats(int type) {
        return this.recordingDiscoveryListener.getReggieStats(type);
    }

    public void terminate() {
        this.sdm.terminate();
    }

    public ServiceItem[] find(String[] machines, Entry[] attrs) {
        ServiceItem[] results;
        block7: {
            results = new ServiceItem[]{};
            try {
                ServiceFilter filter = null;
                if (machines != null && machines.length > 0 || attrs != null && attrs.length > 0) {
                    filter = new ServiceFilter(machines, attrs);
                }
                if (!GS.commandLine) {
                    results = this.allServicesCache.lookup((ServiceItemFilter)filter, Integer.MAX_VALUE);
                    if (results.length == 0) {
                        System.out.println("num lookups " + this.getDiscoveryManagement().getRegistrars().length + ", total services " + results.length);
                    } else {
                        System.out.println("total services " + results.length);
                    }
                } else {
                    long timeOut = (Long)GS.settings.get("disco-timeout");
                    long t0 = System.currentTimeMillis();
                    results = this.sdm.lookup(this.allServices, 1, Integer.MAX_VALUE, (ServiceItemFilter)filter, timeOut);
                    long t1 = System.currentTimeMillis();
                    System.out.println("total " + results.length);
                    System.out.println("discovery time " + (t1 - t0) + " millis, " + (t1 - t0) / 1000L + " seconds, timeout used " + timeOut + "\n");
                }
            }
            catch (Exception e) {
                if (!logger.isLoggable(Level.SEVERE)) break block7;
                logger.log(Level.SEVERE, e.toString(), e);
            }
        }
        return results;
    }

    public ServiceItem[] findGSCs(String[] machines, Entry[] attrs) {
        ServiceItem[] results;
        block5: {
            results = new ServiceItem[]{};
            try {
                ServiceFilter filter = null;
                if (machines != null && machines.length > 0 || attrs != null && attrs.length > 0) {
                    filter = new ServiceFilter(machines, attrs);
                }
                if (!GS.commandLine) {
                    results = this.gscCache.lookup((ServiceItemFilter)filter, Integer.MAX_VALUE);
                    System.out.println("total " + results.length);
                } else {
                    long timeOut = (Long)GS.settings.get("disco-timeout");
                    long t0 = System.currentTimeMillis();
                    results = this.sdm.lookup(this.gscServices, Integer.MAX_VALUE, Integer.MAX_VALUE, (ServiceItemFilter)filter, timeOut);
                    long t1 = System.currentTimeMillis();
                    System.out.println("total " + results.length);
                    System.out.println("discovery time " + (t1 - t0) + " millis, timeout used " + timeOut + "\n");
                }
            }
            catch (Exception e) {
                if (!logger.isLoggable(Level.SEVERE)) break block5;
                logger.log(Level.SEVERE, e.toString(), e);
            }
        }
        return results;
    }

    public ServiceItem[] findGSAs(String[] machines, Entry[] attrs) {
        ServiceItem[] results;
        block5: {
            results = new ServiceItem[]{};
            try {
                ServiceFilter filter = null;
                if (machines != null && machines.length > 0 || attrs != null && attrs.length > 0) {
                    filter = new ServiceFilter(machines, attrs);
                }
                if (!GS.commandLine) {
                    results = this.gsaCache.lookup((ServiceItemFilter)filter, Integer.MAX_VALUE);
                    System.out.println("total " + results.length);
                } else {
                    long timeOut = (Long)GS.settings.get("disco-timeout");
                    long t0 = System.currentTimeMillis();
                    results = this.sdm.lookup(this.gsaServices, Integer.MAX_VALUE, Integer.MAX_VALUE, (ServiceItemFilter)filter, timeOut);
                    long t1 = System.currentTimeMillis();
                    System.out.println("total " + results.length);
                    System.out.println("discovery time " + (t1 - t0) + " millis, timeout used " + timeOut + "\n");
                }
            }
            catch (Exception e) {
                if (!logger.isLoggable(Level.SEVERE)) break block5;
                logger.log(Level.SEVERE, e.toString(), e);
            }
        }
        return results;
    }

    public ServiceItem[] findSpaces(String[] machines, Entry[] attrs) {
        ServiceItem[] results;
        block5: {
            results = new ServiceItem[]{};
            try {
                ServiceFilter filter = null;
                if (machines != null && machines.length > 0 || attrs != null && attrs.length > 0) {
                    filter = new ServiceFilter(machines, attrs);
                }
                if (!GS.commandLine) {
                    results = this.spaceCache.lookup((ServiceItemFilter)filter, Integer.MAX_VALUE);
                    System.out.println("total " + results.length);
                } else {
                    long timeOut = (Long)GS.settings.get("disco-timeout");
                    long t0 = System.currentTimeMillis();
                    results = this.sdm.lookup(this.spaceServices, Integer.MAX_VALUE, Integer.MAX_VALUE, (ServiceItemFilter)filter, timeOut);
                    long t1 = System.currentTimeMillis();
                    System.out.println("total " + results.length);
                    System.out.println("discovery time " + (t1 - t0) + " millis, timeout used " + timeOut + "\n");
                }
            }
            catch (Exception e) {
                if (!logger.isLoggable(Level.SEVERE)) break block5;
                logger.log(Level.SEVERE, e.toString(), e);
            }
        }
        return results;
    }

    public List<ServiceItem> getAllSecuredServices() {
        ServiceItem[] gsmServicesArray = this.findGSMs(null, null);
        ServiceItem[] gscServicesArray = this.findGSCs(null, null);
        ServiceItem[] spaceServicesArray = this.findSpaces(null, null);
        ServiceItem[] gsaServicesArray = this.findGSAs(null, null);
        ServiceItem[] allServicesArray = new ServiceItem[gsmServicesArray.length + gscServicesArray.length + spaceServicesArray.length + gsaServicesArray.length];
        System.arraycopy(gsmServicesArray, 0, allServicesArray, 0, gsmServicesArray.length);
        System.arraycopy(gscServicesArray, 0, allServicesArray, gsmServicesArray.length, gscServicesArray.length);
        System.arraycopy(spaceServicesArray, 0, allServicesArray, gsmServicesArray.length + gscServicesArray.length, spaceServicesArray.length);
        System.arraycopy(gsaServicesArray, 0, allServicesArray, gsmServicesArray.length + gscServicesArray.length + spaceServicesArray.length, gsaServicesArray.length);
        ArrayList<ServiceItem> securedServicesList = new ArrayList<ServiceItem>(allServicesArray.length);
        for (ServiceItem serviceItem : allServicesArray) {
            securedServicesList.add(serviceItem);
        }
        return securedServicesList;
    }

    public ServiceItem[] findGSMs(String[] machines, Entry[] attrs) {
        ServiceItem[] results;
        block5: {
            results = new ServiceItem[]{};
            try {
                ServiceFilter filter = null;
                if (machines != null && machines.length > 0 || attrs != null && attrs.length > 0) {
                    filter = new ServiceFilter(machines, attrs);
                }
                if (!GS.commandLine) {
                    results = this.gsmCache.lookup((ServiceItemFilter)filter, Integer.MAX_VALUE);
                    System.out.println("Found " + results.length + " GSMs");
                } else {
                    long timeOut = (Long)GS.settings.get("disco-timeout");
                    long t0 = System.currentTimeMillis();
                    results = this.sdm.lookup(this.gsmServices, Integer.MAX_VALUE, Integer.MAX_VALUE, (ServiceItemFilter)filter, timeOut);
                    long t1 = System.currentTimeMillis();
                    System.out.println("Found " + results.length + " GSMs");
                    System.out.println("discovery time " + (t1 - t0) + " millis, timeout used " + timeOut + "\n");
                }
            }
            catch (Exception e) {
                if (!logger.isLoggable(Level.SEVERE)) break block5;
                logger.log(Level.SEVERE, e.toString(), e);
            }
        }
        this.orderByManagingFirst(results);
        return results;
    }

    private void orderByManagingFirst(ServiceItem[] results) {
        int managingIdx = -1;
        for (int i = 0; i < results.length; ++i) {
            try {
                if (!((GSM)results[i].getService()).isManaging()) continue;
                managingIdx = i;
                break;
            }
            catch (RemoteException remoteException) {
                // empty catch block
            }
        }
        if (managingIdx > 0) {
            ServiceItem managing = results[managingIdx];
            results[managingIdx] = results[0];
            results[0] = managing;
        }
    }

    public DiscoveryManagement getDiscoveryManagement() {
        return this.sdm.getDiscoveryManager();
    }

    void resolveServiceInfo(ServiceInfo sInfo) {
        boolean resolved = false;
        for (int i = 0; i < 5; ++i) {
            try {
                this.doResolve(sInfo);
                resolved = true;
                break;
            }
            catch (IllegalStateException e) {
                if (!logger.isLoggable(Level.SEVERE)) continue;
                logger.log(Level.SEVERE, e.toString(), e);
                continue;
            }
            catch (ResourceUnavailableException e) {
                int max = this.serviceInfoFetchPool.getMax();
                this.serviceInfoFetchPool.setMax(max + 1);
            }
        }
        if (!resolved) {
            System.err.println("There are no available threads in the ThreadPool to obtain service information for the [" + sInfo.name + "] service, ignoring...");
        }
    }

    void doResolve(ServiceInfo sInfo) throws ResourceUnavailableException {
        PoolableThread thread = (PoolableThread)this.serviceInfoFetchPool.get(10000L);
        InfoFetchStat i = new InfoFetchStat(sInfo.getServiceName());
        i.starTime = System.currentTimeMillis();
        this.poolMap.put((Thread)thread, i);
        thread.execute((Runnable)new InfoFetcher(sInfo, thread));
    }

    Map<Thread, InfoFetchStat> getPoolables() {
        HashMap<Thread, InfoFetchStat> poolables = new HashMap<Thread, InfoFetchStat>();
        poolables.putAll(this.poolMap);
        return poolables;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ServiceInfo[] getServiceInfo() {
        ServiceInfo[] info;
        ArrayList<ServiceInfo> arrayList = this.serviceInfo;
        synchronized (arrayList) {
            info = this.serviceInfo.toArray(new ServiceInfo[this.serviceInfo.size()]);
        }
        return info;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ServiceInfo getServiceInfo(ServiceID serviceID) {
        ServiceInfo si = null;
        ArrayList<ServiceInfo> arrayList = this.serviceInfo;
        synchronized (arrayList) {
            for (ServiceInfo sInfo : this.serviceInfo) {
                if (!sInfo.getServiceItem().serviceID.equals((Object)serviceID)) continue;
                si = sInfo;
                break;
            }
        }
        return si;
    }

    public static String getName(Entry[] attrs) {
        int x;
        String name = null;
        for (x = 0; x < attrs.length; ++x) {
            if (!(attrs[x] instanceof Name)) continue;
            name = ((Name)attrs[x]).name;
            break;
        }
        if (name == null) {
            for (x = 0; x < attrs.length; ++x) {
                if (!(attrs[x] instanceof net.jini.lookup.entry.ServiceInfo)) continue;
                name = ((net.jini.lookup.entry.ServiceInfo)attrs[x]).name;
                break;
            }
        }
        return name;
    }

    public ServiceItem lookupServiceItem(ServiceID serviceID) {
        ServiceTemplate serviceTemplate = new ServiceTemplate(serviceID, null, null);
        ServiceItem serviceItem = this.sdm.lookup(serviceTemplate, null);
        return serviceItem;
    }

    public static String getCPU(Entry[] attrs) {
        String cpu = "n/a";
        for (int x = 0; x < attrs.length; ++x) {
            if (!(attrs[x] instanceof ComputeResourceUtilization)) continue;
            ComputeResourceUtilization cru = (ComputeResourceUtilization)attrs[x];
            Double dCpu = (Double)cru.utilizationMap.get("CPU");
            if (dCpu == null) break;
            NumberFormat numberFormatter = NumberFormat.getPercentInstance();
            numberFormatter.setMaximumFractionDigits(2);
            cpu = numberFormatter.format(dCpu);
            break;
        }
        return cpu;
    }

    public static class InfoFetchStat {
        final String name;
        String host = "<?>";
        long starTime;
        long stopTime;

        InfoFetchStat(String name) {
            this.name = name;
        }
    }

    public class InfoFetcher
    implements Runnable {
        ServiceInfo sInfo;
        PoolableThread thread;

        InfoFetcher(ServiceInfo sInfo, PoolableThread thread) {
            this.sInfo = sInfo;
            this.thread = thread;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            block27: {
                try {
                    ServiceItem item = this.sInfo.getServiceItem();
                    Object service = item.getService();
                    if (service instanceof ServiceRegistrar) {
                        try {
                            this.sInfo.setHost(((ServiceRegistrar)service).getLocator().getHost());
                            this.updateHost(Thread.currentThread(), this.sInfo.getHost());
                        }
                        catch (RemoteException e) {
                            if (logger.isLoggable(Level.SEVERE)) {
                                logger.log(Level.SEVERE, e.toString(), e);
                            }
                        }
                    } else {
                        ApplianceInfo ai = ApplianceInfo.getApplianceInfo((Entry[])item.attributeSets);
                        if (ai != null) {
                            if (ai.hostName.equals(ai.hostAddress)) {
                                this.sInfo.setHost(ai.hostName);
                            } else {
                                this.sInfo.setHost(ai.hostName + "@" + ai.hostAddress);
                            }
                            this.updateHost(Thread.currentThread(), this.sInfo.getHost());
                        } else {
                            String hostName = null;
                            for (int i = 0; i < item.attributeSets.length; ++i) {
                                if (!item.attributeSets[i].getClass().getName().equals("com.j_spaces.lookup.entry.HostName")) continue;
                                try {
                                    Field name = item.attributeSets[i].getClass().getDeclaredField("name");
                                    hostName = (String)name.get(item.attributeSets[i]);
                                    continue;
                                }
                                catch (Exception e) {
                                    if (!logger.isLoggable(Level.FINE)) continue;
                                    logger.log(Level.FINE, "EXCEPTION GETTING com.j_spaces.lookup.entry.HostName FOR [" + this.sInfo.getServiceName() + "]", e);
                                }
                            }
                            if (hostName != null) {
                                this.sInfo.setHost(hostName);
                                this.updateHost(Thread.currentThread(), this.sInfo.getHost());
                            }
                        }
                    }
                    if (!(service instanceof Administrable)) break block27;
                    try {
                        String[] groups = new String[]{};
                        Object admin = null;
                        try {
                            admin = ((Administrable)service).getAdmin();
                        }
                        catch (Exception e) {
                            logger.log(Level.WARNING, e.toString());
                        }
                        if (admin instanceof JoinAdmin) {
                            groups = ((JoinAdmin)admin).getLookupGroups();
                        }
                        if (groups.length == 0 && admin instanceof DiscoveryAdmin) {
                            groups = ((DiscoveryAdmin)admin).getMemberGroups();
                        }
                        if (groups == LookupGroups.all()) {
                            groups = new String[]{"ALL_GROUPS"};
                        }
                        this.sInfo.setGroups(groups);
                    }
                    catch (RemoteException e) {
                        if (!logger.isLoggable(Level.FINE)) break block27;
                        logger.log(Level.FINE, "EXCEPTION GETTING GROUPS FOR [" + this.sInfo.getServiceName() + "]", e);
                    }
                }
                catch (Throwable t) {
                    block28: {
                        try {
                            System.err.println("EXCEPTION GETTING ServiceInfo FOR [" + this.sInfo.getServiceName() + "]");
                            if (!logger.isLoggable(Level.SEVERE)) break block28;
                            logger.log(Level.SEVERE, t.toString(), t);
                        }
                        catch (Throwable throwable) {
                            long t1 = System.currentTimeMillis();
                            InfoFetchStat ifs = (InfoFetchStat)ServiceFinder.this.poolMap.remove(this.thread);
                            int size = ServiceFinder.this.poolMap.size();
                            ifs.stopTime = t1;
                            if (!GS.commandLine && logger.isLoggable(Level.FINE)) {
                                logger.log(Level.FINE, "ServiceInfo resolve time for [" + this.sInfo.getServiceName() + "] = " + (t1 - ifs.starTime) + ", pool size = " + size);
                            }
                            throw throwable;
                        }
                    }
                    long t1 = System.currentTimeMillis();
                    InfoFetchStat ifs = (InfoFetchStat)ServiceFinder.this.poolMap.remove(this.thread);
                    int size = ServiceFinder.this.poolMap.size();
                    ifs.stopTime = t1;
                    if (!GS.commandLine && logger.isLoggable(Level.FINE)) {
                        logger.log(Level.FINE, "ServiceInfo resolve time for [" + this.sInfo.getServiceName() + "] = " + (t1 - ifs.starTime) + ", pool size = " + size);
                    }
                }
            }
            long t1 = System.currentTimeMillis();
            InfoFetchStat ifs = (InfoFetchStat)ServiceFinder.this.poolMap.remove(this.thread);
            int size = ServiceFinder.this.poolMap.size();
            ifs.stopTime = t1;
            if (!GS.commandLine && logger.isLoggable(Level.FINE)) {
                logger.log(Level.FINE, "ServiceInfo resolve time for [" + this.sInfo.getServiceName() + "] = " + (t1 - ifs.starTime) + ", pool size = " + size);
            }
        }

        void updateHost(Thread t, String host) {
            InfoFetchStat ifs = (InfoFetchStat)ServiceFinder.this.poolMap.get(t);
            ifs.host = host;
            ServiceFinder.this.poolMap.put(t, ifs);
        }
    }

    public static class ServiceInfo {
        static final String UNKNOWN = "<?>";
        private String name = "<?>";
        private String[] groups = new String[]{"<?>"};
        private ServiceItem item;
        private String host = "<?>";
        private long pid = -1L;

        ServiceInfo(ServiceItem item) {
            this.setServiceItem(item);
        }

        void setServiceItem(ServiceItem item) {
            this.item = item;
            this.name = ServiceFinder.getName(item.attributeSets);
            if (this.name == null) {
                this.name = item.getClass().getName();
            }
            Object service = item.getService();
            try {
                if (service instanceof IJSpace) {
                    service = ((IJSpace)service).getAdmin();
                }
                if (service instanceof JVMInfoProvider) {
                    JVMInfoProvider jvmInfoProvider = (JVMInfoProvider)service;
                    this.pid = jvmInfoProvider.getJVMDetails().getPid();
                }
            }
            catch (RemoteException remoteException) {
                // empty catch block
            }
        }

        String getServiceName() {
            return this.name;
        }

        void setHost(String h) {
            this.host = h;
        }

        long getPid() {
            return this.pid;
        }

        String getHost() {
            return this.host;
        }

        void setGroups(String[] g) {
            this.groups = g;
        }

        String[] getGroups() {
            return this.groups;
        }

        ServiceItem getServiceItem() {
            return this.item;
        }

        public int hashCode() {
            return this.item.serviceID.hashCode();
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof ServiceInfo)) {
                return false;
            }
            ServiceInfo that = (ServiceInfo)obj;
            return this.item.serviceID.equals((Object)that.item.serviceID);
        }
    }

    public class ServiceListener
    implements ServiceDiscoveryListener {
        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void serviceAdded(ServiceDiscoveryEvent sdEvent) {
            ServiceItem item = sdEvent.getPostEventServiceItem();
            ServiceInfo sb = new ServiceInfo(item);
            boolean added = false;
            ArrayList arrayList = ServiceFinder.this.serviceInfo;
            synchronized (arrayList) {
                if (!ServiceFinder.this.serviceInfo.contains(sb)) {
                    added = ServiceFinder.this.serviceInfo.add(sb);
                }
            }
            if (added) {
                ServiceFinder.this.resolveServiceInfo(sb);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void serviceRemoved(ServiceDiscoveryEvent sdEvent) {
            ServiceItem item = sdEvent.getPreEventServiceItem();
            ServiceInfo[] info = ServiceFinder.this.getServiceInfo();
            for (int i = 0; i < info.length; ++i) {
                if (!((ServiceInfo)info[i]).item.serviceID.equals((Object)item.serviceID)) continue;
                ArrayList arrayList = ServiceFinder.this.serviceInfo;
                synchronized (arrayList) {
                    ServiceFinder.this.serviceInfo.remove(info[i]);
                    break;
                }
            }
        }

        public void serviceChanged(ServiceDiscoveryEvent sdEvent) {
            ServiceItem item = sdEvent.getPostEventServiceItem();
            ServiceInfo[] info = ServiceFinder.this.getServiceInfo();
            for (int i = 0; i < info.length; ++i) {
                if (!((ServiceInfo)info[i]).item.serviceID.equals((Object)item.serviceID)) continue;
                info[i].setServiceItem(item);
                break;
            }
        }
    }

    public static class SecurityUpdateServiceListener
    implements ServiceDiscoveryListener {
        public void serviceAdded(ServiceDiscoveryEvent sdEvent) {
            ServiceItem item = sdEvent.getPostEventServiceItem();
            CLISecurityRepository.getInstance().addService(item);
        }

        public void serviceRemoved(ServiceDiscoveryEvent sdEvent) {
            ServiceItem item = sdEvent.getPreEventServiceItem();
            CLISecurityRepository.getInstance().removeService(item.serviceID);
        }

        public void serviceChanged(ServiceDiscoveryEvent sdEvent) {
        }
    }

    public static class ServiceFilter
    implements ServiceItemFilter {
        private final String[] hostNames;
        private final Entry[] attrs;

        public ServiceFilter(String[] hostNames) {
            this(hostNames, null);
        }

        public ServiceFilter(String[] hostNames, Entry[] attrs) {
            this.hostNames = hostNames == null ? new String[0] : hostNames;
            this.attrs = attrs == null ? new Entry[0] : attrs;
        }

        /*
         * Unable to fully structure code
         */
        public boolean check(ServiceItem item) {
            matched = false;
            if (this.hostNames.length == 0) {
                matched = true;
            } else {
                service = item.getService();
                if (service instanceof ServiceRegistrar) {
                    try {
                        host = ((ServiceRegistrar)service).getLocator().getHost();
                        for (i = 0; i < this.hostNames.length; ++i) {
                            if (!this.hostNames[i].equalsIgnoreCase(host)) continue;
                            matched = true;
                        }
                    }
                    catch (RemoteException e) {
                        if (!ServiceFinder.access$100().isLoggable(Level.SEVERE)) ** GOTO lbl19
                        ServiceFinder.access$100().log(Level.SEVERE, e.toString(), e);
                    }
                } else {
                    matched = this.hostNameMatches(item.attributeSets);
                }
            }
lbl19:
            // 6 sources

            if (matched) {
                matched = this.checkAttributes(item.attributeSets);
            }
            return matched;
        }

        public boolean hostNameMatches(Entry[] attrs) {
            ApplianceInfo ai = ApplianceInfo.getApplianceInfo((Entry[])attrs);
            if (ai != null) {
                return this.checkHosts(ai);
            }
            return false;
        }

        boolean checkHosts(ApplianceInfo aInfo) {
            boolean found = false;
            for (int i = 0; i < this.hostNames.length; ++i) {
                if (!this.hostNames[i].equalsIgnoreCase(aInfo.hostAddress) && !this.hostNames[i].equalsIgnoreCase(aInfo.hostName)) continue;
                found = true;
            }
            return found;
        }

        boolean checkAttributes(Entry[] attributes) {
            if (this.attrs.length == 0) {
                return true;
            }
            boolean matched = false;
            int numMatched = 0;
            for (int i = 0; i < this.attrs.length; ++i) {
                for (int j = 0; j < attributes.length; ++j) {
                    if (!LookupAttributes.matches((Entry)this.attrs[i], (Entry)attributes[j])) continue;
                    matched = true;
                    ++numMatched;
                    break;
                }
                if (!matched) break;
            }
            return numMatched == this.attrs.length;
        }
    }
}

