/*
 * Decompiled with CFR 0.152.
 */
package com.gigaspaces.admin.cli;

import com.sun.jini.proxy.BasicProxyTrustVerifier;
import java.rmi.Remote;
import java.rmi.RemoteException;
import java.rmi.server.ExportException;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.jini.config.Configuration;
import net.jini.config.ConfigurationException;
import net.jini.export.Exporter;
import net.jini.security.TrustVerifier;
import net.jini.security.proxytrust.ServerProxyTrust;
import org.jini.rio.config.ExporterConfig;
import org.jini.rio.core.ServiceBeanInstance;
import org.jini.rio.core.ServiceElement;
import org.jini.rio.core.ServiceProvisionListener;

public class ServiceProvisionNotification
implements ServiceProvisionListener,
ServerProxyTrust {
    Exporter exporter;
    ServiceProvisionListener provisionListener;
    int provisionedSuccessfully;
    int provisionFailures;
    int notificationCounter;
    int serviceCounter;
    boolean interactive = false;
    Object mutex = new Object();
    private static final Logger _logger = Logger.getLogger("com.gigaspaces.admin.cli");

    public ServiceProvisionNotification(Configuration config) throws ConfigurationException, ExportException {
        this.exporter = ExporterConfig.getExporter((Configuration)config, (String)"com.gigaspaces.admin", (String)"provisionListenerExporter");
        this.provisionListener = (ServiceProvisionListener)this.exporter.export((Remote)((Object)this));
    }

    public void unexport() {
        this.exporter.unexport(true);
    }

    public ServiceProvisionListener getServiceProvisionListener() {
        return this.provisionListener;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void notify(int serviceCount, long maxTimeout) {
        this.interactive = true;
        this.notificationCounter = 0;
        this.serviceCounter = serviceCount;
        Object object = this.mutex;
        synchronized (object) {
            block6: {
                try {
                    this.mutex.wait(maxTimeout);
                    this.interactive = false;
                    if (this.notificationCounter < this.serviceCounter) {
                        System.out.println("\t- There are [" + (this.serviceCounter - this.notificationCounter) + "] service provisioning requests outstanding");
                    }
                }
                catch (InterruptedException e) {
                    if (!_logger.isLoggable(Level.SEVERE)) break block6;
                    _logger.log(Level.SEVERE, e.toString(), e);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void receivedNotify() {
        if (this.interactive) {
            ++this.notificationCounter;
            if (this.notificationCounter == this.serviceCounter) {
                Object object = this.mutex;
                synchronized (object) {
                    this.mutex.notifyAll();
                }
            }
        }
    }

    public void succeeded(ServiceBeanInstance jsbInstance) throws RemoteException {
        ++this.provisionedSuccessfully;
        if (this.interactive) {
            System.out.println("\t[" + (this.notificationCounter + 1) + "] " + jsbInstance.getServiceBeanConfig().getName() + " provisioned to\t" + jsbInstance.getHostAddress());
        }
        this.receivedNotify();
    }

    public void failed(ServiceElement sElem, boolean resubmitted) throws RemoteException {
        ++this.provisionFailures;
        this.receivedNotify();
        if (this.interactive) {
            System.out.println("\t" + sElem.getName() + " provision failure");
        }
    }

    public TrustVerifier getProxyVerifier() {
        return new BasicProxyTrustVerifier((Object)this.provisionListener);
    }
}

