/*
 * Decompiled with CFR 0.152.
 */
package com.gigaspaces.admin.cli;

import com.gigaspaces.admin.cli.AbstractSpaceCommand;
import com.gigaspaces.admin.cli.CLIFinder;
import com.gigaspaces.admin.cli.CLIUtilities;
import com.gigaspaces.admin.cli.Formatter;
import com.gigaspaces.admin.cli.OptionHandler;
import com.gigaspaces.admin.cli.utils.CLISecurityUtils;
import com.gigaspaces.security.authorities.MonitorAuthority;
import com.gigaspaces.security.authorities.Privilege;
import com.gigaspaces.security.service.SecuredService;
import com.j_spaces.core.IJSpace;
import com.j_spaces.core.IJSpaceContainer;
import com.j_spaces.core.NoSuchNameException;
import com.j_spaces.core.admin.IRemoteJSpaceAdmin;
import com.j_spaces.core.admin.SpaceConfig;
import com.j_spaces.core.client.FinderException;
import com.j_spaces.core.cluster.ClusterPolicy;
import com.j_spaces.kernel.JSpaceUtilities;
import java.io.BufferedReader;
import java.rmi.RemoteException;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import net.jini.core.lookup.ServiceID;
import net.jini.core.lookup.ServiceItem;

public class SpaceConfiguration
extends AbstractSpaceCommand {
    private OptionHandler validOptions;
    public static final String OPERATION_NAME = "config";
    protected static final String YES_OPTION = "Yes";
    protected static final String NO_OPTION = "No";

    public SpaceConfiguration() {
        String[] validOptionsArray = new String[]{"h", "help", "url", "c", "cluster"};
        this.validOptions = new OptionHandler(Formatter.fromArray(validOptionsArray));
        this.operationName = OPERATION_NAME;
        this.searchedSpaceState = -1;
    }

    @Override
    public String getUsage() {
        StringBuffer strBuffer = this.getBasicUsage();
        return strBuffer.toString();
    }

    @Override
    public String process(String input, BufferedReader br) {
        try {
            Map<String, String> args = this.validOptions.getOptions(input, true);
            if (args.containsKey("h") || args.containsKey("help")) {
                return this.getUsage();
            }
            if (!args.containsKey("url")) {
                IJSpace[] spaces = this.getSelectedSpaceProxies(br);
                this.printSpacesConfig(spaces);
                return "";
            }
            String finderURL = args.get("url");
            if (JSpaceUtilities.isEmpty((String)finderURL, (boolean)true)) {
                CLIUtilities.printMissingValueMessage("url");
                return "";
            }
            Object foundObj = null;
            try {
                foundObj = this.find(finderURL);
            }
            catch (FinderException e) {
                return "";
            }
            if (foundObj == null) {
                CLIUtilities.printWrongServiceURLMessage(finderURL, finderURL != null && finderURL.indexOf("groups") >= 0, finderURL != null && finderURL.indexOf("locators") >= 0);
                return "";
            }
            IJSpace space = null;
            if (foundObj instanceof IJSpaceContainer) {
                ServiceItem[] serviceItemsArray = this.getContainerSpaces((IJSpaceContainer)foundObj, finderURL);
                IJSpace[] spacesArray = this.getSelectedFromListSpaceProxies(serviceItemsArray, br, -1);
                this.printSpacesConfig(spacesArray);
                return "";
            }
            if (foundObj instanceof IJSpace) {
                space = (IJSpace)foundObj;
            }
            String spaceName = space.getName();
            System.out.println("Started to print <" + spaceName + "> space configuration...");
            ClusterPolicy clusterPolicy = this.getClusterPolicy(space);
            if (clusterPolicy != null) {
                if (args.containsKey("c") || args.containsKey("cluster")) {
                    System.out.println("Attempting to receive cluster members...");
                    this.printClusterMembers(clusterPolicy);
                } else {
                    IJSpace[] selectedClusterMembers = this.getAllClusterMembers(clusterPolicy, br);
                    if (selectedClusterMembers == null) {
                        return "No cluster members found.";
                    }
                    this.printSpacesConfig(selectedClusterMembers);
                }
            } else {
                this.printSpaceConfig(space);
            }
        }
        catch (IllegalArgumentException e) {
            if (e.getMessage() != null) {
                System.out.println(e.getMessage());
            } else {
                System.out.println(e.toString());
            }
            System.out.println(this.getUsage());
        }
        catch (Exception ex) {
            System.out.println("Failed to print configuration. Please see CLI log file for details.");
            _logger.log(Level.SEVERE, ex.toString(), ex);
        }
        return "";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void printClusterMembers(ClusterPolicy clusterPolicy) throws RemoteException, FinderException, NoSuchNameException {
        Map<String, IJSpace> proxySpacesMap = CLIFinder.getClusterMembersSpaceProxies(clusterPolicy, this.searchedSpaceState);
        Set<Map.Entry<String, IJSpace>> entriesSet = proxySpacesMap.entrySet();
        int mapSize = proxySpacesMap.size();
        System.out.println("There are " + mapSize + " cluster space configurations to be printed.");
        int counter = 0;
        for (Map.Entry<String, IJSpace> mapEntry : entriesSet) {
            IJSpace spaceProxy = mapEntry.getValue();
            String memberName = mapEntry.getKey();
            try {
                if (spaceProxy == null) {
                    CLIUtilities.printWrongClusterMemberMessage(memberName);
                    continue;
                }
                System.out.println(" " + this.operationName + " of <" + memberName + "> cluster member (" + (counter + 1) + " of " + mapSize + "): ");
                this.printSpaceConfig(spaceProxy);
            }
            catch (Exception e) {
                System.out.println("Failed to print configuration of \"" + memberName + "\" member");
                _logger.log(Level.SEVERE, e.toString(), e);
            }
            finally {
                ++counter;
            }
        }
    }

    private void printSpacesConfig(IJSpace[] spaces) {
        if (spaces != null) {
            int selSpacesAmount = spaces.length;
            for (int i = 0; i < selSpacesAmount; ++i) {
                try {
                    this.printSpaceConfig(spaces[i]);
                    continue;
                }
                catch (Exception e) {
                    System.out.println("Failed to print configuration of spaces list");
                    _logger.log(Level.SEVERE, e.toString(), e);
                }
            }
        }
    }

    private void printSpaceConfig(IJSpace spaceProxy) throws Exception {
        ServiceID spaceID = JSpaceUtilities.getSpaceServiceID((IJSpace)spaceProxy);
        if (CLISecurityUtils.hasPermittedPermission((SecuredService)spaceProxy, spaceID, (Privilege)MonitorAuthority.MonitorPrivilege.MONITOR_PU, spaceProxy.isSecured())) {
            IRemoteJSpaceAdmin spaceAdmin = (IRemoteJSpaceAdmin)spaceProxy.getAdmin();
            SpaceConfig spaceConfig = spaceAdmin.getConfig();
            String spaceConfigDesc = spaceConfig.toString();
            System.out.println(spaceConfigDesc);
            _logger.log(Level.INFO, spaceConfigDesc);
        } else {
            String containerName = spaceProxy.getContainerName();
            String spaceName = spaceProxy.getName();
            String fullSpaceName = JSpaceUtilities.createFullSpaceName((String)containerName, (String)spaceName);
            System.out.println("You do not have the <" + MonitorAuthority.MonitorPrivilege.MONITOR_PU + "> permission which is required to view the configuration of secured space instance <" + fullSpaceName + ">.");
        }
    }
}

