/*
 * Decompiled with CFR 0.152.
 */
package com.gigaspaces.admin.cli;

import com.gigaspaces.admin.cli.AbstractSpaceCommand;
import com.gigaspaces.admin.cli.CLIFinder;
import com.gigaspaces.admin.cli.CLIUtilities;
import com.gigaspaces.admin.cli.Formatter;
import com.gigaspaces.admin.cli.GS;
import com.gigaspaces.admin.cli.OptionHandler;
import com.gigaspaces.admin.cli.utils.CLISecurityUtils;
import com.gigaspaces.internal.client.spaceproxy.IDirectSpaceProxy;
import com.gigaspaces.lrmi.TransportProtocolHelper;
import com.gigaspaces.management.client.MBeanServerConnectionFactory;
import com.gigaspaces.management.transport.ITransportConnection;
import com.gigaspaces.management.transport.TransportConstants;
import com.gigaspaces.security.authorities.MonitorAuthority;
import com.gigaspaces.security.authorities.Privilege;
import com.gigaspaces.security.service.SecuredService;
import com.j_spaces.core.IJSpace;
import com.j_spaces.core.IJSpaceContainer;
import com.j_spaces.core.admin.ContainerConfig;
import com.j_spaces.core.admin.IJSpaceContainerAdmin;
import com.j_spaces.core.admin.IRemoteJSpaceAdmin;
import com.j_spaces.core.client.FinderException;
import com.j_spaces.core.cluster.ClusterPolicy;
import com.j_spaces.kernel.JSpaceUtilities;
import com.j_spaces.lookup.entry.ContainerName;
import java.io.BufferedReader;
import java.io.IOException;
import java.rmi.RemoteException;
import java.text.DateFormat;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import javax.management.MBeanServerConnection;
import javax.management.ObjectName;
import net.jini.core.entry.Entry;
import net.jini.core.lookup.ServiceID;
import net.jini.core.lookup.ServiceItem;

public class SpaceConnections
extends AbstractSpaceCommand {
    private OptionHandler validOptions;
    public static final String OPERATION_NAME = "connections";
    private static final int[] _tabs = new int[]{15, 30, 26, 31, 29};
    private static final String[] _labels = new String[]{"Space Name", "Container Name", "Source space IP Address", "Destination client IP Address", "Connection Time"};
    private static final String YES_VAL = "Yes";
    private static final String NO_VAL = "No";
    private DateFormat df = DateFormat.getDateTimeInstance(2, 1);
    private Object[] params;
    private String[] signature;
    private Map<IJSpaceContainerAdmin, MBeanServerConnection> _mBeanServerConnectionsMap = new HashMap<IJSpaceContainerAdmin, MBeanServerConnection>();

    public SpaceConnections() {
        String[] validOptionsArray = new String[]{"h", "help", "url", "c", "cluster"};
        this.validOptions = new OptionHandler(Formatter.fromArray(validOptionsArray));
        this.searchedSpaceState = -1;
        this.params = new Long[1];
        this.signature = new String[1];
        this.signature[0] = Long.TYPE.getName();
    }

    @Override
    public String getUsage() {
        StringBuffer strBuffer = new StringBuffer();
        strBuffer.append("\n*****************************************************\n");
        strBuffer.append("Usage: space connections [options]\n");
        strBuffer.append("options:\n");
        strBuffer.append("\t-h/-help    prints help\n");
        strBuffer.append("\t-url    space url\n");
        strBuffer.append("\t-c/-cluster    cluster operation\n");
        return strBuffer.toString();
    }

    @Override
    public String process(String input, BufferedReader br) {
        try {
            Map<String, String> args = this.validOptions.getOptions(input, true);
            if (args.containsKey("h") || args.containsKey("help")) {
                return this.getUsage();
            }
            ServiceItem[] items = null;
            String finderURL = args.get("url");
            if (args.containsKey("url")) {
                ClusterPolicy clusterPolicy;
                if (JSpaceUtilities.isEmpty((String)finderURL, (boolean)true)) {
                    CLIUtilities.printMissingValueMessage("url");
                    return "";
                }
                Object foundObj = null;
                try {
                    foundObj = this.find(finderURL);
                }
                catch (FinderException e) {
                    return "";
                }
                if (foundObj == null) {
                    CLIUtilities.printWrongServiceURLMessage(finderURL, finderURL != null && finderURL.indexOf("groups") >= 0, finderURL != null && finderURL.indexOf("locators") >= 0);
                    return "";
                }
                IJSpace spaceProxy = null;
                if (foundObj instanceof IJSpaceContainer) {
                    ServiceItem[] serviceItemsArray = this.getContainerSpaces((IJSpaceContainer)foundObj, finderURL);
                    this.spaceLister(serviceItemsArray);
                    return "";
                }
                if (foundObj instanceof IJSpace) {
                    spaceProxy = (IJSpace)foundObj;
                }
                if ((clusterPolicy = this.getClusterPolicy(spaceProxy)) != null) {
                    if (args.containsKey("c") || args.containsKey("cluster")) {
                        System.out.println("Attempting to receive cluster members...");
                        items = CLIFinder.findClusterMembers(clusterPolicy, this.searchedSpaceState);
                    } else {
                        String response = this.showClusterWarningMessageAndReadUserInput(br);
                        if (response == null || response.equals("c")) {
                            return "";
                        }
                        items = response.equals("n") ? CLIFinder.findSpaceServices(finderURL, this.searchedSpaceState) : CLIFinder.findClusterMembers(clusterPolicy, this.searchedSpaceState);
                    }
                } else {
                    items = CLIFinder.findSpaceServices(finderURL, this.searchedSpaceState);
                }
            } else {
                items = GS.getServiceFinder().findSpaces(null, null);
            }
            if (items != null) {
                this.spaceLister(items);
            }
        }
        catch (IllegalArgumentException e) {
            if (e.getMessage() != null) {
                System.out.println(e.getMessage());
            } else {
                System.out.println(e.toString());
            }
            System.out.println(this.getUsage());
        }
        catch (Exception ex) {
            _logger.log(Level.SEVERE, ex.toString(), ex);
        }
        return "";
    }

    protected String showClusterWarningMessageAndReadUserInput(BufferedReader br) throws IOException {
        String message = "The space is clustered.Do you want to display connections of all the spaces members in this cluster?\nEnter \"y\" for Yes, \"n\" for displaying connections of only one space.";
        System.out.println(message);
        return br.readLine();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void spaceLister(ServiceItem[] items) {
        if (items == null || items.length == 0) {
            return;
        }
        StringBuilder strBuff = null;
        System.out.println("\n" + SpaceConnections.createLabel(_labels));
        String sep = "-----------------------------------------------------------------------------------------------------------------------------------";
        System.out.println(sep);
        for (int i = 0; i < items.length; ++i) {
            ContainerConfig containerConfig;
            ServiceID serviceID;
            String containerName;
            String spaceName;
            IJSpace space;
            block16: {
                space = (IJSpace)items[i].getService();
                spaceName = space.getName();
                containerName = "-";
                Entry[] entriesArray = items[i].attributeSets;
                serviceID = items[i].serviceID;
                ContainerName containerNameEntry = (ContainerName)this.getEntryClass(entriesArray, ContainerName.class);
                containerConfig = null;
                try {
                    containerConfig = space.getDirectProxy().getContainerConfig();
                    containerName = containerNameEntry != null ? containerNameEntry.name : space.getContainerName();
                }
                catch (RemoteException re) {
                    if (!_logger.isLoggable(Level.FINEST)) break block16;
                    _logger.log(Level.FINEST, re.toString(), re);
                }
            }
            if (CLISecurityUtils.hasPermittedPermission((SecuredService)space, serviceID, (Privilege)MonitorAuthority.MonitorPrivilege.MONITOR_PU, space.isSecured())) {
                try {
                    if (containerConfig.isJMXEnabled()) {
                        IRemoteJSpaceAdmin remoteAdminSpace = (IRemoteJSpaceAdmin)((IDirectSpaceProxy)space).getRemoteJSpace();
                        long remoteObjID = TransportProtocolHelper.getRemoteObjID((Object)remoteAdminSpace);
                        if (remoteObjID < 0L) continue;
                        Long idParam = new Long(remoteObjID);
                        this.params[0] = idParam;
                        MBeanServerConnection mBeanServerConnection = null;
                        IJSpaceContainerAdmin containerAdmin = (IJSpaceContainerAdmin)space.getDirectProxy().getContainer();
                        if (containerAdmin != null) {
                            mBeanServerConnection = this._mBeanServerConnectionsMap.get(containerAdmin);
                        }
                        if (mBeanServerConnection == null) {
                            String jndiURL = containerConfig.jndiUrl;
                            mBeanServerConnection = MBeanServerConnectionFactory.createMBeanServerConnection((String)jndiURL);
                            if (containerAdmin != null) {
                                this._mBeanServerConnectionsMap.put(containerAdmin, mBeanServerConnection);
                            }
                        }
                        ObjectName transportMBeanName = TransportConstants.createTransportMBeanObjectName((String)containerName);
                        List list = (List)mBeanServerConnection.invoke(transportMBeanName, "getTransportConnections", this.params, this.signature);
                        for (ITransportConnection transportConnection : list) {
                            System.out.println(SpaceConnections.createLabel(new String[]{spaceName, containerName, transportConnection.getServerIPAddress() + ":" + transportConnection.getServerPort(), transportConnection.getClientIPAddress() + ":" + transportConnection.getClientPort(), this.df.format(transportConnection.getConnectTime())}));
                            System.out.println(sep);
                        }
                        System.out.println(JSpaceUtilities.LINE_SEPARATOR + list.size() + " connection(s) to \"" + containerName + ":" + spaceName + "\" space");
                        if (i + 1 >= items.length) continue;
                        System.out.println(JSpaceUtilities.LINE_SEPARATOR + JSpaceUtilities.LINE_SEPARATOR);
                        continue;
                    }
                    System.out.println(SpaceConnections.createLabel(new String[]{spaceName, containerName, "JMX disabled", "", ""}));
                    System.out.println(sep);
                    continue;
                }
                catch (Exception e) {
                    if (!_logger.isLoggable(Level.SEVERE)) continue;
                    _logger.log(Level.SEVERE, e.toString(), e);
                    continue;
                }
                finally {
                    if (strBuff != null && strBuff.length() > 0) {
                        System.out.println(strBuff.toString());
                    }
                }
            }
            String fullSpaceName = JSpaceUtilities.createFullSpaceName((String)containerName, (String)spaceName);
            System.out.println("You do not have the <" + MonitorAuthority.MonitorPrivilege.MONITOR_PU + "> permission which is required to view the connection of secured space instance <" + fullSpaceName + ">.\n");
        }
        System.out.println();
    }

    private Entry getEntryClass(Entry[] entriesArray, Class classInstance) {
        if (entriesArray != null) {
            for (Entry entry : entriesArray) {
                if (!entry.getClass().equals(classInstance)) continue;
                return entry;
            }
        }
        return null;
    }

    private static String createLabel(String[] labels) {
        String str = "";
        for (int j = 0; j < labels.length; ++j) {
            str = labels[j].length() >= _tabs[j] ? str + labels[j].substring(0, _tabs[j] - 1).concat(".") : str + labels[j];
            for (int s = 0; s < _tabs[j] - labels[j].length(); ++s) {
                str = str + ' ';
            }
        }
        return str;
    }
}

