/*
 * Decompiled with CFR 0.152.
 */
package com.gigaspaces.admin.cli;

import com.gigaspaces.admin.cli.CleanSpace;
import com.gigaspaces.admin.cli.ClusterMembers;
import com.gigaspaces.admin.cli.Constants;
import com.gigaspaces.admin.cli.CopySpace;
import com.gigaspaces.admin.cli.GS;
import com.gigaspaces.admin.cli.ListSpaces;
import com.gigaspaces.admin.cli.Ping;
import com.gigaspaces.admin.cli.SpaceConfiguration;
import com.gigaspaces.admin.cli.SpaceConnections;
import com.gigaspaces.admin.cli.SpaceSQL;
import com.gigaspaces.logger.GSLogConfigLoader;
import java.io.BufferedReader;
import java.util.HashMap;
import java.util.Map;
import java.util.StringTokenizer;

public class SpaceHandler
implements GS.OptionHandler,
Constants {
    public static final String OPERATION_NAME = "space";
    private static final Map<String, GS.OptionHandler> handlresMap = new HashMap<String, GS.OptionHandler>();
    private static final String SPACE_CLEAR_OPERATION = "clear";

    @Override
    public String process(String input, BufferedReader br) {
        StringTokenizer tok = new StringTokenizer(input);
        tok.nextToken();
        if (!tok.hasMoreTokens()) {
            return this.getUsage();
        }
        String value = tok.nextToken();
        GS.OptionHandler handler = handlresMap.get(value);
        if (handler == null) {
            System.out.println("Unknown option : " + value);
            return this.getUsage();
        }
        String args = "";
        while (tok.hasMoreTokens()) {
            args = args + tok.nextToken() + " ";
        }
        return handler.process(args, br);
    }

    @Override
    public String getUsage() {
        StringBuilder strBuffer = new StringBuilder();
        strBuffer.append("usage: space command [options]\n");
        strBuffer.append("\nAvailable commands (select a single command):");
        strBuffer.append("\n\t");
        strBuffer.append("clean");
        strBuffer.append(" | ");
        strBuffer.append(SPACE_CLEAR_OPERATION);
        strBuffer.append(" | ");
        strBuffer.append("config");
        strBuffer.append(" | ");
        strBuffer.append("list");
        strBuffer.append(" | ");
        strBuffer.append("connections");
        strBuffer.append("\n\t");
        strBuffer.append("ping");
        strBuffer.append(" | ");
        strBuffer.append("copy");
        strBuffer.append(" | ");
        strBuffer.append("sql");
        strBuffer.append(" | ");
        strBuffer.append("cluster-members");
        strBuffer.append("\n");
        strBuffer.append("options:");
        strBuffer.append("\n\t-h/-help");
        return strBuffer.toString();
    }

    static {
        handlresMap.put("config", new SpaceConfiguration());
        handlresMap.put("list", new ListSpaces());
        handlresMap.put("connections", new SpaceConnections());
        handlresMap.put("cluster-members", new ClusterMembers());
        handlresMap.put("clean", new CleanSpace());
        handlresMap.put(SPACE_CLEAR_OPERATION, new CleanSpace());
        handlresMap.put("ping", new Ping());
        handlresMap.put("copy", new CopySpace());
        handlresMap.put("sql", new SpaceSQL());
        GSLogConfigLoader.getLoader();
    }
}

