/*
 * Decompiled with CFR 0.152.
 */
package com.gigaspaces.admin.cli;

import com.gigaspaces.admin.cli.AbstractSpaceCommand;
import com.gigaspaces.admin.cli.CLIUtilities;
import com.gigaspaces.admin.cli.Formatter;
import com.gigaspaces.admin.cli.OptionHandler;
import com.gigaspaces.admin.cli.utils.CLISecurityRepository;
import com.gigaspaces.security.SecurityException;
import com.gigaspaces.security.service.SecuredService;
import com.j_spaces.core.IJSpace;
import com.j_spaces.jdbc.driver.GConnection;
import com.j_spaces.kernel.JSpaceUtilities;
import java.io.BufferedReader;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;

public class SpaceSQL
extends AbstractSpaceCommand {
    private OptionHandler validOptions;
    public static final String OPERATION_NAME = "sql";
    private static final String DRIVER_CLASS_NAME = "com.j_spaces.jdbc.driver.GDriver";
    private static final String SQL_URL_PREFIX = "jdbc:gigaspaces:url:";
    private ResultSet rs;
    private int columnWidth;
    private Map<String, GConnection> connectionsMap = new HashMap<String, GConnection>();

    public SpaceSQL() {
        String[] validOptionsArray = new String[]{"h", "help", "url", "query", "multispace"};
        this.validOptions = new OptionHandler(Formatter.fromArray(validOptionsArray));
        this.operationName = OPERATION_NAME;
        this.searchedSpaceState = 1;
        try {
            Class.forName(DRIVER_CLASS_NAME);
        }
        catch (ClassNotFoundException e) {
            System.out.println("Unable to initialize com.j_spaces.jdbc.driver.GDriver class.");
            _logger.log(Level.SEVERE, e.toString(), e);
        }
    }

    @Override
    public String getUsage() {
        StringBuilder strBuffer = new StringBuilder();
        strBuffer.append("\n*****************************************************\n\n");
        strBuffer.append("Usage: space sql [options] query \n");
        strBuffer.append("options:\n");
        strBuffer.append("\t-h/-help    prints help\n");
        strBuffer.append("\t-url    space url, mandatory option\n");
        strBuffer.append("\t-query  query that will be run on the space, mandatory option\n");
        strBuffer.append("\t-multispace  indicates if this query will be multi space, by default query is single space\n");
        strBuffer.append("Usage example: ");
        strBuffer.append("\tspace sql -url rmi://localhost:10098/mySpace_container/mySpace -query select uid,* from com.j_spaces.examples.benchmark.messages.Message WHERE rownum<1000\n");
        strBuffer.append("\n*****************************************************\n");
        return strBuffer.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String process(String input, BufferedReader br) {
        Statement st = null;
        try {
            GConnection con;
            Map<String, String> args = this.validOptions.getOptions(input, true);
            if (args.containsKey("h") || args.containsKey("help")) {
                String string = this.getUsage();
                return string;
            }
            if (!args.containsKey("url")) {
                CLIUtilities.printMissingParameterMessage("url");
                String string = this.getUsage();
                return string;
            }
            if (!args.containsKey("query")) {
                CLIUtilities.printMissingParameterMessage("query");
                String string = this.getUsage();
                return string;
            }
            String finderURL = args.get("url");
            if (JSpaceUtilities.isEmpty((String)finderURL, (boolean)true)) {
                CLIUtilities.printMissingValueMessage("url");
                String e = "";
                return e;
            }
            String query = args.get("query");
            if (JSpaceUtilities.isEmpty((String)query, (boolean)true)) {
                CLIUtilities.printMissingValueMessage("query");
                String e = "";
                return e;
            }
            System.out.println("Query:" + query);
            Object foundService = this.find(finderURL);
            if (foundService == null || !(foundService instanceof IJSpace)) {
                String e = "Failed to locate space for provided url.";
                return e;
            }
            IJSpace space = (IJSpace)foundService;
            boolean isSecuredSpace = space.isSecured();
            if (isSecuredSpace) {
                CLISecurityRepository.getInstance().login((SecuredService)space);
            }
            if ((con = this.connectionsMap.get(finderURL)) == null) {
                con = GConnection.getInstance((IJSpace)space);
            }
            con.setAutoCommit(true);
            if (!isSecuredSpace) {
                this.connectionsMap.put(finderURL, con);
            }
            st = con.createStatement();
            if (args.containsKey("multispace")) {
                con.setUseSingleSpace(false);
            } else {
                con.setUseSingleSpace(true);
            }
            if (query.startsWith("select")) {
                this.rs = st.executeQuery(query);
                this.printOut(this.rs);
            } else {
                st.executeUpdate(query);
            }
            if (JSpaceUtilities.isEmpty((String)query, (boolean)true)) {
                CLIUtilities.printMissingValueMessage("url");
                String string = "";
                return string;
            }
        }
        catch (SecurityException se) {
            System.out.println("Failed due to a security error: " + se.getMessage());
        }
        catch (IllegalArgumentException e) {
            if (e.getMessage() != null) {
                System.out.println(e.getMessage());
            } else {
                System.out.println(e.toString());
            }
            System.out.println(this.getUsage());
        }
        catch (Exception ex) {
            Throwable throwable = JSpaceUtilities.getAssignableCauseExceptionFromHierarchy((Exception)ex, SecurityException.class);
            if (throwable != null) {
                System.out.println("Failed due to a security error: " + throwable.getMessage());
            } else {
                System.out.println("Failed to run query, see log file for details.");
            }
            _logger.log(Level.SEVERE, ex.toString(), ex);
        }
        finally {
            if (st != null) {
                try {
                    st.close();
                }
                catch (SQLException e) {
                    _logger.log(Level.SEVERE, e.toString(), e);
                }
            }
        }
        return "";
    }

    private void printOut(ResultSet rs) {
        block9: {
            StringBuilder output = null;
            try {
                int i;
                ResultSetMetaData resultSetMetaData = rs.getMetaData();
                int colCount = resultSetMetaData.getColumnCount();
                output = new StringBuilder();
                for (i = 1; i <= colCount; ++i) {
                    output.append(this.formatSeparator(resultSetMetaData.getColumnName(i), resultSetMetaData.getColumnDisplaySize(i)));
                    if (i == colCount) {
                        output.append("-|");
                        continue;
                    }
                    output.append("-+-");
                }
                System.out.println();
                System.out.println(output);
                output = new StringBuilder();
                for (i = 1; i <= colCount; ++i) {
                    output.append(this.formatLabel(resultSetMetaData.getColumnName(i), resultSetMetaData.getColumnDisplaySize(i)));
                    output.append(" | ");
                }
                System.out.println(output);
                output = new StringBuilder();
                for (i = 1; i <= colCount; ++i) {
                    output.append(this.formatSeparator(resultSetMetaData.getColumnName(i), resultSetMetaData.getColumnDisplaySize(i)));
                    if (i == colCount) {
                        output.append("-|");
                        continue;
                    }
                    output.append("-+-");
                }
                System.out.println(output.toString());
                while (rs != null && rs.next()) {
                    output = new StringBuilder();
                    for (i = 1; i <= colCount; ++i) {
                        Object obj = rs.getObject(i);
                        output.append(this.formatValue(resultSetMetaData.getColumnName(i), obj == null ? "" : obj.toString(), resultSetMetaData.getColumnDisplaySize(i)));
                        output.append(" | ");
                    }
                    System.out.println(output);
                    System.out.println("\n");
                }
            }
            catch (Exception e) {
                if (!_logger.isLoggable(Level.SEVERE)) break block9;
                _logger.log(Level.SEVERE, e.toString(), e);
            }
        }
    }

    private String formatLabel(String s, int width) {
        if (s == null) {
            s = "NULL";
        }
        if (this.columnWidth != 0 && width > this.columnWidth) {
            width = this.columnWidth;
        }
        if (width < s.length()) {
            width = s.length();
        }
        int len = s.length();
        boolean leftJustify = false;
        if (len >= width) {
            return s.substring(0, width);
        }
        int fillWidth = width - len;
        StringBuffer fill = new StringBuffer(fillWidth);
        for (int i = 0; i < fillWidth; ++i) {
            fill.append(' ');
        }
        if (leftJustify) {
            return s + fill;
        }
        if (s.startsWith("-")) {
            return "-" + fill + s.substring(1);
        }
        return s + fill;
    }

    private String formatSeparator(String s, int width) {
        int len;
        if (s == null) {
            s = "NULL";
        }
        if (this.columnWidth != 0 && width > this.columnWidth) {
            width = this.columnWidth;
        }
        if (width < s.length()) {
            width = s.length();
        }
        if ((len = s.length()) >= width) {
            width = len;
        }
        StringBuffer fill = new StringBuffer(width);
        for (int i = 0; i < width; ++i) {
            fill.append('-');
        }
        return fill.toString();
    }

    private String formatValue(String label, String s, int width) {
        if (s == null) {
            s = "NULL";
        }
        if (this.columnWidth != 0 && width > this.columnWidth) {
            width = this.columnWidth;
        }
        if (width < label.length()) {
            width = label.length();
        }
        int len = s.length();
        boolean leftJustify = false;
        if (len >= width) {
            return s.substring(0, width);
        }
        int fillWidth = width - len;
        StringBuffer fill = new StringBuffer(fillWidth);
        for (int i = 0; i < fillWidth; ++i) {
            fill.append(' ');
        }
        if (leftJustify) {
            return s + fill;
        }
        if (s.startsWith("-")) {
            return "-" + fill + s.substring(1);
        }
        return s + fill;
    }
}

