/*
 * Decompiled with CFR 0.152.
 */
package com.gigaspaces.admin.cli.multicast;

import com.gigaspaces.admin.cli.multicast.MulticastUtilities;
import com.gigaspaces.internal.utils.concurrent.GSThread;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.SocketException;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;

public abstract class AbstractMulticastReceiver
implements Runnable {
    private Thread _receiverThread;
    protected DatagramSocket _dataGramSocket;
    private static final long QUEUE_TIMEOUT = 10000L;
    private static final Logger _logger = Logger.getLogger("com.gigaspaces.admin.cli");
    private LinkedBlockingQueue<DatagramPacket> _eventQueue = new LinkedBlockingQueue(10000);

    public AbstractMulticastReceiver(String threadName, DatagramSocket dataGramSocket) throws SocketException {
        this._dataGramSocket = dataGramSocket;
        this._dataGramSocket.setReceiveBufferSize(64000);
        MulticastUtilities.dumpNetworkInterfaceInfo();
        this._receiverThread = new Thread((Runnable)this, threadName);
        this._receiverThread.start();
        new FireEventDaemon().start();
    }

    @Override
    public void run() {
        while (this._receiverThread != null) {
            byte[] buffer = new byte[100];
            DatagramPacket packet = new DatagramPacket(buffer, buffer.length);
            try {
                this._dataGramSocket.receive(packet);
                this._eventQueue.offer(packet, 10000L, TimeUnit.SECONDS);
            }
            catch (Exception e) {
                if (!_logger.isLoggable(Level.SEVERE)) continue;
                _logger.log(Level.SEVERE, e.toString(), e);
            }
        }
    }

    void stop() {
        if (this._receiverThread != null && this._receiverThread.isAlive()) {
            this._receiverThread = null;
            try {
                this._dataGramSocket.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    abstract void fireReceivedEvent(DatagramPacket var1);

    protected DatagramSocket getSocket() {
        return this._dataGramSocket;
    }

    private class FireEventDaemon
    extends GSThread {
        FireEventDaemon() {
            super("MulticastReceiver-FireEventDaemon");
            this.setDaemon(true);
        }

        public void run() {
            while (AbstractMulticastReceiver.this._receiverThread != null && !this.isInterrupted()) {
                try {
                    DatagramPacket event = (DatagramPacket)AbstractMulticastReceiver.this._eventQueue.poll(10000L, TimeUnit.SECONDS);
                    if (event == null) continue;
                    AbstractMulticastReceiver.this.fireReceivedEvent(event);
                }
                catch (InterruptedException e) {
                    this.interrupt();
                    break;
                }
            }
        }
    }
}

