/*
 * Decompiled with CFR 0.152.
 */
package com.gigaspaces.admin.cli.multicast;

import com.gigaspaces.admin.cli.multicast.AbstractMulticastReceiver;
import java.io.IOException;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.SocketException;
import java.util.logging.Level;
import java.util.logging.Logger;

public class MulticastReceiver
extends AbstractMulticastReceiver {
    boolean verbose = false;
    private static final Logger _logger = Logger.getLogger("com.gigaspaces.admin.cli");

    public MulticastReceiver(DatagramSocket dataGramSocket, boolean verbose) throws SocketException {
        super("McastReceiverTest thread", dataGramSocket);
        this.verbose = verbose;
    }

    @Override
    void fireReceivedEvent(DatagramPacket receivedEvent) {
        block3: {
            String timeStamp = new String(receivedEvent.getData()).trim();
            if (this.verbose) {
                System.out.println("Received from [sender=" + receivedEvent.getAddress().getHostAddress() + ':' + receivedEvent.getPort() + "] packet size: " + receivedEvent.getData().length + " bytes");
            }
            byte[] replyBuf = timeStamp.getBytes();
            DatagramPacket replyAckEvent = new DatagramPacket(replyBuf, replyBuf.length, receivedEvent.getAddress(), receivedEvent.getPort());
            try {
                this.getSocket().send(replyAckEvent);
            }
            catch (IOException e) {
                if (!_logger.isLoggable(Level.SEVERE)) break block3;
                _logger.log(Level.SEVERE, e.toString(), e);
            }
        }
    }
}

