/*
 * Decompiled with CFR 0.152.
 */
package com.gigaspaces.admin.cli.multicast;

import com.gigaspaces.admin.cli.multicast.AbstractMulticastReceiver;
import com.gigaspaces.admin.cli.multicast.MulticastUtilities;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.net.MulticastSocket;
import java.net.SocketException;
import java.util.logging.Level;
import java.util.logging.Logger;

public class MulticastSender {
    MulticastSocket _sock;
    InetAddress _mcastAddr = null;
    InetAddress _bindAddr = null;
    DatagramPacket packet;
    private static final Logger _logger = Logger.getLogger("com.gigaspaces.admin.cli");
    private int _ttl = 1;
    private int _ackEventPort = 4161;
    private int _destPort = MulticastUtilities.DESTINATION_PORT_DEFAULT;
    private int _eventSize = 100;
    byte[] _eventBuffer = null;

    public void setBindAddr(InetAddress bindAddr) {
        this._bindAddr = bindAddr;
    }

    public void setMulticastAddr(InetAddress mcastAddr) {
        this._mcastAddr = mcastAddr;
    }

    public void setTTL(int ttl) {
        this._ttl = ttl;
    }

    public void setDestinationPort(int destPort) {
        this._destPort = destPort;
    }

    public void setEventSize(int eventSize) {
        this._eventSize = eventSize;
    }

    public void go() {
        try {
            this._sock = new MulticastSocket(this._ackEventPort);
            this._sock.setSendBufferSize(64000);
            this._sock.setTimeToLive(this._ttl);
            this._eventBuffer = new byte[this._eventSize];
            if (this._bindAddr != null) {
                this._sock.setInterface(this._bindAddr);
            }
            System.out.println("Started MulticastSocket=" + this._mcastAddr + ':' + this._destPort + ", ack-reply port: " + this._sock.getLocalPort() + ", ttl=" + this._sock.getTimeToLive() + ", bind interface=" + this._sock.getInterface() + ", eventSize=" + this._eventSize);
            new AckReceiver((DatagramSocket)this._sock);
            while (true) {
                String dispatchTimeStamp = String.valueOf(System.currentTimeMillis());
                byte[] timeStampBuf = dispatchTimeStamp.getBytes();
                System.arraycopy(timeStampBuf, 0, this._eventBuffer, 0, timeStampBuf.length);
                this.packet = new DatagramPacket(this._eventBuffer, this._eventBuffer.length, this._mcastAddr, this._destPort);
                this._sock.send(this.packet);
                Thread.sleep(1000L);
            }
        }
        catch (Exception e) {
            _logger.log(Level.SEVERE, e.toString(), e);
            return;
        }
    }

    private class AckReceiver
    extends AbstractMulticastReceiver {
        AckReceiver(DatagramSocket sock) throws SocketException {
            super("McastSenderTest.AckReceiver thread", sock);
        }

        @Override
        void fireReceivedEvent(DatagramPacket receivedEvent) {
            String ackReply = new String(receivedEvent.getData()).trim();
            long timeStamp = Long.parseLong(ackReply);
            double roundTripTime = System.currentTimeMillis() - timeStamp;
            System.out.println("Reply from " + receivedEvent.getAddress().getHostAddress() + ':' + receivedEvent.getPort() + " bytes=" + MulticastSender.this._eventSize + " time=" + roundTripTime + "ms");
        }
    }
}

