/*
 * Decompiled with CFR 0.152.
 */
package com.gigaspaces.admin.cli.multicast;

import com.gigaspaces.admin.cli.CLIUtilities;
import com.gigaspaces.admin.cli.CommandException;
import com.gigaspaces.admin.cli.Constants;
import com.gigaspaces.admin.cli.Formatter;
import com.gigaspaces.admin.cli.GS;
import com.gigaspaces.admin.cli.OptionHandler;
import com.gigaspaces.admin.cli.multicast.MulticastReceiver;
import com.gigaspaces.admin.cli.multicast.MulticastSender;
import com.gigaspaces.admin.cli.multicast.MulticastUtilities;
import com.gigaspaces.internal.version.PlatformVersion;
import java.io.BufferedReader;
import java.net.InetAddress;
import java.net.MulticastSocket;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;

public class MulticastTest
implements Constants,
GS.OptionHandler {
    private static final Logger _logger = Logger.getLogger("com.gigaspaces.admin.cli");
    private OptionHandler validOptions;
    public static final String OPERATION_NAME = "multicastTest";

    public MulticastTest() {
        String[] validOptionsArray = new String[]{"h", "help", "ba", "ma", "t", "verbose", "sender", "receiver"};
        this.validOptions = new OptionHandler(Formatter.fromArray(validOptionsArray));
    }

    @Override
    public String process(String input, BufferedReader br) throws CommandException {
        block18: {
            InetAddress mcastAddr = null;
            InetAddress bindAddr = null;
            int port = MulticastUtilities.DESTINATION_PORT_DEFAULT;
            boolean verbose = false;
            try {
                Map<String, String> args = this.validOptions.getOptions(input, true);
                if (!args.containsKey("sender") && !args.containsKey("receiver")) {
                    CLIUtilities.printMissingParametersMessage("sender", "receiver");
                    return this.getUsage();
                }
                if (args.containsKey("ba")) {
                    bindAddr = InetAddress.getByName(args.get("ba"));
                }
                mcastAddr = args.containsKey("ma") ? InetAddress.getByName(args.get("ma")) : net.jini.discovery.Constants.getRequestAddress();
                if (args.containsKey("port")) {
                    port = Integer.parseInt(args.get("port"));
                }
                if (args.containsKey("sender")) {
                    System.out.println("Starting Multicast-Sender...");
                    MulticastSender sender = new MulticastSender();
                    sender.setMulticastAddr(mcastAddr);
                    if (bindAddr != null) {
                        sender.setBindAddr(bindAddr);
                    }
                    if (args.containsKey("port")) {
                        sender.setDestinationPort(port);
                    }
                    if (args.containsKey("t")) {
                        sender.setTTL(Integer.parseInt(args.get("t")));
                    }
                    if (args.containsKey("s")) {
                        sender.setEventSize(Integer.parseInt(args.get("s")));
                    }
                    sender.go();
                    break block18;
                }
                if (args.containsKey("receiver")) {
                    System.out.println("Starting Multicast-Receiver...");
                    MulticastSocket socket = new MulticastSocket(port);
                    socket.setReceiveBufferSize(64000);
                    if (bindAddr != null) {
                        socket.setInterface(bindAddr);
                    }
                    if (mcastAddr != null) {
                        socket.joinGroup(mcastAddr);
                    }
                    if (args.containsKey("verbose")) {
                        verbose = true;
                    }
                    new MulticastReceiver(socket, verbose);
                    break block18;
                }
                return this.getUsage();
            }
            catch (NumberFormatException ex) {
                System.out.println("Please, provide integer numbers only.");
            }
            catch (IllegalArgumentException e) {
                if (e.getMessage() != null) {
                    System.out.println(e.getMessage());
                } else {
                    System.out.println(e.toString());
                }
                System.out.println(this.getUsage());
            }
            catch (Exception ex) {
                _logger.log(Level.SEVERE, ex.toString(), ex);
            }
        }
        return "";
    }

    @Override
    public String getUsage() {
        StringBuilder strBuffer = new StringBuilder("\n***************************************************************\n\n");
        strBuffer.append(" Usage: admin multicastTest [options]\n");
        strBuffer.append(" Options:\n");
        strBuffer.append("    -h/-help             This help screen\n");
        strBuffer.append("    -sender/-receiver  Sender or receiver, specify one\n");
        strBuffer.append("    -ba            Binding address. Useful for multihomed hosts.\n");
        strBuffer.append("    -ma            Multicast address\n");
        strBuffer.append("    -t             Time to live for multicast packets\n");
        strBuffer.append("    -verbose       Print out the received messages\n\n");
        strBuffer.append(" Example:  admin multicastTest -sender \n");
        strBuffer.append(" Example:  admin multicastTest -receiver -verbose\n\n");
        strBuffer.append(" DESCRIPTION\n");
        strBuffer.append(" This multicast utility serves to check multicast communication between sender and receiver.\n");
        strBuffer.append(" 1. Run admin multicastTest -sender on source machine\n");
        strBuffer.append(" 2. Run admin multicastTest -receiver on each target machine.\n");
        strBuffer.append(" On the source machine it should display a round-trip \"Reply\" from all target machines.\n");
        strBuffer.append(" e.g. : \"Reply from 192.138.120.56:5558 bytes=100 time=1.539ms\"");
        strBuffer.append(" if multicast is enabled between source and targets.\n");
        strBuffer.append(" Note: For multi-homed network card machine use multicastTest -sender -ba [network card IP]\n");
        strBuffer.append(" For more details please refer to the online documentation at " + PlatformVersion.getProductHelpUrl() + "/admin/logging-overview.html \n");
        strBuffer.append("\n***************************************************************\n");
        return strBuffer.toString();
    }
}

