/*
 * Decompiled with CFR 0.152.
 */
package com.gigaspaces.admin.cli.multicast;

import java.net.InetAddress;
import java.net.NetworkInterface;
import java.util.Enumeration;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.jini.discovery.Constants;

public class MulticastUtilities {
    public static final int TTL_DEFAULT = 1;
    public static final int ACK_EVENT_PORT_DEFAULT = 4161;
    public static final int DESTINATION_PORT_DEFAULT = Constants.getDiscoveryPort();
    public static final int EVENT_SIZE_DEFAULT = 100;
    public static final int DEFAULT_BUFFER_SIZE = 64000;
    private static final Logger _logger = Logger.getLogger("com.gigaspaces.admin.cli");

    public static void dumpNetworkInterfaceInfo() {
        try {
            String hostName = InetAddress.getLocalHost().getHostName();
            StringBuilder dumpInfo = new StringBuilder("\n---------- [" + hostName + "] NETWORK INTERFACE INFO -----------");
            Enumeration<NetworkInterface> enum_ = NetworkInterface.getNetworkInterfaces();
            while (enum_.hasMoreElements()) {
                NetworkInterface net = enum_.nextElement();
                dumpInfo.append("\nNames: " + net.getName() + " / " + net.getDisplayName());
                Enumeration<InetAddress> enum2 = net.getInetAddresses();
                while (enum2.hasMoreElements()) {
                    InetAddress address = enum2.nextElement();
                    dumpInfo.append("\n\tAddress: " + address.getHostAddress());
                }
            }
            dumpInfo.append("\n---------- [" + hostName + "] NETWORK INTERFACE INFO -----------");
            System.out.println(dumpInfo.toString());
        }
        catch (Exception ex) {
            System.out.println("Failed to dump network interface info.");
            _logger.log(Level.SEVERE, ex.toString(), ex);
        }
    }
}

