/*
 * Decompiled with CFR 0.152.
 */
package com.gigaspaces.admin.cli.utils;

import com.gigaspaces.admin.cli.GS;
import com.gigaspaces.internal.service.ServiceItemUtils;
import com.gigaspaces.security.Authentication;
import com.gigaspaces.security.SecurityException;
import com.gigaspaces.security.directory.CredentialsProvider;
import com.gigaspaces.security.directory.CredentialsProviderHelper;
import com.gigaspaces.security.directory.User;
import com.gigaspaces.security.directory.UserDetails;
import com.gigaspaces.security.service.SecuredService;
import com.gigaspaces.security.service.SecurityContext;
import java.rmi.RemoteException;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.jini.core.lookup.ServiceID;
import net.jini.core.lookup.ServiceItem;

public class CLISecurityRepository {
    private static final Logger LOGGER = Logger.getLogger("com.gigaspaces.admin.cli");
    private static CLISecurityRepository _cliSecurityRepository;
    private final Map<ServiceID, Authentication> _authenticationsMap = new HashMap<ServiceID, Authentication>();
    private CredentialsProvider _currentCredentialsProvider;

    public static synchronized CLISecurityRepository getInstance() {
        if (_cliSecurityRepository == null) {
            _cliSecurityRepository = new CLISecurityRepository();
        }
        return _cliSecurityRepository;
    }

    private CLISecurityRepository() {
    }

    public boolean login(Properties loginProperties, String credentialsProviderClassName) {
        loginProperties = loginProperties == null ? new Properties() : loginProperties;
        this._currentCredentialsProvider = this.initCredentialsProvider(credentialsProviderClassName, loginProperties);
        if (this._currentCredentialsProvider == null) {
            return false;
        }
        boolean isAllLoginsSucceeded = true;
        for (ServiceItem securedServiceItem : GS.getServiceFinder().getAllSecuredServices()) {
            if (this.login(securedServiceItem)) continue;
            isAllLoginsSucceeded = false;
        }
        if (!isAllLoginsSucceeded) {
            System.out.println("\nLogin to some services failed, see log file for details.\n");
        } else {
            System.out.println("\nCredentials recorded and will be used to login to the available secured components.\n");
        }
        return true;
    }

    private CredentialsProvider initCredentialsProvider(String credentialsProviderClassName, Properties properties) {
        CredentialsProvider credentialsProvider;
        try {
            credentialsProvider = CredentialsProviderHelper.fromClassName((String)credentialsProviderClassName, (Properties)properties);
        }
        catch (Exception e) {
            System.out.println("\nFailed to load credentials provider class from \"" + credentialsProviderClassName + "\", see log file for details\n");
            if (LOGGER.isLoggable(Level.SEVERE)) {
                LOGGER.log(Level.SEVERE, "Failed to load credentials provider class - " + e.toString(), e);
            }
            return null;
        }
        try {
            credentialsProvider.getUserDetails();
        }
        catch (Exception e) {
            System.out.println("Failed to create UserDetails, see log file for details.");
            if (LOGGER.isLoggable(Level.SEVERE)) {
                LOGGER.log(Level.SEVERE, "Failed to create UserDetails - " + e.toString(), e);
            }
            return null;
        }
        return credentialsProvider;
    }

    private boolean login(ServiceItem serviceItem) {
        if (this._currentCredentialsProvider != null) {
            try {
                SecuredService service = ServiceItemUtils.getSecuredService((ServiceItem)serviceItem);
                if (service.isServiceSecured()) {
                    SecurityContext securityContext = this.login(service);
                    this._authenticationsMap.put(serviceItem.serviceID, securityContext.getAuthentication());
                }
            }
            catch (Exception re) {
                if (LOGGER.isLoggable(Level.SEVERE)) {
                    LOGGER.log(Level.SEVERE, "Failed to login with [" + this.formatCredentials() + "] - " + re.toString(), re);
                }
                return false;
            }
        }
        return true;
    }

    public SecurityContext login(SecuredService securedService) throws SecurityException, RemoteException {
        SecurityContext retSecurityContext = null;
        if (this._currentCredentialsProvider != null) {
            retSecurityContext = securedService.login(this._currentCredentialsProvider);
        }
        return retSecurityContext;
    }

    private String formatCredentials() {
        if (this._currentCredentialsProvider == null) {
            return "null";
        }
        UserDetails userDetails = this._currentCredentialsProvider.getUserDetails();
        if (userDetails instanceof User) {
            return userDetails.getUsername();
        }
        return userDetails.toString();
    }

    public Authentication getSecurityAuthentication(ServiceID securedServiceId) {
        return this._authenticationsMap.get(securedServiceId);
    }

    public void removeService(ServiceID serviceID) {
        this._authenticationsMap.remove(serviceID);
    }

    public void addService(ServiceItem serviceItem) {
        this.login(serviceItem);
    }

    public CredentialsProvider getCurrentCredentialsProvider() {
        return this._currentCredentialsProvider;
    }
}

