/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.guice.bean.binders;

import com.google.inject.Binding;
import com.google.inject.TypeLiteral;
import com.google.inject.spi.DefaultBindingTargetVisitor;
import com.google.inject.spi.InjectionPoint;
import com.google.inject.spi.LinkedKeyBinding;
import com.google.inject.spi.UntargettedBinding;
import org.sonatype.guice.bean.reflect.Logs;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class DependencyVerifier
extends DefaultBindingTargetVisitor<Object, Boolean> {
    DependencyVerifier() {
    }

    public Boolean visit(UntargettedBinding<?> binding) {
        return this.verify(binding.getKey().getTypeLiteral());
    }

    public Boolean visit(LinkedKeyBinding<?> binding) {
        return this.verify(binding.getLinkedKey().getTypeLiteral());
    }

    public Boolean visitOther(Binding<?> binding) {
        return Boolean.TRUE;
    }

    private Boolean verify(TypeLiteral<?> type) {
        if ((type.getRawType().getModifiers() & 0x600) != 0) {
            return Boolean.TRUE;
        }
        try {
            InjectionPoint.forConstructorOf(type).getDependencies();
            InjectionPoint.forInstanceMethodsAndFields(type);
            return Boolean.TRUE;
        }
        catch (Throwable e) {
            Logs.debug("Ignore: {}", type, e);
            return Boolean.FALSE;
        }
    }
}

