/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.api.python;

import java.io.DataOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.net.InetAddress;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.attribute.FileAttribute;
import org.apache.spark.SparkConf;
import org.apache.spark.internal.Logging;
import org.apache.spark.internal.Logging$class;
import org.apache.spark.util.Utils$;
import org.slf4j.Logger;
import py4j.GatewayServer;
import scala.Function0;
import scala.Predef$;
import scala.Serializable;
import scala.StringContext;
import scala.collection.Seq;
import scala.runtime.BoxesRunTime;
import scala.sys.package$;

public final class PythonGatewayServer$
implements Logging {
    public static final PythonGatewayServer$ MODULE$;
    private transient Logger org$apache$spark$internal$Logging$$log_;

    static {
        new PythonGatewayServer$();
    }

    @Override
    public Logger org$apache$spark$internal$Logging$$log_() {
        return this.org$apache$spark$internal$Logging$$log_;
    }

    @Override
    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$internal$Logging$$log_ = x$1;
    }

    @Override
    public String logName() {
        return Logging$class.logName(this);
    }

    @Override
    public Logger log() {
        return Logging$class.log(this);
    }

    @Override
    public void logInfo(Function0<String> msg) {
        Logging$class.logInfo(this, msg);
    }

    @Override
    public void logDebug(Function0<String> msg) {
        Logging$class.logDebug(this, msg);
    }

    @Override
    public void logTrace(Function0<String> msg) {
        Logging$class.logTrace(this, msg);
    }

    @Override
    public void logWarning(Function0<String> msg) {
        Logging$class.logWarning(this, msg);
    }

    @Override
    public void logError(Function0<String> msg) {
        Logging$class.logError(this, msg);
    }

    @Override
    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging$class.logInfo(this, msg, throwable);
    }

    @Override
    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging$class.logDebug(this, msg, throwable);
    }

    @Override
    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging$class.logTrace(this, msg, throwable);
    }

    @Override
    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging$class.logWarning(this, msg, throwable);
    }

    @Override
    public void logError(Function0<String> msg, Throwable throwable) {
        Logging$class.logError(this, msg, throwable);
    }

    @Override
    public boolean isTraceEnabled() {
        return Logging$class.isTraceEnabled(this);
    }

    @Override
    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging$class.initializeLogIfNecessary(this, isInterpreter);
    }

    @Override
    public boolean initializeLogIfNecessary(boolean isInterpreter, boolean silent) {
        return Logging$class.initializeLogIfNecessary(this, isInterpreter, silent);
    }

    @Override
    public boolean initializeLogIfNecessary$default$2() {
        return Logging$class.initializeLogIfNecessary$default$2(this);
    }

    public void main(String[] args) {
        String secret = Utils$.MODULE$.createSecret(new SparkConf());
        InetAddress localhost = InetAddress.getLoopbackAddress();
        GatewayServer gatewayServer = new GatewayServer.GatewayServerBuilder().authToken(secret).javaPort(0).javaAddress(localhost).callbackClient(25334, localhost, secret).build();
        gatewayServer.start();
        int boundPort2 = gatewayServer.getListeningPort();
        if (boundPort2 == -1) {
            this.logError((Function0<String>)new Serializable(){
                public static final long serialVersionUID = 0L;

                public final String apply() {
                    return "GatewayServer failed to bind; exiting";
                }
            });
            System.exit(1);
        } else {
            this.logDebug((Function0<String>)new Serializable(boundPort2){
                public static final long serialVersionUID = 0L;
                private final int boundPort$1;

                public final String apply() {
                    return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Started PythonGatewayServer on port ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.boundPort$1)}));
                }
                {
                    this.boundPort$1 = boundPort$1;
                }
            });
        }
        File connectionInfoPath = new File((String)package$.MODULE$.env().apply((Object)"_PYSPARK_DRIVER_CONN_INFO_PATH"));
        File tmpPath = Files.createTempFile(connectionInfoPath.getParentFile().toPath(), "connection", ".info", new FileAttribute[0]).toFile();
        DataOutputStream dos = new DataOutputStream(new FileOutputStream(tmpPath));
        dos.writeInt(boundPort2);
        byte[] secretBytes = secret.getBytes(StandardCharsets.UTF_8);
        dos.writeInt(secretBytes.length);
        dos.write(secretBytes, 0, secretBytes.length);
        dos.close();
        if (!tmpPath.renameTo(connectionInfoPath)) {
            this.logError((Function0<String>)new Serializable(connectionInfoPath){
                public static final long serialVersionUID = 0L;
                private final File connectionInfoPath$1;

                public final String apply() {
                    return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Unable to write connection information to ", "."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.connectionInfoPath$1}));
                }
                {
                    this.connectionInfoPath$1 = connectionInfoPath$1;
                }
            });
            System.exit(1);
        }
        while (System.in.read() != -1) {
        }
        this.logDebug((Function0<String>)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return "Exiting due to broken pipe from Python driver";
            }
        });
        System.exit(0);
    }

    private PythonGatewayServer$() {
        MODULE$ = this;
        Logging$class.$init$(this);
        this.initializeLogIfNecessary(true);
    }
}

