/*
 * Decompiled with CFR 0.152.
 */
package org.apache.zeppelin.realm.jwt;

import java.util.Arrays;
import java.util.HashMap;
import java.util.StringTokenizer;
import org.apache.zeppelin.realm.jwt.PrincipalMapper;
import org.apache.zeppelin.realm.jwt.PrincipalMappingException;

public class SimplePrincipalMapper
implements PrincipalMapper {
    public HashMap<String, String[]> principalMappings = null;
    public HashMap<String, String[]> groupMappings = null;

    @Override
    public void loadMappingTable(String principalMapping, String groupMapping) throws PrincipalMappingException {
        if (principalMapping != null) {
            this.principalMappings = this.parseMapping(principalMapping);
            this.groupMappings = this.parseMapping(groupMapping);
        }
    }

    private HashMap<String, String[]> parseMapping(String mappings) throws PrincipalMappingException {
        if (mappings == null) {
            return null;
        }
        HashMap<String, String[]> table = new HashMap<String, String[]>();
        try {
            StringTokenizer t = new StringTokenizer(mappings, ";");
            if (t.hasMoreTokens()) {
                do {
                    String mapping = t.nextToken();
                    String principals = mapping.substring(0, mapping.indexOf(61));
                    String value = mapping.substring(mapping.indexOf(61) + 1);
                    String[] v = value.split(",");
                    String[] p = principals.split(",");
                    for (int i = 0; i < p.length; ++i) {
                        table.put(p[i], v);
                    }
                } while (t.hasMoreTokens());
            }
            return table;
        }
        catch (Exception e) {
            table.clear();
            throw new PrincipalMappingException("Unable to load mappings from provided string: " + mappings + " - no principal mapping will be provided.", e);
        }
    }

    @Override
    public String mapUserPrincipal(String principalName) {
        String[] p = null;
        if (this.principalMappings != null) {
            p = this.principalMappings.get(principalName);
        }
        if (p == null) {
            return principalName;
        }
        return p[0];
    }

    @Override
    public String[] mapGroupPrincipal(String principalName) {
        String[] groups = null;
        String[] wildCardGroups = null;
        if (this.groupMappings != null) {
            groups = this.groupMappings.get(principalName);
            wildCardGroups = this.groupMappings.get("*");
            if (groups != null && wildCardGroups != null) {
                groups = SimplePrincipalMapper.concat(groups, wildCardGroups);
            } else if (wildCardGroups != null) {
                return wildCardGroups;
            }
        }
        return groups;
    }

    public static <T> T[] concat(T[] groups, T[] wildCardGroups) {
        T[] result = Arrays.copyOf(groups, groups.length + wildCardGroups.length);
        System.arraycopy(wildCardGroups, 0, result, groups.length, wildCardGroups.length);
        return result;
    }
}

