/*
 * Decompiled with CFR 0.152.
 */
package org.openspaces.core.gateway;

import com.gigaspaces.internal.cluster.node.impl.gateway.GatewayPolicy;
import com.j_spaces.core.cluster.RedoLogCapacityExceededPolicy;

public class GatewayTarget {
    private String name;
    private Integer bulkSize;
    private Long idleTimeThreshold;
    private Integer pendingOperationThreshold;
    private Long maxRedoLogCapacity;
    private RedoLogCapacityExceededPolicy onRedoLogCapacityExceeded;
    private Boolean replicateChangeAsUpdate;

    public GatewayTarget() {
    }

    public GatewayTarget(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setBulkSize(Integer bulkSize) {
        if (bulkSize != null && bulkSize < 0) {
            throw new IllegalArgumentException("bulkSize can't be negative.");
        }
        this.bulkSize = bulkSize;
    }

    public Integer getBulkSize() {
        return this.bulkSize;
    }

    public void setIdleTimeThreshold(Long idleTimeThreshold) {
        if (idleTimeThreshold != null && idleTimeThreshold < 0L) {
            throw new IllegalArgumentException("idleTimeThreshold can't be negative.");
        }
        this.idleTimeThreshold = idleTimeThreshold;
    }

    public Long getIdleTimeThreshold() {
        return this.idleTimeThreshold;
    }

    public void setPendingOperationThreshold(Integer pendingOperationThreshold) {
        if (pendingOperationThreshold != null && pendingOperationThreshold < 0) {
            throw new IllegalArgumentException("pendingOperationThreshold can't be negative.");
        }
        this.pendingOperationThreshold = pendingOperationThreshold;
    }

    public Integer getPendingOperationThreshold() {
        return this.pendingOperationThreshold;
    }

    public void setUnlimitedRedoLogCapacity() {
        this.maxRedoLogCapacity = -1L;
    }

    public void setMaxRedoLogCapacity(Long maxRedoLogCapacity) {
        if (maxRedoLogCapacity != null && maxRedoLogCapacity < -1L) {
            throw new IllegalArgumentException("maxRedoLogCapacity must be larger than 0 or -1 for unlimited.");
        }
        this.maxRedoLogCapacity = maxRedoLogCapacity;
    }

    public Long getMaxRedoLogCapacity() {
        return this.maxRedoLogCapacity;
    }

    public void setOnRedoLogCapacityExceeded(RedoLogCapacityExceededPolicy onRedoLogCapacityExceeded) {
        this.onRedoLogCapacityExceeded = onRedoLogCapacityExceeded;
    }

    public RedoLogCapacityExceededPolicy getOnRedoLogCapacityExceeded() {
        return this.onRedoLogCapacityExceeded;
    }

    public void setReplicateChangeAsUpdate(Boolean replicateChangeAsUpdate) {
        this.replicateChangeAsUpdate = replicateChangeAsUpdate;
    }

    public Boolean isReplicateChangeAsUpdate() {
        return this.replicateChangeAsUpdate;
    }

    public GatewayPolicy asGatewayPolicy() {
        return this.asGatewayPolicy(new GatewayPolicy());
    }

    public GatewayPolicy asGatewayPolicy(GatewayPolicy defaultGatewayPolicy) {
        GatewayPolicy policy = new GatewayPolicy();
        policy.setGatewayName(this.name);
        if (this.bulkSize != null) {
            policy.setBulkSize(this.bulkSize.intValue());
        } else {
            policy.setBulkSize(defaultGatewayPolicy.getBulkSize());
        }
        if (this.idleTimeThreshold != null) {
            policy.setIdleTimeThreshold(this.idleTimeThreshold.longValue());
        } else {
            policy.setIdleTimeThreshold(defaultGatewayPolicy.getIdleTimeThreshold());
        }
        if (this.pendingOperationThreshold != null) {
            policy.setPendingOperationThreshold(this.pendingOperationThreshold.intValue());
        } else {
            policy.setPendingOperationThreshold(defaultGatewayPolicy.getPendingOperationThreshold());
        }
        if (this.maxRedoLogCapacity != null) {
            policy.setMaxRedoLogCapacity(this.maxRedoLogCapacity.longValue());
        } else {
            policy.setMaxRedoLogCapacity(defaultGatewayPolicy.getMaxRedoLogCapacity());
        }
        if (this.onRedoLogCapacityExceeded != null) {
            policy.setOnRedoLogCapacityExceeded(this.onRedoLogCapacityExceeded);
        } else {
            policy.setOnRedoLogCapacityExceeded(defaultGatewayPolicy.getOnRedoLogCapacityExceeded());
        }
        if (this.replicateChangeAsUpdate != null) {
            policy.setReplicateChangeAsUpdate(this.replicateChangeAsUpdate.booleanValue());
        } else {
            policy.setReplicateChangeAsUpdate(defaultGatewayPolicy.isReplicateChangeAsUpdate());
        }
        return policy;
    }
}

