/*
 * Decompiled with CFR 0.152.
 */
package org.openspaces.core.gateway;

import com.gigaspaces.internal.cluster.node.impl.gateway.GatewayConfig;
import com.gigaspaces.internal.cluster.node.impl.gateway.GatewayPolicy;
import com.gigaspaces.internal.cluster.node.impl.gateway.GatewaysPolicy;
import com.gigaspaces.server.SpaceCustomComponent;
import com.j_spaces.core.cluster.RedoLogCapacityExceededPolicy;
import java.util.List;
import org.openspaces.core.extension.SpaceCustomComponentFactoryBean;
import org.openspaces.core.gateway.GatewayTarget;
import org.springframework.beans.factory.InitializingBean;

public class GatewayTargetsFactoryBean
implements SpaceCustomComponentFactoryBean,
InitializingBean {
    private String localGatewayName;
    private List<GatewayTarget> gatewayTargets;
    private Integer bulkSize;
    private Long idleTimeThreshold;
    private Integer pendingOperationThreshold;
    private Long maxRedoLogCapacity;
    private RedoLogCapacityExceededPolicy onRedoLogCapacityExceeded;
    private Boolean replicateChangeAsUpdate;

    public void setLocalGatewayName(String localGatewayName) {
        this.localGatewayName = localGatewayName;
    }

    public String getLocalGatewayName() {
        return this.localGatewayName;
    }

    public List<GatewayTarget> getGatewayTargets() {
        return this.gatewayTargets;
    }

    public void setGatewayTargets(List<GatewayTarget> gatewayTargets) {
        this.gatewayTargets = gatewayTargets;
    }

    public void setBulkSize(Integer bulkSize) {
        this.bulkSize = bulkSize;
    }

    public void setIdleTimeThreshold(Long idleTimeThreshold) {
        this.idleTimeThreshold = idleTimeThreshold;
    }

    public void setPendingOperationThreshold(Integer pendingOperationThreshold) {
        this.pendingOperationThreshold = pendingOperationThreshold;
    }

    public void setMaxRedoLogCapacity(Long maxRedoLogCapacity) {
        this.maxRedoLogCapacity = maxRedoLogCapacity;
    }

    public void setOnRedoLogCapacityExceeded(RedoLogCapacityExceededPolicy onRedoLogCapacityExceeded) {
        this.onRedoLogCapacityExceeded = onRedoLogCapacityExceeded;
    }

    public void setReplicateChangeAsUpdate(Boolean replicateChangeAsUpdate) {
        this.replicateChangeAsUpdate = replicateChangeAsUpdate;
    }

    public GatewaysPolicy asGatewaysPolicy() {
        GatewaysPolicy gatewaysPolicy = new GatewaysPolicy();
        gatewaysPolicy.setLocalSiteName(this.getLocalGatewayName());
        if (this.gatewayTargets != null) {
            GatewayPolicy[] policies = new GatewayPolicy[this.gatewayTargets.size()];
            for (int i = 0; i < this.gatewayTargets.size(); ++i) {
                policies[i] = this.gatewayTargets.get(i).asGatewayPolicy();
            }
            gatewaysPolicy.setGatewayPolicies(policies);
            gatewaysPolicy.setDefaultGatewayPolicy(this.createDefaultGatewayPolicy());
        }
        return gatewaysPolicy;
    }

    private GatewayPolicy createDefaultGatewayPolicy() {
        GatewayPolicy policy = new GatewayPolicy();
        policy.setGatewayName("default");
        if (this.bulkSize != null) {
            policy.setBulkSize(this.bulkSize.intValue());
        }
        if (this.idleTimeThreshold != null) {
            policy.setIdleTimeThreshold(this.idleTimeThreshold.longValue());
        }
        if (this.pendingOperationThreshold != null) {
            policy.setPendingOperationThreshold(this.pendingOperationThreshold.intValue());
        }
        if (this.maxRedoLogCapacity != null) {
            policy.setMaxRedoLogCapacity(this.maxRedoLogCapacity.longValue());
        }
        if (this.onRedoLogCapacityExceeded != null) {
            policy.setOnRedoLogCapacityExceeded(this.onRedoLogCapacityExceeded);
        }
        if (this.replicateChangeAsUpdate != null) {
            policy.setReplicateChangeAsUpdate(this.replicateChangeAsUpdate.booleanValue());
        }
        return policy;
    }

    public void afterPropertiesSet() throws Exception {
        if (this.gatewayTargets != null) {
            for (GatewayTarget gatewayTarget : this.gatewayTargets) {
                if (gatewayTarget.getBulkSize() == null) {
                    gatewayTarget.setBulkSize(this.bulkSize);
                }
                if (gatewayTarget.getIdleTimeThreshold() == null) {
                    gatewayTarget.setIdleTimeThreshold(this.idleTimeThreshold);
                }
                if (gatewayTarget.getMaxRedoLogCapacity() == null) {
                    gatewayTarget.setMaxRedoLogCapacity(this.maxRedoLogCapacity);
                }
                if (gatewayTarget.getPendingOperationThreshold() == null) {
                    gatewayTarget.setPendingOperationThreshold(this.pendingOperationThreshold);
                }
                if (gatewayTarget.getOnRedoLogCapacityExceeded() == null) {
                    gatewayTarget.setOnRedoLogCapacityExceeded(this.onRedoLogCapacityExceeded);
                }
                if (gatewayTarget.isReplicateChangeAsUpdate() != null) continue;
                gatewayTarget.setReplicateChangeAsUpdate(this.replicateChangeAsUpdate);
            }
        }
    }

    public SpaceCustomComponent createSpaceComponent() {
        return new GatewayConfig().setGatewaysPolicy(this.asGatewaysPolicy());
    }
}

