/*
 * Decompiled with CFR 0.152.
 */
package org.apache.zeppelin.display;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang.StringUtils;
import org.apache.zeppelin.display.OldInput;
import org.apache.zeppelin.display.RuntimeTypeAdapterFactory;
import org.apache.zeppelin.display.ui.CheckBox;
import org.apache.zeppelin.display.ui.OptionInput;
import org.apache.zeppelin.display.ui.Select;
import org.apache.zeppelin.display.ui.TextBox;

public class Input<T>
implements Serializable {
    public static final RuntimeTypeAdapterFactory TypeAdapterFactory = RuntimeTypeAdapterFactory.of(Input.class, "type").registerSubtype(TextBox.class, "TextBox").registerSubtype(Select.class, "Select").registerSubtype(CheckBox.class, "CheckBox").registerSubtype(OldInput.OldTextBox.class, "input").registerSubtype(OldInput.OldSelect.class, "select").registerSubtype(OldInput.OldCheckBox.class, "checkbox").registerSubtype(OldInput.class, null);
    protected String name;
    protected String displayName;
    protected T defaultValue;
    protected boolean hidden;
    protected String argument;
    private static final Pattern VAR_PTN = Pattern.compile("([_])?[$][{]([^=}]*([=][^}]*)?)[}]");
    private static final Pattern VAR_NOTE_PTN = Pattern.compile("([_])?[$]{2}[{]([^=}]*([=][^}]*)?)[}]");
    private static final String DEFAULT_DELIMITER = ",";

    public boolean isHidden() {
        return this.hidden;
    }

    public String getName() {
        return this.name;
    }

    public T getDefaultValue() {
        return this.defaultValue;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public void setDisplayName(String displayName) {
        this.displayName = displayName;
    }

    public void setArgument(String argument) {
        this.argument = argument;
    }

    public void setHidden(boolean hidden) {
        this.hidden = hidden;
    }

    public String getArgument() {
        return this.argument;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Input input = (Input)o;
        if (this.hidden != input.hidden) {
            return false;
        }
        if (this.name != null ? !this.name.equals(input.name) : input.name != null) {
            return false;
        }
        if (this.displayName != null ? !this.displayName.equals(input.displayName) : input.displayName != null) {
            return false;
        }
        if (this.defaultValue instanceof Object[] ? (this.defaultValue != null ? !Arrays.equals((Object[])this.defaultValue, (Object[])input.defaultValue) : input.defaultValue != null) : (this.defaultValue != null ? !this.defaultValue.equals(input.defaultValue) : input.defaultValue != null)) {
            return false;
        }
        return this.argument != null ? this.argument.equals(input.argument) : input.argument == null;
    }

    public int hashCode() {
        int result = this.name != null ? this.name.hashCode() : 0;
        result = 31 * result + (this.displayName != null ? this.displayName.hashCode() : 0);
        result = 31 * result + (this.defaultValue != null ? this.defaultValue.hashCode() : 0);
        result = 31 * result + (this.hidden ? 1 : 0);
        result = 31 * result + (this.argument != null ? this.argument.hashCode() : 0);
        return result;
    }

    public static TextBox textbox(String name, String defaultValue) {
        return new TextBox(name, defaultValue);
    }

    public static Select select(String name, Object defaultValue, OptionInput.ParamOption[] options) {
        return new Select(name, defaultValue, options);
    }

    public static CheckBox checkbox(String name, Object[] defaultChecked, OptionInput.ParamOption[] options) {
        return new CheckBox(name, defaultChecked, options);
    }

    private static String[] getNameAndDisplayName(String str) {
        Pattern p = Pattern.compile("([^(]*)\\s*[(]([^)]*)[)]");
        Matcher m = p.matcher(str.trim());
        if (m == null || !m.find()) {
            return null;
        }
        String[] ret = new String[]{m.group(1), m.group(2)};
        return ret;
    }

    private static String[] getType(String str) {
        Pattern p = Pattern.compile("([^:()]*)\\s*([(][^()]*[)])?\\s*:(.*)");
        Matcher m = p.matcher(str.trim());
        if (m == null || !m.find()) {
            return null;
        }
        String[] ret = new String[3];
        ret[0] = m.group(1).trim();
        if (m.group(2) != null) {
            ret[1] = m.group(2).trim().replaceAll("[()]", "");
        }
        ret[2] = m.group(3).trim();
        return ret;
    }

    private static Input getInputForm(Matcher match) {
        String varName;
        String varNamePart;
        String valuePart;
        String namePart;
        String m;
        int p;
        String hiddenPart = match.group(1);
        boolean hidden = false;
        if ("_".equals(hiddenPart)) {
            hidden = true;
        }
        if ((p = (m = match.group(2)).indexOf(61)) > 0) {
            namePart = m.substring(0, p);
            valuePart = m.substring(p + 1);
        } else {
            namePart = m;
            valuePart = null;
        }
        String displayName = null;
        String type = null;
        String arg = null;
        String[] defaultValue = "";
        OptionInput.ParamOption[] paramOptions = null;
        String[] typeArray = Input.getType(namePart);
        if (typeArray != null) {
            type = typeArray[0];
            arg = typeArray[1];
            varNamePart = typeArray[2];
        } else {
            varNamePart = namePart;
        }
        String[] varNameArray = Input.getNameAndDisplayName(varNamePart);
        if (varNameArray != null) {
            varName = varNameArray[0];
            displayName = varNameArray[1];
        } else {
            varName = varNamePart.trim();
        }
        if (valuePart != null) {
            int optionP = valuePart.indexOf(DEFAULT_DELIMITER);
            if (optionP >= 0) {
                defaultValue = valuePart.substring(0, optionP);
                if (type != null && type.equals("checkbox")) {
                    defaultValue = Input.splitPipe((String)defaultValue);
                }
                String optionPart = valuePart.substring(optionP + 1);
                String[] options = Input.splitPipe(optionPart);
                paramOptions = new OptionInput.ParamOption[options.length];
                for (int i = 0; i < options.length; ++i) {
                    String[] optNameArray = Input.getNameAndDisplayName(options[i]);
                    paramOptions[i] = optNameArray != null ? new OptionInput.ParamOption(optNameArray[0], optNameArray[1]) : new OptionInput.ParamOption(options[i], null);
                }
            } else {
                defaultValue = valuePart;
            }
        }
        Input input = null;
        if (type == null) {
            input = paramOptions == null ? new TextBox(varName, (String)defaultValue) : new Select(varName, defaultValue, paramOptions);
        } else if (type.equals("checkbox")) {
            input = new CheckBox(varName, defaultValue, paramOptions);
        } else {
            throw new RuntimeException("Could not recognize dynamic form with type: " + type);
        }
        input.setArgument(arg);
        input.setDisplayName(displayName);
        input.setHidden(hidden);
        return input;
    }

    public static LinkedHashMap<String, Input> extractSimpleQueryForm(String script, boolean noteForm) {
        LinkedHashMap<String, Input> forms = new LinkedHashMap<String, Input>();
        if (script == null) {
            return forms;
        }
        String replaced = script;
        Pattern pattern = noteForm ? VAR_NOTE_PTN : VAR_PTN;
        Matcher match = pattern.matcher(replaced);
        while (match.find()) {
            int first = match.start();
            if (!noteForm && first > 0 && replaced.charAt(first - 1) == '$') continue;
            Input form = Input.getInputForm(match);
            forms.put(form.name, form);
        }
        forms.remove("pql");
        return forms;
    }

    public static String getSimpleQuery(Map<String, Object> params, String script, boolean noteForm) {
        String replaced = script;
        Pattern pattern = noteForm ? VAR_NOTE_PTN : VAR_PTN;
        Matcher match = pattern.matcher(replaced);
        while (match.find()) {
            String expanded;
            int first = match.start();
            if (!noteForm && first > 0 && replaced.charAt(first - 1) == '$') continue;
            Input input = Input.getInputForm(match);
            Object value = params.containsKey(input.name) ? params.get(input.name) : input.getDefaultValue();
            if (value instanceof Object[] || value instanceof Collection) {
                OptionInput optionInput = (OptionInput)input;
                String delimiter = input.argument;
                if (delimiter == null) {
                    delimiter = DEFAULT_DELIMITER;
                }
                List<Object> checked = value instanceof Collection ? (List<Object>)value : Arrays.asList((Object[])value);
                LinkedList validChecked = new LinkedList();
                block1: for (Object e : checked) {
                    for (OptionInput.ParamOption option : optionInput.getOptions()) {
                        if (!option.getValue().equals(e)) continue;
                        validChecked.add(e);
                        continue block1;
                    }
                }
                params.put(input.name, validChecked);
                expanded = StringUtils.join(validChecked, (String)delimiter);
            } else {
                expanded = value.toString();
            }
            replaced = match.replaceFirst(expanded);
            match = pattern.matcher(replaced);
        }
        return replaced;
    }

    public static String[] split(String str) {
        return str.split(";(?=([^\"']*\"[^\"']*\")*[^\"']*$)");
    }

    public static String[] splitPipe(String str) {
        return Input.split(str, '|');
    }

    public static String[] split(String str, char split) {
        return Input.split(str, new String[]{String.valueOf(split)}, false);
    }

    public static String[] split(String str, String[] splitters, boolean includeSplitter) {
        String escapeSeq = "\"',;${}";
        char escapeChar = '\\';
        String[] blockStart = new String[]{"\"", "'", "${", "N_(", "N_<"};
        String[] blockEnd = new String[]{"\"", "'", "}", "N_)", "N_>"};
        return Input.split(str, escapeSeq, escapeChar, blockStart, blockEnd, splitters, includeSplitter);
    }

    public static String[] split(String str, String escapeSeq, char escapeChar, String[] blockStart, String[] blockEnd, String[] splitters, boolean includeSplitter) {
        ArrayList<String> splits = new ArrayList<String>();
        StringBuilder curString = new StringBuilder();
        boolean escape = false;
        int lastEscapeOffset = -1;
        int blockStartPos = -1;
        LinkedList<Integer> blockStack = new LinkedList<Integer>();
        block0: for (int i = 0; i < str.length(); ++i) {
            char c = str.charAt(i);
            if (c == escapeChar && !escape) {
                escape = true;
                continue;
            }
            if (escape) {
                if (escapeSeq.indexOf(c) < 0) {
                    curString.append(escapeChar);
                }
                curString.append(c);
                escape = false;
                lastEscapeOffset = curString.length();
                continue;
            }
            if (blockStack.size() > 0) {
                curString.append(c);
                boolean multicharBlockDetected = false;
                for (int b = 0; b < blockStart.length; ++b) {
                    if (blockStartPos < 0 || Input.getBlockStr(blockStart[b]).compareTo(str.substring(blockStartPos, i)) != 0) continue;
                    blockStack.remove(0);
                    blockStack.add(0, b);
                    multicharBlockDetected = true;
                    break;
                }
                if (multicharBlockDetected) continue;
                if (Input.isNestedBlock(blockStart[(Integer)blockStack.get(0)]) && curString.substring(lastEscapeOffset + 1).endsWith(Input.getBlockStr(blockStart[(Integer)blockStack.get(0)]))) {
                    blockStack.add(0, (Integer)blockStack.get(0));
                    blockStartPos = i;
                    continue;
                }
                if (!curString.substring(lastEscapeOffset + 1).endsWith(Input.getBlockStr(blockEnd[(Integer)blockStack.get(0)]))) continue;
                if (!Input.isNestedBlock(blockEnd[(Integer)blockStack.get(0)])) {
                    for (String splitter : splitters) {
                        if (splitter.compareTo(Input.getBlockStr(blockEnd[(Integer)blockStack.get(0)])) != 0) continue;
                        splits.add(curString.toString());
                        if (includeSplitter) {
                            splits.add(splitter);
                        }
                        curString.setLength(0);
                        lastEscapeOffset = -1;
                        break;
                    }
                }
                blockStartPos = -1;
                blockStack.remove(0);
                continue;
            }
            boolean splitted = false;
            for (String splitter : splitters) {
                int curentLenght = i + splitter.length();
                if (splitter.compareTo(str.substring(i, Math.min(curentLenght, str.length()))) != 0) continue;
                splits.add(curString.toString());
                if (includeSplitter) {
                    splits.add(splitter);
                }
                curString.setLength(0);
                lastEscapeOffset = -1;
                i += splitter.length() - 1;
                splitted = true;
                break;
            }
            if (splitted) continue;
            curString.append(c);
            for (int b = 0; b < blockStart.length; ++b) {
                if (!curString.substring(lastEscapeOffset + 1).endsWith(Input.getBlockStr(blockStart[b]))) continue;
                blockStack.add(0, b);
                blockStartPos = i;
                continue block0;
            }
        }
        if (curString.length() > 0) {
            splits.add(curString.toString().trim());
        }
        return splits.toArray(new String[0]);
    }

    private static String getBlockStr(String blockDef) {
        if (blockDef.startsWith("N_")) {
            return blockDef.substring("N_".length());
        }
        return blockDef;
    }

    private static boolean isNestedBlock(String blockDef) {
        return blockDef.startsWith("N_");
    }
}

