/*
 * Decompiled with CFR 0.152.
 */
package org.apache.zeppelin.interpreter.remote;

import java.io.IOException;
import java.net.ConnectException;
import java.net.Inet4Address;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.InterfaceAddress;
import java.net.NetworkInterface;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketException;
import java.net.UnknownHostException;
import java.util.Collections;
import org.apache.commons.lang.StringUtils;
import org.apache.thrift.TException;
import org.apache.thrift.protocol.TBinaryProtocol;
import org.apache.thrift.protocol.TProtocol;
import org.apache.thrift.transport.TServerSocket;
import org.apache.thrift.transport.TSocket;
import org.apache.thrift.transport.TTransport;
import org.apache.thrift.transport.TTransportException;
import org.apache.zeppelin.interpreter.thrift.CallbackInfo;
import org.apache.zeppelin.interpreter.thrift.RemoteInterpreterCallbackService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RemoteInterpreterUtils {
    static Logger LOGGER = LoggerFactory.getLogger(RemoteInterpreterUtils.class);

    public static int findRandomAvailablePortOnAllLocalInterfaces() throws IOException {
        int port;
        try (ServerSocket socket = new ServerSocket(0);){
            port = socket.getLocalPort();
            socket.close();
        }
        return port;
    }

    public static TServerSocket createTServerSocket(String portRange) throws IOException {
        TServerSocket tSocket = null;
        if (StringUtils.isBlank((String)portRange) || portRange.equals(":")) {
            try {
                tSocket = new TServerSocket(0);
                return tSocket;
            }
            catch (TTransportException e) {
                throw new IOException("Fail to create TServerSocket", e);
            }
        }
        int start = 1024;
        int end = 65535;
        String[] ports = portRange.split(":", -1);
        if (!ports[0].isEmpty()) {
            start = Integer.parseInt(ports[0]);
        }
        if (!ports[1].isEmpty()) {
            end = Integer.parseInt(ports[1]);
        }
        for (int i = start; i <= end; ++i) {
            try {
                tSocket = new TServerSocket(i);
                return tSocket;
            }
            catch (Exception exception) {
                continue;
            }
        }
        throw new IOException("No available port in the portRange: " + portRange);
    }

    public static String findAvailableHostAddress() throws UnknownHostException, SocketException {
        InetAddress address = InetAddress.getLocalHost();
        if (address.isLoopbackAddress()) {
            for (NetworkInterface networkInterface : Collections.list(NetworkInterface.getNetworkInterfaces())) {
                if (networkInterface.isLoopback()) continue;
                for (InterfaceAddress interfaceAddress : networkInterface.getInterfaceAddresses()) {
                    InetAddress a = interfaceAddress.getAddress();
                    if (!(a instanceof Inet4Address)) continue;
                    return a.getHostAddress();
                }
            }
        }
        return address.getHostAddress();
    }

    public static boolean checkIfRemoteEndpointAccessible(String host, int port) {
        try {
            Socket discover = new Socket();
            discover.setSoTimeout(1000);
            discover.connect(new InetSocketAddress(host, port), 1000);
            discover.close();
            return true;
        }
        catch (ConnectException cne) {
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("Remote endpoint '" + host + ":" + port + "' is not accessible (might be initializing): " + cne.getMessage());
            }
            return false;
        }
        catch (IOException ioe) {
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("Remote endpoint '" + host + ":" + port + "' is not accessible (might be initializing): " + ioe.getMessage());
            }
            return false;
        }
    }

    public static String getInterpreterSettingId(String intpGrpId) {
        String settingId = null;
        if (intpGrpId != null) {
            int indexOfColon = intpGrpId.indexOf(":");
            settingId = intpGrpId.substring(0, indexOfColon);
        }
        return settingId;
    }

    public static boolean isEnvString(String key) {
        if (key == null || key.length() == 0) {
            return false;
        }
        return key.matches("^[A-Z_0-9]*");
    }

    public static void registerInterpreter(String callbackHost, int callbackPort, CallbackInfo callbackInfo) throws TException {
        LOGGER.info("callbackHost: {}, callbackPort: {}, callbackInfo: {}", new Object[]{callbackHost, callbackPort, callbackInfo});
        try (TSocket transport = new TSocket(callbackHost, callbackPort);){
            transport.open();
            TBinaryProtocol protocol = new TBinaryProtocol((TTransport)transport);
            RemoteInterpreterCallbackService.Client client = new RemoteInterpreterCallbackService.Client((TProtocol)protocol);
            client.callback(callbackInfo);
        }
    }
}

