/*
 * Decompiled with CFR 0.152.
 */
package org.apache.zeppelin.scheduler;

import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.ExecutorService;
import org.apache.zeppelin.interpreter.InterpreterResult;
import org.apache.zeppelin.scheduler.Job;
import org.apache.zeppelin.scheduler.Scheduler;
import org.apache.zeppelin.scheduler.SchedulerListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FIFOScheduler
implements Scheduler {
    List<Job> queue = new LinkedList<Job>();
    private ExecutorService executor;
    private SchedulerListener listener;
    boolean terminate = false;
    Job runningJob = null;
    private String name;
    static Logger LOGGER = LoggerFactory.getLogger(FIFOScheduler.class);

    public FIFOScheduler(String name, ExecutorService executor, SchedulerListener listener) {
        this.name = name;
        this.executor = executor;
        this.listener = listener;
    }

    @Override
    public String getName() {
        return this.name;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Collection<Job> getJobsWaiting() {
        LinkedList<Job> ret = new LinkedList<Job>();
        List<Job> list = this.queue;
        synchronized (list) {
            for (Job job : this.queue) {
                ret.add(job);
            }
        }
        return ret;
    }

    @Override
    public Collection<Job> getJobsRunning() {
        LinkedList<Job> ret = new LinkedList<Job>();
        Job job = this.runningJob;
        if (job != null) {
            ret.add(job);
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void submit(Job job) {
        job.setStatus(Job.Status.PENDING);
        List<Job> list = this.queue;
        synchronized (list) {
            this.queue.add(job);
            this.queue.notify();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Job removeFromWaitingQueue(String jobId) {
        List<Job> list = this.queue;
        synchronized (list) {
            Iterator<Job> it = this.queue.iterator();
            while (it.hasNext()) {
                Job job = it.next();
                if (!job.getId().equals(jobId)) continue;
                it.remove();
                return job;
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        List<Job> list = this.queue;
        synchronized (list) {
            while (!this.terminate) {
                List<Job> list2 = this.queue;
                synchronized (list2) {
                    if (this.runningJob != null || this.queue.isEmpty()) {
                        try {
                            this.queue.wait(500L);
                        }
                        catch (InterruptedException e) {
                            LOGGER.error("Exception in FIFOScheduler while run queue.wait", (Throwable)e);
                        }
                        continue;
                    }
                    this.runningJob = this.queue.remove(0);
                }
                final FIFOScheduler scheduler = this;
                this.executor.execute(new Runnable(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public void run() {
                        if (FIFOScheduler.this.runningJob.isAborted()) {
                            FIFOScheduler.this.runningJob.setStatus(Job.Status.ABORT);
                            FIFOScheduler.this.runningJob.aborted = false;
                            List<Job> list = FIFOScheduler.this.queue;
                            synchronized (list) {
                                FIFOScheduler.this.queue.notify();
                            }
                            return;
                        }
                        FIFOScheduler.this.runningJob.setStatus(Job.Status.RUNNING);
                        if (FIFOScheduler.this.listener != null) {
                            FIFOScheduler.this.listener.jobStarted(scheduler, FIFOScheduler.this.runningJob);
                        }
                        FIFOScheduler.this.runningJob.run();
                        Object jobResult = FIFOScheduler.this.runningJob.getReturn();
                        if (FIFOScheduler.this.runningJob.isAborted()) {
                            FIFOScheduler.this.runningJob.setStatus(Job.Status.ABORT);
                            LOGGER.debug("Job Aborted, " + FIFOScheduler.this.runningJob.getId() + ", " + FIFOScheduler.this.runningJob.getErrorMessage());
                        } else if (FIFOScheduler.this.runningJob.getException() != null) {
                            LOGGER.debug("Job Error, " + FIFOScheduler.this.runningJob.getId() + ", " + FIFOScheduler.this.runningJob.getReturn());
                            FIFOScheduler.this.runningJob.setStatus(Job.Status.ERROR);
                        } else if (jobResult != null && jobResult instanceof InterpreterResult && ((InterpreterResult)jobResult).code() == InterpreterResult.Code.ERROR) {
                            LOGGER.debug("Job Error, " + FIFOScheduler.this.runningJob.getId() + ", " + FIFOScheduler.this.runningJob.getReturn());
                            FIFOScheduler.this.runningJob.setStatus(Job.Status.ERROR);
                        } else {
                            LOGGER.debug("Job Finished, " + FIFOScheduler.this.runningJob.getId() + ", Result: " + FIFOScheduler.this.runningJob.getReturn());
                            FIFOScheduler.this.runningJob.setStatus(Job.Status.FINISHED);
                        }
                        if (FIFOScheduler.this.listener != null) {
                            FIFOScheduler.this.listener.jobFinished(scheduler, FIFOScheduler.this.runningJob);
                        }
                        FIFOScheduler.this.runningJob.aborted = false;
                        FIFOScheduler.this.runningJob = null;
                        List<Job> list = FIFOScheduler.this.queue;
                        synchronized (list) {
                            FIFOScheduler.this.queue.notify();
                        }
                    }
                });
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void stop() {
        this.terminate = true;
        List<Job> list = this.queue;
        synchronized (list) {
            this.queue.notify();
        }
    }
}

